/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.lang.reflect.Modifier;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.ObjectFactory;

public final class AllocateInstanceObjectFactory<E>
implements ObjectFactory<E> {
    private static final long serialVersionUID = 0L;
    private final Class<E> eClass;

    public AllocateInstanceObjectFactory(Class<E> eClass) {
        if (eClass.isInterface() || Modifier.isAbstract(eClass.getModifiers()) || eClass.isEnum()) {
            throw new IllegalArgumentException(eClass + " should be a non-abstract non-enum class");
        }
        this.eClass = eClass;
    }

    public Class<E> allocatedClass() {
        return this.eClass;
    }

    @Override
    public E create() throws Exception {
        return (E)NativeBytes.UNSAFE.allocateInstance(this.eClass);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((AllocateInstanceObjectFactory)obj).eClass == this.eClass;
    }

    public int hashCode() {
        return this.eClass.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{eClass=" + this.eClass + "}";
    }
}

