/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.openhft.lang.io.VanillaMappedBytes;
import net.openhft.lang.io.VanillaMappedMode;
import net.openhft.lang.io.VanillaMappedResource;

public class VanillaMappedFile
implements VanillaMappedResource {
    private final File path;
    private final FileChannel channel;
    private final VanillaMappedMode mode;
    private final long size;

    public VanillaMappedFile(File path, VanillaMappedMode mode) throws IOException {
        this(path, mode, -1L);
    }

    public VanillaMappedFile(File path, VanillaMappedMode mode, long size) throws IOException {
        this.path = path;
        this.mode = mode;
        this.size = size;
        this.channel = VanillaMappedFile.fileChannel(path, mode, this.size);
    }

    public VanillaMappedBytes bytes(long address, long size) throws IOException {
        return this.bytes(address, size, -1L);
    }

    public synchronized VanillaMappedBytes bytes(long address, long size, long index) throws IOException {
        MappedByteBuffer buffer = this.channel.map(this.mode.mapValue(), address, size);
        buffer.order(ByteOrder.nativeOrder());
        return new VanillaMappedBytes(buffer, index);
    }

    @Override
    public String path() {
        return this.path.getAbsolutePath();
    }

    @Override
    public long size() {
        try {
            return this.channel.size();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
    }

    private static FileChannel fileChannel(File path, VanillaMappedMode mapMode, long size) throws IOException {
        FileChannel fileChannel = null;
        try {
            RandomAccessFile raf = new RandomAccessFile(path, mapMode.stringValue());
            if (size > 0L && raf.length() != size) {
                if (mapMode.mapValue() != FileChannel.MapMode.READ_WRITE) {
                    throw new IOException("Cannot resize file to " + size + " as mode is not READ_WRITE");
                }
                raf.setLength(size);
            }
            fileChannel = raf.getChannel();
            fileChannel.force(true);
        }
        catch (Exception e) {
            throw VanillaMappedFile.wrap(e);
        }
        return fileChannel;
    }

    private static IOException wrap(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        } else if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable);
    }

    public static VanillaMappedFile readWrite(File path) throws IOException {
        return new VanillaMappedFile(path, VanillaMappedMode.RW);
    }

    public static VanillaMappedFile readWrite(File path, long size) throws IOException {
        return new VanillaMappedFile(path, VanillaMappedMode.RW, size);
    }

    public static VanillaMappedFile readOnly(File path) throws IOException {
        return new VanillaMappedFile(path, VanillaMappedMode.RO);
    }

    public static VanillaMappedFile readOnly(File path, long size) throws IOException {
        return new VanillaMappedFile(path, VanillaMappedMode.RO, size);
    }
}

