/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.EOFException;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.lang.io.AbstractBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.model.constraints.NotNull;
import sun.misc.Unsafe;

public class NativeBytes
extends AbstractBytes {
    @NotNull
    public static final Unsafe UNSAFE;
    protected static final long NO_PAGE;
    static final int BYTES_OFFSET;
    protected long startAddr;
    protected long positionAddr;
    protected long limitAddr;
    long capacityAddr;

    public NativeBytes(long startAddr, long capacityAddr) {
        this.positionAddr = this.startAddr = startAddr;
        this.limitAddr = this.capacityAddr = capacityAddr;
    }

    public NativeBytes(BytesMarshallerFactory bytesMarshallerFactory, long startAddr, long capacityAddr, AtomicInteger refCount) {
        super(bytesMarshallerFactory, refCount);
        this.positionAddr = this.startAddr = startAddr;
        this.limitAddr = this.capacityAddr = capacityAddr;
    }

    public NativeBytes(NativeBytes bytes) {
        super(bytes.bytesMarshallerFactory(), new AtomicInteger(1));
        this.startAddr = bytes.startAddr;
        this.positionAddr = bytes.positionAddr;
        this.limitAddr = bytes.limitAddr;
        this.capacityAddr = bytes.capacityAddr;
    }

    public static long longHash(byte[] bytes, int off, int len) {
        int pos;
        long hash = 0L;
        for (pos = 0; pos < len - 7; pos += 8) {
            hash = hash * 10191L + UNSAFE.getLong(bytes, (long)BYTES_OFFSET + (long)off + (long)pos);
        }
        while (pos < len) {
            hash = hash * 57L + (long)bytes[off + pos];
            ++pos;
        }
        return hash;
    }

    @Override
    public NativeBytes slice() {
        return new NativeBytes(this.bytesMarshallerFactory(), this.positionAddr, this.limitAddr, this.refCount);
    }

    @Override
    public NativeBytes slice(long offset, long length) {
        long sliceStart = this.positionAddr + offset;
        assert (sliceStart >= this.startAddr && sliceStart < this.capacityAddr);
        long sliceEnd = sliceStart + length;
        assert (sliceEnd > sliceStart && sliceEnd <= this.capacityAddr);
        return new NativeBytes(this.bytesMarshallerFactory(), sliceStart, sliceEnd, this.refCount);
    }

    @Override
    public NativeBytes bytes() {
        return new NativeBytes(this.bytesMarshallerFactory(), this.startAddr, this.capacityAddr, this.refCount);
    }

    @Override
    public NativeBytes bytes(long offset, long length) {
        long sliceStart = this.startAddr + offset;
        assert (sliceStart >= this.startAddr && sliceStart < this.capacityAddr);
        long sliceEnd = sliceStart + length;
        assert (sliceEnd > sliceStart && sliceEnd <= this.capacityAddr);
        return new NativeBytes(this.bytesMarshallerFactory(), sliceStart, sliceEnd, this.refCount);
    }

    @Override
    public long address() {
        return this.startAddr;
    }

    @Override
    public Bytes zeroOut() {
        this.clear();
        UNSAFE.setMemory(this.startAddr, this.capacity(), (byte)0);
        return this;
    }

    @Override
    public Bytes zeroOut(long start, long end) {
        if (start < 0L || end > this.limit()) {
            throw new IllegalArgumentException("start: " + start + ", end: " + end);
        }
        if (start >= end) {
            return this;
        }
        UNSAFE.setMemory(this.startAddr + start, end - start, (byte)0);
        return this;
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) {
        if (len < 0 || off < 0 || off + len > bytes.length) {
            throw new IllegalArgumentException();
        }
        long left = this.remaining();
        if (left <= 0L) {
            return -1;
        }
        int len2 = (int)Math.min((long)len, left);
        UNSAFE.copyMemory(null, this.positionAddr, bytes, BYTES_OFFSET + off, len2);
        this.positionAddr += (long)len2;
        return len2;
    }

    @Override
    public byte readByte() {
        return UNSAFE.getByte(this.positionAddr++);
    }

    @Override
    public byte readByte(long offset) {
        return UNSAFE.getByte(this.startAddr + offset);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) {
        if (len < 0 || off < 0 || off + len > b.length) {
            throw new IllegalArgumentException();
        }
        long left = this.remaining();
        if (left < (long)len) {
            throw new IllegalStateException(new EOFException());
        }
        UNSAFE.copyMemory(null, this.positionAddr, b, BYTES_OFFSET + off, len);
        this.positionAddr += (long)len;
    }

    @Override
    public short readShort() {
        short s = UNSAFE.getShort(this.positionAddr);
        this.positionAddr += 2L;
        return s;
    }

    @Override
    public short readShort(long offset) {
        return UNSAFE.getShort(this.startAddr + offset);
    }

    @Override
    public char readChar() {
        char ch = UNSAFE.getChar(this.positionAddr);
        this.positionAddr += 2L;
        return ch;
    }

    @Override
    public char readChar(long offset) {
        return UNSAFE.getChar(this.startAddr + offset);
    }

    @Override
    public int readInt() {
        int i = UNSAFE.getInt(this.positionAddr);
        this.positionAddr += 4L;
        return i;
    }

    @Override
    public int readInt(long offset) {
        return UNSAFE.getInt(this.startAddr + offset);
    }

    @Override
    public int readVolatileInt() {
        int i = UNSAFE.getIntVolatile(null, this.positionAddr);
        this.positionAddr += 4L;
        return i;
    }

    @Override
    public int readVolatileInt(long offset) {
        return UNSAFE.getIntVolatile(null, this.startAddr + offset);
    }

    @Override
    public long readLong() {
        long l = UNSAFE.getLong(this.positionAddr);
        this.positionAddr += 8L;
        return l;
    }

    @Override
    public long readLong(long offset) {
        return UNSAFE.getLong(this.startAddr + offset);
    }

    @Override
    public long readVolatileLong() {
        long l = UNSAFE.getLongVolatile(null, this.positionAddr);
        this.positionAddr += 8L;
        return l;
    }

    @Override
    public long readVolatileLong(long offset) {
        return UNSAFE.getLongVolatile(null, this.startAddr + offset);
    }

    @Override
    public float readFloat() {
        float f = UNSAFE.getFloat(this.positionAddr);
        this.positionAddr += 4L;
        return f;
    }

    @Override
    public float readFloat(long offset) {
        return UNSAFE.getFloat(this.startAddr + offset);
    }

    @Override
    public double readDouble() {
        double d = UNSAFE.getDouble(this.positionAddr);
        this.positionAddr += 8L;
        return d;
    }

    @Override
    public double readDouble(long offset) {
        return UNSAFE.getDouble(this.startAddr + offset);
    }

    @Override
    public void write(int b) {
        UNSAFE.putByte(this.positionAddr++, (byte)b);
    }

    @Override
    public void writeByte(long offset, int b) {
        UNSAFE.putByte(this.startAddr + offset, (byte)b);
    }

    @Override
    public void write(long offset, @NotNull byte[] bytes) {
        if (offset < 0L || offset + (long)bytes.length > this.capacity()) {
            throw new IllegalArgumentException();
        }
        UNSAFE.copyMemory(bytes, BYTES_OFFSET, null, this.startAddr + offset, bytes.length);
        this.positionAddr += (long)bytes.length;
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        UNSAFE.copyMemory(bytes, BYTES_OFFSET + off, null, this.positionAddr, len);
        this.positionAddr += (long)len;
    }

    @Override
    public void writeShort(int v) {
        UNSAFE.putShort(this.positionAddr, (short)v);
        this.positionAddr += 2L;
    }

    @Override
    public void writeShort(long offset, int v) {
        UNSAFE.putShort(this.startAddr + offset, (short)v);
    }

    @Override
    public void writeChar(int v) {
        UNSAFE.putChar(this.positionAddr, (char)v);
        this.positionAddr += 2L;
    }

    @Override
    public void writeChar(long offset, int v) {
        UNSAFE.putChar(this.startAddr + offset, (char)v);
    }

    @Override
    public void writeInt(int v) {
        UNSAFE.putInt(null, this.positionAddr, v);
        this.positionAddr += 4L;
    }

    @Override
    public void writeInt(long offset, int v) {
        UNSAFE.putInt(this.startAddr + offset, v);
    }

    @Override
    public void writeOrderedInt(int v) {
        UNSAFE.putOrderedInt(null, this.positionAddr, v);
        this.positionAddr += 4L;
    }

    @Override
    public void writeOrderedInt(long offset, int v) {
        UNSAFE.putOrderedInt(null, this.startAddr + offset, v);
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int x) {
        return UNSAFE.compareAndSwapInt(null, this.startAddr + offset, expected, x);
    }

    @Override
    public void writeLong(long v) {
        UNSAFE.putLong(this.positionAddr, v);
        this.positionAddr += 8L;
    }

    @Override
    public void writeLong(long offset, long v) {
        UNSAFE.putLong(this.startAddr + offset, v);
    }

    @Override
    public void writeOrderedLong(long v) {
        UNSAFE.putOrderedLong(null, this.positionAddr, v);
        this.positionAddr += 8L;
    }

    @Override
    public void writeOrderedLong(long offset, long v) {
        UNSAFE.putOrderedLong(null, this.startAddr + offset, v);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long x) {
        return UNSAFE.compareAndSwapLong(null, this.startAddr + offset, expected, x);
    }

    @Override
    public void writeFloat(float v) {
        UNSAFE.putFloat(this.positionAddr, v);
        this.positionAddr += 4L;
    }

    @Override
    public void writeFloat(long offset, float v) {
        UNSAFE.putFloat(this.startAddr + offset, v);
    }

    @Override
    public void writeDouble(double v) {
        UNSAFE.putDouble(this.positionAddr, v);
        this.positionAddr += 8L;
    }

    @Override
    public void writeDouble(long offset, double v) {
        UNSAFE.putDouble(this.startAddr + offset, v);
    }

    @Override
    public void readObject(Object object, int start, int end) {
        int len;
        for (len = end - start; len >= 8; len -= 8) {
            UNSAFE.putLong(object, start, UNSAFE.getLong(this.positionAddr));
            this.positionAddr += 8L;
            start += 8;
        }
        while (len > 0) {
            UNSAFE.putByte(object, start, UNSAFE.getByte(this.positionAddr));
            ++this.positionAddr;
            ++start;
            --len;
        }
    }

    @Override
    public void writeObject(Object object, int start, int end) {
        int len;
        for (len = end - start; len >= 8; len -= 8) {
            UNSAFE.putLong(this.positionAddr, UNSAFE.getLong(object, start));
            this.positionAddr += 8L;
            start += 8;
        }
        while (len > 0) {
            UNSAFE.putByte(this.positionAddr, UNSAFE.getByte(object, start));
            ++this.positionAddr;
            ++start;
            --len;
        }
    }

    @Override
    public boolean startsWith(RandomDataInput input) {
        long inputRemaining = input.remaining();
        if (this.limitAddr - this.positionAddr < inputRemaining) {
            return false;
        }
        long pos = this.position();
        long inputPos = input.position();
        UNSAFE.getLong(this.startAddr + pos);
        int i = 0;
        while ((long)i < inputRemaining - 7L) {
            if (UNSAFE.getLong(this.startAddr + pos + (long)i) != input.readLong(inputPos + (long)i)) {
                return false;
            }
            i += 8;
        }
        while ((long)i < inputRemaining) {
            if (UNSAFE.getByte(this.startAddr + pos + (long)i) != input.readByte(inputPos + (long)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public long position() {
        return this.positionAddr - this.startAddr;
    }

    @Override
    public NativeBytes position(long position) {
        if (position < 0L || position > this.limit()) {
            throw new IllegalArgumentException("position: " + position + " limit: " + this.limit());
        }
        this.positionAddr = this.startAddr + position;
        return this;
    }

    @Override
    public long capacity() {
        return this.capacityAddr - this.startAddr;
    }

    @Override
    public long remaining() {
        return this.limitAddr - this.positionAddr;
    }

    @Override
    public long limit() {
        return this.limitAddr - this.startAddr;
    }

    @Override
    public NativeBytes limit(long limit) {
        if (limit < 0L || limit > this.capacity()) {
            throw new IllegalArgumentException("limit: " + limit + " capacity: " + this.capacity());
        }
        this.limitAddr = this.startAddr + limit;
        return this;
    }

    @Override
    @NotNull
    public ByteOrder byteOrder() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public void checkEndOfBuffer() throws IndexOutOfBoundsException {
        if (this.position() > this.capacity()) {
            throw new IndexOutOfBoundsException("position is beyond the end of the buffer " + this.position() + " > " + this.capacity());
        }
    }

    public long startAddr() {
        return this.startAddr;
    }

    long capacityAddr() {
        return this.capacityAddr;
    }

    @Override
    protected void cleanup() {
    }

    @Override
    public Bytes load() {
        int pageSize = UNSAFE.pageSize();
        for (long addr = this.startAddr; addr < this.capacityAddr; addr += (long)pageSize) {
            UNSAFE.getByte(addr);
        }
        return this;
    }

    @Override
    public void alignPositionAddr(int powerOf2) {
        this.positionAddr = this.positionAddr + (long)powerOf2 - 1L & (long)(~(powerOf2 - 1));
    }

    public void positionAddr(long positionAddr) {
        this.positionAddr = positionAddr;
    }

    public long positionAddr() {
        return this.positionAddr;
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
            BYTES_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        NO_PAGE = UNSAFE.allocateMemory(UNSAFE.pageSize());
    }
}

