/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import org.jetbrains.annotations.NotNull;
import sun.misc.Cleaner;
import sun.nio.ch.FileChannelImpl;

public class MappedStore
implements BytesStore {
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    private final FileChannel fileChannel;
    private final Cleaner cleaner;
    private final long address;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final long size;
    private final BytesMarshallerFactory bytesMarshallerFactory;

    public MappedStore(File file, FileChannel.MapMode mode, long size) throws IOException {
        this(file, mode, size, new VanillaBytesMarshallerFactory());
    }

    private MappedStore(File file, FileChannel.MapMode mode, long size, BytesMarshallerFactory bytesMarshallerFactory) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("size: " + size);
        }
        this.size = size;
        this.bytesMarshallerFactory = bytesMarshallerFactory;
        this.fileChannel = new RandomAccessFile(file, mode == FileChannel.MapMode.READ_WRITE ? "rw" : "r").getChannel();
        try {
            FileDescriptor fd = MappedStore.getFD(this.fileChannel);
            if (this.fileChannel.size() < size) {
                int rv;
                if (mode != FileChannel.MapMode.READ_WRITE) {
                    throw new IOException("Cannot resize file to " + size + " as mode is not READ_WRITE");
                }
                while ((rv = MappedStore.truncate0(fd, size)) == -3 && this.fileChannel.isOpen()) {
                }
            }
            int imode = MappedStore.imodeFor(mode);
            this.address = MappedStore.map0(this.fileChannel, imode, 0L, size);
            this.cleaner = Cleaner.create((Object)this, (Runnable)new Unmapper(this.address, size, fd));
        }
        catch (Exception e) {
            throw MappedStore.wrap(e);
        }
    }

    private static long map0(FileChannel fileChannel, int imode, long start, long size) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method map0 = fileChannel.getClass().getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
        map0.setAccessible(true);
        return (Long)map0.invoke((Object)fileChannel, imode, start, size);
    }

    private static int truncate0(FileDescriptor fd, long size) throws IOException {
        try {
            Method close0 = Class.forName("sun.nio.ch.FileDispatcherImpl").getDeclaredMethod("truncate0", FileDescriptor.class, Long.TYPE);
            close0.setAccessible(true);
            return (Integer)close0.invoke(null, fd, size);
        }
        catch (Exception e) {
            throw MappedStore.wrap(e);
        }
    }

    private static void unmap0(long address, long size) throws IOException {
        try {
            Method unmap0 = FileChannelImpl.class.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
            unmap0.setAccessible(true);
            unmap0.invoke(null, address, size);
        }
        catch (Exception e) {
            throw MappedStore.wrap(e);
        }
    }

    private static void close0(FileDescriptor fd) {
        try {
            Method close0 = Class.forName("sun.nio.ch.FileDispatcherImpl").getDeclaredMethod("close0", FileDescriptor.class);
            close0.setAccessible(true);
            close0.invoke(null, fd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static IOException wrap(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    @Override
    public BytesMarshallerFactory bytesMarshallerFactory() {
        return this.bytesMarshallerFactory;
    }

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void free() {
        this.cleaner.clean();
    }

    @Override
    @NotNull
    public DirectBytes createSlice() {
        return new DirectBytes(this, this.refCount);
    }

    @Override
    @NotNull
    public DirectBytes createSlice(long offset, long length) {
        return new DirectBytes(this, this.refCount, offset, length);
    }

    private static int imodeFor(FileChannel.MapMode mode) {
        int imode = -1;
        if (mode == FileChannel.MapMode.READ_ONLY) {
            imode = 0;
        } else if (mode == FileChannel.MapMode.READ_WRITE) {
            imode = 1;
        } else if (mode == FileChannel.MapMode.PRIVATE) {
            imode = 2;
        }
        assert (imode >= 0);
        return imode;
    }

    private static FileDescriptor getFD(FileChannel fileChannel) throws IOException {
        try {
            Field fd = fileChannel.getClass().getDeclaredField("fd");
            fd.setAccessible(true);
            return (FileDescriptor)fd.get(fileChannel);
        }
        catch (Exception e) {
            throw MappedStore.wrap(e);
        }
    }

    static class Unmapper
    implements Runnable {
        private final long size;
        private final FileDescriptor fd;
        private volatile long address;

        Unmapper(long address, long size, FileDescriptor fd) {
            assert (address != 0L);
            this.address = address;
            this.size = size;
            this.fd = fd;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            try {
                MappedStore.unmap0(this.address, this.size);
                this.address = 0L;
                if (this.fd.valid()) {
                    MappedStore.close0(this.fd);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static enum IOStatus {

        static final int EOF = -1;
        static final int UNAVAILABLE = -2;
        static final int INTERRUPTED = -3;
        static final int UNSUPPORTED = -4;
        static final int THROWN = -5;
        static final int UNSUPPORTED_CASE = -6;
    }
}

