/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.nio.MappedByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.lang.ReferenceCounted;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class MappedMemory
implements ReferenceCounted {
    private final MappedByteBuffer buffer;
    private final long index;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private volatile boolean unmapped = false;

    public MappedMemory(MappedByteBuffer buffer, long index) {
        this.buffer = buffer;
        this.index = index;
    }

    private static void unmap(MappedByteBuffer bb) {
        Cleaner cl = ((DirectBuffer)((Object)bb)).cleaner();
        if (cl != null) {
            cl.clean();
        }
    }

    public long index() {
        return this.index;
    }

    @Override
    public void reserve() {
        if (this.unmapped) {
            throw new IllegalStateException();
        }
        this.refCount.incrementAndGet();
    }

    @Override
    public void release() {
        if (this.unmapped) {
            throw new IllegalStateException();
        }
        if (this.refCount.decrementAndGet() > 0) {
            return;
        }
        this.close();
    }

    @Override
    public int refCount() {
        return this.refCount.get();
    }

    public MappedByteBuffer buffer() {
        return this.buffer;
    }

    public long address() {
        return ((DirectBuffer)((Object)this.buffer)).address();
    }

    public static void release(MappedMemory mapmem) {
        if (mapmem != null) {
            mapmem.release();
        }
    }

    public void force() {
        if (!this.unmapped) {
            this.buffer.force();
        }
    }

    public void close() {
        MappedMemory.unmap(this.buffer);
        this.unmapped = true;
    }
}

