/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import net.openhft.lang.io.StopCharTester;
import net.openhft.lang.model.constraints.NotNull;

public enum StopCharTesters implements StopCharTester
{
    COMMA_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return ch < 32 || ch == 44;
        }
    }
    ,
    CONTROL_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return ch < 32;
        }
    }
    ,
    SPACE_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return Character.isWhitespace(ch) || ch == 0;
        }
    }
    ,
    XML_TEXT{

        @Override
        public boolean isStopChar(int ch) {
            return ch == 34 || ch == 60 || ch == 62 || ch == 0;
        }
    }
    ,
    FIX_TEXT{

        @Override
        public boolean isStopChar(int ch) {
            return ch <= 1;
        }
    };


    @NotNull
    public static StopCharTester forChars(@NotNull CharSequence sequence) {
        if (sequence.length() == 1) {
            return StopCharTesters.forChar(sequence.charAt(0));
        }
        return new CSCSTester(sequence);
    }

    @NotNull
    private static StopCharTester forChar(char ch) {
        return new CharCSTester(ch);
    }

    static class CharCSTester
    implements StopCharTester {
        private final char ch;

        public CharCSTester(char ch) {
            this.ch = ch;
        }

        @Override
        public boolean isStopChar(int ch) {
            return this.ch == ch;
        }
    }

    static class CSCSTester
    implements StopCharTester {
        @NotNull
        private final String seperators;

        public CSCSTester(@NotNull CharSequence cs) {
            this.seperators = ((Object)cs).toString();
        }

        @Override
        public boolean isStopChar(int ch) {
            return this.seperators.indexOf(ch) >= 0;
        }
    }
}

