/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.collection;

import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;

public class ATSDirectBitSet
implements DirectBitSet {
    private final Bytes bytes;
    private final long longLength;

    public ATSDirectBitSet(Bytes bytes) {
        this.bytes = bytes;
        this.longLength = bytes.capacity() >> 3;
    }

    @Override
    public void reserve() {
        this.bytes.reserve();
    }

    @Override
    public void release() {
        this.bytes.release();
    }

    @Override
    public int refCount() {
        return this.bytes.refCount();
    }

    @Override
    public DirectBitSet flip(long bitIndex) {
        long l2;
        long l;
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        while (!this.bytes.compareAndSwapLong(byteIndex, l = this.bytes.readVolatileLong(byteIndex), l2 = l ^ mask)) {
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public DirectBitSet flip(long fromIndex, long exclusiveToIndex) {
        long l2;
        long l;
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long l22;
            long l3;
            long i;
            long l23;
            long l4;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = fromLongIndex << 3;
                mask = -1L << (int)fromIndex;
                while (!this.bytes.compareAndSwapLong(fromByteIndex, l4 = this.bytes.readVolatileLong(fromByteIndex), l23 = l4 ^ mask)) {
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                i = firstFullLongIndex;
                while (true) {
                    if (i > toLongIndex) {
                        return this;
                    }
                    while (!this.bytes.compareAndSwapLong(i << 3, l3 = this.bytes.readVolatileLong(i << 3), l22 = l3 ^ 0xFFFFFFFFFFFFFFFFL)) {
                    }
                    ++i;
                }
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                while (!this.bytes.compareAndSwapLong(i << 3, l3 = this.bytes.readVolatileLong(i << 3), l22 = l3 ^ 0xFFFFFFFFFFFFFFFFL)) {
                }
            }
            long toByteIndex = toLongIndex << 3;
            mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
            while (!this.bytes.compareAndSwapLong(toByteIndex, l4 = this.bytes.readVolatileLong(toByteIndex), l23 = l4 ^ mask)) {
            }
            return this;
        }
        long byteIndex = fromLongIndex << 3;
        long mask = -1L << (int)fromIndex & -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
        while (!this.bytes.compareAndSwapLong(byteIndex, l = this.bytes.readVolatileLong(byteIndex), l2 = l ^ mask)) {
        }
        return this;
    }

    @Override
    public DirectBitSet set(long bitIndex) {
        long l2;
        long l;
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        do {
            if (((l = this.bytes.readVolatileLong(byteIndex)) & mask) == 0L) continue;
            return this;
        } while (!this.bytes.compareAndSwapLong(byteIndex, l, l2 = l | mask));
        return this;
    }

    @Override
    public boolean setIfClear(long bitIndex) {
        long l2;
        long l;
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        do {
            if ((l = this.bytes.readVolatileLong(byteIndex)) != (l2 = l | mask)) continue;
            return false;
        } while (!this.bytes.compareAndSwapLong(byteIndex, l, l2));
        return true;
    }

    @Override
    public DirectBitSet set(long bitIndex, boolean value) {
        return value ? this.set(bitIndex) : this.clear(bitIndex);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public DirectBitSet set(long fromIndex, long exclusiveToIndex) {
        long l2;
        long l;
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long i;
            long l22;
            long l3;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = fromLongIndex << 3;
                mask = -1L << (int)fromIndex;
                while (!this.bytes.compareAndSwapLong(fromByteIndex, l3 = this.bytes.readVolatileLong(fromByteIndex), l22 = l3 | mask)) {
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                i = firstFullLongIndex;
                while (true) {
                    if (i > toLongIndex) {
                        return this;
                    }
                    this.bytes.writeLong(i << 3, -1L);
                    ++i;
                }
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                this.bytes.writeLong(i << 3, -1L);
            }
            long toByteIndex = toLongIndex << 3;
            mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
            while (!this.bytes.compareAndSwapLong(toByteIndex, l3 = this.bytes.readVolatileLong(toByteIndex), l22 = l3 | mask)) {
            }
            return this;
        }
        long byteIndex = fromLongIndex << 3;
        long mask = -1L << (int)fromIndex & -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
        while (!this.bytes.compareAndSwapLong(byteIndex, l = this.bytes.readVolatileLong(byteIndex), l2 = l | mask)) {
        }
        return this;
    }

    @Override
    public DirectBitSet setAll() {
        for (long i = 0L; i < this.longLength; ++i) {
            this.bytes.writeLong(i << 3, -1L);
        }
        return this;
    }

    @Override
    public DirectBitSet set(long fromIndex, long toIndex, boolean value) {
        return value ? this.set(fromIndex, toIndex) : this.clear(fromIndex, toIndex);
    }

    @Override
    public DirectBitSet clear(long bitIndex) {
        long l2;
        long l;
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        do {
            if (((l = this.bytes.readVolatileLong(byteIndex)) & mask) != 0L) continue;
            return this;
        } while (!this.bytes.compareAndSwapLong(byteIndex, l, l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL)));
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public DirectBitSet clear(long fromIndex, long exclusiveToIndex) {
        long l2;
        long l;
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long i;
            long l22;
            long l3;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = fromLongIndex << 3;
                mask = -1L << (int)fromIndex ^ 0xFFFFFFFFFFFFFFFFL;
                while (!this.bytes.compareAndSwapLong(fromByteIndex, l3 = this.bytes.readVolatileLong(fromByteIndex), l22 = l3 & mask)) {
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                i = firstFullLongIndex;
                while (true) {
                    if (i > toLongIndex) {
                        return this;
                    }
                    this.bytes.writeLong(i << 3, 0L);
                    ++i;
                }
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                this.bytes.writeLong(i << 3, 0L);
            }
            long toByteIndex = toLongIndex << 3;
            mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL;
            while (!this.bytes.compareAndSwapLong(toByteIndex, l3 = this.bytes.readVolatileLong(toByteIndex), l22 = l3 & mask)) {
            }
            return this;
        }
        long byteIndex = fromLongIndex << 3;
        long mask = -1L << (int)fromIndex ^ 0xFFFFFFFFFFFFFFFFL | -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL;
        while (!this.bytes.compareAndSwapLong(byteIndex, l = this.bytes.readVolatileLong(byteIndex), l2 = l & mask)) {
        }
        return this;
    }

    @Override
    public DirectBitSet clear() {
        this.bytes.zeroOut();
        return this;
    }

    @Override
    public boolean get(long bitIndex) {
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long l = this.bytes.readVolatileLong(longIndex << 3);
        return (l & 1L << (int)bitIndex) != 0L;
    }

    @Override
    public long getLong(long longIndex) {
        if (longIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes.readVolatileLong(longIndex << 3);
    }

    @Override
    public long nextSetBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = this.bytes.readVolatileLong(fromLongIndex << 3) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.bytes.readLong(i << 3);
            if (l == 0L) continue;
            return (i << 6) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public long nextSetLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        if (this.bytes.readVolatileLong(fromLongIndex << 3) != 0L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            if (this.bytes.readLong(i << 3) == 0L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long nextClearBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = (this.bytes.readVolatileLong(fromLongIndex << 3) ^ 0xFFFFFFFFFFFFFFFFL) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return (i << 6) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public long setNFrom(long fromIndex, int numberOfBits) {
        if (numberOfBits != 1) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        do {
            long fromLongIndex;
            if ((fromLongIndex = fromIndex >> 6) >= this.longLength) {
                return -1L;
            }
            if ((fromIndex = this.nextClearBit(fromIndex)) != -1L) continue;
            return -1L;
        } while (!this.setIfClear(fromIndex));
        return fromIndex;
    }

    @Override
    public long nextClearLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        if (this.bytes.readVolatileLong(fromLongIndex << 3) != -1L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            if (this.bytes.readLong(i << 3) == -1L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousSetBit(long fromIndex) {
        long l;
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = this.bytes.readVolatileLong(fromLongIndex << 3) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.bytes.readLong(i << 3);
            if (l == 0L) continue;
            return (i << 6) + 63L - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public long previousSetLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            if (fromLongIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
        }
        if (this.bytes.readVolatileLong(fromLongIndex << 3) != 0L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            if (this.bytes.readLong(i << 3) == 0L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousClearBit(long fromIndex) {
        long l;
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = (this.bytes.readVolatileLong(fromLongIndex << 3) ^ 0xFFFFFFFFFFFFFFFFL) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return (i << 6) + 63L - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public long previousClearLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            if (fromLongIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
        }
        if (this.bytes.readVolatileLong(fromLongIndex << 3) != -1L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            if (this.bytes.readLong(i << 3) == -1L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long size() {
        return this.longLength << 6;
    }

    @Override
    public long cardinality() {
        long count = Long.bitCount(this.bytes.readVolatileLong(0L));
        for (long i = 1L; i < this.longLength; ++i) {
            count += (long)Long.bitCount(this.bytes.readLong(i << 3));
        }
        return count;
    }

    @Override
    public DirectBitSet and(long longIndex, long value) {
        long l2;
        long l;
        while ((l = this.bytes.readVolatileLong(longIndex << 3)) != (l2 = l & value) && !this.bytes.compareAndSwapLong(longIndex << 3, l, l2)) {
        }
        return this;
    }

    @Override
    public DirectBitSet or(long longIndex, long value) {
        long l2;
        long l;
        while ((l = this.bytes.readVolatileLong(longIndex << 3)) != (l2 = l | value) && !this.bytes.compareAndSwapLong(longIndex << 3, l, l2)) {
        }
        return this;
    }

    @Override
    public DirectBitSet xor(long longIndex, long value) {
        long l2;
        long l;
        while (!this.bytes.compareAndSwapLong(longIndex << 3, l = this.bytes.readVolatileLong(longIndex << 3), l2 = l ^ value)) {
        }
        return this;
    }

    @Override
    public DirectBitSet andNot(long longIndex, long value) {
        long l2;
        long l;
        while (!this.bytes.compareAndSwapLong(longIndex << 3, l = this.bytes.readVolatileLong(longIndex << 3), l2 = l & (value ^ 0xFFFFFFFFFFFFFFFFL))) {
        }
        return this;
    }
}

