/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.model;

import java.io.Externalizable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.Copyable;
import net.openhft.lang.model.DataValueModel;
import net.openhft.lang.model.FieldModel;
import net.openhft.lang.model.constraints.Digits;
import net.openhft.lang.model.constraints.MaxSize;
import net.openhft.lang.model.constraints.Range;

public class DataValueModelImpl<T>
implements DataValueModel<T> {
    private final Map<String, FieldModelImpl> fieldModelMap = new TreeMap<String, FieldModelImpl>();
    private final Class<T> type;
    private final Map<Class, DataValueModel> nestedMap = new HashMap<Class, DataValueModel>();
    static final Map<Class, Integer> HEAP_SIZE_MAP = new HashMap<Class, Integer>();

    public DataValueModelImpl(Class<T> type) {
        Method[] methods;
        this.type = type;
        if (!type.isInterface()) {
            throw new IllegalArgumentException("type must be an interface, was " + type);
        }
        block4: for (Method method : methods = type.getMethods()) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == Object.class || declaringClass == Externalizable.class || declaringClass == BytesMarshallable.class || declaringClass == Copyable.class || declaringClass == Byteable.class) continue;
            String name = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            switch (parameterTypes.length) {
                case 0: {
                    if (returnType == Void.TYPE) {
                        throw new IllegalArgumentException("void () not supported " + method);
                    }
                    String name2 = DataValueModelImpl.getGetter(name, returnType);
                    FieldModelImpl fm = this.acquireField(name2);
                    fm.getter(method);
                    continue block4;
                }
                case 1: {
                    if (returnType != Void.TYPE) {
                        throw new IllegalArgumentException("setter must be void " + method);
                    }
                    String name2 = DataValueModelImpl.getSetter(name);
                    FieldModelImpl fm = this.acquireField(name2);
                    fm.setter(method);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("method not supported " + method);
                }
            }
        }
        for (Map.Entry<String, FieldModelImpl> entry : this.fieldModelMap.entrySet()) {
            FieldModelImpl model = entry.getValue();
            if (model.getter() == null || model.setter() == null) {
                throw new IllegalArgumentException("Field " + entry.getKey() + " must have a getter and setter.");
            }
            Class ftype = model.type();
            if (this.isScalar(ftype) || this.nestedMap.containsKey(ftype)) continue;
            this.nestedMap.put(ftype, new DataValueModelImpl(ftype));
        }
    }

    private FieldModelImpl acquireField(String name) {
        FieldModelImpl fieldModelImpl = this.fieldModelMap.get(name);
        if (fieldModelImpl == null) {
            fieldModelImpl = new FieldModelImpl(name);
            this.fieldModelMap.put(name, fieldModelImpl);
        }
        return fieldModelImpl;
    }

    private static String getSetter(String name) {
        if (name.length() > 3 && name.startsWith("set") && Character.isUpperCase(name.charAt(3))) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        return name;
    }

    private static String getGetter(String name, Class returnType) {
        if (name.length() > 3 && name.startsWith("get") && Character.isUpperCase(name.charAt(3))) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        if ((returnType == Boolean.TYPE || returnType == Boolean.class) && name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2))) {
            return Character.toLowerCase(name.charAt(2)) + name.substring(3);
        }
        return name;
    }

    @Override
    public Map<String, ? extends FieldModel> fieldMap() {
        return this.fieldModelMap;
    }

    @Override
    public boolean isScalar(Class type) {
        return type.isPrimitive() || CharSequence.class.isAssignableFrom(type);
    }

    @Override
    public Set<Class> nestedModels() {
        return this.nestedMap.keySet();
    }

    @Override
    public <N> DataValueModel<N> nestedModel(Class<N> nClass) {
        DataValueModelImpl model = nClass == this.type ? this : this.nestedMap.get(nClass);
        return model;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    static {
        HEAP_SIZE_MAP.put(Boolean.TYPE, 1);
        HEAP_SIZE_MAP.put(Byte.TYPE, 8);
        HEAP_SIZE_MAP.put(Character.TYPE, 16);
        HEAP_SIZE_MAP.put(Short.TYPE, 16);
        HEAP_SIZE_MAP.put(Integer.TYPE, 32);
        HEAP_SIZE_MAP.put(Float.TYPE, 32);
        HEAP_SIZE_MAP.put(Long.TYPE, 64);
        HEAP_SIZE_MAP.put(Double.TYPE, 64);
    }

    static class FieldModelImpl<T>
    implements FieldModel<T> {
        private final String name;
        private Method getter;
        private Method setter;
        private Digits digits;
        private Range range;
        private MaxSize maxSize;

        public FieldModelImpl(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        public void getter(Method getter) {
            this.getter = getter;
        }

        @Override
        public Method getter() {
            return this.getter;
        }

        public void setter(Method setter) {
            this.setter = setter;
            for (Annotation a : setter.getParameterAnnotations()[0]) {
                if (a instanceof Digits) {
                    this.digits = (Digits)a;
                }
                if (a instanceof Range) {
                    this.range = (Range)a;
                }
                if (!(a instanceof MaxSize)) continue;
                this.maxSize = (MaxSize)a;
            }
        }

        @Override
        public Method setter() {
            return this.setter;
        }

        @Override
        public Class<T> type() {
            return this.getter.getReturnType();
        }

        @Override
        public int heapSize() {
            Integer size = HEAP_SIZE_MAP.get(this.type());
            if (size == null) {
                return -1;
            }
            return size;
        }

        @Override
        public int nativeSize() {
            Integer size = HEAP_SIZE_MAP.get(this.type());
            if (size != null) {
                return size;
            }
            MaxSize maxSize2 = this.size();
            if (maxSize2 == null) {
                throw new AssertionError((Object)(this.type() + " without a @MaxSize not supported for native types"));
            }
            return maxSize2.value() << 3;
        }

        @Override
        public Digits digits() {
            return this.digits;
        }

        @Override
        public Range range() {
            return this.range;
        }

        @Override
        public MaxSize size() {
            return this.maxSize;
        }

        public String toString() {
            return "FieldModel{name='" + this.name + '\'' + ", getter=" + this.getter + ", setter=" + this.setter + (this.digits == null ? "" : ", digits= " + this.digits) + (this.range == null ? "" : ", range= " + this.range) + (this.maxSize == null ? "" : ", size= " + this.maxSize) + '}';
        }
    }
}

