/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.direct;

import java.lang.reflect.Field;
import java.util.List;
import net.openhft.lang.Jvm;
import net.openhft.lang.io.NativeBytes;

public class DirectSerializationMetadata {
    private static final int OBJECT_ALIGNMENT = 8;
    private static final int OBJECT_ALIGNMENT_MASK = 7;
    static final long NATIVE_WORD_SIZE = Jvm.is64Bit() ? 8L : 4L;
    static final long OOP_SIZE = NativeBytes.UNSAFE.arrayIndexScale(Object[].class);
    static final long OBJECT_HEADER_SIZE = NATIVE_WORD_SIZE + OOP_SIZE;
    public static final SerializationMetadata EmptyObjectMetadata = new SerializationMetadata(0L, 0L);

    public static SerializationMetadata extractMetadata(List<Field> fields) {
        if (fields.isEmpty()) {
            return EmptyObjectMetadata;
        }
        Offsets offsets = DirectSerializationMetadata.minMaxOffsets(fields);
        long totalSize = OBJECT_HEADER_SIZE + offsets.max - offsets.min + 1L;
        return new SerializationMetadata(offsets.min, DirectSerializationMetadata.padToObjectAlignment(totalSize) - OBJECT_HEADER_SIZE);
    }

    public static SerializationMetadata extractMetadataForPartialCopy(List<Field> fields) {
        if (fields.isEmpty()) {
            return EmptyObjectMetadata;
        }
        Offsets offsets = DirectSerializationMetadata.minMaxOffsets(fields);
        Field lastField = fields.get(fields.size() - 1);
        return new SerializationMetadata(offsets.min, offsets.max + DirectSerializationMetadata.sizeOf(lastField) - OBJECT_HEADER_SIZE);
    }

    private static Offsets minMaxOffsets(List<Field> fields) {
        long minOffset = NativeBytes.UNSAFE.objectFieldOffset(fields.get(0));
        long maxOffset = NativeBytes.UNSAFE.objectFieldOffset(fields.get(fields.size() - 1));
        return new Offsets(minOffset, maxOffset);
    }

    static long padToObjectAlignment(long length) {
        if ((length & 7L) != 0L) {
            long padding = 8L - (length & 7L);
            length += padding;
        }
        return length;
    }

    private static long sizeOf(Field field) {
        if (Boolean.TYPE.equals(field.getType())) {
            return 1L;
        }
        if (Byte.TYPE.equals(field.getType())) {
            return 1L;
        }
        if (Short.TYPE.equals(field.getType())) {
            return 2L;
        }
        if (Character.TYPE.equals(field.getType())) {
            return 2L;
        }
        if (Integer.TYPE.equals(field.getType())) {
            return 4L;
        }
        if (Float.TYPE.equals(field.getType())) {
            return 4L;
        }
        return 8L;
    }

    private static final class Offsets {
        public final long min;
        public final long max;

        private Offsets(long min, long max) {
            this.min = min;
            this.max = max;
        }
    }

    public static final class SerializationMetadata {
        final long start;
        final long length;

        SerializationMetadata(long start, long length) {
            this.start = start;
            this.length = length;
        }

        public String toString() {
            return String.format("SerializationMetadata: Start %s Length %s", this.start, this.length);
        }
    }
}

