/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesMarshaller;
import net.openhft.lang.io.StopCharTester;
import org.jetbrains.annotations.NotNull;

public class ExternalizableMarshaller<E extends Externalizable>
implements BytesMarshaller<E> {
    @NotNull
    private final Class<E> classMarshaled;
    private final Constructor<E> constructor;

    public ExternalizableMarshaller(@NotNull Class<E> classMarshaled) {
        this.classMarshaled = classMarshaled;
        try {
            this.constructor = classMarshaled.getConstructor(new Class[0]);
            this.constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public Class<E> classMarshaled() {
        return this.classMarshaled;
    }

    @Override
    public void write(Bytes bytes, @NotNull E e) {
        try {
            e.writeExternal(bytes);
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public void append(Bytes bytes, @NotNull E e) {
        this.write(bytes, e);
    }

    @Override
    public E read(Bytes bytes) {
        try {
            Externalizable e = (Externalizable)this.constructor.newInstance(new Object[0]);
            e.readExternal(bytes);
            return (E)e;
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public E parse(Bytes bytes, StopCharTester tester) {
        return (E)this.read(bytes);
    }
}

