/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.compiler;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import net.openhft.compiler.CachedCompiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public enum CompilerUtils {

    public static final boolean DEBUGGING = CompilerUtils.isDebug();
    public static final CachedCompiler CACHED_COMPILER = new CachedCompiler(null, null);
    private static final Logger LOGGER = LoggerFactory.getLogger(CompilerUtils.class);
    private static final Method DEFINE_CLASS_METHOD;
    private static final Charset UTF_8;
    private static final String JAVA_CLASS_PATH = "java.class.path";
    static JavaCompiler s_compiler;
    static StandardJavaFileManager s_standardJavaFileManager;

    private static boolean isDebug() {
        String inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments().toString();
        return inputArguments.contains("-Xdebug") || inputArguments.contains("-agentlib:jdwp=");
    }

    private static void reset() {
        s_compiler = ToolProvider.getSystemJavaCompiler();
        if (s_compiler == null) {
            try {
                Class<?> javacTool = Class.forName("com.sun.tools.javac.api.JavacTool");
                Method create = javacTool.getMethod("create", new Class[0]);
                s_compiler = (JavaCompiler)create.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static Class<?> loadFromResource(@NotNull String className, @NotNull String resourceName) throws IOException, ClassNotFoundException {
        return CompilerUtils.loadFromJava(className, CompilerUtils.readText(resourceName));
    }

    private static Class<?> loadFromJava(@NotNull String className, @NotNull String javaCode) throws ClassNotFoundException {
        return CACHED_COMPILER.loadFromJava(Thread.currentThread().getContextClassLoader(), className, javaCode);
    }

    public static boolean addClassPath(@NotNull String dir) {
        File file = new File(dir);
        if (file.exists()) {
            String path;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException ignored) {
                path = file.getAbsolutePath();
            }
            if (!Arrays.asList(System.getProperty(JAVA_CLASS_PATH).split(File.pathSeparator)).contains(path)) {
                System.setProperty(JAVA_CLASS_PATH, System.getProperty(JAVA_CLASS_PATH) + File.pathSeparator + path);
            }
        } else {
            return false;
        }
        CompilerUtils.reset();
        return true;
    }

    public static void defineClass(@NotNull String className, @NotNull byte[] bytes) {
        CompilerUtils.defineClass(Thread.currentThread().getContextClassLoader(), className, bytes);
    }

    public static Class<?> defineClass(@Nullable ClassLoader classLoader, @NotNull String className, @NotNull byte[] bytes) {
        try {
            return (Class)DEFINE_CLASS_METHOD.invoke((Object)classLoader, className, bytes, 0, bytes.length);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readText(@NotNull String resourceName) throws IOException {
        if (resourceName.startsWith("=")) {
            return resourceName.substring(1);
        }
        StringWriter sw = new StringWriter();
        InputStreamReader isr = new InputStreamReader(CompilerUtils.getInputStream(resourceName), UTF_8);
        try {
            int len;
            char[] chars = new char[8192];
            while ((len = isr.read(chars)) > 0) {
                sw.write(chars, 0, len);
            }
        }
        finally {
            CompilerUtils.close(isr);
        }
        return sw.toString();
    }

    @NotNull
    private static String decodeUTF8(@NotNull byte[] bytes) {
        try {
            return new String(bytes, UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nullable
    private static byte[] readBytes(@NotNull File file) {
        if (!file.exists()) {
            return null;
        }
        long len = file.length();
        if (len > Runtime.getRuntime().totalMemory() / 10L) {
            throw new IllegalStateException("Attempted to read large file " + file + " was " + len + " bytes.");
        }
        byte[] bytes = new byte[(int)len];
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(file));
            dis.readFully(bytes);
        }
        catch (IOException e) {
            CompilerUtils.close(dis);
            LOGGER.warn("Unable to read {}", (Object)file, (Object)e);
            throw new IllegalStateException("Unable to read file " + file, e);
        }
        return bytes;
    }

    private static void close(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOGGER.trace("Failed to close {}", (Object)closeable, (Object)e);
            }
        }
    }

    public static boolean writeText(@NotNull File file, @NotNull String text) {
        return CompilerUtils.writeBytes(file, CompilerUtils.encodeUTF8(text));
    }

    @NotNull
    private static byte[] encodeUTF8(@NotNull String text) {
        try {
            return text.getBytes(UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean writeBytes(@NotNull File file, @NotNull byte[] bytes) {
        File parentDir = file.getParentFile();
        if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
            throw new IllegalStateException("Unable to create directory " + parentDir);
        }
        File bak = null;
        if (file.exists()) {
            byte[] bytes2 = CompilerUtils.readBytes(file);
            if (Arrays.equals(bytes, bytes2)) {
                return false;
            }
            bak = new File(parentDir, file.getName() + ".bak");
            file.renameTo(bak);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(bytes);
        }
        catch (IOException e) {
            CompilerUtils.close(fos);
            LOGGER.warn("Unable to write {} as {}", new Object[]{file, CompilerUtils.decodeUTF8(bytes), e});
            file.delete();
            if (bak != null) {
                bak.renameTo(file);
            }
            throw new IllegalStateException("Unable to write " + file, e);
        }
        return true;
    }

    @NotNull
    private static InputStream getInputStream(@NotNull String filename) throws FileNotFoundException {
        if (filename.isEmpty()) {
            throw new IllegalArgumentException("The file name cannot be empty.");
        }
        if (filename.charAt(0) == '=') {
            return new ByteArrayInputStream(CompilerUtils.encodeUTF8(filename.substring(1)));
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = contextClassLoader.getResourceAsStream(filename);
        if (is != null) {
            return is;
        }
        InputStream is2 = contextClassLoader.getResourceAsStream('/' + filename);
        if (is2 != null) {
            return is2;
        }
        return new FileInputStream(filename);
    }

    static {
        UTF_8 = Charset.forName("UTF-8");
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Unsafe u = (Unsafe)theUnsafe.get(null);
            DEFINE_CLASS_METHOD = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            try {
                Field f = AccessibleObject.class.getDeclaredField("override");
                long offset = u.objectFieldOffset(f);
                u.putBoolean(DEFINE_CLASS_METHOD, offset, true);
            }
            catch (NoSuchFieldException e) {
                DEFINE_CLASS_METHOD.setAccessible(true);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        CompilerUtils.reset();
    }
}

