/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.scoped.ScopedResourcePool;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryReadDocumentContext
implements ReadDocumentContext {
    public long start = -1L;
    public long lastStart = -1L;
    @Nullable
    protected Wire wire;
    protected boolean present;
    protected boolean notComplete;
    protected long readPosition;
    protected long readLimit;
    protected boolean metaData;
    protected boolean rollback;
    static final ScopedResourcePool<StringBuilder> SBP = StringBuilderPool.createThreadLocal((int)1);

    public BinaryReadDocumentContext(@Nullable Wire wire) {
        this.wire = wire;
    }

    @Deprecated
    public BinaryReadDocumentContext(@Nullable Wire wire, boolean ensureFullRead) {
        this.wire = wire;
        assert (!ensureFullRead) : "DeltaWire not supported";
    }

    @Override
    public boolean isMetaData() {
        return this.metaData;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public void closeReadPosition(long readPosition) {
        this.readPosition = readPosition;
    }

    @Override
    public void closeReadLimit(long readLimit) {
        this.readLimit = readLimit;
    }

    @Override
    @Nullable
    public Wire wire() {
        return this.wire;
    }

    protected boolean rollback() {
        return this.rollback;
    }

    @Override
    public void close() {
        if (this.rollbackIfNeeded()) {
            return;
        }
        long readLimit0 = this.readLimit;
        long readPosition0 = this.readPosition;
        Wire wire0 = this.wire;
        this.start = -1L;
        if (readLimit0 > 0L && wire0 != null) {
            @NotNull Bytes<?> bytes = wire0.bytes();
            bytes.readLimit(readLimit0);
            if (this.wire.usePadding()) {
                readPosition0 += BytesUtil.padOffset((long)readPosition0);
            }
            bytes.readPosition(Math.min(readLimit0, readPosition0));
        }
        this.present = false;
    }

    @Override
    public void reset() {
        this.close();
        this.readPosition = 0L;
        this.readLimit = 0L;
        this.start = -1L;
        this.lastStart = -1L;
    }

    protected boolean rollbackIfNeeded() {
        if (this.rollback) {
            this.present = false;
            this.rollback = false;
            if (this.start > -1L) {
                ((Bytes)this.wire.bytes().readPosition(this.start)).readLimit(this.readLimit);
            }
            this.start = -1L;
            return true;
        }
        return false;
    }

    @Override
    public void start() {
        this.rollback = false;
        this.wire.getValueIn().resetState();
        this.wire.getValueOut().resetBetweenDocuments();
        this.readLimit = -1L;
        this.readPosition = -1L;
        @NotNull Bytes<?> bytes = this.wire.bytes();
        this.setStart(bytes.readPosition());
        this.present = false;
        if (bytes.readRemaining() < 4L) {
            this.notComplete = false;
            return;
        }
        long position = bytes.readPositionForHeader(this.wire.usePadding());
        int header = bytes.readVolatileInt(position);
        this.notComplete = Wires.isNotComplete(header);
        if (header == 0 || this.wire.notCompleteIsNotPresent() && this.notComplete) {
            return;
        }
        bytes.readSkip(4L);
        int len = Wires.lengthOf(header);
        if ((long)len > bytes.readRemaining()) {
            bytes.readSkip(-4L);
            return;
        }
        this.metaData = Wires.isReadyMetaData(header);
        this.readLimit = bytes.readLimit();
        this.readPosition = bytes.readPosition() + (long)len;
        bytes.readLimit(this.readPosition);
        this.present = true;
    }

    @Override
    public long index() {
        return this.readPosition;
    }

    @Override
    public int sourceId() {
        return -1;
    }

    @Override
    public boolean isNotComplete() {
        return this.notComplete;
    }

    @Override
    public void rollbackOnClose() {
        this.rollback = true;
    }

    public void setStart(long start) {
        this.start = start;
        this.lastStart = start;
    }

    public String toString() {
        return Wires.fromSizePrefixedBlobs(this);
    }
}

