/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.converter;

import java.util.Arrays;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.LongConverter;

public class SymbolsLongConverter
implements LongConverter {
    private final int factor;
    private final short[] encode;
    private final char[] decode;
    private final int maxParseLength;

    public SymbolsLongConverter(String symbols) {
        int length;
        this.factor = length = symbols.length();
        this.decode = symbols.toCharArray();
        this.encode = new short[128];
        Arrays.fill(this.encode, (short)-1);
        for (int i = 0; i < this.decode.length; ++i) {
            this.encode[this.decode[i]] = (short)i;
        }
        this.maxParseLength = LongConverter.maxParseLength(length);
    }

    @Override
    public int maxParseLength() {
        return this.maxParseLength;
    }

    @Override
    public long parse(CharSequence textToParse) {
        this.lengthCheck(textToParse);
        return this.parse0(textToParse, 0, textToParse.length());
    }

    @Override
    public long parse(CharSequence textToParse, int beginIndex, int endIndex) {
        this.lengthCheck(textToParse, beginIndex, endIndex);
        return this.parse0(textToParse, beginIndex, endIndex);
    }

    private long parse0(CharSequence text, int beginIndex, int endIndex) {
        long v = 0L;
        for (int i = beginIndex; i < endIndex; ++i) {
            char ch = text.charAt(i);
            if (ch >= this.encode.length || this.encode[ch] < 0) {
                throw new IllegalArgumentException("Unexpected character '" + ch + "' in \"" + text + "\"");
            }
            v = v * (long)this.factor + (long)this.encode[ch];
        }
        return v;
    }

    @Override
    public void append(StringBuilder destinationBuilder, long numericValue) {
        int v;
        int start = destinationBuilder.length();
        if (numericValue < 0L) {
            v = (int)Long.remainderUnsigned(numericValue, this.factor);
            numericValue = Long.divideUnsigned(numericValue, this.factor);
            destinationBuilder.append(this.decode[v]);
        }
        while (numericValue != 0L) {
            v = (int)(numericValue % (long)this.factor);
            numericValue /= (long)this.factor;
            destinationBuilder.append(this.decode[v]);
        }
        StringUtils.reverse((StringBuilder)destinationBuilder, (int)start);
        if (destinationBuilder.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            destinationBuilder.setLength(start + this.maxParseLength());
        }
    }

    @Override
    public void append(Bytes<?> destination, long numericValue) {
        int v;
        int start = destination.length();
        if (numericValue < 0L) {
            v = (int)Long.remainderUnsigned(numericValue, this.factor);
            numericValue = Long.divideUnsigned(numericValue, this.factor);
            destination.append(this.decode[v]);
        }
        while (numericValue != 0L) {
            v = (int)(numericValue % (long)this.factor);
            numericValue /= (long)this.factor;
            destination.append(this.decode[v]);
        }
        BytesUtil.reverse(destination, (int)start);
        if (destination.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            destination.readLimit((long)start + (long)this.maxParseLength());
        }
    }

    @Override
    public void addEncode(char alias, char as) {
        this.encode[alias] = this.encode[as];
    }
}

