/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.util.InvocationTargetRuntimeException;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.AbstractMarshallableCfg;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.FieldNumberParselet;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodFilterOnFirstArg;
import net.openhft.chronicle.wire.MethodWireKey;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ReflectionUtil;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireParselet;
import net.openhft.chronicle.wire.WireParser;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class VanillaMethodReader
implements MethodReader {
    public static final boolean DEBUG_ENABLED = Jvm.isDebugEnabled(VanillaMethodReader.class) && Jvm.getBoolean((String)"wire.mr.debug");
    static final Object[] NO_ARGS = new Object[0];
    static final Object IGNORED = new Object();
    private final MarshallableIn in;
    @NotNull
    private final WireParser metaWireParser;
    private final WireParser dataWireParser;
    private final MethodReaderInterceptorReturns methodReaderInterceptorReturns;
    private final Predicate<MethodReader> predicate;
    private MessageHistory messageHistory;
    private boolean closeIn = false;
    private boolean closed;

    @UsedViaReflection
    public VanillaMethodReader(MarshallableIn in, boolean ignoreDefault, WireParselet defaultParselet, MethodReaderInterceptorReturns methodReaderInterceptorReturns, Object[] metadataHandlers, Object ... handlers) {
        this(in, ignoreDefault, defaultParselet, VanillaWireParser.SKIP_READABLE_BYTES, methodReaderInterceptorReturns, metadataHandlers, handlers);
    }

    @UsedViaReflection
    public VanillaMethodReader(MarshallableIn in, boolean ignoreDefault, WireParselet defaultParselet, FieldNumberParselet fieldNumberParselet, MethodReaderInterceptorReturns methodReaderInterceptorReturns, Object ... handlers) {
        this(in, ignoreDefault, defaultParselet, fieldNumberParselet, methodReaderInterceptorReturns, (Object[])null, handlers);
    }

    public VanillaMethodReader(MarshallableIn in, boolean ignoreDefault, WireParselet defaultParselet, FieldNumberParselet fieldNumberParselet, MethodReaderInterceptorReturns methodReaderInterceptorReturns, Object[] metadataHandlers, Object ... handlers) {
        this(in, ignoreDefault, defaultParselet, fieldNumberParselet, methodReaderInterceptorReturns, metadataHandlers, (MethodReader x) -> true, handlers);
    }

    public VanillaMethodReader(MarshallableIn in, boolean ignoreDefault, WireParselet defaultParselet, FieldNumberParselet fieldNumberParselet, MethodReaderInterceptorReturns methodReaderInterceptorReturns, Object[] metadataHandlers, Predicate<MethodReader> predicate, Object ... handlers) {
        this.in = in;
        this.methodReaderInterceptorReturns = methodReaderInterceptorReturns;
        this.predicate = predicate;
        if (handlers[0] instanceof WireParselet) {
            defaultParselet = (WireParselet)handlers[0];
        }
        this.metaWireParser = WireParser.wireParser((s, in0) -> in0.skipValue());
        this.dataWireParser = WireParser.wireParser(defaultParselet, fieldNumberParselet);
        this.addParsersForComponents(this.metaWireParser, ignoreDefault, this.addObjectsToMetaDataHandlers(metadataHandlers, handlers));
        this.addParsersForComponents(this.dataWireParser, ignoreDefault, handlers);
        if (this.dataWireParser.lookup("history") == null) {
            this.dataWireParser.register(new MethodWireKey("history", -1), (s, v) -> v.marshallable(this.messageHistory));
        }
    }

    private static LongConversion longConversionForFirstParam(Method method) {
        Annotation[][] annotations = method.getParameterAnnotations();
        if (annotations.length < 1 || annotations[0].length < 1) {
            return null;
        }
        for (Annotation annotation : annotations[0]) {
            if (!(annotation instanceof LongConversion)) continue;
            return (LongConversion)annotation;
        }
        return null;
    }

    private static void invokeMethodWithOneLong(Object target, Object[] contextHolder, @NotNull Method method, String methodName, MethodHandle methodHandle, Object[] argHolder, CharSequence eventName, ValueIn valueIn, MethodReaderInterceptorReturns interceptor) {
        block16: {
            try {
                if (Jvm.isDebug()) {
                    VanillaMethodReader.logMessage(eventName, valueIn);
                }
                if (contextHolder[0] == null) {
                    VanillaMethodReader.updateContext(contextHolder, target);
                }
                long arg = 0L;
                if (valueIn.isBinary()) {
                    arg = valueIn.int64();
                } else {
                    LongConversion lc = VanillaMethodReader.longConversionForFirstParam(method);
                    if (lc == null) {
                        arg = valueIn.int64();
                    } else {
                        String text = valueIn.text();
                        if (text != null && !text.isEmpty()) {
                            LongConverter longConverter = (LongConverter)ObjectUtils.newInstance(lc.value());
                            arg = longConverter.parse(text);
                        }
                    }
                }
                if (interceptor != null) {
                    argHolder[0] = arg;
                    Object intercept = interceptor.intercept(method, contextHolder[0], argHolder, VanillaMethodReader::actualInvoke);
                    VanillaMethodReader.updateContext(contextHolder, intercept);
                    break block16;
                }
                if (methodHandle == null) {
                    argHolder[0] = arg;
                    VanillaMethodReader.updateContext(contextHolder, method.invoke(contextHolder[0], argHolder));
                    break block16;
                }
                try {
                    if (method.getReturnType() == Void.TYPE) {
                        methodHandle.invokeExact(arg);
                        VanillaMethodReader.updateContext(contextHolder, null);
                    } else {
                        VanillaMethodReader.updateContext(contextHolder, methodHandle.invokeExact(arg));
                    }
                }
                catch (Throwable t) {
                    throw new InvocationTargetException(t);
                }
            }
            catch (InvocationTargetException e) {
                throw new InvocationTargetRuntimeException((Throwable)e);
            }
            catch (Throwable e) {
                String msg = "Failure to dispatch message: " + method.getName() + " " + Arrays.asList(argHolder);
                Jvm.warn().on(target.getClass(), msg, e);
            }
        }
    }

    private static void updateContext(Object[] contextHolder, Object intercept) {
        contextHolder[0] = intercept;
    }

    private static Object actualInvoke(Method method, Object target, Object[] args) throws InvocationTargetException {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException iae) {
            throw Jvm.rethrow((Throwable)iae);
        }
    }

    public static void logMessage(@NotNull CharSequence eventName, @NotNull ValueIn valueIn) {
        if (!DEBUG_ENABLED) {
            return;
        }
        Jvm.debug().on(VanillaMethodReader.class, VanillaMethodReader.logMessage0(eventName, valueIn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static String logMessage0(@NotNull CharSequence eventName, @NotNull ValueIn valueIn) {
        try {
            String rest;
            if (valueIn.wireIn().isBinary()) {
                Bytes<?> bytes0 = valueIn.wireIn().bytes();
                OnHeapBytes bytes = Bytes.allocateElasticOnHeap((int)((int)(bytes0.readRemaining() * 3L / 2L + 64L)));
                long pos = bytes0.readPosition();
                try {
                    valueIn.wireIn().copyTo((WireOut)WireType.TEXT.apply(bytes));
                    rest = bytes.toString();
                }
                catch (Exception t) {
                    rest = bytes0.toHexString(pos, bytes0.readLimit() - pos);
                }
                finally {
                    bytes0.readPosition(pos);
                    bytes.releaseLast();
                }
            } else {
                rest = valueIn.toString();
            }
            if (rest.endsWith("\n")) {
                rest = rest.substring(0, rest.length() - 1);
            }
            return "read " + eventName + " - " + rest;
        }
        catch (Exception e) {
            return "read " + eventName + " - " + e;
        }
    }

    private Object[] addObjectsToMetaDataHandlers(Object[] metadataHandlers, @NotNull @NotNull Object @NotNull [] handlers) {
        if (metadataHandlers == null) {
            metadataHandlers = handlers;
        } else {
            LinkedHashSet metaHandlerSet = new LinkedHashSet();
            Collections.addAll(metaHandlerSet, metadataHandlers);
            Collections.addAll(metaHandlerSet, handlers);
            metadataHandlers = metaHandlerSet.toArray();
        }
        return metadataHandlers;
    }

    private void addParsersForComponents(WireParser wireParser, boolean ignoreDefault, @NotNull @NotNull Object @NotNull [] handlers) {
        @NotNull HashSet<String> methodsSignaturesHandled = new HashSet<String>();
        @NotNull HashSet<String> methodsNamesHandled = new HashSet<String>();
        MethodFilterOnFirstArg methodFilterOnFirstArg = null;
        for (Object o : handlers) {
            if (o instanceof MethodFilterOnFirstArg) {
                if (methodFilterOnFirstArg != null) {
                    Jvm.warn().on(this.getClass(), "Multiple filters on first arg not supported, only the first one is applied.");
                } else {
                    methodFilterOnFirstArg = (MethodFilterOnFirstArg)o;
                }
            }
            Class<?> oClass = o.getClass();
            Object[] context = new Object[]{null};
            Supplier<Object> original = () -> o;
            Supplier<Object> inarray = () -> context[0];
            LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
            for (Class<?> anInterface : ReflectionUtil.interfaces(oClass)) {
                this.addParsletsFor(wireParser, interfaces, anInterface, ignoreDefault, methodsNamesHandled, methodsSignaturesHandled, methodFilterOnFirstArg, o, context, original, inarray);
            }
        }
    }

    private void addParsletsFor(WireParser wireParser, Set<Class> interfaces, Class<?> handlerClass, boolean ignoreDefault, Set<String> methodNamesHandled, Set<String> methodsSignaturesHandled, MethodFilterOnFirstArg methodFilterOnFirstArg, Object handler, Object[] contextHolder, Supplier contextSupplier, Supplier nextContextSupplier) {
        if (!handlerClass.isInterface() || Jvm.dontChain(handlerClass)) {
            return;
        }
        if (!interfaces.add(handlerClass)) {
            return;
        }
        block6: for (Method m : handlerClass.getMethods()) {
            Class<?> declaringClass = m.getDeclaringClass();
            if (declaringClass == Object.class || Modifier.isStatic(m.getModifiers()) || ignoreDefault && declaringClass.isInterface() || "ignoreMethodBasedOnFirstArg".equals(m.getName()) || !methodsSignaturesHandled.add(this.signature(m))) continue;
            try {
                Object.class.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!methodNamesHandled.add(m.getName())) {
                    String previous = methodsSignaturesHandled.stream().filter(signature -> signature.contains(" " + m.getName() + " ")).findFirst().orElseThrow(IllegalStateException::new);
                    String msg = m + " previous: " + previous;
                    throw new IllegalStateException("MethodReader does not support overloaded methods. Method: " + msg);
                }
                Class[] parameterTypes = m.getParameterTypes();
                switch (parameterTypes.length) {
                    case 0: {
                        this.addParseletForMethod(wireParser, handler, contextHolder, contextSupplier, m);
                        continue block6;
                    }
                    case 1: {
                        this.addParseletForMethod(wireParser, handler, contextHolder, contextSupplier, m, parameterTypes[0]);
                        continue block6;
                    }
                    default: {
                        if (methodFilterOnFirstArg == null) {
                            this.addParseletForMethod(wireParser, handler, contextHolder, contextSupplier, m, parameterTypes);
                            continue block6;
                        }
                        this.addParseletForMethod(wireParser, handler, contextHolder, contextSupplier, m, parameterTypes, methodFilterOnFirstArg);
                    }
                }
            }
        }
        for (Method m : handlerClass.getMethods()) {
            Class<?> returnType = m.getReturnType();
            this.addParsletsFor(wireParser, interfaces, returnType, ignoreDefault, methodNamesHandled, methodsSignaturesHandled, methodFilterOnFirstArg, handler, contextHolder, nextContextSupplier, nextContextSupplier);
        }
    }

    private String signature(Method method) {
        return method.getReturnType() + " " + method.getName() + " " + Arrays.toString(method.getParameterTypes());
    }

    @NotNull
    public VanillaMethodReader closeIn(boolean closeIn) {
        this.throwExceptionIfClosed();
        this.closeIn = closeIn;
        return this;
    }

    public void throwExceptionIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
    }

    public void addParseletForMethod(WireParser wireParser, Object target, Object[] contextHolder, Supplier contextSupplier, @NotNull Method method, Class<?> parameterType) {
        this.throwExceptionIfClosed();
        Jvm.setAccessible((AccessibleObject)method);
        String name = method.getName();
        Class parameterType2 = ObjectUtils.implementationToUse(parameterType);
        if (parameterType == Long.TYPE && target != null) {
            try {
                MethodHandle mh = method.getDeclaringClass().isInstance(target) ? MethodHandles.lookup().unreflect(method).bindTo(target) : null;
                Object[] argArr = new Object[]{null};
                MethodWireKey key = this.createWireKey(method, name);
                wireParser.registerOnce(key, (s, v) -> VanillaMethodReader.invokeMethodWithOneLong(target, contextHolder, method, name, mh, argArr, s, v, this.methodReaderInterceptorReturns));
            }
            catch (IllegalAccessException e) {
                Jvm.warn().on(target.getClass(), "Unable to unreflect " + method, (Throwable)e);
            }
        } else if (parameterType.isPrimitive() || parameterType2.isInterface() || !ReadMarshallable.class.isAssignableFrom(parameterType2)) {
            Object[] argArr = new Object[]{null};
            MethodWireKey key = this.createWireKey(method, name);
            wireParser.registerOnce(key, (s, v) -> {
                if (Jvm.isDebug()) {
                    VanillaMethodReader.logMessage(s, v);
                }
                argArr[0] = v.object(this.checkRecycle(argArr[0]), parameterType2);
                if (contextHolder[0] == null) {
                    VanillaMethodReader.updateContext(contextHolder, target);
                }
                Object invoke = this.invoke(contextHolder[0], method, argArr);
                VanillaMethodReader.updateContext(contextHolder, invoke);
            });
        } else {
            ReadMarshallable arg = (ReadMarshallable)ObjectUtils.newInstance((Class)parameterType2);
            ReadMarshallable[] argArr = new ReadMarshallable[]{arg};
            MethodWireKey key = this.createWireKey(method, name);
            wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$8(argArr, parameterType2, contextHolder, target, (Supplier)contextSupplier, method, arg_0, arg_1));
        }
    }

    public void addParseletForMethod(WireParser wireParser, Object target, Object[] contextHolder, Supplier contextSupplier, @NotNull Method method) {
        this.throwExceptionIfClosed();
        Jvm.setAccessible((AccessibleObject)method);
        String name = method.getName();
        MethodWireKey key = this.createWireKey(method, name);
        wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$9((Supplier)contextSupplier, method, contextHolder, target, arg_0, arg_1));
    }

    @NotNull
    protected MethodWireKey createWireKey(@NotNull Method method, String name) {
        MethodId annotation = (MethodId)Jvm.findAnnotation((AnnotatedElement)method, MethodId.class);
        return new MethodWireKey(name, annotation == null ? name.hashCode() : Maths.toInt32((long)annotation.value()));
    }

    public void addParseletForMethod(WireParser wireParser, Object target, Object[] contextHolder, Supplier contextSupplier, @NotNull Method method, @NotNull Class[] parameterTypes) {
        this.throwExceptionIfClosed();
        Jvm.setAccessible((AccessibleObject)method);
        @NotNull Object[] args = new Object[parameterTypes.length];
        @NotNull BiConsumer<Object[], ValueIn> sequenceReader = (a, v) -> {
            int i = 0;
            for (Class clazz : parameterTypes) {
                a[i] = v.object(this.checkRecycle(a[i]), clazz);
                ++i;
            }
        };
        String name = method.getName();
        MethodWireKey key = this.createWireKey(method, name);
        wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$11(args, sequenceReader, (Supplier)contextSupplier, method, contextHolder, target, arg_0, arg_1));
    }

    private <T> T checkRecycle(T instance) {
        if (instance instanceof Collection) {
            ((Collection)instance).clear();
            return instance;
        }
        if (instance instanceof Map) {
            ((Map)instance).clear();
            return instance;
        }
        if (instance instanceof AbstractMarshallableCfg) {
            ((AbstractMarshallableCfg)instance).reset();
        }
        return (T)(instance instanceof Marshallable ? instance : null);
    }

    public void addParseletForMethod(WireParser wireParser, Object target, Object[] contextHolder, Supplier contextSupplier, @NotNull Method method, @NotNull Class[] parameterTypes, MethodFilterOnFirstArg methodFilterOnFirstArg) {
        this.throwExceptionIfClosed();
        Jvm.setAccessible((AccessibleObject)method);
        @NotNull Object[] args = new Object[parameterTypes.length];
        @NotNull BiConsumer<Object[], ValueIn> sequenceReader = (a, v) -> {
            int i = 0;
            boolean ignored = false;
            for (Class clazz : parameterTypes) {
                if (ignored) {
                    v.skipValue();
                } else {
                    a[i] = v.object(this.checkRecycle(a[i]), clazz);
                }
                if (i == 0 && methodFilterOnFirstArg.ignoreMethodBasedOnFirstArg(method.getName(), a[0])) {
                    a[0] = IGNORED;
                    ignored = true;
                }
                ++i;
            }
        };
        String name = method.getName();
        MethodWireKey key = this.createWireKey(method, name);
        wireParser.registerOnce(key, (arg_0, arg_1) -> this.lambda$addParseletForMethod$13(args, sequenceReader, (Supplier)contextSupplier, method, contextHolder, target, arg_0, arg_1));
    }

    protected Object invoke(Object target, @NotNull Method method, Object[] args) throws InvocationTargetRuntimeException {
        try {
            if (this.methodReaderInterceptorReturns != null) {
                return this.methodReaderInterceptorReturns.intercept(method, target, args, VanillaMethodReader::actualInvoke);
            }
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(e.getCause());
        }
        catch (IllegalAccessException e) {
            Throwable cause = e.getCause();
            String msg = "Failure to dispatch message: " + method.getName() + " " + Arrays.asList(args);
            if (cause instanceof IllegalArgumentException) {
                Jvm.warn().on(target.getClass(), msg + " " + cause);
            } else {
                Jvm.warn().on(target.getClass(), msg, cause);
            }
            return null;
        }
    }

    public boolean readOne() throws InvocationTargetRuntimeException {
        this.throwExceptionIfClosed();
        boolean test = this.predicate.test(this);
        return test && this.readOne0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readOne0() {
        try (DocumentContext context = this.in.readingDocument();){
            if (!context.isPresent()) {
                boolean bl = false;
                return bl;
            }
            if (context.isMetaData()) {
                this.metaWireParser.accept(context.wire());
                boolean bl = true;
                return bl;
            }
            assert (context.isData());
            this.messageHistory().reset(context.sourceId(), context.index());
            this.dataWireParser.accept(context.wire());
        }
        finally {
            this.messageHistory().reset();
        }
        return true;
    }

    private MessageHistory messageHistory() {
        if (this.messageHistory == null) {
            this.messageHistory = MessageHistory.get();
        }
        return this.messageHistory;
    }

    public void close() {
        if (this.closeIn) {
            Closeable.closeQuietly((Object)this.in);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public MethodReaderInterceptorReturns methodReaderInterceptorReturns() {
        this.throwExceptionIfClosed();
        return this.methodReaderInterceptorReturns;
    }

    private /* synthetic */ void lambda$addParseletForMethod$13(Object[] args, BiConsumer sequenceReader, Supplier contextSupplier, Method method, Object[] contextHolder, Object target, CharSequence s, ValueIn v) throws InvalidMarshallableException {
        if (Jvm.isDebug()) {
            VanillaMethodReader.logMessage(s, v);
        }
        v.sequence(args, sequenceReader);
        if (args[0] == IGNORED) {
            args[0] = null;
            return;
        }
        Object invoke = this.invoke(contextSupplier.get(), method, args);
        if (invoke != null) {
            VanillaMethodReader.updateContext(contextHolder, invoke);
        } else if (target != null) {
            VanillaMethodReader.updateContext(contextHolder, target);
        }
    }

    private /* synthetic */ void lambda$addParseletForMethod$11(Object[] args, BiConsumer sequenceReader, Supplier contextSupplier, Method method, Object[] contextHolder, Object target, CharSequence s, ValueIn v) throws InvalidMarshallableException {
        if (Jvm.isDebug()) {
            VanillaMethodReader.logMessage(s, v);
        }
        v.sequence(args, sequenceReader);
        Object invoke = this.invoke(contextSupplier.get(), method, args);
        if (invoke != null) {
            VanillaMethodReader.updateContext(contextHolder, invoke);
        } else if (target != null) {
            VanillaMethodReader.updateContext(contextHolder, target);
        }
    }

    private /* synthetic */ void lambda$addParseletForMethod$9(Supplier contextSupplier, Method method, Object[] contextHolder, Object target, CharSequence s, ValueIn v) throws InvalidMarshallableException {
        if (Jvm.isDebug()) {
            VanillaMethodReader.logMessage(s, v);
        }
        v.skipValue();
        Object invoke = this.invoke(contextSupplier.get(), method, NO_ARGS);
        if (invoke != null) {
            VanillaMethodReader.updateContext(contextHolder, invoke);
        } else if (target != null) {
            VanillaMethodReader.updateContext(contextHolder, target);
        }
    }

    private /* synthetic */ void lambda$addParseletForMethod$8(ReadMarshallable[] argArr, Class parameterType2, Object[] contextHolder, Object target, Supplier contextSupplier, Method method, CharSequence s, ValueIn v) throws InvalidMarshallableException {
        if (Jvm.isDebug()) {
            VanillaMethodReader.logMessage(s, v);
        }
        argArr[0] = v.object(this.checkRecycle(argArr[0]), Jvm.uncheckedCast((Class)parameterType2));
        if (contextHolder[0] == null) {
            VanillaMethodReader.updateContext(contextHolder, target);
        }
        Object invoke = this.invoke(contextSupplier.get(), method, argArr);
        VanillaMethodReader.updateContext(contextHolder, invoke);
    }
}

