/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import net.openhft.chronicle.wire.AbstractClassGenerator;
import net.openhft.chronicle.wire.MethodDelegate;
import net.openhft.chronicle.wire.utils.SourceCodeFormatter;

public class GenerateMethodDelegate
extends AbstractClassGenerator<GMDMetaData> {
    public GenerateMethodDelegate() {
        super(new GMDMetaData());
    }

    @Override
    public synchronized <T> Class<T> acquireClass(ClassLoader classLoader) {
        ((GMDMetaData)this.metaData()).interfaces().add(MethodDelegate.class);
        return super.acquireClass(classLoader);
    }

    @Override
    protected String generateGenericType() {
        return "OUT extends Object & " + ((GMDMetaData)this.metaData()).interfaces().stream().map(this::nameForClass).map(s -> s.equals("MethodDelegate") ? "MethodDelegate<OUT>" : s).collect(Collectors.joining(" & "));
    }

    @Override
    protected void generateFields(SourceCodeFormatter mainCode) {
        mainCode.append("private ").append(this.getDelegateType()).append(" delegate;\n");
    }

    protected String getDelegateType() {
        return "OUT";
    }

    @Override
    protected void generateConstructors(SourceCodeFormatter mainCode) {
    }

    @Override
    protected void generateMethod(Method method, SourceCodeFormatter mainCode) {
        String s = method.toString();
        if (s.equals("public abstract void net.openhft.chronicle.wire.MethodDelegate.delegate(java.lang.Object)")) {
            this.withLineNumber(mainCode).append("public void delegate(Object delegate) {\nthis.delegate = (").append(this.getDelegateType()).append(") delegate;\n}\n");
        } else {
            super.generateMethod(method, mainCode);
        }
    }

    @Override
    protected void generateMethod(Method method, StringBuilder params, List<String> paramList, SourceCodeFormatter mainCode) {
        if (method.getReturnType() != Void.TYPE) {
            mainCode.append("return ");
        }
        this.getDelegate(mainCode, method).append(".").append(method.getName()).append("(").append(params).append(");\n");
    }

    protected SourceCodeFormatter getDelegate(SourceCodeFormatter mainCode, Method method) {
        return mainCode.append("this.delegate");
    }

    public static class GMDMetaData
    extends AbstractClassGenerator.MetaData<GMDMetaData> {
    }
}

