/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.converter;

import net.openhft.chronicle.wire.LongConverter;

public class SizeLongConverter
implements LongConverter {
    public static final SizeLongConverter INSTANCE = new SizeLongConverter();

    @Override
    public long parse(CharSequence text) throws NumberFormatException {
        int shift;
        int length = text.length();
        if (length < 1) {
            throw new NumberFormatException("Empty string");
        }
        switch (text.charAt(length - 1)) {
            case 'T': 
            case 't': {
                shift = 40;
                break;
            }
            case 'G': 
            case 'g': {
                shift = 30;
                break;
            }
            case 'M': 
            case 'm': {
                shift = 20;
                break;
            }
            case 'K': 
            case 'k': {
                shift = 10;
                break;
            }
            default: {
                shift = 0;
            }
        }
        if (shift != 0) {
            if (length < 2) {
                throw new NumberFormatException("No number for prefix '" + text + "'");
            }
            text = text.subSequence(0, length - 1);
        }
        return Long.parseLong(text.toString()) << shift;
    }

    @Override
    public void append(StringBuilder text, long value) {
        if (value == 0L) {
            text.append('0');
        } else if (value >> 40 << 40 == value) {
            text.append(value >> 40).append('T');
        } else if (value >> 30 << 30 == value) {
            text.append(value >> 30).append('G');
        } else if (value >> 20 << 20 == value) {
            text.append(value >> 20).append('M');
        } else if (value >> 10 << 10 == value) {
            text.append(value >> 10).append('K');
        } else {
            text.append(value);
        }
    }
}

