/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.ref.TextBooleanReference;
import net.openhft.chronicle.bytes.ref.TextIntReference;
import net.openhft.chronicle.bytes.ref.TextLongArrayReference;
import net.openhft.chronicle.bytes.ref.TextLongReference;
import net.openhft.chronicle.bytes.render.GeneralDecimaliser;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.values.BooleanValue;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.CommentAnnotationNotifier;
import net.openhft.chronicle.wire.DynamicEnum;
import net.openhft.chronicle.wire.Quotes;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class YamlWireOut<T extends YamlWireOut<T>>
extends AbstractWire {
    @Deprecated
    private static final boolean APPEND_0 = Jvm.getBoolean((String)"bytes.append.0", (boolean)true);
    public static final BytesStore<?, ?> TYPE = BytesStore.from((String)"!type ");
    static final String NULL = "!null \"\"";
    static final BitSet STARTS_QUOTE_CHARS = new BitSet();
    static final BitSet QUOTE_CHARS = new BitSet();
    static final BytesStore<?, ?> COMMA_SPACE = BytesStore.from((String)", ");
    static final BytesStore<?, ?> COMMA_NEW_LINE = BytesStore.from((String)",\n");
    static final BytesStore<?, ?> NEW_LINE = BytesStore.from((String)"\n");
    static final BytesStore<?, ?> EMPTY_AFTER_COMMENT = BytesStore.wrap((byte[])new byte[0]);
    static final BytesStore<?, ?> EMPTY = BytesStore.from((String)"");
    static final BytesStore<?, ?> SPACE = BytesStore.from((String)" ");
    static final BytesStore<?, ?> END_FIELD = NEW_LINE;
    static final char[] HEXADECIMAL = "0123456789ABCDEF".toCharArray();
    protected final YamlValueOut valueOut = this.createValueOut();
    protected final StringBuilder sb = new StringBuilder();
    private boolean addTimeStamps = false;
    private boolean trimFirstCurly = true;

    protected YamlWireOut(@NotNull Bytes bytes, boolean use8bit) {
        super(bytes, use8bit);
        bytes.decimaliser(GeneralDecimaliser.GENERAL);
    }

    public boolean addTimeStamps() {
        return this.addTimeStamps;
    }

    public T addTimeStamps(boolean addTimeStamps) {
        this.addTimeStamps = addTimeStamps;
        return (T)this;
    }

    @NotNull
    protected YamlValueOut createValueOut() {
        return new YamlValueOut();
    }

    @NotNull
    protected StringBuilder acquireStringBuilder() {
        this.sb.setLength(0);
        return this.sb;
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    @NotNull
    public ValueOut write() {
        return this.valueOut.write();
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        return this.valueOut.write(key);
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull CharSequence name) {
        return this.valueOut.write(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueOut writeEvent(Class<?> expectedType, Object eventKey) throws InvalidMarshallableException {
        if (eventKey instanceof WireKey) {
            return this.writeEventName((WireKey)eventKey);
        }
        if (eventKey instanceof CharSequence) {
            return this.writeEventName((CharSequence)eventKey);
        }
        if (expectedType != null && expectedType.isInstance(eventKey)) {
            if (eventKey instanceof Enum) {
                return this.writeEventName(((Enum)eventKey).name());
            }
            if (eventKey instanceof DynamicEnum) {
                return this.writeEventName(((DynamicEnum)eventKey).name());
            }
            if (eventKey instanceof Boolean) {
                return this.writeEventName(eventKey.toString());
            }
        }
        boolean wasLeft = this.valueOut.swapLeaf(true);
        try {
            YamlValueOut yamlValueOut = this.valueOut.write(expectedType, eventKey);
            return yamlValueOut;
        }
        finally {
            this.valueOut.swapLeaf(wasLeft);
        }
    }

    @NotNull
    public T dropDefault(boolean dropDefault) {
        this.valueOut.dropDefault = dropDefault;
        return (T)this;
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @NotNull
    public T writeComment(@NotNull CharSequence s) {
        this.valueOut.writeComment(s);
        return (T)this;
    }

    @NotNull
    public T addPadding(int paddingToAdd) {
        for (int i = 0; i < paddingToAdd; ++i) {
            this.bytes.writeUnsignedByte((this.bytes.writePosition() & 0x3FL) == 0L ? 10 : 32);
        }
        return (T)this;
    }

    void escape(@NotNull CharSequence s) {
        @NotNull Quotes quotes = this.needsQuotes(s);
        if (quotes == Quotes.NONE) {
            this.escape0(s, quotes);
            return;
        }
        this.bytes.writeUnsignedByte((int)quotes.q);
        this.escape0(s, quotes);
        this.bytes.writeUnsignedByte((int)quotes.q);
    }

    protected void escape0(@NotNull CharSequence s, @NotNull Quotes quotes) {
        block18: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\u0000': {
                    this.bytes.append((CharSequence)"\\0");
                    continue block18;
                }
                case '\u0007': {
                    this.bytes.append((CharSequence)"\\a");
                    continue block18;
                }
                case '\b': {
                    this.bytes.append((CharSequence)"\\b");
                    continue block18;
                }
                case '\t': {
                    this.bytes.append((CharSequence)"\\t");
                    continue block18;
                }
                case '\n': {
                    this.bytes.append((CharSequence)"\\n");
                    continue block18;
                }
                case '\u000b': {
                    this.bytes.append((CharSequence)"\\v");
                    continue block18;
                }
                case '\f': {
                    this.bytes.append((CharSequence)"\\f");
                    continue block18;
                }
                case '\r': {
                    this.bytes.append((CharSequence)"\\r");
                    continue block18;
                }
                case '\u001b': {
                    this.bytes.append((CharSequence)"\\e");
                    continue block18;
                }
                case '\"': {
                    if (ch == quotes.q) {
                        ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte((int)ch);
                        continue block18;
                    }
                    this.bytes.writeUnsignedByte((int)ch);
                    continue block18;
                }
                case '\'': {
                    if (ch == quotes.q) {
                        ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte((int)ch);
                        continue block18;
                    }
                    this.bytes.writeUnsignedByte((int)ch);
                    continue block18;
                }
                case '\\': {
                    ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte((int)ch);
                    continue block18;
                }
                case '\u0085': {
                    this.bytes.appendUtf8((CharSequence)"\\N");
                    continue block18;
                }
                case '\u00a0': {
                    this.bytes.appendUtf8((CharSequence)"\\_");
                    continue block18;
                }
                case '\u2028': {
                    this.bytes.appendUtf8((CharSequence)"\\L");
                    continue block18;
                }
                case '\u2029': {
                    this.bytes.appendUtf8((CharSequence)"\\P");
                    continue block18;
                }
                default: {
                    if (ch > '\u00ff') {
                        this.appendU4(ch);
                        continue block18;
                    }
                    if (ch < ' ' || ch > '\u007f') {
                        this.appendX2(ch);
                        continue block18;
                    }
                    this.bytes.appendUtf8((int)ch);
                }
            }
        }
    }

    private void appendX2(char ch) {
        this.bytes.append('\\');
        this.bytes.append('x');
        this.bytes.append(HEXADECIMAL[ch >> 4 & 0xF]);
        this.bytes.append(HEXADECIMAL[ch & 0xF]);
    }

    protected void appendU4(char ch) {
        this.bytes.append('\\');
        this.bytes.append('u');
        this.bytes.append(HEXADECIMAL[ch >> 12]);
        this.bytes.append(HEXADECIMAL[ch >> 8 & 0xF]);
        this.bytes.append(HEXADECIMAL[ch >> 4 & 0xF]);
        this.bytes.append(HEXADECIMAL[ch & 0xF]);
    }

    @NotNull
    protected Quotes needsQuotes(@NotNull CharSequence s) {
        @NotNull Quotes quotes = Quotes.NONE;
        if (s.length() == 0) {
            return Quotes.DOUBLE;
        }
        if (STARTS_QUOTE_CHARS.get(s.charAt(0)) || Character.isWhitespace(s.charAt(s.length() - 1))) {
            return Quotes.DOUBLE;
        }
        boolean hasSingleQuote = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (QUOTE_CHARS.get(ch) || ch < ' ' || ch > '\u007f') {
                return Quotes.DOUBLE;
            }
            if (ch == '\'') {
                hasSingleQuote = true;
            }
            if (ch != '\"') continue;
            if (i < s.length() - 1 && s.charAt(i + 1) == '\'') {
                return Quotes.DOUBLE;
            }
            quotes = Quotes.SINGLE;
        }
        if (hasSingleQuote) {
            return Quotes.NONE;
        }
        return quotes;
    }

    public void append(@NotNull CharSequence cs) {
        if (this.use8bit) {
            this.bytes.append8bit(cs);
        } else {
            this.bytes.appendUtf8(cs);
        }
    }

    public void append(@NotNull CharSequence cs, int offset, int length) {
        if (this.use8bit) {
            this.bytes.append8bit(cs, offset, offset + length);
        } else {
            this.bytes.appendUtf8(cs, offset, length);
        }
    }

    public void writeObject(Object o) throws InvalidMarshallableException {
        if (o instanceof Iterable) {
            for (Object o2 : (Iterable)o) {
                this.writeObject(o2, 2);
            }
        } else if (o instanceof Map) {
            for (Map.Entry entry : ((Map)o).entrySet()) {
                this.write(() -> entry.getKey().toString()).object(entry.getValue());
            }
        } else if (o instanceof WriteMarshallable) {
            this.valueOut.typedMarshallable((WriteMarshallable)o);
        } else {
            this.valueOut.object(o);
        }
    }

    private void writeObject(Object o, int indentation) throws InvalidMarshallableException {
        this.writeTwo('-', ' ');
        this.indentation(indentation - 2);
        this.valueOut.object(o);
    }

    private void indentation(int indentation) {
        while (indentation-- > 0) {
            this.bytes.writeUnsignedByte(32);
        }
    }

    @Override
    public void writeStartEvent() {
        this.valueOut.prependSeparator();
        this.writeTwo('?', ' ');
    }

    @Override
    public void writeEndEvent() {
        this.valueOut.endEvent();
    }

    void writeTwo(char ch1, char ch2) {
        this.bytes.writeUnsignedByte((int)ch1);
        this.bytes.writeUnsignedByte((int)ch2);
    }

    public boolean trimFirstCurly() {
        return this.trimFirstCurly;
    }

    public T trimFirstCurly(boolean trimFirstCurly) {
        this.trimFirstCurly = trimFirstCurly;
        return (T)this;
    }

    static {
        IOTools.unmonitor(TYPE);
        for (char ch : "?%*&@`0123456789+- ',#:{}[]|>!\\".toCharArray()) {
            STARTS_QUOTE_CHARS.set(ch);
        }
        for (char ch : "?,#:{}[]|>\\^".toCharArray()) {
            QUOTE_CHARS.set(ch);
        }
        WireInternal.INTERNER.valueCount();
    }

    class YamlValueOut
    implements ValueOut,
    CommentAnnotationNotifier {
        protected boolean hasCommentAnnotation = false;
        protected int indentation = 0;
        @NotNull
        protected List<BytesStore> seps = new ArrayList<BytesStore>(4);
        @NotNull
        protected BytesStore<?, ?> sep = BytesStore.empty();
        protected boolean leaf = false;
        protected boolean dropDefault = false;
        @Nullable
        private String eventName;

        YamlValueOut() {
        }

        @Override
        public ClassLookup classLookup() {
            return YamlWireOut.this.classLookup();
        }

        @Override
        public void hasPrecedingComment(boolean hasCommentAnnotation) {
            this.hasCommentAnnotation = hasCommentAnnotation;
        }

        @Override
        public void resetState() {
            this.indentation = 0;
            this.seps.clear();
            this.sep = BytesStore.empty();
            this.leaf = false;
            this.dropDefault = false;
            this.eventName = null;
        }

        void prependSeparator() {
            this.appendSep();
            this.sep = BytesStore.empty();
        }

        protected void appendSep() {
            YamlWireOut.this.append((CharSequence)this.sep);
            this.trimWhiteSpace();
            if (YamlWireOut.this.bytes.endsWith('\n') || this.sep == EMPTY_AFTER_COMMENT) {
                this.indent();
            }
        }

        protected void trimWhiteSpace() {
            BytesUtil.combineDoubleNewline((Bytes)YamlWireOut.this.bytes);
        }

        @Override
        public boolean swapLeaf(boolean isLeaf) {
            if (isLeaf == this.leaf) {
                return this.leaf;
            }
            this.leaf = isLeaf;
            if (!isLeaf && this.sep.startsWith(',')) {
                this.elementSeparator();
            }
            return !this.leaf;
        }

        @NotNull
        public T wireOut() {
            return YamlWireOut.this;
        }

        protected void indent() {
            BytesUtil.combineDoubleNewline((Bytes)YamlWireOut.this.bytes);
            for (int i = 0; i < this.indentation; ++i) {
                YamlWireOut.this.bytes.writeUnsignedShort(8224);
            }
        }

        @Override
        public void elementSeparator() {
            if (this.indentation == 0) {
                if (this.leaf) {
                    this.sep = COMMA_SPACE;
                } else {
                    this.sep = BytesStore.empty();
                    YamlWireOut.this.bytes.writeUnsignedByte(10);
                }
            } else {
                this.sep = this.leaf ? COMMA_SPACE : COMMA_NEW_LINE;
            }
            BytesUtil.combineDoubleNewline((Bytes)YamlWireOut.this.bytes);
        }

        @NotNull
        public T bool(@Nullable Boolean flag) {
            if (this.dropDefault) {
                if (flag == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWireOut.this.append(flag == null ? this.nullOut() : (flag != false ? "true" : "false"));
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public String nullOut() {
            return "!!null \"\"";
        }

        @NotNull
        public T text(@Nullable CharSequence s) {
            if (this.dropDefault) {
                if (s == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            if (s == null) {
                YamlWireOut.this.append(this.nullOut());
            } else {
                YamlWireOut.this.escape(s);
            }
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T bytes(@Nullable BytesStore<?, ?> fromBytes) {
            if (this.dropDefault) {
                if (fromBytes == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            if (this.isText(fromBytes)) {
                return (YamlWireOut)this.text(fromBytes);
            }
            int length = Maths.toInt32((long)fromBytes.readRemaining());
            @NotNull byte[] byteArray = new byte[length];
            fromBytes.copyTo(byteArray);
            return this.bytes(byteArray);
        }

        @NotNull
        public T rawBytes(@NotNull byte[] value) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWireOut.this.bytes.write(value);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T rawText(CharSequence value) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWireOut.this.bytes.write(value);
            this.elementSeparator();
            return this.wireOut();
        }

        private boolean isText(@Nullable BytesStore<?, ?> fromBytes) {
            if (fromBytes == null) {
                return true;
            }
            for (long i = fromBytes.readPosition(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch < 127) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public ValueOut writeLength(long remaining) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public T bytes(byte[] byteArray) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            return this.bytes("!binary", byteArray);
        }

        @NotNull
        public T bytes(@NotNull String type, byte[] byteArray) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            this.typePrefix(type);
            if (this.getClass() != YamlValueOut.class) {
                YamlWireOut.this.bytes.append('\"');
            }
            YamlWireOut.this.append(Base64.getEncoder().encodeToString(byteArray));
            if (this.getClass() != YamlValueOut.class) {
                YamlWireOut.this.bytes.append('\"');
            }
            this.elementSeparator();
            this.endTypePrefix();
            return this.wireOut();
        }

        @NotNull
        public T bytes(@NotNull String type, @Nullable BytesStore<?, ?> bytesStore) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (bytesStore == null) {
                return (YamlWireOut)this.nu11();
            }
            this.prependSeparator();
            this.typePrefix(type);
            YamlWireOut.this.append(Base64.getEncoder().encodeToString(bytesStore.toByteArray()));
            this.endTypePrefix();
            YamlWireOut.this.append((CharSequence)END_FIELD);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T int8(byte i8) {
            if (this.dropDefault) {
                if (i8 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWireOut.this.bytes.append((int)i8);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T uint8checked(int u8) {
            if (this.dropDefault) {
                if (u8 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWireOut.this.bytes.append(u8);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T int16(short i16) {
            if (this.dropDefault) {
                if (i16 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWireOut.this.bytes.append((int)i16);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T uint16checked(int u16) {
            if (this.dropDefault) {
                if (u16 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWireOut.this.bytes.append(u16);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T utf8(int codepoint) {
            if (this.dropDefault) {
                if (codepoint == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            StringBuilder stringBuilder = YamlWireOut.this.acquireStringBuilder();
            stringBuilder.appendCodePoint(codepoint);
            this.text(stringBuilder);
            this.sep = BytesStore.empty();
            return this.wireOut();
        }

        @NotNull
        public T int32(int i32) {
            if (this.dropDefault) {
                if (i32 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWireOut.this.bytes.append(i32);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T uint32checked(long u32) {
            if (this.dropDefault) {
                if (u32 == 0L) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWireOut.this.bytes.append(u32);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T int64(long i64) {
            boolean addTimeStamp;
            if (this.dropDefault) {
                if (i64 == 0L) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWireOut.this.bytes.append(i64);
            this.elementSeparator();
            boolean bl = addTimeStamp = YamlWireOut.this.addTimeStamps && !this.leaf;
            if (addTimeStamp) {
                this.addTimeStamp(i64);
            }
            return this.wireOut();
        }

        @NotNull
        public T int128forBinding(long i64x0, long i64x1, TwoLongValue longValue) {
            throw new UnsupportedOperationException("todo");
        }

        public void addTimeStamp(long i64) {
            if (1000000000000L < i64 && i64 < 4111000000000L) {
                YamlWireOut.this.bytes.append((CharSequence)", # ");
                YamlWireOut.this.bytes.appendDateMillis(i64);
                YamlWireOut.this.bytes.append((CharSequence)"T");
                YamlWireOut.this.bytes.appendTimeMillis(i64);
                this.sep = NEW_LINE;
            } else if (1000000000000000000L < i64 && i64 < 4111000000000000000L) {
                long millis = i64 / 1000000L;
                long nanos = i64 % 1000000L;
                YamlWireOut.this.bytes.append((CharSequence)", # ");
                YamlWireOut.this.bytes.appendDateMillis(millis);
                YamlWireOut.this.bytes.append((CharSequence)"T");
                YamlWireOut.this.bytes.appendTimeMillis(millis);
                YamlWireOut.this.bytes.append((char)(48L + nanos / 100000L));
                YamlWireOut.this.bytes.append((char)(48L + nanos / 100000L % 10L));
                YamlWireOut.this.bytes.append((char)(48L + nanos / 10000L % 10L));
                YamlWireOut.this.bytes.append((char)(48L + nanos / 1000L % 10L));
                YamlWireOut.this.bytes.append((char)(48L + nanos / 100L % 10L));
                YamlWireOut.this.bytes.append((char)(48L + nanos / 10L % 10L));
                YamlWireOut.this.bytes.append((char)(48L + nanos % 10L));
                this.sep = NEW_LINE;
            }
        }

        @NotNull
        public T int64_0x(long i64) {
            if (this.dropDefault) {
                if (i64 == 0L) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            ((Bytes)((Bytes)YamlWireOut.this.bytes.writeUnsignedByte(48)).writeUnsignedByte(120)).appendBase16(i64);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T int64array(long capacity) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            TextLongArrayReference.write((Bytes)YamlWireOut.this.bytes, (long)capacity);
            return this.wireOut();
        }

        @NotNull
        public T int64array(long capacity, @NotNull LongArrayValues values) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            long pos = YamlWireOut.this.bytes.writePosition();
            TextLongArrayReference.write((Bytes)YamlWireOut.this.bytes, (long)capacity);
            ((Byteable)values).bytesStore((BytesStore)YamlWireOut.this.bytes, pos, YamlWireOut.this.bytes.lengthWritten(pos));
            return this.wireOut();
        }

        @NotNull
        public T float32(float f) {
            if (this.dropDefault) {
                if (f == 0.0f) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            double af = Math.abs(f);
            if (af == 0.0 || af >= 0.001 && af < 1000000.0) {
                YamlWireOut.this.bytes.append(f);
            } else {
                YamlWireOut.this.bytes.append((CharSequence)this.floatToString(f));
            }
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T float64(double d) {
            if (this.dropDefault) {
                if (d == 0.0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            double ad = Math.abs(d);
            if (ad == 0.0) {
                YamlWireOut.this.bytes.append(d);
            } else if (ad >= 1.0E-7 && ad < 1.0E15) {
                if ((double)((int)(ad / 1000000.0)) * 1000000.0 == ad) {
                    ((Bytes)YamlWireOut.this.bytes.append((int)(d / 1000000.0))).append((CharSequence)"E6");
                } else if ((double)((int)(ad / 1000.0)) * 1000.0 == ad) {
                    ((Bytes)YamlWireOut.this.bytes.append((int)(d / 1000.0))).append((CharSequence)"E3");
                } else if (ad < 0.001) {
                    double d7 = (double)Math.round(d * 1.0E16) / 1.0E9;
                    double ad7 = Math.abs(d7);
                    if (ad7 < 10.0) {
                        ((Bytes)YamlWireOut.this.bytes.append(d7)).append((CharSequence)"E-7");
                    } else if (ad7 < 100.0) {
                        ((Bytes)YamlWireOut.this.bytes.append(d7 / 10.0)).append((CharSequence)"E-6");
                    } else if (ad7 < 1000.0) {
                        ((Bytes)YamlWireOut.this.bytes.append(d7 / 100.0)).append((CharSequence)"E-5");
                    } else if (ad7 < 10000.0) {
                        ((Bytes)YamlWireOut.this.bytes.append(d7 / 1000.0)).append((CharSequence)"E-4");
                    } else {
                        ((Bytes)YamlWireOut.this.bytes.append(d7 / 10000.0)).append((CharSequence)"E-3");
                    }
                } else {
                    YamlWireOut.this.bytes.append(d);
                }
            } else {
                YamlWireOut.this.bytes.append((CharSequence)this.doubleToString(d));
            }
            this.elementSeparator();
            return this.wireOut();
        }

        protected String doubleToString(double d) {
            return Double.toString(d);
        }

        protected String floatToString(float f) {
            return Float.toString(f);
        }

        @NotNull
        public T time(LocalTime localTime) {
            return this.asText(localTime);
        }

        @NotNull
        public T zonedDateTime(@Nullable ZonedDateTime zonedDateTime) {
            if (this.dropDefault) {
                if (zonedDateTime == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            if (zonedDateTime == null) {
                return (YamlWireOut)this.nu11();
            }
            String s = zonedDateTime.toString();
            return (YamlWireOut)(s.endsWith("]") ? this.text(s) : this.asText(s));
        }

        @NotNull
        public T date(LocalDate localDate) {
            return this.asText(localDate);
        }

        @NotNull
        public T dateTime(LocalDateTime localDateTime) {
            return this.asText(localDateTime);
        }

        @NotNull
        private T asText(@Nullable Object stringable) {
            if (this.dropDefault) {
                if (stringable == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            if (stringable == null) {
                this.nu11();
            } else {
                this.prependSeparator();
                String s = stringable.toString();
                Quotes quotes = YamlWireOut.this.needsQuotes(s);
                this.asTestQuoted(s, quotes);
                this.elementSeparator();
            }
            return this.wireOut();
        }

        protected void asTestQuoted(String s, Quotes quotes) {
            if (quotes == Quotes.NONE) {
                YamlWireOut.this.append(s);
            } else {
                YamlWireOut.this.escape0(s, quotes);
            }
        }

        @Override
        @NotNull
        public ValueOut optionalTyped(Class<?> aClass) {
            return this.typePrefix(aClass);
        }

        @Override
        @NotNull
        public YamlValueOut typePrefix(@NotNull CharSequence typeName) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWireOut.this.bytes.writeUnsignedByte(33);
            YamlWireOut.this.append(typeName);
            YamlWireOut.this.bytes.writeUnsignedByte(32);
            this.sep = BytesStore.empty();
            return this;
        }

        @NotNull
        public T typeLiteral(@NotNull BiConsumer<Class, Bytes<?>> typeTranslator, Class<?> type) {
            if (this.dropDefault) {
                if (type == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWireOut.this.append((CharSequence)TYPE);
            typeTranslator.accept(type, YamlWireOut.this.bytes);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T typeLiteral(@Nullable CharSequence type) {
            if (this.dropDefault) {
                if (type == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            if (type == null) {
                return (YamlWireOut)this.nu11();
            }
            this.prependSeparator();
            YamlWireOut.this.append((CharSequence)TYPE);
            YamlWireOut.this.escape(type);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T uuid(@NotNull UUID uuid) {
            return this.asText(uuid);
        }

        @NotNull
        public T int32forBinding(int value) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextIntReference.write((Bytes)YamlWireOut.this.bytes, (int)value);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T int32forBinding(int value, @NotNull IntValue intValue) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (!(intValue instanceof TextIntReference)) {
                throw new IllegalArgumentException();
            }
            this.prependSeparator();
            long offset = YamlWireOut.this.bytes.writePosition();
            TextIntReference.write((Bytes)YamlWireOut.this.bytes, (int)value);
            long length = YamlWireOut.this.bytes.lengthWritten(offset);
            ((Byteable)intValue).bytesStore((BytesStore)YamlWireOut.this.bytes, offset, length);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T int64forBinding(long value) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextLongReference.write((Bytes)YamlWireOut.this.bytes, (long)value);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T int64forBinding(long value, @NotNull LongValue longValue) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (!(longValue instanceof TextLongReference)) {
                throw new IllegalArgumentException();
            }
            this.prependSeparator();
            long offset = YamlWireOut.this.bytes.writePosition();
            TextLongReference.write((Bytes)YamlWireOut.this.bytes, (long)value);
            long length = YamlWireOut.this.bytes.lengthWritten(offset);
            ((Byteable)longValue).bytesStore((BytesStore)YamlWireOut.this.bytes, offset, length);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T boolForBinding(boolean value, @NotNull BooleanValue longValue) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (!(longValue instanceof TextBooleanReference)) {
                throw new IllegalArgumentException();
            }
            this.prependSeparator();
            long offset = YamlWireOut.this.bytes.writePosition();
            TextBooleanReference.write((boolean)value, (BytesStore)YamlWireOut.this.bytes, (long)offset);
            long length = YamlWireOut.this.bytes.lengthWritten(offset);
            ((Byteable)longValue).bytesStore((BytesStore)YamlWireOut.this.bytes, offset, length);
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public <E> T sequence(E e, @NotNull BiConsumer<E, ValueOut> writer) {
            this.startBlock('[');
            boolean leaf = this.leaf;
            if (!leaf) {
                this.newLine();
            } else {
                YamlWireOut.this.bytes.writeUnsignedByte(32);
            }
            long pos = YamlWireOut.this.bytes.writePosition();
            writer.accept(e, this);
            if (!leaf) {
                this.addNewLine(pos);
            }
            this.popState();
            this.leaf = leaf;
            if (!leaf) {
                this.indent();
            } else {
                this.addSpace(pos);
            }
            this.endBlock(']');
            this.elementSeparator();
            return this.wireOut();
        }

        public void startBlock(char c) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (!this.sep.isEmpty()) {
                YamlWireOut.this.append((CharSequence)this.sep);
                this.trimWhiteSpace();
                this.indent();
                this.sep = EMPTY;
            }
            this.pushState();
            YamlWireOut.this.bytes.writeUnsignedByte((int)c);
        }

        @NotNull
        public <E, K> T sequence(E e, K kls, @NotNull TriConsumer<E, K, ValueOut> writer) throws InvalidMarshallableException {
            boolean leaf = this.leaf;
            this.startBlock('[');
            if (leaf) {
                this.sep = SPACE;
            } else {
                this.newLine();
            }
            long pos = YamlWireOut.this.bytes.readPosition();
            writer.accept(e, kls, this);
            if (leaf) {
                this.addSpace(pos);
            } else {
                this.addNewLine(pos);
            }
            this.popState();
            if (!leaf) {
                this.indent();
            }
            this.endBlock(']');
            this.elementSeparator();
            return this.wireOut();
        }

        public void endBlock(char c) {
            BytesUtil.combineDoubleNewline((Bytes)YamlWireOut.this.bytes);
            YamlWireOut.this.bytes.writeUnsignedByte((int)c);
        }

        protected void addNewLine(long pos) {
            if (YamlWireOut.this.bytes.writePosition() > pos + 1L) {
                YamlWireOut.this.bytes.writeUnsignedByte(10);
            }
        }

        protected void addSpace(long pos) {
            if (YamlWireOut.this.bytes.writePosition() > pos + 1L) {
                YamlWireOut.this.bytes.writeUnsignedByte(32);
            }
        }

        protected void newLine() {
            this.sep = NEW_LINE;
        }

        protected void popState() {
            this.sep = this.seps.remove(this.seps.size() - 1);
            --this.indentation;
            this.leaf = false;
            this.dropDefault = false;
        }

        protected void pushState() {
            ++this.indentation;
            this.seps.add(this.sep);
            this.sep = EMPTY;
        }

        @NotNull
        public T marshallable(@NotNull WriteMarshallable object) throws InvalidMarshallableException {
            WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(object.getClass());
            boolean wasLeaf0 = this.leaf;
            if (this.indentation > 1 && wm.isLeaf()) {
                this.leaf = true;
            }
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (YamlWireOut.this.trimFirstCurly && YamlWireOut.this.bytes.writePosition() == 0L) {
                object.writeMarshallable(YamlWireOut.this);
                if (YamlWireOut.this.bytes.writePosition() == 0L) {
                    YamlWireOut.this.bytes.append((CharSequence)"{}");
                }
                return this.wireOut();
            }
            boolean wasLeaf = this.leaf;
            this.startBlock('{');
            if (wasLeaf) {
                this.afterOpen();
            } else {
                this.newLine();
            }
            object.writeMarshallable(this.wireOut());
            BytesStore popSep = null;
            if (wasLeaf) {
                if (this.sep.endsWith(' ')) {
                    YamlWireOut.this.append(" ");
                }
                this.trimWhiteSpace();
                this.leaf = false;
                this.popState();
            } else if (!this.seps.isEmpty()) {
                popSep = this.seps.get(this.seps.size() - 1);
                this.trimWhiteSpace();
                this.popState();
                this.newLine();
            }
            if (this.sep.startsWith(',')) {
                YamlWireOut.this.append((CharSequence)this.sep, 1, this.sep.length() - 1);
                if (!wasLeaf) {
                    this.indent();
                }
            } else {
                this.prependSeparator();
            }
            this.endBlock('}');
            this.leaf = wasLeaf0;
            if (popSep != null) {
                this.sep = popSep;
            }
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public T marshallable(@NotNull Serializable object) throws InvalidMarshallableException {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (YamlWireOut.this.bytes.writePosition() == 0L) {
                this.writeSerializable(object);
                return this.wireOut();
            }
            boolean wasLeaf = this.leaf;
            if (!wasLeaf) {
                this.pushState();
            }
            this.prependSeparator();
            YamlWireOut.this.bytes.writeUnsignedByte(object instanceof Externalizable ? 91 : 123);
            if (wasLeaf) {
                this.afterOpen();
            } else {
                this.newLine();
            }
            this.writeSerializable(object);
            @Nullable BytesStore popSep = null;
            if (wasLeaf) {
                this.leaf = false;
            } else if (this.seps.size() > 0) {
                popSep = this.seps.get(this.seps.size() - 1);
                this.popState();
                this.newLine();
            }
            if (this.sep.startsWith(',')) {
                YamlWireOut.this.append((CharSequence)this.sep, 1, this.sep.length() - 1);
                this.trimWhiteSpace();
                if (!wasLeaf) {
                    this.indent();
                }
            } else {
                this.prependSeparator();
            }
            BytesUtil.combineDoubleNewline((Bytes)YamlWireOut.this.bytes);
            YamlWireOut.this.bytes.writeUnsignedByte(object instanceof Externalizable ? 93 : 125);
            if (popSep != null) {
                this.sep = popSep;
            }
            if (this.indentation == 0) {
                this.afterClose();
            } else {
                this.elementSeparator();
            }
            return this.wireOut();
        }

        private void writeSerializable(@NotNull Serializable object) throws InvalidMarshallableException {
            try {
                if (object instanceof Externalizable) {
                    ((Externalizable)object).writeExternal(YamlWireOut.this.objectOutput());
                } else {
                    Wires.writeMarshallable(object, this.wireOut());
                }
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        protected void afterClose() {
            this.newLine();
            YamlWireOut.this.append((CharSequence)this.sep);
            this.sep = EMPTY;
        }

        protected void afterOpen() {
            this.sep = SPACE;
        }

        @NotNull
        public T map(@NotNull Map map) throws InvalidMarshallableException {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.marshallable(map, Object.class, Object.class, false);
            return this.wireOut();
        }

        protected void endField() {
            this.sep = END_FIELD;
        }

        protected void fieldValueSeperator() {
            YamlWireOut.this.writeTwo(':', ' ');
        }

        @NotNull
        public YamlValueOut write() {
            if (this.dropDefault) {
                this.eventName = "";
            } else {
                YamlWireOut.this.append((CharSequence)this.sep);
                YamlWireOut.this.writeTwo('\"', '\"');
                this.endEvent();
            }
            return this;
        }

        @NotNull
        public YamlValueOut write(@NotNull WireKey key) {
            if (this.dropDefault) {
                this.eventName = key.name().toString();
            } else {
                this.write(key.name());
            }
            return this;
        }

        @NotNull
        public YamlValueOut write(@NotNull CharSequence name) {
            if (this.dropDefault) {
                this.eventName = name.toString();
            } else {
                this.prependSeparator();
                YamlWireOut.this.escape(name);
                this.fieldValueSeperator();
            }
            return this;
        }

        @NotNull
        public YamlValueOut write(Class<?> expectedType, @NotNull Object objectKey) throws InvalidMarshallableException {
            if (this.dropDefault) {
                if (expectedType != String.class) {
                    throw new UnsupportedOperationException("todo");
                }
                this.eventName = objectKey.toString();
            } else {
                this.prependSeparator();
                YamlWireOut.this.writeStartEvent();
                this.object(expectedType, objectKey);
                this.endEvent();
            }
            return this;
        }

        private void writeSavedEventName() {
            if (this.eventName == null) {
                return;
            }
            this.prependSeparator();
            YamlWireOut.this.escape(this.eventName);
            this.fieldValueSeperator();
            this.eventName = null;
        }

        public void endEvent() {
            if (YamlWireOut.this.bytes.readByte(YamlWireOut.this.bytes.writePosition() - 1L) <= 32) {
                YamlWireOut.this.bytes.writeSkip(-1L);
            }
            this.fieldValueSeperator();
            this.sep = BytesStore.empty();
        }

        public void writeComment(@NotNull CharSequence s) {
            if (this.hasCommentAnnotation) {
                if (!this.sep.endsWith('\n')) {
                    return;
                }
                this.sep = COMMA_SPACE;
            } else {
                this.prependSeparator();
            }
            YamlWireOut.this.append((CharSequence)this.sep);
            if (this.hasCommentAnnotation) {
                YamlWireOut.this.writeTwo('\t', '\t');
            }
            YamlWireOut.this.writeTwo('#', ' ');
            YamlWireOut.this.append(s);
            YamlWireOut.this.bytes.writeUnsignedByte(10);
            this.sep = EMPTY_AFTER_COMMENT;
        }
    }
}

