/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel.echo.internal;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.channel.ChannelHeader;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.OkHeader;
import net.openhft.chronicle.wire.converter.NanoTime;

public class EchoChannel
extends SimpleCloseable
implements ChronicleChannel {
    private static final OkHeader OK = new OkHeader();
    private final Wire wire = (Wire)WireType.BINARY_LIGHT.apply(Bytes.allocateElasticOnHeap());
    private final ChronicleChannelCfg<?> channelCfg;
    private long lastTestMessage;

    public EchoChannel(ChronicleChannelCfg<?> channelCfg) {
        this.channelCfg = channelCfg;
    }

    @Override
    public ChronicleChannelCfg<?> channelCfg() {
        return this.channelCfg;
    }

    @Override
    public ChannelHeader headerOut() {
        return OK;
    }

    @Override
    public ChannelHeader headerIn() {
        return OK;
    }

    @Override
    public void testMessage(long now) {
        this.lastTestMessage = now;
        try (DocumentContext dc = this.writingDocument(true);){
            dc.wire().write("testMessage").writeLong(NanoTime.INSTANCE, now);
        }
    }

    @Override
    public long lastTestMessage() {
        return this.lastTestMessage;
    }

    @Override
    public DocumentContext readingDocument() {
        return this.wire.readingDocument();
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        if (this.wire.isEmpty()) {
            this.wire.reset();
        }
        return this.wire.writingDocument(metaData);
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        if (this.wire.isEmpty()) {
            this.wire.reset();
        }
        return this.wire.acquireWritingDocument(metaData);
    }
}

