/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.converter;

import java.util.Arrays;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.LongConverter;

public class SymbolsLongConverter
implements LongConverter {
    private final int factor;
    private final short[] encode;
    private final char[] decode;
    private final int maxParseLength;

    public SymbolsLongConverter(String symbols) {
        int length;
        this.factor = length = symbols.length();
        this.decode = symbols.toCharArray();
        this.encode = new short[128];
        Arrays.fill(this.encode, (short)-1);
        for (int i = 0; i < this.decode.length; ++i) {
            this.encode[this.decode[i]] = (short)i;
        }
        this.maxParseLength = LongConverter.maxParseLength(length);
    }

    @Override
    public int maxParseLength() {
        return this.maxParseLength;
    }

    @Override
    public long parse(CharSequence text) {
        this.lengthCheck(text);
        return this.parse0(text, 0, text.length());
    }

    @Override
    public long parse(CharSequence text, int beginIndex, int endIndex) {
        this.lengthCheck(text, beginIndex, endIndex);
        return this.parse0(text, beginIndex, endIndex);
    }

    private long parse0(CharSequence text, int beginIndex, int endIndex) {
        long v = 0L;
        for (int i = beginIndex; i < endIndex; ++i) {
            char ch = text.charAt(i);
            if (ch >= this.encode.length || this.encode[ch] < 0) {
                throw new IllegalArgumentException("Unexpected character '" + ch + "' in \"" + text + "\"");
            }
            v = v * (long)this.factor + (long)this.encode[ch];
        }
        return v;
    }

    @Override
    public void append(StringBuilder text, long value) {
        int v;
        int start = text.length();
        if (value < 0L) {
            v = (int)Long.remainderUnsigned(value, this.factor);
            value = Long.divideUnsigned(value, this.factor);
            text.append(this.decode[v]);
        }
        while (value != 0L) {
            v = (int)(value % (long)this.factor);
            value /= (long)this.factor;
            text.append(this.decode[v]);
        }
        StringUtils.reverse((StringBuilder)text, (int)start);
        if (text.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            text.setLength(start + this.maxParseLength());
        }
    }

    @Override
    public void append(Bytes<?> text, long value) {
        int v;
        int start = text.length();
        if (value < 0L) {
            v = (int)Long.remainderUnsigned(value, this.factor);
            value = Long.divideUnsigned(value, this.factor);
            text.append(this.decode[v]);
        }
        while (value != 0L) {
            v = (int)(value % (long)this.factor);
            value /= (long)this.factor;
            text.append(this.decode[v]);
        }
        BytesUtil.reverse(text, (int)start);
        if (text.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            text.readLimit((long)start + (long)this.maxParseLength());
        }
    }

    @Override
    public void addEncode(char alias, char as) {
        this.encode[alias] = this.encode[as];
    }
}

