/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.CommonMarshallable;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.ref.TextBooleanReference;
import net.openhft.chronicle.bytes.ref.TextIntArrayReference;
import net.openhft.chronicle.bytes.ref.TextIntReference;
import net.openhft.chronicle.bytes.ref.TextLongArrayReference;
import net.openhft.chronicle.bytes.ref.TextLongReference;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.ValidatableUtil;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.BooleanValue;
import net.openhft.chronicle.core.values.IntArrayValues;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.BinaryWriteDocumentContext;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.Comment;
import net.openhft.chronicle.wire.DefaultValueIn;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SerializationStrategies;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TextMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.TextReadDocumentContext;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.TextWriteDocumentContext;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.VanillaMethodReaderBuilder;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.YamlKeys;
import net.openhft.chronicle.wire.YamlToken;
import net.openhft.chronicle.wire.YamlTokeniser;
import net.openhft.chronicle.wire.YamlWireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlWire
extends YamlWireOut<YamlWire> {
    static final String SEQ_MAP = "!seqmap";
    static final String BINARY_TAG = "!binary";
    static final String DATA_TAG = "!data";
    static final String NULL_TAG = "!null";
    private final TextValueIn valueIn = this.createValueIn();
    private final YamlTokeniser yt;
    private final Map<String, Object> anchorValues = new HashMap<String, Object>();
    private DefaultValueIn defaultValueIn;
    private WriteDocumentContext writeContext;
    private ReadDocumentContext readContext;
    private YamlWire rereadWire;

    public YamlWire(@NotNull Bytes<?> bytes, boolean use8bit) {
        super((Bytes)bytes, use8bit);
        this.yt = new YamlTokeniser((BytesIn<?>)bytes);
        this.defaultValueIn = new DefaultValueIn(this);
    }

    public YamlWire(@NotNull Bytes<?> bytes) {
        this(bytes, false);
    }

    @NotNull
    public static YamlWire fromFile(String name) throws IOException {
        return new YamlWire((Bytes<?>)BytesUtil.readFile((String)name), true);
    }

    @NotNull
    public static YamlWire from(@NotNull String text) {
        return new YamlWire(Bytes.from((String)text));
    }

    public static String asText(@NotNull Wire wire) throws InvalidMarshallableException {
        long pos = wire.bytes().readPosition();
        @NotNull Wire tw = Wire.newYamlWireOnHeap();
        wire.copyTo(tw);
        wire.bytes().readPosition(pos);
        return tw.toString();
    }

    private static <ACS extends Appendable & CharSequence> void unescape(@NotNull ACS sb, char blockQuote) {
        int end = 0;
        int length = ((CharSequence)sb).length();
        boolean skip = false;
        for (int i = 0; i < length; ++i) {
            char ch2;
            if (skip) {
                skip = false;
                continue;
            }
            char ch = ((CharSequence)sb).charAt(i);
            if (blockQuote == '\"' && ch == '\\' && i < length - 1) {
                char ch3 = ((CharSequence)sb).charAt(++i);
                switch (ch3) {
                    case '0': {
                        ch = '\u0000';
                        break;
                    }
                    case 'a': {
                        ch = '\u0007';
                        break;
                    }
                    case 'b': {
                        ch = '\b';
                        break;
                    }
                    case 't': {
                        ch = '\t';
                        break;
                    }
                    case 'n': {
                        ch = '\n';
                        break;
                    }
                    case 'v': {
                        ch = '\u000b';
                        break;
                    }
                    case 'f': {
                        ch = '\f';
                        break;
                    }
                    case 'r': {
                        ch = '\r';
                        break;
                    }
                    case 'e': {
                        ch = '\u001b';
                        break;
                    }
                    case 'N': {
                        ch = '\u0085';
                        break;
                    }
                    case '_': {
                        ch = '\u00a0';
                        break;
                    }
                    case 'L': {
                        ch = '\u2028';
                        break;
                    }
                    case 'P': {
                        ch = '\u2029';
                        break;
                    }
                    case 'x': {
                        ch = (char)(Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 16 + Character.getNumericValue(((CharSequence)sb).charAt(++i)));
                        break;
                    }
                    case 'u': {
                        ch = (char)(Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 4096 + Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 256 + Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 16 + Character.getNumericValue(((CharSequence)sb).charAt(++i)));
                        break;
                    }
                    default: {
                        ch = ch3;
                    }
                }
            }
            if (blockQuote == '\'' && ch == '\'' && i < length - 1 && (ch2 = ((CharSequence)sb).charAt(i + 1)) == ch) {
                skip = true;
            }
            AppendableUtil.setCharAt(sb, (int)end++, (char)ch);
        }
        if (length != ((CharSequence)sb).length()) {
            throw new IllegalStateException("Length changed from " + length + " to " + ((CharSequence)sb).length() + " for " + sb);
        }
        AppendableUtil.setLength(sb, (int)end);
    }

    static void removeUnderscore(@NotNull StringBuilder s) {
        int i = 0;
        for (int j = 0; j < s.length(); ++j) {
            char ch = s.charAt(j);
            s.setCharAt(i, ch);
            if (ch == '_') continue;
            ++i;
        }
        s.setLength(i);
    }

    @Nullable
    static Object readNumberOrTextFrom(char bq, @Nullable StringBuilder s) {
        if (YamlWire.leaveUnparsed(bq, s)) {
            return s;
        }
        StringBuilder sb = s;
        if (StringUtils.startsWith((CharSequence)s, (String)"0o")) {
            sb = new StringBuilder(s);
            sb.deleteCharAt(1);
        }
        if (s.indexOf("_") >= 0) {
            sb = new StringBuilder(s);
            YamlWire.removeUnderscore(sb);
        }
        String ss = sb.toString();
        try {
            return Long.decode(ss);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(ss);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return YamlWire.parseDateOrTime(s, ss);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    return s;
                }
            }
        }
    }

    private static boolean leaveUnparsed(char bq, @Nullable StringBuilder s) {
        return s == null || bq != '\u0000' || s.length() < 1 || s.length() > 40 || "0123456789.+-".indexOf(s.charAt(0)) < 0;
    }

    private static TemporalAccessor parseDateOrTime(StringBuilder s, String ss) {
        if (s.length() == 7 && s.charAt(1) == ':') {
            return LocalTime.parse('0' + ss);
        }
        if (s.length() == 8 && s.charAt(2) == ':') {
            return LocalTime.parse(s);
        }
        if (s.length() == 10) {
            return LocalDate.parse(s);
        }
        if (s.length() >= 22) {
            return ZonedDateTime.parse(s);
        }
        throw new DateTimeParseException("Unable to parse date or time", s, 0);
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean hintReadInputOrder() {
        return true;
    }

    @Override
    @NotNull
    public <T> T methodWriter(@NotNull Class<T> tClass, Class<?> ... additional) {
        VanillaMethodWriterBuilder<T> builder = new VanillaMethodWriterBuilder<T>(tClass, WireType.YAML, () -> this.newTextMethodWriterInvocationHandler(tClass));
        for (Class<?> aClass : additional) {
            builder.addInterface(aClass);
        }
        this.useTextDocuments();
        builder.marshallableOut(this);
        return builder.build();
    }

    @NotNull
    TextMethodWriterInvocationHandler newTextMethodWriterInvocationHandler(Class<?> ... interfaces) {
        for (Class<?> anInterface : interfaces) {
            Comment c = (Comment)Jvm.findAnnotation(anInterface, Comment.class);
            if (c == null) continue;
            this.writeComment(c.value());
        }
        return new TextMethodWriterInvocationHandler(interfaces[0], this);
    }

    @Override
    @NotNull
    public <T> MethodWriterBuilder<T> methodWriterBuilder(@NotNull Class<T> tClass) {
        VanillaMethodWriterBuilder<T> builder = new VanillaMethodWriterBuilder<T>(tClass, WireType.YAML, () -> this.newTextMethodWriterInvocationHandler(tClass));
        builder.marshallableOut(this);
        return builder;
    }

    @Override
    @NotNull
    public VanillaMethodReaderBuilder methodReaderBuilder() {
        return super.methodReaderBuilder().wireType(WireType.YAML);
    }

    @Override
    @NotNull
    public DocumentContext writingDocument(boolean metaData) {
        if (this.writeContext == null) {
            this.useBinaryDocuments();
        }
        this.writeContext.start(metaData);
        return this.writeContext;
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean metaData) {
        if (this.writeContext != null && this.writeContext.isOpen()) {
            return this.writeContext;
        }
        return this.writingDocument(metaData);
    }

    @Override
    @NotNull
    public DocumentContext readingDocument() {
        this.initReadContext();
        return this.readContext;
    }

    protected void initReadContext() {
        if (this.readContext == null) {
            this.useBinaryDocuments();
        }
        this.readContext.start();
        this.yt.lineStart(this.bytes.readPosition());
    }

    @NotNull
    public YamlWire useBinaryDocuments() {
        this.readContext = new BinaryReadDocumentContext(this, false);
        this.writeContext = new BinaryWriteDocumentContext(this);
        return this;
    }

    @NotNull
    public YamlWire useTextDocuments() {
        this.readContext = new TextReadDocumentContext(this);
        this.writeContext = new TextWriteDocumentContext(this);
        return this;
    }

    @Override
    @NotNull
    public DocumentContext readingDocument(long readLocation) {
        long readPosition = this.bytes().readPosition();
        long readLimit = this.bytes().readLimit();
        this.bytes().readPosition(readLocation);
        this.initReadContext();
        this.readContext.closeReadLimit(readLimit);
        this.readContext.closeReadPosition(readPosition);
        return this.readContext;
    }

    @NotNull
    protected TextValueIn createValueIn() {
        return new TextValueIn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.bytes.readRemaining() > 0x100000L) {
            long l = this.bytes.readLimit();
            try {
                this.bytes.readLimit(this.bytes.readPosition() + 0x100000L);
                String string = this.bytes + "..";
                return string;
            }
            finally {
                this.bytes.readLimit(l);
            }
        }
        return this.bytes.toString();
    }

    @Override
    public void copyTo(@NotNull WireOut wire) throws InvalidMarshallableException {
        if (wire.getClass() == TextWire.class || wire.getClass() == YamlWire.class) {
            Bytes<?> bytes0 = this.bytes();
            wire.bytes().write((BytesStore)this.bytes, this.yt.blockStart(), bytes0.readLimit() - this.yt.blockStart);
            this.bytes.readPosition(this.bytes.readLimit());
        } else {
            while (!this.endOfDocument()) {
                this.copyOne(wire, true);
                this.yt.next();
            }
        }
    }

    private void copyOne(WireOut wire, boolean nested) throws InvalidMarshallableException {
        ValueOut wireValueOut = wire.getValueOut();
        switch (this.yt.current()) {
            case NONE: {
                break;
            }
            case COMMENT: {
                wire.writeComment(this.yt.text());
                break;
            }
            case TAG: {
                wireValueOut.typePrefix(this.yt.text());
                this.yt.next();
                this.copyOne(wire, true);
                wireValueOut.endTypePrefix();
                this.yt.next();
                break;
            }
            case DIRECTIVE: {
                break;
            }
            case DOCUMENT_END: {
                break;
            }
            case DIRECTIVES_END: {
                this.yt.next();
                while (!this.endOfDocument()) {
                    this.copyOne(wire, false);
                    this.yt.next();
                }
                break;
            }
            case MAPPING_KEY: {
                this.copyMappingKey(wire, nested);
                break;
            }
            case MAPPING_END: {
                return;
            }
            case MAPPING_START: {
                if (!nested) break;
                this.yt.next();
                wireValueOut.marshallable(w -> {
                    while (this.yt.current() == YamlToken.MAPPING_KEY) {
                        this.copyMappingKey(wire, true);
                        this.yt.next();
                    }
                });
                break;
            }
            case SEQUENCE_END: {
                break;
            }
            case SEQUENCE_ENTRY: {
                break;
            }
            case SEQUENCE_START: {
                this.yt.next();
                YamlWire yw = this;
                wireValueOut.sequence(w -> {
                    while (this.yt.current() != YamlToken.SEQUENCE_END) {
                        yw.copyOne(w.wireOut(), true);
                        yw.yt.next();
                    }
                });
                break;
            }
            case TEXT: {
                Object o = this.valueIn.readNumberOrText();
                if (o instanceof Long) {
                    wireValueOut.int64((Long)o);
                    break;
                }
                wireValueOut.object(o);
                break;
            }
            case LITERAL: {
                wireValueOut.text(this.yt.text());
                break;
            }
            case ANCHOR: {
                break;
            }
            case ALIAS: {
                break;
            }
            case RESERVED: {
                break;
            }
            case STREAM_END: {
                break;
            }
        }
    }

    private boolean endOfDocument() {
        if (this.isEmpty()) {
            return true;
        }
        switch (this.yt.current()) {
            case NONE: 
            case DOCUMENT_END: 
            case STREAM_END: 
            case STREAM_START: {
                return true;
            }
        }
        return false;
    }

    private void copyMappingKey(WireOut wire, boolean nested) throws InvalidMarshallableException {
        this.yt.next();
        if (this.yt.current() == YamlToken.MAPPING_KEY) {
            this.yt.next();
        }
        if (this.yt.current() == YamlToken.TEXT) {
            if (nested) {
                wire.write(this.yt.text());
            } else {
                wire.writeEvent(String.class, this.yt.text());
            }
        } else {
            throw new UnsupportedOperationException("Unable to copy key " + this.yt);
        }
        this.yt.next();
        this.copyOne(wire, true);
    }

    @Override
    public long readEventNumber() {
        StringBuilder stringBuilder = this.acquireStringBuilder();
        this.readField(stringBuilder);
        try {
            return StringUtils.parseInt((CharSequence)stringBuilder, (int)10);
        }
        catch (NumberFormatException ignored) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.readField(this.acquireStringBuilder());
        switch (this.yt.current()) {
            case NONE: 
            case MAPPING_END: {
                return this.defaultValueIn;
            }
        }
        return this.valueIn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected StringBuilder readField(@NotNull StringBuilder sb) {
        this.startEventIfTop();
        if (this.yt.current() == YamlToken.MAPPING_KEY) {
            this.yt.next();
            if (this.yt.current() != YamlToken.TEXT) throw new IllegalStateException(this.yt.toString());
            String text = this.yt.text();
            sb.setLength(0);
            sb.append(text);
            YamlWire.unescape(sb, this.yt.blockQuote());
            this.yt.next();
            return sb;
        } else {
            sb.setLength(0);
        }
        return sb;
    }

    @Override
    @Nullable
    public <K> K readEvent(@NotNull Class<K> expectedClass) throws InvalidMarshallableException {
        this.startEventIfTop();
        switch (this.yt.current()) {
            case MAPPING_START: {
                this.yt.next();
                assert (this.yt.current() == YamlToken.MAPPING_KEY);
            }
            case MAPPING_KEY: {
                YamlToken next = this.yt.next();
                if (next == YamlToken.MAPPING_KEY) {
                    return this.readEvent(expectedClass);
                }
                K object = this.valueIn.object(expectedClass);
                if (object instanceof StringBuilder) {
                    return (K)object.toString();
                }
                return object;
            }
            case NONE: {
                return null;
            }
        }
        throw new UnsupportedOperationException(this.yt.toString());
    }

    @Override
    public boolean isNotEmptyAfterPadding() {
        this.consumePadding();
        switch (this.yt.current()) {
            case NONE: 
            case DOCUMENT_END: 
            case MAPPING_END: 
            case SEQUENCE_END: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void consumePadding() {
        block4: while (true) {
            switch (this.yt.current()) {
                case COMMENT: {
                    String text = this.yt.text();
                    this.commentListener.accept(text);
                }
                case DIRECTIVE: 
                case DIRECTIVES_END: {
                    this.yt.next();
                    continue block4;
                }
            }
            break;
        }
    }

    @Override
    @NotNull
    public String readingPeekYaml() {
        return "todo";
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        return this.read(key.name().toString());
    }

    @Override
    @NotNull
    public ValueIn read(String keyName) {
        this.startEventIfTop();
        YamlKeys keys = this.yt.keys();
        int count = keys.count();
        if (count > 0) {
            long[] offsets = keys.offsets();
            if (this.rereadWire == null) {
                this.initRereadWire();
            }
            int indent = this.yt.topContext().indent;
            for (int i = 0; i < count; ++i) {
                this.rereadWire.yt.topContext().indent = indent;
                long end = this.bytes.readPosition();
                long offset = offsets[i];
                this.rereadWire.bytes.readPositionRemaining(offset, end - offset);
                this.rereadWire.yt.rereadFrom(offset);
                YamlToken next = this.rereadWire.yt.next();
                if (next == YamlToken.MAPPING_START) {
                    next = this.rereadWire.yt.next();
                }
                assert (next == YamlToken.MAPPING_KEY) : "next: " + (Object)((Object)next);
                if (!this.rereadWire.checkForMatch(keyName)) continue;
                keys.removeIndex(i);
                return this.rereadWire.valueIn;
            }
        }
        YamlTokeniser.YTContext yc = this.yt.topContext();
        int minIndent = yc.indent;
        while (this.yt.current() == YamlToken.MAPPING_KEY) {
            long lastKeyPosition = this.yt.lineStart;
            if (this.checkForMatch(keyName)) {
                return this.valueIn;
            }
            if (!StringUtils.startsWith((CharSequence)this.sb, (String)"-")) {
                keys.push(lastKeyPosition);
            }
            this.valueIn.consumeAny(minIndent >= 0 ? minIndent : Integer.MAX_VALUE);
        }
        return this.defaultValueIn;
    }

    private void initRereadWire() {
        YamlToken yamlToken;
        this.rereadWire = new YamlWire(this.bytes.bytesStore().bytesForRead());
        while ((yamlToken = this.rereadWire.yt.next()) == YamlToken.STREAM_START || yamlToken == YamlToken.DIRECTIVES_END || yamlToken == YamlToken.COMMENT || yamlToken == YamlToken.MAPPING_START) {
        }
    }

    public String dumpContext() {
        ValidatableUtil.startValidateDisabled();
        try {
            Wire yw = Wire.newYamlWireOnHeap();
            yw.getValueOut().list(this.yt.contexts, YamlTokeniser.YTContext.class);
            String string = yw.toString();
            return string;
        }
        finally {
            ValidatableUtil.endValidateDisabled();
        }
    }

    private boolean checkForMatch(@NotNull String keyName) {
        YamlToken next = this.yt.next();
        if (next != YamlToken.TEXT) {
            throw new IllegalStateException(next.toString());
        }
        this.sb.setLength(0);
        this.sb.append(this.yt.text());
        YamlWire.unescape(this.sb, this.yt.blockQuote());
        this.yt.next();
        return this.sb.length() == 0 || StringUtils.isEqual((StringBuilder)this.sb, (CharSequence)keyName);
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.startEventIfTop();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        s.setLength(0);
        if (this.yt.current() == YamlToken.COMMENT) {
            s.append(this.yt.text());
            this.yt.next();
        }
        return this;
    }

    @Override
    public void clear() {
        this.reset();
    }

    protected void consumeDocumentStart() {
        if (this.bytes.readRemaining() > 4L) {
            String word;
            long pos = this.bytes.readPosition();
            if (this.bytes.readByte(pos) == 45 && this.bytes.readByte(pos + 1L) == 45 && this.bytes.readByte(pos + 2L) == 45) {
                this.bytes.readSkip(3L);
            }
            pos = this.bytes.readPosition();
            switch (word = this.bytes.parseUtf8((StopCharTester)StopCharTesters.SPACE_STOP)) {
                case "!!data": 
                case "!!data-not-ready": 
                case "!!meta-data": 
                case "!!meta-data-not-ready": {
                    break;
                }
                default: {
                    this.bytes.readPosition(pos);
                }
            }
        }
        if (this.yt.current() == YamlToken.NONE) {
            this.yt.next();
        }
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new TextLongReference();
    }

    @Override
    @NotNull
    public BooleanValue newBooleanReference() {
        return new TextBooleanReference();
    }

    @Override
    public boolean useSelfDescribingMessage(@NotNull CommonMarshallable object) {
        return true;
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new TextIntReference();
    }

    @Override
    @NotNull
    public LongArrayValues newLongArrayReference() {
        return new TextLongArrayReference();
    }

    @Override
    @NotNull
    public IntArrayValues newIntArrayReference() {
        return new TextIntArrayReference();
    }

    @NotNull
    private Map readMap(Class<?> valueType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.yt.current() == YamlToken.MAPPING_START) {
            while (this.yt.next() == YamlToken.MAPPING_KEY) {
                if (this.yt.next() == YamlToken.TEXT) {
                    String key = this.yt.text();
                    if (this.yt.next() != YamlToken.TEXT) {
                        throw new UnsupportedOperationException(this.yt.toString());
                    }
                    Object o = ObjectUtils.convertTo(valueType, (Object)this.yt.text());
                    map.put(key, o);
                    continue;
                }
                throw new UnsupportedOperationException(this.yt.toString());
            }
        } else {
            throw new UnsupportedOperationException(this.yt.toString());
        }
        return map;
    }

    @Override
    public void startEvent() {
        this.consumePadding();
        switch (this.yt.current()) {
            case MAPPING_START: {
                this.yt.next(Integer.MAX_VALUE);
                return;
            }
            case NONE: {
                return;
            }
        }
        throw new UnsupportedOperationException(this.yt.toString());
    }

    void startEventIfTop() {
        this.consumePadding();
        if (this.yt.contextSize() == 3 && this.yt.current() == YamlToken.MAPPING_START) {
            this.yt.next();
        }
    }

    @Override
    public boolean isEndEvent() {
        this.consumePadding();
        YamlToken current = this.yt.current();
        return current == YamlToken.MAPPING_END || current == YamlToken.NONE;
    }

    @Override
    public void endEvent() {
        YamlTokeniser.YTContext context = this.yt.topContext();
        int minIndent = context.indent;
        switch (this.yt.current()) {
            case NONE: 
            case DOCUMENT_END: 
            case MAPPING_END: {
                break;
            }
            default: {
                do {
                    this.valueIn.consumeAny(minIndent);
                } while (this.yt.current() == YamlToken.COMMENT);
            }
        }
        if (this.yt.current() == YamlToken.NONE) {
            this.yt.next(Integer.MIN_VALUE);
        } else {
            while (this.yt.current() == YamlToken.MAPPING_KEY) {
                this.valueIn.consumeAny(minIndent);
            }
        }
        if (this.yt.current() == YamlToken.MAPPING_END || this.yt.current() == YamlToken.DOCUMENT_END || this.yt.current() == YamlToken.NONE) {
            this.yt.next(Integer.MIN_VALUE);
            return;
        }
        throw new UnsupportedOperationException(this.yt.toString());
    }

    @Override
    public void reset() {
        if (this.readContext != null) {
            this.readContext.reset();
        }
        if (this.writeContext != null) {
            this.writeContext.reset();
        }
        this.bytes.clear();
        this.sb.setLength(0);
        this.yt.reset();
        this.valueIn.resetState();
        this.valueOut.resetState();
        this.anchorValues.clear();
    }

    @Override
    public boolean hasMetaDataPrefix() {
        if (this.yt.current() == YamlToken.TAG && this.yt.isText("!meta-data")) {
            this.yt.next();
            return true;
        }
        return false;
    }

    @Override
    public boolean readDocument(@Nullable ReadMarshallable metaDataConsumer, @Nullable ReadMarshallable dataConsumer) throws InvalidMarshallableException {
        this.valueIn.resetState();
        return super.readDocument(metaDataConsumer, dataConsumer);
    }

    @Override
    public boolean readDocument(long position, @Nullable ReadMarshallable metaDataConsumer, @Nullable ReadMarshallable dataConsumer) throws InvalidMarshallableException {
        this.valueIn.resetState();
        return super.readDocument(position, metaDataConsumer, dataConsumer);
    }

    @Override
    public boolean writingIsComplete() {
        return !this.writeContext.isNotComplete();
    }

    @Override
    public void rollbackIfNotComplete() {
        this.writeContext.rollbackIfNotComplete();
    }

    class TextValueIn
    implements ValueIn {
        TextValueIn() {
        }

        @Override
        public ClassLookup classLookup() {
            return YamlWire.this.classLookup();
        }

        @Override
        public void resetState() {
            YamlWire.this.yt.reset();
            YamlWire.this.anchorValues.clear();
        }

        @Override
        @Nullable
        public String text() {
            @Nullable StringBuilder cs = this.textTo0(YamlWire.this.acquireStringBuilder());
            YamlWire.this.yt.next();
            return cs == null ? null : WireInternal.INTERNER.intern((CharSequence)cs);
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            sb.setLength(0);
            @Nullable StringBuilder cs = this.textTo0(sb);
            YamlWire.this.yt.next();
            if (cs == null) {
                return null;
            }
            if (cs != sb) {
                sb.setLength(0);
                sb.append((CharSequence)cs);
            }
            return sb;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @Nullable
        public Bytes<?> textTo(@NotNull Bytes<?> bytes) {
            bytes.clear();
            if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                bytes.append((CharSequence)YamlWire.this.yt.text());
                YamlWire.this.yt.next();
                return bytes;
            } else {
                if (YamlWire.this.yt.current() != YamlToken.TAG) throw new UnsupportedOperationException(YamlWire.this.yt.toString());
                if (YamlWire.this.yt.isText(YamlWire.NULL_TAG)) {
                    YamlWire.this.yt.next();
                    YamlWire.this.yt.next();
                    return null;
                }
                if (!YamlWire.this.yt.isText(YamlWire.BINARY_TAG)) throw new UnsupportedOperationException(YamlWire.this.yt.toString());
                YamlWire.this.yt.next();
                bytes.write((byte[])this.decodeBinary(byte[].class));
            }
            return bytes;
        }

        @Override
        public <E> E object(@Nullable E using, @Nullable Class<? extends E> clazz, boolean bestEffort) throws InvalidMarshallableException {
            YamlToken current = YamlWire.this.yt.current();
            if (current == YamlToken.ALIAS) {
                String alias = YamlWire.this.yt.text();
                Object o = YamlWire.this.anchorValues.get(alias);
                YamlWire.this.yt.next();
                if (o == null) {
                    throw new IllegalStateException("Unknown alias " + alias + " with no corresponding anchor");
                }
                return (E)o;
            }
            if (current == YamlToken.ANCHOR) {
                String alias = YamlWire.this.yt.text();
                YamlWire.this.yt.next();
                E o = Wires.object0(this, using, clazz, bestEffort);
                YamlWire.this.anchorValues.put(alias, o);
                return o;
            }
            return Wires.object0(this, using, clazz, bestEffort);
        }

        @Override
        public BracketType getBracketType() {
            switch (YamlWire.this.yt.current()) {
                default: {
                    throw new UnsupportedOperationException(YamlWire.this.yt.toString());
                }
                case COMMENT: 
                case TAG: 
                case DIRECTIVES_END: {
                    YamlWire.this.yt.next();
                    return this.getBracketType();
                }
                case MAPPING_START: {
                    return BracketType.MAP;
                }
                case SEQUENCE_START: {
                    return BracketType.SEQ;
                }
                case NONE: 
                case MAPPING_KEY: 
                case SEQUENCE_ENTRY: 
                case TEXT: 
                case LITERAL: 
                case STREAM_START: 
            }
            return BracketType.NONE;
        }

        @Nullable
        StringBuilder textTo0(@NotNull StringBuilder a) {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_ENTRY) {
                YamlWire.this.yt.next();
            }
            if (YamlWire.this.yt.current() == YamlToken.TEXT || YamlWire.this.yt.current() == YamlToken.LITERAL) {
                a.append(YamlWire.this.yt.text());
                if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                    YamlWire.unescape(a, YamlWire.this.yt.blockQuote());
                }
            } else if (YamlWire.this.yt.current() == YamlToken.TAG) {
                if (YamlWire.this.yt.isText(YamlWire.NULL_TAG)) {
                    YamlWire.this.yt.next();
                    return null;
                }
                if (YamlWire.this.yt.isText(YamlWire.BINARY_TAG)) {
                    byte[] arr;
                    YamlWire.this.yt.next();
                    for (byte b : arr = (byte[])this.decodeBinary(byte[].class)) {
                        a.append((char)b);
                    }
                    return a;
                }
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            return a;
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore<?, ?> compareBytes, BooleanConsumer consumer) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut<?> toBytes) {
            toBytes.clear();
            return this.bytes(b -> {
                Bytes cfr_ignored_0 = (Bytes)toBytes.write((BytesStore)b);
            });
        }

        @Override
        @Nullable
        public WireIn bytesSet(@NotNull PointerBytesStore toBytes) {
            return this.bytes(bytes -> {
                long capacity = bytes.readRemaining();
                VanillaBytes bytes2 = Bytes.allocateDirect((long)capacity);
                bytes2.write((BytesStore)bytes);
                toBytes.set(bytes2.addressForRead(bytes2.start()), capacity);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadBytesMarshallable bytesConsumer) {
            YamlWire.this.consumePadding();
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            if (YamlWire.this.yt.current() == YamlToken.TAG) {
                YamlWire.this.bytes.readSkip(1L);
                YamlWire.this.yt.text(sb);
                YamlWire.this.yt.next();
                if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                    throw new UnsupportedOperationException(YamlWire.this.yt.toString());
                }
                @Nullable byte[] uncompressed = Compression.uncompress((CharSequence)sb, (Object)YamlWire.this.yt, t -> {
                    @NotNull StringBuilder sb2 = YamlWire.this.acquireStringBuilder();
                    t.text(sb2);
                    return Base64.getDecoder().decode(sb2.toString());
                });
                if (uncompressed != null) {
                    Bytes bytes = Bytes.wrapForRead((byte[])uncompressed);
                    try {
                        bytesConsumer.readMarshallable((BytesIn)bytes);
                        return YamlWire.this;
                    }
                    finally {
                        bytes.releaseLast();
                    }
                } else {
                    if (!StringUtils.isEqual((StringBuilder)sb, (CharSequence)YamlWire.NULL_TAG)) throw new IORuntimeException("Unsupported type=" + sb);
                    bytesConsumer.readMarshallable(null);
                    YamlWire.this.yt.next();
                }
                return YamlWire.this;
            }
            this.textTo(sb);
            Bytes bytes = Bytes.wrapForRead((byte[])sb.toString().getBytes(StandardCharsets.ISO_8859_1));
            try {
                bytesConsumer.readMarshallable((BytesIn)bytes);
                return YamlWire.this;
            }
            finally {
                bytes.releaseLast();
            }
        }

        @Override
        public byte @Nullable [] bytes(byte[] using) {
            return (byte[])this.objectWithInferredType(using, SerializationStrategies.ANY_OBJECT, byte[].class);
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return YamlWire.this;
        }

        @Override
        public long readLength() {
            return this.readLengthMarshallable();
        }

        @Override
        @NotNull
        public WireIn skipValue() {
            this.consumeAny(((YamlWire)YamlWire.this).yt.topContext().indent);
            return YamlWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long readLengthMarshallable() {
            long start = YamlWire.this.bytes.readPosition();
            try {
                this.consumeAny(((YamlWire)YamlWire.this).yt.topContext().indent);
                long l = YamlWire.this.bytes.readPosition() - start;
                return l;
            }
            finally {
                YamlWire.this.bytes.readPosition(start);
            }
        }

        protected void consumeAny(int minIndent) {
            YamlWire.this.consumePadding();
            int indent2 = Math.max(((YamlWire)YamlWire.this).yt.topContext().indent, minIndent);
            switch (YamlWire.this.yt.current()) {
                case TAG: 
                case SEQUENCE_ENTRY: {
                    YamlWire.this.yt.next(minIndent);
                    this.consumeAny(minIndent);
                    break;
                }
                case MAPPING_START: {
                    this.consumeMap(indent2);
                    break;
                }
                case SEQUENCE_START: {
                    this.consumeSeq(indent2);
                    break;
                }
                case MAPPING_KEY: {
                    YamlWire.this.yt.next(minIndent);
                    this.consumeAny(minIndent);
                    if (YamlWire.this.yt.current() == YamlToken.MAPPING_KEY || YamlWire.this.yt.current() == YamlToken.MAPPING_END) break;
                    this.consumeAny(minIndent);
                    break;
                }
                case SEQUENCE_END: {
                    YamlWire.this.yt.next(minIndent);
                    break;
                }
                case TEXT: {
                    YamlWire.this.yt.next(minIndent);
                    break;
                }
                case NONE: 
                case DOCUMENT_END: 
                case MAPPING_END: 
                case STREAM_START: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(YamlWire.this.yt.toString());
                }
            }
        }

        private void consumeSeq(int minIndent) {
            assert (YamlWire.this.yt.current() == YamlToken.SEQUENCE_START);
            YamlWire.this.yt.next(minIndent);
            block4: while (true) {
                switch (YamlWire.this.yt.current()) {
                    case SEQUENCE_ENTRY: {
                        YamlWire.this.yt.next(minIndent);
                        this.consumeAny(minIndent);
                        continue block4;
                    }
                    case SEQUENCE_END: {
                        YamlWire.this.yt.next(minIndent);
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException(YamlWire.this.yt.toString());
        }

        private void consumeMap(int minIndent) {
            YamlWire.this.yt.next(minIndent);
            while (YamlWire.this.yt.current() == YamlToken.MAPPING_KEY) {
                YamlWire.this.yt.next(minIndent);
                this.consumeAny(minIndent);
                this.consumeAny(minIndent);
            }
            if (YamlWire.this.yt.current() == YamlToken.NONE) {
                YamlWire.this.yt.next(Integer.MIN_VALUE);
            }
            if (YamlWire.this.yt.current() == YamlToken.MAPPING_END) {
                YamlWire.this.yt.next(minIndent);
            }
        }

        @Override
        @NotNull
        public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> tFlag) {
            YamlWire.this.consumePadding();
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            if (this.textTo(stringBuilder) == null) {
                tFlag.accept(t, null);
                return YamlWire.this;
            }
            Boolean flag = stringBuilder.length() == 0 ? null : Boolean.valueOf(StringUtils.isEqual((StringBuilder)stringBuilder, (CharSequence)"true"));
            tFlag.accept(t, flag);
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
            YamlWire.this.consumePadding();
            tb.accept(t, (byte)this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            YamlWire.this.consumePadding();
            ti.accept(t, (short)this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            YamlWire.this.consumePadding();
            ti.accept(t, (short)this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            YamlWire.this.consumePadding();
            ti.accept(t, (int)this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            YamlWire.this.consumePadding();
            ti.accept(t, (int)this.getALong());
            return YamlWire.this;
        }

        long getALong() {
            if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                long l = YamlWire.this.yt.parseLong();
                YamlWire.this.yt.next();
                return l;
            }
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            YamlWire.this.consumePadding();
            tl.accept(t, this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            YamlWire.this.consumePadding();
            tl.accept(t, this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
            YamlWire.this.consumePadding();
            tf.accept(t, (float)this.getADouble());
            return YamlWire.this;
        }

        public double getADouble() {
            if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                double v = YamlWire.this.yt.parseDouble();
                YamlWire.this.yt.next();
                return v;
            }
            throw new UnsupportedOperationException("yt:" + (Object)((Object)YamlWire.this.yt.current()));
        }

        @Override
        @NotNull
        public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
            YamlWire.this.consumePadding();
            td.accept(t, this.getADouble());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
            YamlWire.this.consumePadding();
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            setLocalTime.accept(t, LocalTime.parse(WireInternal.INTERNER.intern((CharSequence)stringBuilder)));
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
            YamlWire.this.consumePadding();
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            tZonedDateTime.accept(t, ZonedDateTime.parse(WireInternal.INTERNER.intern((CharSequence)stringBuilder)));
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
            YamlWire.this.consumePadding();
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            tLocalDate.accept(t, LocalDate.parse(WireInternal.INTERNER.intern((CharSequence)stringBuilder)));
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
            YamlWire.this.consumePadding();
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            tuuid.accept(t, UUID.fromString(WireInternal.INTERNER.intern((CharSequence)stringBuilder)));
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
            YamlWire.this.consumePadding();
            if (!(values instanceof TextLongArrayReference)) {
                values = new TextLongArrayReference();
            }
            @NotNull Byteable b = (Byteable)values;
            long length = TextLongArrayReference.peakLength((BytesStore)YamlWire.this.bytes, (long)YamlWire.this.bytes.readPosition());
            b.bytesStore((BytesStore)YamlWire.this.bytes, YamlWire.this.bytes.readPosition(), length);
            YamlWire.this.bytes.readSkip(length);
            setter.accept(t, values);
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(@NotNull LongValue value) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public WireIn int32(@NotNull IntValue value) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        public WireIn bool(@NotNull BooleanValue value) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
            if (!(value instanceof TextLongReference)) {
                value = new TextLongReference();
                setter.accept(t, value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        public <T> boolean sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
            YamlWire.this.consumePadding();
            if (this.isNull()) {
                return false;
            }
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_START) {
                int minIndent = ((YamlWire)YamlWire.this).yt.secondTopContext().indent;
                YamlWire.this.yt.next(Integer.MAX_VALUE);
                tReader.accept(t, YamlWire.this.valueIn);
                if (YamlWire.this.yt.current() == YamlToken.NONE) {
                    YamlWire.this.yt.next(minIndent);
                }
                if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_END) {
                    YamlWire.this.yt.next(minIndent);
                }
            } else if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                tReader.accept(t, YamlWire.this.valueIn);
            } else {
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            return true;
        }

        @Override
        public <T> boolean sequence(List<T> list, @NotNull List<T> buffer, Supplier<T> bufferAdd, ValueIn.Reader reader0) throws InvalidMarshallableException {
            return this.sequence(list, buffer, bufferAdd);
        }

        @Override
        public <T> boolean sequence(@NotNull List<T> list, @NotNull List<T> buffer, @NotNull Supplier<T> bufferAdd) throws InvalidMarshallableException {
            YamlWire.this.consumePadding();
            if (this.isNull()) {
                return false;
            }
            list.clear();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_START) {
                int minIndent = ((YamlWire)YamlWire.this).yt.secondTopContext().indent;
                YamlWire.this.yt.next(Integer.MAX_VALUE);
                while (this.hasNextSequenceItem()) {
                    if (buffer.size() <= list.size()) {
                        buffer.add(bufferAdd.get());
                    }
                    T using = buffer.get(list.size());
                    list.add(YamlWire.this.valueIn.object(using, using.getClass()));
                }
                if (YamlWire.this.yt.current() == YamlToken.NONE) {
                    YamlWire.this.yt.next(minIndent);
                }
                if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_END) {
                    YamlWire.this.yt.next(minIndent);
                }
            } else {
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            return true;
        }

        @Override
        @NotNull
        public <T, K> WireIn sequence(@NotNull T t, K kls, @NotNull TriConsumer<T, K, ValueIn> tReader) throws InvalidMarshallableException {
            YamlWire.this.consumePadding();
            assert (YamlWire.this.yt.current() == YamlToken.SEQUENCE_START);
            YamlWire.this.yt.next(Integer.MIN_VALUE);
            block4: while (true) {
                switch (YamlWire.this.yt.current()) {
                    case SEQUENCE_ENTRY: 
                    case TEXT: {
                        tReader.accept(t, kls, YamlWire.this.valueIn);
                        continue block4;
                    }
                    case SEQUENCE_END: {
                        YamlWire.this.yt.next(Integer.MIN_VALUE);
                        return YamlWire.this;
                    }
                }
                break;
            }
            throw new IllegalStateException(YamlWire.this.yt.toString());
        }

        @Override
        public boolean hasNext() {
            if (YamlWire.this.yt.current() == YamlToken.DOCUMENT_END) {
                YamlWire.this.yt.next(Integer.MIN_VALUE);
            }
            YamlWire.this.consumePadding();
            switch (YamlWire.this.yt.current()) {
                case NONE: 
                case DOCUMENT_END: 
                case MAPPING_END: 
                case SEQUENCE_END: 
                case STREAM_END: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean hasNextSequenceItem() {
            YamlWire.this.consumePadding();
            switch (YamlWire.this.yt.current()) {
                case SEQUENCE_ENTRY: 
                case SEQUENCE_START: 
                case TEXT: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.TAG) {
                ts.accept(t, YamlWire.this.yt.text());
                YamlWire.this.yt.next();
            } else {
                ts.accept(t, "java.lang.Object");
            }
            return this;
        }

        @Override
        public Class<?> typePrefix() {
            if (YamlWire.this.yt.current() != YamlToken.TAG) {
                return null;
            }
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            YamlWire.this.yt.text(stringBuilder);
            if (YamlWire.BINARY_TAG.contentEquals(stringBuilder) || YamlWire.DATA_TAG.contains(stringBuilder)) {
                return null;
            }
            try {
                YamlWire.this.yt.next();
                return this.classLookup().forName((CharSequence)stringBuilder);
            }
            catch (ClassNotFoundRuntimeException e) {
                Jvm.warn().on(this.getClass(), "Unable to find " + stringBuilder + " " + (Object)((Object)e));
                return null;
            }
        }

        @Override
        public Object typePrefixOrObject(Class<?> tClass) {
            YamlWire.this.consumePadding();
            switch (YamlWire.this.yt.current()) {
                case TAG: {
                    Class<?> type = this.typePrefix();
                    return type;
                }
            }
            return null;
        }

        @Override
        public boolean isTyped() {
            YamlWire.this.consumePadding();
            int code = YamlWire.this.bytes.peekUnsignedByte();
            return code == 33;
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) throws IORuntimeException, BufferUnderflowException {
            if (YamlWire.this.yt.current() != YamlToken.TAG) {
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            if (!YamlWire.this.yt.isText("type")) {
                throw new UnsupportedOperationException(YamlWire.this.yt.text());
            }
            if (YamlWire.this.yt.next() != YamlToken.TEXT) {
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            classNameConsumer.accept(t, stringBuilder);
            return YamlWire.this;
        }

        @Override
        public Type typeLiteral(BiFunction<CharSequence, ClassNotFoundException, Type> unresolvedHandler) {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.TAG && YamlWire.this.yt.text().equals("type") && YamlWire.this.yt.next() == YamlToken.TEXT) {
                String text = YamlWire.this.yt.text();
                YamlWire.this.yt.next();
                try {
                    return this.classLookup().forName((CharSequence)text);
                }
                catch (ClassNotFoundRuntimeException e) {
                    return unresolvedHandler.apply(text, e.getCause());
                }
            }
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @Nullable
        public Object marshallable(@NotNull Object object, @NotNull SerializationStrategy strategy) throws BufferUnderflowException, IORuntimeException, InvalidMarshallableException {
            if (this.isNull()) {
                this.consumeAny(((YamlWire)YamlWire.this).yt.topContext().indent);
                return null;
            }
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_ENTRY) {
                YamlWire.this.yt.next();
                YamlWire.this.consumePadding();
            }
            switch (YamlWire.this.yt.current()) {
                case TAG: {
                    Class<?> clazz = this.typePrefix();
                    if (clazz != object.getClass()) {
                        object = ObjectUtils.newInstance(clazz);
                    }
                    return this.marshallable(object, strategy);
                }
                case SEQUENCE_START: {
                    Jvm.warn().on(this.getClass(), "Expected a {} but was blank for type " + object.getClass());
                    this.consumeAny(((YamlWire)YamlWire.this).yt.secondTopContext().indent);
                    return object;
                }
                case MAPPING_START: {
                    this.wireIn().startEvent();
                    object = strategy.readUsing(null, object, this, BracketType.MAP);
                    try {
                        this.wireIn().endEvent();
                    }
                    catch (UnsupportedOperationException uoe) {
                        throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (Object)((Object)YamlWire.this.yt.current()) + "', bytes=" + Bytes.toString((Bytes)YamlWire.this.bytes, (long)1024L));
                    }
                    return object;
                }
                case TEXT: {
                    return ObjectUtils.convertTo(object.getClass(), (Object)this.text());
                }
            }
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Demarshallable demarshallable(@NotNull Class<?> clazz) {
            Object object;
            YamlWire.this.consumePadding();
            switch (YamlWire.this.yt.current()) {
                case TAG: {
                    YamlWire.this.yt.next();
                    break;
                }
                case MAPPING_START: {
                    break;
                }
                default: {
                    throw new IORuntimeException("Unsupported type " + (Object)((Object)YamlWire.this.yt.current()));
                }
            }
            long len = this.readLengthMarshallable();
            long limit = YamlWire.this.bytes.readLimit();
            long position = YamlWire.this.bytes.readPosition();
            long newLimit = position - 1L + len;
            try {
                YamlWire.this.bytes.readLimit(newLimit);
                YamlWire.this.bytes.readSkip(1L);
                YamlWire.this.consumePadding();
                object = Demarshallable.newInstance(clazz, YamlWire.this);
            }
            finally {
                YamlWire.this.bytes.readLimit(limit);
                YamlWire.this.bytes.readPosition(newLimit);
            }
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() != YamlToken.MAPPING_END) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (Object)((Object)YamlWire.this.yt.current()) + "', bytes=" + Bytes.toString((Bytes)YamlWire.this.bytes, (long)1024L));
            }
            YamlWire.this.yt.next();
            return object;
        }

        @Override
        @Nullable
        public <T> T typedMarshallable() throws InvalidMarshallableException {
            return (T)this.objectWithInferredType(null, SerializationStrategies.ANY_NESTED, null);
        }

        @Nullable
        private <K, V> Map<K, V> map(@NotNull Class<K> kClass, @NotNull Class<V> vClass, @Nullable Map<K, V> usingMap) throws InvalidMarshallableException {
            YamlWire.this.consumePadding();
            if (usingMap == null) {
                usingMap = new LinkedHashMap();
            } else {
                usingMap.clear();
            }
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            switch (YamlWire.this.yt.current()) {
                case TAG: {
                    return this.typedMap(kClass, vClass, usingMap, sb);
                }
                case MAPPING_START: {
                    return this.marshallableAsMap(kClass, vClass, usingMap);
                }
                case SEQUENCE_START: {
                    return YamlWire.this.readAllAsMap(kClass, vClass, usingMap);
                }
            }
            throw new IORuntimeException("Unexpected code " + (Object)((Object)YamlWire.this.yt.current()));
        }

        @Nullable
        private <K, V> Map<K, V> typedMap(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap, @NotNull StringBuilder sb) throws InvalidMarshallableException {
            YamlWire.this.yt.text(sb);
            YamlWire.this.yt.next();
            if (YamlWire.NULL_TAG.contentEquals(sb)) {
                this.text();
                return null;
            }
            if (YamlWire.SEQ_MAP.contentEquals(sb)) {
                YamlWire.this.consumePadding();
                if (YamlWire.this.yt.current() != YamlToken.SEQUENCE_START) {
                    throw new IORuntimeException("Unsupported start of sequence : " + (Object)((Object)YamlWire.this.yt.current()));
                }
                do {
                    this.marshallable((WireIn r) -> {
                        @Nullable E k = r.read(() -> "key").object(kClazz);
                        @Nullable E v = r.read(() -> "value").object(vClass);
                        usingMap.put(k, v);
                    });
                } while (this.hasNextSequenceItem());
                return usingMap;
            }
            throw new IORuntimeException("Unsupported type :" + sb);
        }

        @Override
        public boolean bool() {
            YamlWire.this.consumePadding();
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            if (this.textTo(stringBuilder) == null) {
                throw new NullPointerException("value is null");
            }
            if (ObjectUtils.isTrue((CharSequence)stringBuilder)) {
                return true;
            }
            if (ObjectUtils.isFalse((CharSequence)stringBuilder)) {
                return false;
            }
            Jvm.debug().on(this.getClass(), "Unable to parse '" + stringBuilder + "' as a boolean flag, assuming false");
            return false;
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public int uint16() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < 0L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/ZERO");
            }
            return (int)l;
        }

        @Override
        public long int64() {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_ENTRY) {
                YamlWire.this.yt.next();
            }
            YamlWire.this.valueIn.skipType();
            if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                Jvm.warn().on(this.getClass(), "Unable to read " + YamlWire.this.valueIn.objectBestEffort() + " as a long.");
                return 0L;
            }
            return this.getALong();
        }

        @Override
        public double float64() {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_ENTRY) {
                YamlWire.this.yt.next();
            }
            YamlWire.this.valueIn.skipType();
            if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                Jvm.warn().on(this.getClass(), "Unable to read " + YamlWire.this.valueIn.objectBestEffort() + " as a double.");
                return 0.0;
            }
            return this.getADouble();
        }

        void skipType() {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.TAG) {
                YamlWire.this.yt.next();
                YamlWire.this.consumePadding();
            }
        }

        @Override
        public float float32() {
            return (float)this.float64();
        }

        @Override
        public boolean isNull() {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.TAG && YamlWire.this.yt.isText(YamlWire.NULL_TAG)) {
                this.consumeAny(0);
                return true;
            }
            return false;
        }

        @Override
        public Object objectWithInferredType(Object using, @NotNull SerializationStrategy strategy, Class<?> type) throws InvalidMarshallableException {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_ENTRY) {
                YamlWire.this.yt.next();
            }
            @Nullable Object o = this.objectWithInferredType0(using, strategy, type);
            YamlWire.this.consumePadding();
            return o;
        }

        @Nullable
        Object objectWithInferredType0(Object using, @NotNull SerializationStrategy strategy, Class<?> type) throws InvalidMarshallableException {
            boolean bestEffort;
            boolean bl = bestEffort = type != null;
            if (YamlWire.this.yt.current() == YamlToken.TAG) {
                Class<?> aClass = this.typePrefix();
                if (type == null || type == Object.class || type.isInterface()) {
                    type = aClass;
                }
            }
            switch (YamlWire.this.yt.current()) {
                case MAPPING_START: {
                    if (type != null) {
                        if (type == SortedMap.class && !(using instanceof SortedMap)) {
                            using = new TreeMap();
                        }
                        if (type == Object.class || Map.class.isAssignableFrom(type) || using instanceof Map) {
                            return this.map(Object.class, Object.class, using);
                        }
                    }
                    return YamlWire.this.valueIn.object(using, type, bestEffort);
                }
                case SEQUENCE_START: {
                    return this.readSequence(type);
                }
                case TEXT: 
                case LITERAL: {
                    TreeMap o = YamlWire.this.valueIn.readNumberOrText();
                    YamlWire.this.yt.next();
                    if (o instanceof StringBuilder) {
                        o = ((Object)o).toString();
                    }
                    if (type == Class.class) {
                        return YamlWire.this.classLookup.forName((CharSequence)((Object)o).toString());
                    }
                    return ObjectUtils.convertTo(type, o);
                }
                case ANCHOR: {
                    String alias = YamlWire.this.yt.text();
                    YamlWire.this.yt.next();
                    TreeMap o = YamlWire.this.valueIn.object(using, type);
                    YamlWire.this.anchorValues.put(alias, o);
                    return o;
                }
                case ALIAS: {
                    String alias = YamlWire.this.yt.text();
                    TreeMap o = YamlWire.this.anchorValues.get(alias);
                    if (o == null) {
                        throw new IllegalStateException("Unknown alias " + alias + " with no corresponding anchor");
                    }
                    YamlWire.this.yt.next();
                    return o;
                }
                case NONE: {
                    return null;
                }
                case TAG: {
                    StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
                    YamlWire.this.yt.text(stringBuilder);
                    if (!YamlWire.BINARY_TAG.contentEquals(stringBuilder)) break;
                    YamlWire.this.yt.next();
                    return this.decodeBinary(type);
                }
            }
            throw new UnsupportedOperationException("Cannot determine what to do with " + (Object)((Object)YamlWire.this.yt.current()));
        }

        @Nullable
        protected Object readNumberOrText() {
            char bq = YamlWire.this.yt.blockQuote();
            @Nullable StringBuilder s = this.textTo0(YamlWire.this.acquireStringBuilder());
            if (YamlWire.this.yt.current() == YamlToken.LITERAL) {
                return s;
            }
            return YamlWire.readNumberOrTextFrom(bq, s);
        }

        @NotNull
        private Object readSequence(Class<?> clazz) {
            @NotNull TreeSet<E> coll = clazz == SortedSet.class ? new TreeSet() : (clazz == Set.class ? new LinkedHashSet() : new ArrayList());
            @Nullable Class<?> componentType = clazz != null && clazz.isArray() && clazz.getComponentType().isPrimitive() ? clazz.getComponentType() : null;
            this.readCollection(componentType, coll);
            if (clazz != null && clazz.isArray()) {
                Object o = Array.newInstance(clazz.getComponentType(), coll.size());
                if (clazz.getComponentType().isPrimitive()) {
                    Iterator iter = coll.iterator();
                    for (int i = 0; i < coll.size(); ++i) {
                        Array.set(o, i, iter.next());
                    }
                    return o;
                }
                return coll.toArray((Object[])o);
            }
            return coll;
        }

        private void readCollection(@Nullable Class<?> clazz, @NotNull Collection list) {
            this.sequence(list, (T l, ValueIn v) -> {
                while (v.hasNextSequenceItem()) {
                    l.add(v.object(clazz));
                }
            });
        }

        private Object decodeBinary(Class<?> type) throws InvalidMarshallableException {
            Object o = this.objectWithInferredType(null, SerializationStrategies.ANY_SCALAR, String.class);
            byte[] decoded = Base64.getDecoder().decode(o == null ? "" : o.toString().replaceAll("\\s", ""));
            if (type == null || BytesStore.class.isAssignableFrom(type)) {
                return BytesStore.wrap((byte[])decoded);
            }
            if (type.isArray() && type.getComponentType().equals(Byte.TYPE)) {
                return decoded;
            }
            try {
                Method valueOf = type.getDeclaredMethod("valueOf", byte[].class);
                Jvm.setAccessible((AccessibleObject)valueOf);
                return valueOf.invoke(null, new Object[]{decoded});
            }
            catch (NoSuchMethodException valueOf) {
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
            throw new UnsupportedOperationException("Cannot determine how to deserialize " + type + " from binary data");
        }

        public String toString() {
            return YamlWire.this.toString();
        }
    }
}

