/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.chronicle.wire.utils.YamlAgitator;

public class MissingFieldAgitator
implements YamlAgitator {
    private String[] fields;

    public MissingFieldAgitator(String ... fields) {
        this.fields = fields;
    }

    @Override
    public Map<String, String> generateInputs(String yaml) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (String field : this.fields) {
            String replacement;
            String regex = "( +)(" + field + ": [^,\\n\\r]*,?)";
            String yaml2 = yaml.replaceAll(regex, replacement = "$1# missing $2\n$1-$2");
            if (yaml2.equals(yaml)) continue;
            ret.put("=" + yaml2, "missing-field-" + field);
        }
        return ret;
    }
}

