/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.AbstractFieldInfo;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.FieldInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class VanillaFieldInfo
extends AbstractFieldInfo
implements FieldInfo {
    private final Class parent;
    private transient Field field;

    public VanillaFieldInfo(String name, Class type, BracketType bracketType, @NotNull Field field) {
        super(type, bracketType, name);
        this.parent = field.getDeclaringClass();
        this.field = field;
    }

    @Override
    @Nullable
    public Object get(Object object) {
        try {
            return this.getField().get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Jvm.debug().on(VanillaFieldInfo.class, (Throwable)e);
            return null;
        }
    }

    @Override
    public long getLong(Object object) {
        try {
            return this.getField().getLong(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Jvm.debug().on(VanillaFieldInfo.class, (Throwable)e);
            return Long.MIN_VALUE;
        }
    }

    @Override
    public int getInt(Object object) {
        try {
            return this.getField().getInt(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Jvm.debug().on(VanillaFieldInfo.class, (Throwable)e);
            return Integer.MIN_VALUE;
        }
    }

    @Override
    public char getChar(Object object) {
        try {
            return this.getField().getChar(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Jvm.debug().on(VanillaFieldInfo.class, (Throwable)e);
            return '\uffff';
        }
    }

    @Override
    public double getDouble(Object object) {
        try {
            return this.getField().getDouble(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Jvm.debug().on(VanillaFieldInfo.class, (Throwable)e);
            return Double.NaN;
        }
    }

    @Override
    public void set(Object object, Object value) throws IllegalArgumentException {
        Object value2 = ObjectUtils.convertTo((Class)this.type, (Object)value);
        try {
            this.getField().set(object, value2);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void set(Object object, int value) throws IllegalArgumentException {
        try {
            this.getField().setInt(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void set(Object object, char value) throws IllegalArgumentException {
        try {
            this.getField().setChar(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void set(Object object, long value) throws IllegalArgumentException {
        try {
            this.getField().setLong(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void set(Object object, double value) throws IllegalArgumentException {
        try {
            this.getField().setDouble(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Field getField() throws NoSuchFieldException {
        if (this.field == null) {
            this.field = this.parent.getDeclaredField(this.name);
            Jvm.setAccessible((AccessibleObject)this.field);
        }
        return this.field;
    }

    @Override
    public Class<?> genericType(int index) {
        ParameterizedType genericType = (ParameterizedType)this.field.getGenericType();
        Type type = genericType.getActualTypeArguments()[index];
        return (Class)type;
    }

    @Override
    public boolean isEqual(Object a, Object b) {
        if (this.type.isPrimitive()) {
            if (this.type == Integer.TYPE) {
                return this.getInt(a) == this.getInt(b);
            }
            if (this.type == Long.TYPE) {
                return this.getLong(a) == this.getLong(b);
            }
            if (this.type == Double.TYPE) {
                return this.getDouble(a) == this.getDouble(b);
            }
            if (this.type == Character.TYPE) {
                return this.getChar(a) == this.getChar(b);
            }
        }
        return Objects.deepEquals(this.get(a), this.get(b));
    }
}

