/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.utils;

import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SourceCodeFormatter
implements Appendable,
CharSequence {
    private final String indentSpaces;
    private final AtomicInteger indent;
    private final StringBuilder formattedCode = new StringBuilder();
    private int lastNewlineIndex = 0;
    private boolean lastCharWasNewLine = false;

    public SourceCodeFormatter(int indentSpaces, AtomicInteger indent) {
        this.indentSpaces = "        ".substring(0, indentSpaces);
        this.indent = indent;
    }

    public SourceCodeFormatter(int indentSpaces) {
        this(indentSpaces, new AtomicInteger(0));
    }

    public SourceCodeFormatter(int indentSpaces, int i) {
        this(indentSpaces, new AtomicInteger(i));
    }

    @Override
    @NotNull
    public String toString() {
        return this.formattedCode.toString();
    }

    @Override
    public SourceCodeFormatter append(CharSequence csq) {
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public SourceCodeFormatter append(CharSequence csq, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public SourceCodeFormatter append(char c) {
        this.formattedCode.append(c);
        switch (c) {
            case '\n': {
                this.lastNewlineIndex = this.formattedCode.length();
                this.lastCharWasNewLine = true;
                this.padding(this.indent.get());
                break;
            }
            case '{': {
                this.indent.incrementAndGet();
                break;
            }
            case '}': {
                this.indent.decrementAndGet();
                if (this.lastNewlineIndex < 0) break;
                this.formattedCode.setLength(this.lastNewlineIndex);
                this.padding(this.indent.get());
                this.formattedCode.append(c);
                break;
            }
            case ' ': {
                if (!this.lastCharWasNewLine) break;
                this.formattedCode.setLength(this.formattedCode.length() - 1);
                break;
            }
            default: {
                this.lastCharWasNewLine = false;
            }
        }
        return this;
    }

    public void setLength(int len) {
        this.formattedCode.setLength(len);
    }

    private void padding(int indent) {
        for (int i = 0; i < indent; ++i) {
            this.formattedCode.append(this.indentSpaces);
        }
    }

    @Override
    public int length() {
        return this.formattedCode.length();
    }

    @Override
    public char charAt(int index) {
        return this.formattedCode.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.formattedCode.subSequence(start, end);
    }

    public SourceCodeFormatter append(long i) {
        this.formattedCode.append(i);
        return this;
    }

    public SourceCodeFormatter append(double d) {
        this.formattedCode.append(d);
        return this;
    }

    public SourceCodeFormatter append(boolean flag) {
        this.formattedCode.append(flag);
        return this;
    }

    public <Stringable> SourceCodeFormatter append(Stringable stringable) {
        this.formattedCode.append(stringable);
        return this;
    }

    public boolean contains(String text) {
        return this.formattedCode.indexOf(text) >= 0;
    }
}

