/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel.impl;

import java.net.URL;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.PauserMode;
import net.openhft.chronicle.wire.channel.ChannelHeader;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.ChronicleContext;
import net.openhft.chronicle.wire.channel.RedirectHeader;
import net.openhft.chronicle.wire.channel.impl.BufferedChronicleChannel;
import net.openhft.chronicle.wire.channel.impl.SocketRegistry;
import net.openhft.chronicle.wire.channel.impl.TCPChronicleChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChronicleChannelUtils {
    private ChronicleChannelUtils() {
    }

    public static ChronicleChannel newChannel(SocketRegistry socketRegistry, ChronicleChannelCfg<?> channelCfg, ChannelHeader headerOut, @Nullable Consumer<ChronicleChannel> closeCallback) throws InvalidMarshallableException {
        TCPChronicleChannel simpleConnection = new TCPChronicleChannel(channelCfg, headerOut, socketRegistry);
        if (closeCallback != null) {
            simpleConnection.closeCallback(closeCallback);
        }
        ChannelHeader marshallable = simpleConnection.headerIn();
        Jvm.debug().on(ChronicleChannel.class, "Client got " + marshallable);
        if (marshallable instanceof RedirectHeader) {
            Closeable.closeQuietly((Object)simpleConnection);
            RedirectHeader rh = (RedirectHeader)marshallable;
            for (String location : rh.locations()) {
                try {
                    URL url = ChronicleContext.urlFor(location);
                    channelCfg.hostname(url.getHost());
                    channelCfg.port(url.getPort());
                    return ChronicleChannelUtils.newChannel(socketRegistry, channelCfg, headerOut, null);
                }
                catch (IORuntimeException e) {
                    Jvm.debug().on(ChronicleChannel.class, (Throwable)e);
                }
            }
            throw new IORuntimeException("No urls available " + rh);
        }
        return channelCfg.buffered() ? new BufferedChronicleChannel(simpleConnection, (Pauser)channelCfg.pauserMode().get()) : simpleConnection;
    }

    @Deprecated
    public static ChronicleChannel newChannel(SocketRegistry socketRegistry, ChronicleChannelCfg channelCfg, ChannelHeader headerOut) throws InvalidMarshallableException {
        return ChronicleChannelUtils.newChannel(socketRegistry, channelCfg, headerOut, null);
    }

    @NotNull
    public static Runnable eventHandlerAsRunnable(ChronicleChannel chronicleChannel, Object eventHandler) {
        BooleanSupplier handlerClosed;
        MethodReader reader = chronicleChannel.methodReader(new Object[]{eventHandler});
        if (eventHandler instanceof Closeable) {
            Closeable sh = (Closeable)eventHandler;
            handlerClosed = () -> ((Closeable)sh).isClosed();
        } else {
            handlerClosed = () -> false;
        }
        return () -> {
            try {
                PauserMode pauserMode = chronicleChannel.channelCfg().pauserMode();
                if (pauserMode == null) {
                    pauserMode = PauserMode.balanced;
                }
                Pauser pauser = (Pauser)pauserMode.get();
                while (true) {
                    if (chronicleChannel.isClosed()) {
                        Jvm.debug().on(eventHandler.getClass(), "Reader on " + chronicleChannel + " is closed");
                        break;
                    }
                    if (handlerClosed.getAsBoolean()) {
                        Jvm.debug().on(eventHandler.getClass(), "Handler " + eventHandler + " is closed");
                        break;
                    }
                    if (reader.readOne()) {
                        pauser.reset();
                        continue;
                    }
                    pauser.pause();
                }
            }
            catch (Throwable t) {
                if (!chronicleChannel.isClosed() && !handlerClosed.getAsBoolean()) {
                    Jvm.warn().on(eventHandler.getClass(), "Error stopped reading thread", t);
                }
            }
            finally {
                Closeable.closeQuietly((Object)reader);
                Closeable.closeQuietly((Object)eventHandler);
            }
        };
    }
}

