/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Mocker;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireParselet;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractGeneratedMethodReader
implements MethodReader {
    private static final Consumer<MessageHistory> NO_OP_MH_CONSUMER = (Consumer)Mocker.ignored(Consumer.class, (Class[])new Class[0]);
    private static final MessageHistoryThreadLocal TEMP_MESSAGE_HISTORY = new MessageHistoryThreadLocal();
    protected final WireParselet debugLoggingParselet;
    private final MarshallableIn in;
    protected MessageHistory messageHistory;
    protected boolean dataEventProcessed;
    private boolean closeIn = false;
    private boolean closed;
    private Consumer<MessageHistory> historyConsumer = NO_OP_MH_CONSUMER;

    protected AbstractGeneratedMethodReader(MarshallableIn in, WireParselet debugLoggingParselet) {
        this.in = in;
        this.debugLoggingParselet = debugLoggingParselet;
    }

    protected static Method lookupMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(name, parameterTypes);
            Jvm.setAccessible((AccessibleObject)method);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void historyConsumer(Consumer<MessageHistory> historyConsumer) {
        this.historyConsumer = historyConsumer;
    }

    protected abstract boolean readOneCall(WireIn var1);

    protected boolean readOneCallMeta(WireIn wireIn) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readOne0(DocumentContext context) {
        if (context.isMetaData()) {
            return false;
        }
        Wire wireIn = context.wire();
        if (wireIn == null) {
            return false;
        }
        if (this.historyConsumer != NO_OP_MH_CONSUMER) {
            this.writeUnwrittenMessageHistory(context);
            this.messageHistory = null;
        }
        this.messageHistory().reset(context.sourceId(), context.index());
        try {
            wireIn.startEvent();
            wireIn.consumePadding();
            Bytes<?> bytes = wireIn.bytes();
            this.dataEventProcessed = false;
            boolean decoded = false;
            while (bytes.readRemaining() > 0L && !wireIn.isEndEvent()) {
                long start = bytes.readPosition();
                if (this.readOneCall(wireIn)) {
                    decoded = true;
                }
                if (this.restIgnored()) break;
                wireIn.consumePadding();
                if (bytes.readPosition() != start) continue;
                Jvm.warn().on(this.getClass(), "Failed to progress reading " + bytes.readRemaining() + " bytes left.");
                break;
            }
            if (decoded) {
                wireIn.endEvent();
            }
            boolean bl = decoded;
            return bl;
        }
        finally {
            if (this.historyConsumer != NO_OP_MH_CONSUMER && this.dataEventProcessed) {
                this.swapMessageHistoryIfDirty();
            }
            this.messageHistory.reset();
        }
    }

    public boolean readOneMeta(DocumentContext context) {
        Wire wireIn = context.wire();
        if (wireIn == null) {
            return false;
        }
        wireIn.startEvent();
        Bytes<?> bytes = wireIn.bytes();
        boolean decoded = false;
        while (bytes.readRemaining() > 0L && !wireIn.isEndEvent()) {
            long start = bytes.readPosition();
            if (this.readOneCallMeta(wireIn)) {
                decoded = true;
            }
            if (this.restIgnored()) break;
            wireIn.consumePadding();
            if (bytes.readPosition() != start) continue;
            Jvm.warn().on(this.getClass(), "Failed to progress reading " + bytes.readRemaining() + " bytes left.");
            break;
        }
        if (decoded) {
            wireIn.endEvent();
        }
        return decoded;
    }

    protected boolean restIgnored() {
        return false;
    }

    private void swapMessageHistoryIfDirty() {
        if (this.messageHistory.isDirty()) {
            this.messageHistory = AbstractGeneratedMethodReader.TEMP_MESSAGE_HISTORY.getAndSet(this.messageHistory);
            MessageHistory.set(this.messageHistory);
            assert (this.messageHistory != TEMP_MESSAGE_HISTORY.get());
        } else {
            TEMP_MESSAGE_HISTORY.get().reset();
        }
    }

    private void writeUnwrittenMessageHistory(DocumentContext context) {
        MessageHistory mh = TEMP_MESSAGE_HISTORY.get();
        if (mh.sources() != 0 && context.sourceId() != mh.lastSourceId() && mh.isDirty()) {
            this.historyConsumer.accept(mh);
        }
    }

    public boolean readOne() {
        boolean ok;
        this.throwExceptionIfClosed();
        try (DocumentContext context = this.in.readingDocument();){
            if (!context.isPresent()) {
                boolean bl = false;
                return bl;
            }
            ok = context.isMetaData() ? this.readOneMeta(context) : this.readOne0(context);
        }
        return ok;
    }

    public void throwExceptionIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
    }

    public MethodReaderInterceptorReturns methodReaderInterceptorReturns() {
        return null;
    }

    public void close() {
        if (this.closeIn) {
            Closeable.closeQuietly((Object)this.in);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public MethodReader closeIn(boolean closeIn) {
        this.throwExceptionIfClosed();
        this.closeIn = closeIn;
        return this;
    }

    protected <T> T checkRecycle(T o) {
        if (o == null || o.getClass().isArray()) {
            return null;
        }
        if (o instanceof Collection) {
            ((Collection)o).clear();
        }
        if (o instanceof Map) {
            ((Map)o).clear();
        }
        return o;
    }

    protected Object actualInvoke(Method method, Object o, Object[] objects) {
        try {
            return method.invoke(o, objects);
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    private MessageHistory messageHistory() {
        if (this.messageHistory == null) {
            this.messageHistory = MessageHistory.get();
        }
        return this.messageHistory;
    }

    private static final class MessageHistoryThreadLocal {
        private final ThreadLocal<MessageHistory> messageHistoryTL = ThreadLocal.withInitial(() -> {
            @NotNull VanillaMessageHistory veh = new VanillaMessageHistory();
            veh.addSourceDetails(true);
            return veh;
        });

        private MessageHistoryThreadLocal() {
        }

        private MessageHistory getAndSet(MessageHistory mh) {
            MessageHistory result = this.messageHistoryTL.get();
            this.messageHistoryTL.set(mh);
            return result;
        }

        public MessageHistory get() {
            return this.messageHistoryTL.get();
        }
    }
}

