/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.GenericReflection;
import net.openhft.chronicle.core.util.IgnoresEverything;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ExcerptListener;
import net.openhft.chronicle.wire.FieldInfo;
import net.openhft.chronicle.wire.FieldNumberParselet;
import net.openhft.chronicle.wire.GenerateMethodWriter;
import net.openhft.chronicle.wire.GeneratingMethodReaderInterceptorReturns;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.IntConverter;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MethodFilterOnFirstArg;
import net.openhft.chronicle.wire.MethodWriter;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ReflectionUtil;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.SourceContext;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.utils.JavaSourceCodeFormatter;
import net.openhft.chronicle.wire.utils.SourceCodeFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateMethodReader {
    private static final boolean DUMP_CODE = Jvm.getBoolean((String)"dumpCode");
    private static final Set<Class<?>> IGNORED_INTERFACES = new LinkedHashSet();
    private final WireType wireType;
    private final Object[] metaDataHandler;
    private final Object[] instances;
    private final MethodReaderInterceptorReturns interceptor;
    private final Map<String, String> handledMethodNames = new HashMap<String, String>();
    private final Set<String> handledMethodSignatures = new HashSet<String>();
    private final Set<Class<?>> handledInterfaces = new HashSet();
    private final SourceCodeFormatter sourceCode = new JavaSourceCodeFormatter();
    private final SourceCodeFormatter fields = new JavaSourceCodeFormatter();
    private final SourceCodeFormatter eventNameSwitchBlock = new JavaSourceCodeFormatter();
    private final SourceCodeFormatter eventNameSwitchBlockMeta = new JavaSourceCodeFormatter();
    private final SourceCodeFormatter eventIdSwitchBlock = new JavaSourceCodeFormatter();
    private final SourceCodeFormatter eventIdSwitchBlockMeta = new JavaSourceCodeFormatter();
    private final SourceCodeFormatter numericConverters = new JavaSourceCodeFormatter();
    private final String generatedClassName;
    private final Set<String> fieldNames = new LinkedHashSet<String>();
    private boolean methodFilterPresent;
    private boolean isSourceCodeGenerated;
    private boolean hasChainedCalls;

    public GenerateMethodReader(WireType wireType, MethodReaderInterceptorReturns interceptor, Object[] metaDataHandler, Object ... instances) {
        this.wireType = wireType;
        this.interceptor = interceptor;
        this.metaDataHandler = metaDataHandler;
        this.instances = instances;
        this.generatedClassName = this.generatedClassName0();
    }

    private static String signature(Method m, Class type) {
        return GenericReflection.getReturnType((Method)m, (Type)type) + " " + m.getName() + " " + Arrays.toString(GenericReflection.getParameterTypes((Method)m, (Type)type));
    }

    static boolean hasInstance(Class<?> aClass) {
        try {
            aClass.getField("INSTANCE");
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public Class<?> createClass() {
        if (!this.isSourceCodeGenerated) {
            this.generateSourceCode();
        }
        ClassLoader classLoader = this.instances[0].getClass().getClassLoader();
        String fullClassName = this.packageName() + "." + this.generatedClassName();
        try {
            return Wires.loadFromJava(classLoader, fullClassName, this.sourceCode.toString());
        }
        catch (AssertionError e) {
            if (((Throwable)((Object)e)).getCause() instanceof LinkageError) {
                try {
                    return Class.forName(fullClassName, true, classLoader);
                }
                catch (ClassNotFoundException x) {
                    throw Jvm.rethrow((Throwable)x);
                }
            }
            throw Jvm.rethrow((Throwable)((Object)e));
        }
        catch (Throwable e) {
            throw Jvm.rethrow((Throwable)new ClassNotFoundException(e.getMessage() + '\n' + this.sourceCode, e));
        }
    }

    private void generateSourceCode() {
        Class<?> aClass;
        int i;
        this.handledInterfaces.clear();
        this.handledMethodNames.clear();
        this.handledMethodSignatures.clear();
        for (i = 0; this.metaDataHandler != null && i < this.metaDataHandler.length; ++i) {
            aClass = this.metaDataHandler[i].getClass();
            for (Class<?> anInterface : ReflectionUtil.interfaces(aClass)) {
                if (Jvm.dontChain(anInterface)) continue;
                this.handleInterface(anInterface, "metaInstance" + i, false, this.eventNameSwitchBlockMeta, this.eventIdSwitchBlockMeta);
            }
        }
        this.handledInterfaces.clear();
        this.handledMethodNames.clear();
        this.handledMethodSignatures.clear();
        for (i = 0; i < this.instances.length; ++i) {
            aClass = this.instances[i].getClass();
            boolean methodFilter = this.instances[i] instanceof MethodFilterOnFirstArg;
            this.methodFilterPresent |= methodFilter;
            for (Class<?> anInterface : ReflectionUtil.interfaces(aClass)) {
                if (IGNORED_INTERFACES.contains(anInterface)) continue;
                this.handleInterface(anInterface, "instance" + i, methodFilter, this.eventNameSwitchBlock, this.eventIdSwitchBlock);
            }
        }
        if (!this.packageName().isEmpty()) {
            this.sourceCode.append(String.format("package %s;\n", this.packageName()));
        }
        this.sourceCode.append("import net.openhft.chronicle.core.Jvm;\nimport net.openhft.chronicle.core.util.InvocationTargetRuntimeException;\nimport net.openhft.chronicle.core.util.ObjectUtils;\nimport net.openhft.chronicle.bytes.*;\nimport net.openhft.chronicle.wire.*;\nimport net.openhft.chronicle.wire.utils.*;\nimport net.openhft.chronicle.wire.BinaryWireCode;\n\nimport java.util.Map;\nimport java.lang.reflect.Method;\n\n");
        this.sourceCode.append(String.format("public class %s extends AbstractGeneratedMethodReader {\n", this.generatedClassName()));
        this.sourceCode.append("// instances on which parsed calls are invoked\n");
        for (i = 0; this.metaDataHandler != null && i < this.metaDataHandler.length; ++i) {
            this.sourceCode.append(String.format("private final Object metaInstance%d;\n", i));
        }
        for (i = 0; i < this.instances.length; ++i) {
            this.sourceCode.append(String.format("private final Object instance%d;\n", i));
        }
        this.sourceCode.append("private final WireParselet defaultParselet;\n");
        this.sourceCode.append("\n");
        if (this.hasRealInterceptorReturns()) {
            this.sourceCode.append("// method reader interceptor\n");
            this.sourceCode.append("private final MethodReaderInterceptorReturns interceptor;\n");
            this.sourceCode.append("\n");
        }
        this.sourceCode.append(this.fields);
        if (this.methodFilterPresent) {
            this.sourceCode.append("// flag for handling ignoreMethodBasedOnFirstArg\n");
            this.sourceCode.append("private boolean ignored;\n\n");
        }
        if (this.numericConverters.length() > 0) {
            this.sourceCode.append("// numeric converters\n");
            this.sourceCode.append(this.numericConverters);
            this.sourceCode.append("\n");
        }
        if (this.hasChainedCalls) {
            this.sourceCode.append("// chained call result\n");
            this.sourceCode.append("private Object chainedCallReturnResult;");
            this.sourceCode.append("\n");
        }
        this.sourceCode.append(String.format("public %s(MarshallableIn in, WireParselet defaultParselet, WireParselet debugLoggingParselet, MethodReaderInterceptorReturns interceptor, Object[] metaInstances, Object[] instances) {\nsuper(in, debugLoggingParselet);\nthis.defaultParselet = defaultParselet;\n", this.generatedClassName()));
        if (this.hasRealInterceptorReturns()) {
            this.sourceCode.append("this.interceptor = interceptor;\n");
        }
        for (i = 0; this.metaDataHandler != null && i < this.metaDataHandler.length; ++i) {
            this.sourceCode.append(String.format("metaInstance%d = metaInstances[%d];\n", i, i));
        }
        for (i = 0; i < this.instances.length - 1; ++i) {
            this.sourceCode.append(String.format("instance%d = instances[%d];\n", i, i));
        }
        this.sourceCode.append(String.format("instance%d = instances[%d];\n}\n\n", this.instances.length - 1, this.instances.length - 1));
        if (this.hasChainedCalls) {
            this.sourceCode.append("@Override\npublic boolean restIgnored() {\n  return chainedCallReturnResult instanceof ").append(IgnoresEverything.class.getName()).append(";\n}\n");
        }
        this.sourceCode.append("@Override\nprotected MethodReaderStatus readOneGenerated(WireIn wireIn) {\nValueIn valueIn = wireIn.getValueIn();\nString lastEventName = \"\";\nif (wireIn.bytes().peekUnsignedByte() == BinaryWireCode.FIELD_NUMBER) {\nint methodId = (int) wireIn.readEventNumber();\nswitch (methodId) {\n");
        this.addMethodIdSwitch("history", -1, this.eventIdSwitchBlock);
        this.sourceCode.append(this.eventIdSwitchBlock);
        this.sourceCode.append("default:\nlastEventName = Integer.toString(methodId);\nbreak;\n}\n}\nelse {\nlastEventName = wireIn.readEvent(String.class);\n}\ntry {\nif (Jvm.isDebug())\ndebugLoggingParselet.accept(lastEventName, valueIn);\nif (lastEventName == null)\nthrow new IllegalStateException(\"Failed to read method name or ID\");\nswitch (lastEventName) {\n");
        if (!this.eventNameSwitchBlock.contains("case \"history\":")) {
            this.sourceCode.append("case MethodReader.HISTORY:\nvalueIn.marshallable(messageHistory);\nreturn MethodReaderStatus.HISTORY;\n\n");
        }
        this.sourceCode.append(this.eventNameSwitchBlock);
        this.sourceCode.append("default:\ndefaultParselet.accept(lastEventName, valueIn);\nreturn MethodReaderStatus.UNKNOWN;\n}\n");
        if (this.eventNameSwitchBlock.contains("break;")) {
            this.sourceCode.append("return MethodReaderStatus.KNOWN;\n");
        }
        this.sourceCode.append("} \ncatch (InvocationTargetRuntimeException e) {\nthrow e;\n}\n}\n");
        this.sourceCode.append("@Override\nprotected MethodReaderStatus readOneMetaGenerated(WireIn wireIn) {\nValueIn valueIn = wireIn.getValueIn();\nString lastEventName = \"\";\nif (wireIn.bytes().peekUnsignedByte() == BinaryWireCode.FIELD_NUMBER) {\nint methodId = (int) wireIn.readEventNumber();\nswitch (methodId) {\n");
        this.sourceCode.append(this.eventIdSwitchBlockMeta);
        this.sourceCode.append("default:\nvalueIn.skipValue();\nreturn MethodReaderStatus.UNKNOWN;\n}\n}\nelse {\nlastEventName = wireIn.readEvent(String.class);\n}\ntry {\nif (Jvm.isDebug())\ndebugLoggingParselet.accept(lastEventName, valueIn);\nif (lastEventName == null)\nthrow new IllegalStateException(\"Failed to read method name or ID\");\nswitch (lastEventName) {\ncase MethodReader.HISTORY:\nvalueIn.marshallable(messageHistory);\nreturn MethodReaderStatus.HISTORY;\n\n");
        this.sourceCode.append(this.eventNameSwitchBlockMeta);
        this.sourceCode.append("default:\ndefaultParselet.accept(lastEventName, valueIn);\nreturn MethodReaderStatus.UNKNOWN;\n}\n");
        if (this.eventNameSwitchBlockMeta.contains("break;")) {
            this.sourceCode.append("return MethodReaderStatus.KNOWN;\n");
        }
        this.sourceCode.append("} \ncatch (InvocationTargetRuntimeException e) {\nthrow e;\n}\n}\n}\n");
        this.isSourceCodeGenerated = true;
        if (DUMP_CODE) {
            System.out.println(this.sourceCode);
        }
    }

    private void handleInterface(Class<?> anInterface, String instanceFieldName, boolean methodFilter, SourceCodeFormatter eventNameSwitchBlock, SourceCodeFormatter eventIdSwitchBlock) {
        if (Jvm.dontChain(anInterface)) {
            return;
        }
        if (!this.handledInterfaces.add(anInterface)) {
            return;
        }
        for (Method m : anInterface.getMethods()) {
            String signature;
            int modifiers;
            Class<?> declaringClass = m.getDeclaringClass();
            if (declaringClass == Object.class || Modifier.isStatic(modifiers = m.getModifiers()) || GenerateMethodWriter.isSynthetic(modifiers) || !this.handledMethodSignatures.add(signature = GenerateMethodReader.signature(m, anInterface))) continue;
            String methodName = m.getName();
            try {
                Object.class.getMethod(methodName, m.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (this.handledMethodNames.containsKey(methodName)) {
                    throw new IllegalStateException("MethodReader does not support overloaded methods. Method: " + this.handledMethodNames.get(methodName) + ", and: " + signature);
                }
                this.handledMethodNames.put(methodName, signature);
                this.handleMethod(m, anInterface, instanceFieldName, methodFilter, eventNameSwitchBlock, eventIdSwitchBlock);
            }
        }
    }

    private void handleMethod(Method m, Class<?> anInterface, String instanceFieldName, boolean methodFilter, SourceCodeFormatter eventNameSwitchBlock, SourceCodeFormatter eventIdSwitchBlock) {
        MethodId methodIdAnnotation;
        Jvm.setAccessible((AccessibleObject)m);
        Type[] parameterTypes = GenericReflection.getParameterTypes((Method)m, anInterface);
        Class chainReturnType = GenericReflection.erase((Type)GenericReflection.getReturnType((Method)m, anInterface));
        if (chainReturnType != DocumentContext.class && (!chainReturnType.isInterface() || Jvm.dontChain((Class)chainReturnType))) {
            chainReturnType = null;
        }
        if (parameterTypes.length > 0 || this.hasRealInterceptorReturns()) {
            this.fields.append(String.format("// %s\n", m.getName()));
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class parameterType = GenericReflection.erase((Type)parameterTypes[i]);
            String typeName = parameterType.getCanonicalName();
            String fieldName = m.getName() + "arg" + i;
            if (!this.fieldNames.add(fieldName)) continue;
            if (parameterType == Bytes.class) {
                this.fields.append(String.format("private Bytes %s = Bytes.allocateElasticOnHeap();\n", fieldName));
                continue;
            }
            this.fields.append(String.format("private %s %s;\n", typeName, fieldName));
        }
        if (chainReturnType != null) {
            this.hasChainedCalls = true;
        }
        if (this.hasRealInterceptorReturns()) {
            this.fields.append(String.format("private final Object[] interceptor%sArgs = new Object[%d];\n", m.getName(), parameterTypes.length));
            String parameterTypesArg = parameterTypes.length == 0 ? "" : ", " + Arrays.stream(parameterTypes).map(t -> GenericReflection.erase((Type)t).getCanonicalName()).map(s -> s + ".class").collect(Collectors.joining(", "));
            this.fields.append(String.format("private static final Method %smethod = lookupMethod(%s.class, \"%s\"%s);\n", m.getName(), anInterface.getCanonicalName(), m.getName(), parameterTypesArg));
        }
        if (parameterTypes.length > 0 || this.hasRealInterceptorReturns()) {
            this.fields.append("\n");
        }
        if ((methodIdAnnotation = (MethodId)Jvm.findAnnotation((AnnotatedElement)m, MethodId.class)) != null) {
            int methodId = Maths.toInt32((long)methodIdAnnotation.value());
            this.addMethodIdSwitch(m.getName(), methodId, eventIdSwitchBlock);
        }
        String chainedCallPrefix = chainReturnType != null ? "chainedCallReturnResult = " : "";
        eventNameSwitchBlock.append(String.format("case \"%s\":\n", m.getName()));
        if (parameterTypes.length == 0) {
            eventNameSwitchBlock.append("valueIn.skipValue();\n");
            eventNameSwitchBlock.append(this.methodCall(m, instanceFieldName, chainedCallPrefix, chainReturnType));
        } else if (parameterTypes.length == 1) {
            eventNameSwitchBlock.append(this.argumentRead(m, 0, false, parameterTypes));
            eventNameSwitchBlock.append(this.methodCall(m, instanceFieldName, chainedCallPrefix, chainReturnType));
        } else {
            if (methodFilter) {
                int i;
                eventNameSwitchBlock.append("ignored = false;\n");
                eventNameSwitchBlock.append("valueIn.sequence(this, (f, v) -> {\n");
                eventNameSwitchBlock.append(this.argumentRead(m, 0, true, parameterTypes));
                eventNameSwitchBlock.append(String.format("if (((MethodFilterOnFirstArg) f.%s).ignoreMethodBasedOnFirstArg(\"%s\", f.%sarg%d)) {\n", instanceFieldName, m.getName(), m.getName(), 0));
                eventNameSwitchBlock.append("f.ignored = true;\n");
                for (i = 1; i < parameterTypes.length; ++i) {
                    eventNameSwitchBlock.append("v.skipValue();\n");
                }
                eventNameSwitchBlock.append("}\n");
                eventNameSwitchBlock.append("else {\n");
                for (i = 1; i < parameterTypes.length; ++i) {
                    eventNameSwitchBlock.append(this.argumentRead(m, i, true, parameterTypes));
                }
                eventNameSwitchBlock.append("}\n");
                eventNameSwitchBlock.append("});\n");
                eventNameSwitchBlock.append("if (!ignored) {\n");
            } else {
                eventNameSwitchBlock.append("valueIn.sequence(this, (f, v) -> { // todo optimize megamorphic lambda call\n");
                for (int i = 0; i < parameterTypes.length; ++i) {
                    eventNameSwitchBlock.append(this.argumentRead(m, i, true, parameterTypes));
                }
                eventNameSwitchBlock.append("});\n");
            }
            eventNameSwitchBlock.append(this.methodCall(m, instanceFieldName, chainedCallPrefix, chainReturnType));
            if (methodFilter) {
                eventNameSwitchBlock.append("}\n");
            }
        }
        if (chainReturnType == DocumentContext.class) {
            eventNameSwitchBlock.append("wireIn.copyTo(((").append(DocumentContext.class.getName()).append(") chainedCallReturnResult).wire());\n").append(Closeable.class.getName()).append(".closeQuietly(chainedCallReturnResult);\nchainedCallReturnResult = null;\n");
            chainReturnType = null;
        }
        eventNameSwitchBlock.append("break;\n\n");
        if (chainReturnType != null) {
            this.handleInterface(chainReturnType, "chainedCallReturnResult", false, eventNameSwitchBlock, eventIdSwitchBlock);
        }
    }

    private void addMethodIdSwitch(String methodName, int methodId, SourceCodeFormatter eventIdSwitchBlock) {
        eventIdSwitchBlock.append(String.format("case %d:\n", methodId));
        eventIdSwitchBlock.append(String.format("lastEventName = \"%s\";\n", methodName));
        eventIdSwitchBlock.append("break;\n\n");
    }

    private String methodCall(Method m, String instanceFieldName, String chainedCallPrefix, @Nullable Class<?> returnType) {
        int i;
        StringBuilder res = new StringBuilder();
        Class<?>[] parameterTypes = m.getParameterTypes();
        CharSequence[] args = new String[parameterTypes.length];
        for (i = 0; i < parameterTypes.length; ++i) {
            args[i] = m.getName() + "arg" + i;
        }
        res.append("try {\n");
        res.append("dataEventProcessed = true;\n");
        if (!this.hasRealInterceptorReturns()) {
            String codeAfter;
            String codeBefore;
            GeneratingMethodReaderInterceptorReturns generatingInterceptor;
            GeneratingMethodReaderInterceptorReturns generatingMethodReaderInterceptorReturns = generatingInterceptor = this.interceptor != null ? (GeneratingMethodReaderInterceptorReturns)this.interceptor : null;
            if (generatingInterceptor != null && (codeBefore = generatingInterceptor.codeBeforeCall(m, instanceFieldName, (String[])args)) != null) {
                res.append(codeBefore).append("\n");
            }
            res.append(String.format("%s((%s) %s).%s(%s);%n", chainedCallPrefix, m.getDeclaringClass().getCanonicalName(), instanceFieldName, m.getName(), String.join((CharSequence)", ", args)));
            if (generatingInterceptor != null && (codeAfter = generatingInterceptor.codeAfterCall(m, instanceFieldName, (String[])args)) != null) {
                res.append(codeAfter).append("\n");
            }
        } else {
            for (i = 0; i < parameterTypes.length; ++i) {
                res.append(String.format("interceptor%sArgs[%d] = %sarg%d;\n", m.getName(), i, m.getName(), i));
            }
            String castPrefix = chainedCallPrefix.isEmpty() || returnType == null ? "" : "(" + returnType.getCanonicalName() + ")";
            res.append(String.format("%s%sinterceptor.intercept(%smethod, %s, interceptor%sArgs, this::actualInvoke);\n", chainedCallPrefix, castPrefix, m.getName(), instanceFieldName, m.getName()));
        }
        res.append("} \ncatch (Exception e) {\nthrow new InvocationTargetRuntimeException(e);\n}\n");
        return res.toString();
    }

    private String argumentRead(Method m, int argIndex, boolean inLambda, Type[] parameterTypes) {
        String valueInName;
        Class<IntConverter> numericConversionClass = null;
        if (this.wireType == WireType.TEXT || this.wireType == WireType.YAML) {
            Annotation[] annotations;
            for (Annotation a : annotations = m.getParameterAnnotations()[argIndex]) {
                if (a instanceof IntConversion) {
                    numericConversionClass = ((IntConversion)a).value();
                    break;
                }
                if (a instanceof LongConversion) {
                    numericConversionClass = ((LongConversion)a).value();
                    break;
                }
                LongConversion lc = (LongConversion)Jvm.findAnnotation(a.annotationType(), LongConversion.class);
                if (lc == null) continue;
                numericConversionClass = lc.value();
                break;
            }
        }
        Class argumentType = GenericReflection.erase((Type)parameterTypes[argIndex]);
        String trueArgumentName = m.getName() + "arg" + argIndex;
        String argumentName = (inLambda ? "f." : "") + trueArgumentName;
        String string = valueInName = inLambda ? "v" : "valueIn";
        if (Boolean.TYPE.equals(argumentType)) {
            return String.format("%s = %s.bool();\n", argumentName, valueInName);
        }
        if (Byte.TYPE.equals(argumentType)) {
            if (numericConversionClass != null && GenerateMethodReader.hasInstance(numericConversionClass)) {
                return String.format("%s = (byte) %s.INSTANCE.parse(%s.text());\n", argumentName, numericConversionClass.getName(), valueInName);
            }
            if (numericConversionClass != null && LongConverter.class.isAssignableFrom(numericConversionClass)) {
                this.numericConverters.append(String.format("private final %s %sConverter = ObjectUtils.newInstance(%s.class);\n", numericConversionClass.getCanonicalName(), trueArgumentName, numericConversionClass.getCanonicalName()));
                return String.format("%s = (byte) %sConverter.parse(%s.text());\n", argumentName, argumentName, valueInName);
            }
            return String.format("%s = %s.readByte();\n", argumentName, valueInName);
        }
        if (Character.TYPE.equals(argumentType)) {
            return String.format("%s = %s.character();\n", argumentName, valueInName);
        }
        if (Short.TYPE.equals(argumentType)) {
            if (numericConversionClass != null && GenerateMethodReader.hasInstance(numericConversionClass)) {
                return String.format("%s = (short) %s.INSTANCE.parse(%s.text());\n", argumentName, numericConversionClass.getName(), valueInName);
            }
            if (numericConversionClass != null && LongConverter.class.isAssignableFrom(numericConversionClass)) {
                this.numericConverters.append(String.format("private final %s %sConverter = ObjectUtils.newInstance(%s.class);\n", numericConversionClass.getCanonicalName(), trueArgumentName, numericConversionClass.getCanonicalName()));
                return String.format("%s = (short) %sConverter.parse(%s.text());\n", argumentName, argumentName, valueInName);
            }
            return String.format("%s = %s.int16();\n", argumentName, valueInName);
        }
        if (Integer.TYPE.equals(argumentType)) {
            if (numericConversionClass != null && GenerateMethodReader.hasInstance(numericConversionClass)) {
                return String.format("%s = (int) %s.INSTANCE.parse(%s.text());\n", argumentName, numericConversionClass.getName(), valueInName);
            }
            if (numericConversionClass != null && LongConverter.class.isAssignableFrom(numericConversionClass)) {
                this.numericConverters.append(String.format("private final %s %sConverter = ObjectUtils.newInstance(%s.class);\n", numericConversionClass.getCanonicalName(), trueArgumentName, numericConversionClass.getCanonicalName()));
                return String.format("%s = (int) %sConverter.parse(%s.text());\n", argumentName, argumentName, valueInName);
            }
            if (numericConversionClass != null && IntConverter.class.isAssignableFrom(numericConversionClass)) {
                this.numericConverters.append(String.format("private final %s %sConverter = ObjectUtils.newInstance(%s.class);\n", numericConversionClass.getCanonicalName(), trueArgumentName, numericConversionClass.getCanonicalName()));
                return String.format("%s = %sConverter.parse(%s.text());\n", argumentName, argumentName, valueInName);
            }
            return String.format("%s = %s.int32();\n", argumentName, valueInName);
        }
        if (Long.TYPE.equals(argumentType)) {
            if (numericConversionClass != null && GenerateMethodReader.hasInstance(numericConversionClass)) {
                return String.format("%s = %s.INSTANCE.parse(%s.text());\n", argumentName, numericConversionClass.getName(), valueInName);
            }
            if (numericConversionClass != null && LongConverter.class.isAssignableFrom(numericConversionClass)) {
                this.numericConverters.append(String.format("private final %s %sConverter = ObjectUtils.newInstance(%s.class);\n", numericConversionClass.getCanonicalName(), trueArgumentName, numericConversionClass.getCanonicalName()));
                return String.format("%s = %sConverter.parse(%s.text());\n", argumentName, argumentName, valueInName);
            }
            return String.format("%s = %s.int64();\n", argumentName, valueInName);
        }
        if (Float.TYPE.equals(argumentType)) {
            return String.format("%s = %s.float32();\n", argumentName, valueInName);
        }
        if (Double.TYPE.equals(argumentType)) {
            return String.format("%s = %s.float64();\n", argumentName, valueInName);
        }
        if (Bytes.class.isAssignableFrom(argumentType)) {
            return String.format("%s.bytes(%s);\n", valueInName, argumentName);
        }
        if (CharSequence.class.isAssignableFrom(argumentType)) {
            return String.format("%s = %s.text();\n", argumentName, valueInName);
        }
        String typeName = argumentType.getCanonicalName();
        return String.format("%s = %s.object(checkRecycle(%s), %s.class);\n", argumentName, valueInName, argumentName, typeName);
    }

    private boolean hasRealInterceptorReturns() {
        return this.interceptor != null && !(this.interceptor instanceof GeneratingMethodReaderInterceptorReturns);
    }

    public String packageName() {
        Class<?> firstClass = this.instances[0].getClass();
        String firstClassFullName = firstClass.getName();
        return ReflectionUtil.generatedPackageName(firstClassFullName);
    }

    public String generatedClassName() {
        return this.generatedClassName;
    }

    @NotNull
    private String generatedClassName0() {
        StringBuilder sb = new StringBuilder();
        for (Object i : this.instances) {
            this.appendInstanceName(sb, i);
        }
        if (this.metaDataHandler != null) {
            for (Object i : this.metaDataHandler) {
                this.appendInstanceName(sb, i);
            }
        }
        if (this.wireType != null) {
            sb.append(this.wireType.toString().replace("_", ""));
        }
        if (this.interceptor instanceof GeneratingMethodReaderInterceptorReturns) {
            sb.append(((GeneratingMethodReaderInterceptorReturns)this.interceptor).generatorId());
        } else if (this.hasRealInterceptorReturns()) {
            sb.append("Intercepting");
        }
        sb.append("MethodReader");
        return sb.toString().replace("/", "$");
    }

    private void appendInstanceName(StringBuilder sb, Object i) {
        int lambdaSlashIndex;
        int packageDelimiterIndex;
        String nameWithoutPackage;
        Class<?> aClass = i.getClass();
        if (Proxy.isProxyClass(aClass)) {
            aClass = aClass.getInterfaces()[0];
        }
        if (aClass.getEnclosingClass() != null) {
            sb.append(aClass.getEnclosingClass().getSimpleName());
        }
        String name = aClass.getName();
        if (aClass.isSynthetic() && name.contains("$$Lambda")) {
            name = aClass.getInterfaces()[0].getName();
        }
        String string = nameWithoutPackage = (packageDelimiterIndex = name.lastIndexOf(46)) == -1 ? name : name.substring(packageDelimiterIndex + 1);
        if (aClass.isSynthetic() && !aClass.isAnonymousClass() && !aClass.isLocalClass() && (lambdaSlashIndex = nameWithoutPackage.lastIndexOf("/")) != -1) {
            nameWithoutPackage = nameWithoutPackage.substring(0, lambdaSlashIndex);
        }
        sb.append(nameWithoutPackage);
    }

    static {
        Wires.init();
        Collections.addAll(IGNORED_INTERFACES, BytesMarshallable.class, DocumentContext.class, ReadDocumentContext.class, WriteDocumentContext.class, ExcerptListener.class, FieldInfo.class, FieldNumberParselet.class, SelfDescribingMarshallable.class, BytesMarshallable.class, Marshallable.class, MarshallableIn.class, MarshallableOut.class, MethodWriter.class, SourceContext.class);
    }
}

