/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.wire.TextMethodTester;
import net.openhft.chronicle.wire.YamlMethodTester;
import net.openhft.chronicle.wire.utils.YamlAgitator;
import net.openhft.chronicle.wire.utils.YamlTester;

public class YamlTesterParametersBuilder<T> {
    private final ThrowingFunction<T, Object, Throwable> builder;
    private final Class<T> outClass;
    private final String paths;
    private final Set<Class> additionalOutputClasses = new LinkedHashSet<Class>();
    private YamlAgitator[] agitators = new YamlAgitator[0];
    private Function<T, ExceptionHandler> exceptionHandlerFunction;
    private boolean exceptionHandlerFunctionAndLog;
    private Predicate<String> testFilter = new ContainsDifferentMessageFilter();

    public YamlTesterParametersBuilder(ThrowingFunction<T, Object, Throwable> builder, Class<T> outClass, String paths) {
        this.builder = builder;
        this.outClass = outClass;
        this.paths = paths;
    }

    public YamlTesterParametersBuilder<T> agitators(YamlAgitator ... agitators) {
        this.agitators = agitators;
        return this;
    }

    public YamlTesterParametersBuilder<T> exceptionHandlerFunction(Function<T, ExceptionHandler> exceptionHandlerFunction) {
        this.exceptionHandlerFunction = exceptionHandlerFunction;
        return this;
    }

    public List<Object[]> get() {
        String path;
        Function compFunction = ThrowingFunction.asFunction(this.builder);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        String[] pathArr = this.paths.split(",");
        Predicate<String> testFilter = this.testFilter;
        LinkedHashMap testers = new LinkedHashMap();
        for (String path2 : pathArr) {
            if ((path2 = path2.trim()).isEmpty()) continue;
            String setup = path2 + "/_setup.yaml";
            TextMethodTester yt = new YamlMethodTester<T>(path2 + "/in.yaml", compFunction, this.outClass, path2 + "/out.yaml").genericEvent("event").setup(setup).exceptionHandlerFunction(this.exceptionHandlerFunction).exceptionHandlerFunctionAndLog(this.exceptionHandlerFunctionAndLog).testFilter(s -> {
                testFilter.test((String)s);
                return true;
            });
            testers.put(path2, yt);
            this.addOutputClasses(yt);
            Object[] test = new Object[]{path2, yt};
            params.add(test);
        }
        if (YamlTester.BASE_TESTS) {
            return params;
        }
        TreeSet<String> skipping = new TreeSet<String>();
        for (Map.Entry pyt : testers.entrySet()) {
            path = (String)pyt.getKey();
            YamlTester yt = (YamlTester)pyt.getValue();
            String setup = path + "/_setup.yaml";
            if (this.agitators.length <= 0) continue;
            LinkedHashMap<String, String> inputToNameMap = new LinkedHashMap<String, String>();
            for (YamlAgitator agitator : this.agitators) {
                Map<String, String> agitateMap = yt.agitate(agitator);
                for (Map.Entry<String, String> entry : agitateMap.entrySet()) {
                    inputToNameMap.putIfAbsent(entry.getKey(), entry.getValue());
                }
            }
            for (Map.Entry entry : inputToNameMap.entrySet()) {
                String name = (String)entry.getValue();
                String output = path + "/out-" + name + ".yaml";
                try {
                    if (!YamlTester.REGRESS_TESTS) {
                        IOTools.urlFor(this.builder.getClass(), (String)output);
                    }
                    TextMethodTester yta = new YamlMethodTester<T>((String)entry.getKey(), compFunction, this.outClass, output).genericEvent("event").setup(setup).exceptionHandlerFunction(this.exceptionHandlerFunction).exceptionHandlerFunctionAndLog(this.exceptionHandlerFunctionAndLog).testFilter(this.testFilter());
                    this.addOutputClasses(yta);
                    Object[] testa = new Object[]{path + "/" + name, yta};
                    params.add(testa);
                }
                catch (FileNotFoundException ioe) {
                    skipping.add(path + "/" + name);
                }
            }
        }
        for (Map.Entry pyt : testers.entrySet()) {
            String in_yaml;
            path = (String)pyt.getKey();
            try {
                in_yaml = new String(IOTools.readFile(this.outClass, (String)(path + "/in.yaml")), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
            String _setup_yaml = "";
            try {
                _setup_yaml = new String(IOTools.readFile(this.outClass, (String)(path + "/_setup.yaml")), StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String path2 : pathArr) {
                if ((path2 = path2.trim()).isEmpty()) continue;
                String name = path2.replaceAll("[:/\\\\]+", "_");
                String output = path + "/out-" + name + ".yaml";
                try {
                    String in_yaml2;
                    if (!YamlTester.REGRESS_TESTS) {
                        IOTools.urlFor(this.builder.getClass(), (String)output);
                    }
                    try {
                        in_yaml2 = new String(IOTools.readFile(this.outClass, (String)(path2 + "/in.yaml")), StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        throw new IORuntimeException((Throwable)e);
                    }
                    String _setup_yaml2 = "";
                    try {
                        _setup_yaml2 = new String(IOTools.readFile(this.outClass, (String)(path2 + "/_setup.yaml")), StandardCharsets.UTF_8);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String in2 = "=\n" + in_yaml + "\n...\n" + in_yaml2;
                    String setup2 = "=\n" + _setup_yaml + "\n...\n" + _setup_yaml2;
                    TextMethodTester yt2 = new YamlMethodTester<T>(in2, compFunction, this.outClass, output).genericEvent("event").setup(setup2).exceptionHandlerFunction(this.exceptionHandlerFunction).exceptionHandlerFunctionAndLog(this.exceptionHandlerFunctionAndLog).testFilter(this.testFilter());
                    this.addOutputClasses(yt2);
                    Object[] test2 = new Object[]{path + "+" + path2, yt2};
                    params.add(test2);
                }
                catch (FileNotFoundException ioe) {
                    skipping.add(path + "/" + path + "+" + path2);
                }
            }
            if (skipping.isEmpty()) continue;
            Jvm.debug().on(YamlTester.class, "Skipping " + skipping);
        }
        return params;
    }

    private void addOutputClasses(YamlTester yta) {
        this.additionalOutputClasses.forEach(((TextMethodTester)yta)::addOutputClass);
    }

    public YamlTesterParametersBuilder<T> addOutputClass(Class outputClass) {
        this.additionalOutputClasses.add(outputClass);
        return this;
    }

    public boolean exceptionHandlerFunctionAndLog() {
        return this.exceptionHandlerFunctionAndLog;
    }

    public YamlTesterParametersBuilder<T> exceptionHandlerFunctionAndLog(boolean exceptionHandlerFunctionAndLog) {
        this.exceptionHandlerFunctionAndLog = exceptionHandlerFunctionAndLog;
        return this;
    }

    public Predicate<String> testFilter() {
        return this.testFilter;
    }

    public YamlTesterParametersBuilder<T> testFilter(Predicate<String> testFilter) {
        this.testFilter = testFilter;
        return this;
    }

    static class ContainsDifferentMessageFilter
    implements Predicate<String> {
        final Set<String> msgs = new HashSet<String>();

        ContainsDifferentMessageFilter() {
        }

        @Override
        public boolean test(String s) {
            boolean added = false;
            for (String msg : s.split("...\\n")) {
                added |= this.msgs.add(msg);
            }
            return added;
        }
    }
}

