/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;

public class SocketRegistry
extends AbstractCloseable {
    private final Map<String, ServerSocketChannel> descToServerSocketChannelMap = new ConcurrentSkipListMap<String, ServerSocketChannel>();
    private final Set<java.io.Closeable> closeableSet = Collections.synchronizedSet(Collections.newSetFromMap(new WeakIdentityHashMap()));

    public ServerSocketChannel acquireServerSocketChannel(URL url) throws IOException {
        return this.acquireServerSocketChannel(url.getHost(), url.getPort());
    }

    private synchronized ServerSocketChannel acquireServerSocketChannel(String hostname, int port) throws IOException {
        String description = hostname == null || hostname.isEmpty() ? "port" + port : (port > 0 ? hostname + ':' + port : hostname);
        ServerSocketChannel ssc = this.descToServerSocketChannelMap.get(description);
        if (ssc != null && ssc.isOpen()) {
            return ssc;
        }
        ssc = ServerSocketChannel.open();
        this.addCloseable(ssc);
        ssc.bind(new InetSocketAddress(port));
        this.descToServerSocketChannelMap.put(description, ssc);
        return ssc;
    }

    public synchronized SocketChannel createSocketChannel(String hostname, int port) throws IOException {
        return SocketChannel.open(new InetSocketAddress(hostname, port));
    }

    private void addCloseable(java.io.Closeable closeable) {
        this.closeableSet.add(closeable);
    }

    protected synchronized void performClose() throws IllegalStateException {
        Closeable.closeQuietly(this.closeableSet);
        this.closeableSet.clear();
    }
}

