/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel;

import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIORuntimeException;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.PauserMode;
import net.openhft.chronicle.wire.Comment;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.channel.ChannelHandler;
import net.openhft.chronicle.wire.channel.ChannelHeader;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.ChronicleContext;
import net.openhft.chronicle.wire.channel.InternalChronicleChannel;
import net.openhft.chronicle.wire.channel.RedirectHeader;
import net.openhft.chronicle.wire.channel.SystemContext;
import net.openhft.chronicle.wire.channel.impl.BufferedChronicleChannel;
import net.openhft.chronicle.wire.channel.impl.SocketRegistry;
import net.openhft.chronicle.wire.channel.impl.TCPChronicleChannel;

public class ChronicleGatewayMain
extends ChronicleContext
implements Closeable {
    private final transient Function<ChannelHeader, ChannelHeader> redirectFunction;
    transient ServerSocketChannel ssc;
    transient Thread thread;
    @Comment(value="PauserMode to use in buffered channels")
    PauserMode pauserMode = PauserMode.balanced;
    @Comment(value="Default buffered if not set by the Handler")
    private boolean buffered = false;
    private ExecutorService service;

    public ChronicleGatewayMain(String url) {
        this(url, new SocketRegistry(), SystemContext.INSTANCE);
        this.addCloseable((Closeable)this.socketRegistry());
    }

    public ChronicleGatewayMain(String url, SocketRegistry socketRegistry, SystemContext systemContext) {
        super(url, socketRegistry);
        this.systemContext(systemContext);
        this.redirectFunction = this::redirect;
    }

    public static void main(String ... args) throws IOException {
        ChronicleGatewayMain chronicleGatewayMain = new ChronicleGatewayMain("tcp://localhost:" + Integer.getInteger("port", 1248)).pauserMode(PauserMode.valueOf((String)System.getProperty("pauserMode", PauserMode.balanced.name()))).buffered(Jvm.getBoolean((String)"buffered"));
        chronicleGatewayMain.useAffinity(Jvm.getBoolean((String)"useAffinity"));
        chronicleGatewayMain.pauserMode = PauserMode.valueOf((String)System.getProperty("pauserMode", PauserMode.balanced.name()));
        ChronicleGatewayMain main = args.length == 0 ? chronicleGatewayMain : Marshallable.fromFile(ChronicleGatewayMain.class, args[0]);
        System.out.println("Starting  " + (Object)((Object)main));
        main.run();
    }

    public ChronicleGatewayMain pauserMode(PauserMode pauserMode) {
        this.pauserMode = pauserMode;
        return this;
    }

    @Override
    public boolean buffered() {
        return this.buffered;
    }

    @Override
    public ChronicleGatewayMain buffered(boolean buffered) {
        this.buffered = buffered;
        return this;
    }

    public synchronized ChronicleGatewayMain start() throws IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
        this.bindSSC();
        if (this.thread == null) {
            this.thread = new Thread(this::run, "acceptor");
            this.thread.setDaemon(true);
            this.thread.start();
        }
        return this;
    }

    private void bindSSC() throws IOException {
        if (this.ssc == null) {
            this.ssc = this.socketRegistry().acquireServerSocketChannel(this.url());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        this.service = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("connections"));
        Throwable thrown = null;
        try {
            this.bindSSC();
            Object channelCfg = ((ChronicleChannelCfg)((ChronicleChannelCfg)new ChronicleChannelCfg().port(this.url().getPort())).pauserMode(this.pauserMode)).buffered(this.buffered);
            while (!this.isClosed()) {
                SocketChannel sc = this.ssc.accept();
                sc.socket().setTcpNoDelay(true);
                TCPChronicleChannel channel = new TCPChronicleChannel(this, (ChronicleChannelCfg)channelCfg, sc, this.redirectFunction);
                this.service.submit(() -> this.handle(channel));
            }
        }
        catch (Throwable e) {
            try {
                thrown = e;
            }
            catch (Throwable throwable) {
                Thread.yield();
                boolean closing = this.isClosing() || this.socketRegistry().isClosing();
                this.close();
                if (thrown != null && !closing) {
                    Jvm.error().on(((Object)((Object)this)).getClass(), thrown);
                }
                throw throwable;
            }
            Thread.yield();
            boolean closing = this.isClosing() || this.socketRegistry().isClosing();
            this.close();
            if (thrown != null && !closing) {
                Jvm.error().on(((Object)((Object)this)).getClass(), thrown);
            }
        }
        Thread.yield();
        boolean closing = this.isClosing() || this.socketRegistry().isClosing();
        this.close();
        if (thrown != null && !closing) {
            Jvm.error().on(((Object)((Object)this)).getClass(), thrown);
        }
    }

    private void waitForService() {
        try {
            this.service.shutdownNow();
            this.service.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Jvm.warn().on(((Object)((Object)this)).getClass(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    protected ChannelHeader redirect(ChannelHeader channelHandler) {
        return null;
    }

    @Override
    protected void performClose() {
        super.performClose();
        Closeable.closeQuietly((Object)this.ssc);
        if (this.service != null) {
            this.waitForService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handle(TCPChronicleChannel channel) {
        InternalChronicleChannel internalChronicleChannel;
        boolean buffered;
        ChannelHandler bh;
        Object var3_3;
        boolean close;
        block24: {
            ChannelHeader marshallable;
            block22: {
                close = true;
                var3_3 = null;
                marshallable = channel.headerIn(this.redirectFunction);
                if (marshallable instanceof ChannelHandler) break block22;
                try (DocumentContext dc = channel.acquireWritingDocument(true);){
                    dc.wire().write("error").text("The header must be a BrokerHandler");
                }
                if (!close) return;
                Closeable.closeQuietly((Object[])new Object[]{var3_3, channel});
                return;
            }
            bh = (ChannelHandler)marshallable;
            buffered = this.buffered;
            if (bh.buffered() != null) {
                buffered = bh.buffered();
            }
            System.out.println("Server got " + bh);
            ChannelHeader headerOut = channel.headerOut();
            if (!(headerOut instanceof RedirectHeader)) break block24;
            System.out.println("Server redirected  " + headerOut);
            if (!close) return;
            Closeable.closeQuietly((Object[])new Object[]{var3_3, channel});
            return;
        }
        try {
            internalChronicleChannel = buffered ? new BufferedChronicleChannel(channel, (Pauser)this.pauserMode.get(), this.redirectFunction) : channel;
            System.out.println("Running " + internalChronicleChannel);
            bh.run(this, internalChronicleChannel);
            close = bh.closeWhenRunEnds();
            if (!close) return;
        }
        catch (Throwable t) {
            try {
                Jvm.pause((long)1L);
                if (!this.isClosing() && !channel.isClosing()) {
                    if (t instanceof ClosedIORuntimeException) {
                        Jvm.warn().on(((Object)((Object)this)).getClass(), t.toString());
                    } else {
                        Jvm.error().on(((Object)((Object)this)).getClass(), t);
                    }
                }
                if (!close) return;
            }
            catch (Throwable throwable) {
                if (!close) throw throwable;
                Closeable.closeQuietly((Object[])new Object[]{var3_3, channel});
                throw throwable;
            }
            Closeable.closeQuietly((Object[])new Object[]{var3_3, channel});
            return;
        }
        Closeable.closeQuietly((Object[])new Object[]{internalChronicleChannel, channel});
        return;
    }

    public int port() {
        return this.ssc.socket().getLocalPort();
    }
}

