/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.ref.BinaryBooleanReference;
import net.openhft.chronicle.bytes.ref.BinaryIntReference;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.BinaryTwoLongReference;
import net.openhft.chronicle.bytes.ref.TextLongArrayReference;
import net.openhft.chronicle.bytes.ref.TextLongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.LicenceCheck;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.values.BooleanValue;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.wire.AbstractAnyWire;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.CSVWire;
import net.openhft.chronicle.wire.JSONWire;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.RawWire;
import net.openhft.chronicle.wire.ReadAnyWire;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlWire;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum WireType implements Function<Bytes<?>, Wire>,
LicenceCheck
{
    TEXT{
        private final boolean TEXT_AS_YAML = Jvm.getBoolean((String)"wire.testAsYaml");

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            if (this.TEXT_AS_YAML) {
                return (Wire)YAML.apply(bytes);
            }
            return new TextWire(bytes).useBinaryDocuments();
        }

        @Override
        public Supplier<LongValue> newLongReference() {
            return TextLongReference::new;
        }

        @Override
        public Supplier<LongArrayValues> newLongArrayReference() {
            return TextLongArrayReference::new;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public <T> T fromString(Class<T> tClass, @NotNull CharSequence cs) {
            NativeBytes bytes = Bytes.allocateElasticDirect((long)cs.length());
            try {
                bytes.appendUtf8(cs);
                @NotNull TextWire wire = (TextWire)this.apply((Bytes<?>)bytes);
                wire.consumePadding();
                wire.consumeDocumentStart();
                T t = wire.getValueIn().object(tClass);
                return t;
            }
            finally {
                bytes.releaseLast();
            }
        }

        @Override
        public boolean isText() {
            return true;
        }
    }
    ,
    BINARY{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new BinaryWire(bytes);
        }

        @Override
        @NotNull
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        @Nullable
        public <T> T fromString(@NotNull CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    BINARY_LIGHT{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return BinaryWire.binaryOnly(bytes);
        }

        @Override
        @NotNull
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        @Nullable
        public <T> T fromString(@NotNull CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    DEFAULT_ZERO_BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes<?> bytes) {
            try {
                return (Wire)Class.forName("software.chronicle.wire.DefaultZeroWire").getDeclaredConstructor(Bytes.class).newInstance(bytes);
            }
            catch (Exception e) {
                @NotNull IllegalStateException licence = new IllegalStateException("A Chronicle Wire Enterprise licence is required to run this code because you are using DefaultZeroWire which is a licence product. Please contact sales@chronicle.software");
                Jvm.warn().on(this.getClass(), (Throwable)licence);
                throw licence;
            }
        }

        @Override
        public void licenceCheck() {
            if (this.isAvailable()) {
                return;
            }
            @NotNull IllegalStateException licence = new IllegalStateException("A Chronicle Wire Enterprise licence is required to run this code because you are using DEFAULT_ZERO_BINARY which is a licence product. Please contact sales@chronicle.software");
            Jvm.warn().on(this.getClass(), (Throwable)licence);
            throw licence;
        }

        @Override
        public boolean isAvailable() {
            return IS_DEFAULT_ZERO_AVAILABLE;
        }

        @Override
        @NotNull
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        @Nullable
        public <T> T fromString(@NotNull CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    DELTA_BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes<?> bytes) {
            try {
                @NotNull Class<?> aClass = Class.forName("software.chronicle.wire.DeltaWire");
                Constructor<?> declaredConstructor = aClass.getDeclaredConstructor(Bytes.class);
                return (Wire)declaredConstructor.newInstance(bytes);
            }
            catch (Exception e) {
                this.licenceCheck();
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void licenceCheck() {
            if (this.isAvailable()) {
                return;
            }
            @NotNull IllegalStateException licence = new IllegalStateException("A Chronicle-Wire-Enterprise licence is required to run this code because you are using DELTA_BINARY which is a licence product. Please contact sales@chronicle.software");
            Jvm.error().on(WireType.class, (Throwable)licence);
            throw licence;
        }

        @Override
        public boolean isAvailable() {
            return IS_DELTA_AVAILABLE;
        }

        @Override
        @NotNull
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        @Nullable
        public <T> T fromString(@NotNull CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    FIELDLESS_BINARY{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new BinaryWire(bytes, false, false, true, Integer.MAX_VALUE, "binary", false);
        }

        @Override
        @NotNull
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        @Nullable
        public <T> T fromString(@NotNull CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    COMPRESSED_BINARY{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new BinaryWire(bytes, false, false, false, COMPRESSED_SIZE, "lzw", true);
        }

        @Override
        @NotNull
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        @Nullable
        public <T> T fromString(@NotNull CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    JSON{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new JSONWire(bytes).useBinaryDocuments();
        }

        @Override
        public boolean isText() {
            return true;
        }
    }
    ,
    JSON_ONLY{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new JSONWire(bytes).useTypes(true).trimFirstCurly(false).useTextDocuments();
        }

        @Override
        public boolean isText() {
            return true;
        }
    }
    ,
    YAML{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new YamlWire(bytes).useBinaryDocuments();
        }

        @Override
        public boolean isText() {
            return true;
        }
    }
    ,
    YAML_ONLY{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new YamlWire(bytes).useTextDocuments();
        }

        @Override
        public boolean isText() {
            return true;
        }
    }
    ,
    RAW{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new RawWire(bytes);
        }

        @Override
        @NotNull
        public String asString(Object marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        @Nullable
        public <T> T fromString(@NotNull CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    CSV{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new CSVWire(bytes);
        }

        @Override
        public boolean isText() {
            return true;
        }
    }
    ,
    READ_ANY{

        @Override
        @NotNull
        public Wire apply(@NotNull Bytes<?> bytes) {
            return new ReadAnyWire(bytes);
        }
    };

    private static final int COMPRESSED_SIZE;
    private static final boolean IS_DELTA_AVAILABLE;
    private static final boolean IS_DEFAULT_ZERO_AVAILABLE;

    private static boolean isDeltaAvailable() {
        try {
            Class.forName("software.chronicle.wire.DeltaWire").getDeclaredConstructor(Bytes.class);
            return true;
        }
        catch (Exception fallback) {
            return false;
        }
    }

    private static boolean isDefaultZeroAvailable() {
        try {
            Class.forName("software.chronicle.wire.DefaultZeroWire").getDeclaredConstructor(Bytes.class);
            return true;
        }
        catch (Exception var4) {
            return false;
        }
    }

    @NotNull
    static Bytes<?> getBytesForToString() {
        return Wires.acquireBytesForToString();
    }

    @NotNull
    static Bytes<?> getBytes2() {
        if (Jvm.isDebug()) {
            return Bytes.allocateElasticOnHeap();
        }
        return Wires.acquireAnotherBytes();
    }

    @Nullable
    public static WireType valueOf(@Nullable Wire wire) {
        if (wire == null) {
            return null;
        }
        if (wire instanceof AbstractAnyWire) {
            wire = ((AbstractAnyWire)wire).underlyingWire();
        }
        if (wire instanceof YamlWire) {
            return YAML;
        }
        if (wire instanceof JSONWire) {
            return JSON;
        }
        if (wire instanceof TextWire) {
            return TEXT;
        }
        if ("DeltaWire".equals(wire.getClass().getSimpleName())) {
            return DELTA_BINARY;
        }
        if ("DefaultZeroWire".equals(wire.getClass().getSimpleName())) {
            return DEFAULT_ZERO_BINARY;
        }
        if (wire instanceof BinaryWire) {
            @NotNull BinaryWire binaryWire = (BinaryWire)wire;
            return binaryWire.fieldLess() ? FIELDLESS_BINARY : BINARY;
        }
        if (wire instanceof RawWire) {
            return RAW;
        }
        throw new IllegalStateException("unknown type");
    }

    public Supplier<IntValue> newIntReference() {
        return BinaryIntReference::new;
    }

    public Supplier<BooleanValue> newBooleanReference() {
        return BinaryBooleanReference::new;
    }

    public Supplier<LongValue> newLongReference() {
        return BinaryLongReference::new;
    }

    public Supplier<TwoLongValue> newTwoLongReference() {
        return BinaryTwoLongReference::new;
    }

    public Supplier<LongArrayValues> newLongArrayReference() {
        return BinaryLongArrayReference::new;
    }

    public String asString(Object marshallable) {
        Bytes<?> bytes = this.asBytes(marshallable);
        return bytes.toString();
    }

    @NotNull
    private Bytes<?> asBytes(Object marshallable) {
        Bytes<?> bytes = WireType.getBytesForToString();
        Wire wire = (Wire)this.apply(bytes);
        wire.usePadding(AbstractWire.DEFAULT_USE_PADDING);
        @NotNull ValueOut valueOut = wire.getValueOut();
        if (marshallable instanceof WriteMarshallable) {
            valueOut.typedMarshallable((WriteMarshallable)marshallable);
        } else if (marshallable instanceof Map) {
            wire.getValueOut().marshallable((Map)marshallable, Object.class, Object.class, false);
        } else if (marshallable instanceof Iterable) {
            wire.getValueOut().sequence((Iterable)marshallable);
        } else if (marshallable instanceof Serializable) {
            valueOut.typedMarshallable((Serializable)marshallable);
        } else {
            valueOut.typedMarshallable(Wires.typeNameFor(marshallable), w -> Wires.writeMarshallable(marshallable, w));
        }
        return bytes;
    }

    @Nullable
    public <T> T fromString(@NotNull CharSequence cs) {
        return this.fromString(null, cs);
    }

    public <T> T fromString(Class<T> tClass, @NotNull CharSequence cs) {
        if (cs.length() == 0) {
            throw new IllegalArgumentException("cannot deserialize an empty string");
        }
        Bytes<?> bytes = WireType.getBytes2();
        bytes.appendUtf8(cs);
        Wire wire = (Wire)this.apply(bytes);
        return wire.getValueIn().object(tClass);
    }

    @NotNull
    public <T> T fromFile(String filename) throws IOException {
        return (T)this.fromFile(Marshallable.class, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T fromFile(@NotNull Class<T> expectedType, String filename) throws IOException {
        Bytes bytes;
        File file = new File(filename);
        URL url = null;
        if (!file.exists()) {
            url = IOTools.urlFor(expectedType, (String)filename);
            file = new File(url.getFile());
        }
        if ((bytes = Bytes.wrapForRead((byte[])IOTools.readAsBytes((InputStream)(url == null ? new FileInputStream(file) : IOTools.open((URL)url))))).readRemaining() == 0L) {
            throw new IOException("File " + file + " was empty");
        }
        try {
            T t = ((Wire)this.apply(bytes)).getValueIn().object(expectedType);
            return t;
        }
        finally {
            bytes.releaseLast();
        }
    }

    @NotNull
    public <T> Stream<T> streamFromFile(String filename) throws IOException {
        return this.streamFromFile(Marshallable.class, filename);
    }

    @NotNull
    public <T> Stream<T> streamFromFile(@NotNull Class<T> expectedType, String filename) throws IOException {
        Bytes b = BytesUtil.readFile((String)filename);
        return this.streamFromBytes(expectedType, b);
    }

    @NotNull
    public <T> Stream<T> streamFromBytes(final @NotNull Class<T> expectedType, Bytes<?> b) {
        final Wire wire = (Wire)this.apply(b);
        final ValueIn valueIn = wire.getValueIn();
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){

            @Override
            public boolean tryAdvance(@NotNull Consumer<? super T> action) {
                Bytes<?> bytes = wire.bytes();
                if (valueIn.hasNext()) {
                    action.accept(valueIn.object(expectedType));
                    if (wire instanceof TextWire) {
                        wire.consumePadding();
                        if (bytes.peekUnsignedByte() == 45 && bytes.peekUnsignedByte(bytes.readPosition() + 1L) == 45 && bytes.peekUnsignedByte(bytes.readPosition() + 2L) == 45) {
                            bytes.readSkip(3L);
                            while (bytes.peekUnsignedByte() == 45) {
                                bytes.readSkip(1L);
                            }
                        }
                    }
                    return true;
                }
                if (bytes.refCount() > 0) {
                    bytes.releaseLast();
                }
                return false;
            }
        }, false);
    }

    @NotNull
    public <T> Map<String, T> fromFileAsMap(String filename, @NotNull Class<T> tClass) throws IOException {
        @NotNull LinkedHashMap<K, V> map = new LinkedHashMap();
        Wire wire = (Wire)this.apply(BytesUtil.readFile((String)filename));
        @NotNull StringBuilder sb = new StringBuilder();
        while (wire.hasMore()) {
            wire.readEventName(sb).object(tClass, map, (m, o) -> m.put(sb.toString(), o));
        }
        return map;
    }

    public <T extends Marshallable> void toFileAsMap(@NotNull String filename, @NotNull Map<String, T> map) throws IOException {
        this.toFileAsMap(filename, map, false);
    }

    public <T extends Marshallable> void toFileAsMap(@NotNull String filename, @NotNull Map<String, T> map, boolean compact) throws IOException {
        Bytes<?> bytes = WireInternal.acquireInternalBytes();
        Wire wire = (Wire)this.apply(bytes);
        for (Map.Entry<String, T> entry : map.entrySet()) {
            @NotNull ValueOut valueOut = wire.writeEventName(entry::getKey);
            boolean wasLeaf = valueOut.swapLeaf(compact);
            valueOut.marshallable((WriteMarshallable)entry.getValue());
            valueOut.swapLeaf(wasLeaf);
        }
        String tempFilename = IOTools.tempName((String)filename);
        IOTools.writeFile((String)tempFilename, (byte[])bytes.toByteArray());
        @NotNull File file2 = new File(tempFilename);
        @NotNull File dest = new File(filename);
        if (!file2.renameTo(dest)) {
            if (dest.delete() && file2.renameTo(dest)) {
                return;
            }
            file2.delete();
            throw new IOException("Failed to rename " + tempFilename + " to " + filename);
        }
    }

    public void toFile(@NotNull String filename, WriteMarshallable marshallable) throws IOException {
        Bytes<?> bytes = WireInternal.acquireInternalBytes();
        Wire wire = (Wire)this.apply(bytes);
        wire.getValueOut().typedMarshallable(marshallable);
        String tempFilename = IOTools.tempName((String)filename);
        IOTools.writeFile((String)tempFilename, (byte[])bytes.toByteArray());
        @NotNull File file2 = new File(tempFilename);
        if (!file2.renameTo(new File(filename))) {
            file2.delete();
            throw new IOException("Failed to rename " + tempFilename + " to " + filename);
        }
    }

    @NotNull
    String asHexString(Object marshallable) {
        Bytes<?> bytes = this.asBytes(marshallable);
        return bytes.toHexString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    <T> T fromHexString(@NotNull CharSequence s) {
        Bytes bytes = Bytes.fromHexString((String)s.toString());
        try {
            Wire wire = (Wire)this.apply(bytes);
            Object t = wire.getValueIn().typedMarshallable();
            return t;
        }
        finally {
            bytes.releaseLast();
        }
    }

    @Nullable
    public Map<String, Object> asMap(@NotNull CharSequence cs) {
        Bytes<?> bytes = WireType.getBytes2();
        bytes.appendUtf8(cs);
        Wire wire = (Wire)this.apply(bytes);
        return wire.getValueIn().marshallableAsMap(String.class, Object.class);
    }

    public void licenceCheck() {
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    static {
        COMPRESSED_SIZE = Integer.getInteger("WireType.compressedSize", 128);
        IS_DELTA_AVAILABLE = WireType.isDeltaAvailable();
        IS_DEFAULT_ZERO_AVAILABLE = WireType.isDefaultZeroAvailable();
    }
}

