/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.bytes.UpdateInterceptor;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.AbstractClassGenerator;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.utils.SourceCodeFormatter;

public class GenerateMethodWriter2
extends AbstractClassGenerator<GMWMetaData> {
    private static final String DOCUMENT_CONTEXT = DocumentContext.class.getSimpleName();
    private static final Map<String, Map<List<Class<?>>, String>> TEMPLATE_METHODS = new LinkedHashMap();
    private final Map<Class<?>, String> methodWritersMap = new LinkedHashMap();

    public GenerateMethodWriter2() {
        super(new GMWMetaData());
        this.nameForClass(DocumentContext.class);
        this.importSet.add("net.openhft.chronicle.bytes.*");
        this.importSet.add("net.openhft.chronicle.wire.*");
    }

    private static String templateFor(String name, Class<?> returnType, Class<?>[] pts) {
        Map<List<Class<?>>, String> map = TEMPLATE_METHODS.get(name);
        if (map == null) {
            return null;
        }
        ArrayList sig = new ArrayList();
        sig.add(returnType);
        Collections.addAll(sig, pts);
        return map.get(sig);
    }

    private static CharSequence asString(Class<?> type) {
        if (Boolean.TYPE.equals(type)) {
            return "bool";
        }
        if (Byte.TYPE.equals(type)) {
            return "writeByte";
        }
        if (Character.TYPE.equals(type)) {
            return "character";
        }
        if (Short.TYPE.equals(type)) {
            return "int16";
        }
        if (Integer.TYPE.equals(type)) {
            return "fixedInt32";
        }
        if (Long.TYPE.equals(type)) {
            return "fixedInt64";
        }
        if (Float.TYPE.equals(type)) {
            return "fixedFloat32";
        }
        if (Double.TYPE.equals(type)) {
            return "fixedFloat64";
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return "text";
        }
        if (Marshallable.class.isAssignableFrom(type)) {
            return "marshallable";
        }
        return "object";
    }

    @Override
    protected void generateFields(SourceCodeFormatter mainCode) {
        super.generateFields(mainCode);
        this.withLineNumber(mainCode).append("private transient final Closeable closeable;\n");
        if (((GMWMetaData)this.metaData()).useUpdateInterceptor()) {
            mainCode.append("private transient final ").append(this.nameForClass(UpdateInterceptor.class)).append(" updateInterceptor;\n");
        }
        mainCode.append("private transient ").append(this.nameForClass(Supplier.class)).append("<").append(this.nameForClass(MarshallableOut.class)).append("> outSupplier;\n");
    }

    @Override
    protected void generateConstructors(SourceCodeFormatter mainCode) {
        super.generateConstructors(mainCode);
        this.withLineNumber(mainCode).append("public ").append(this.className()).append("(").append(this.nameForClass(Supplier.class)).append("<").append(this.nameForClass(MarshallableOut.class)).append("> outSupplier, ").append(this.nameForClass(Closeable.class)).append(" closeable, ").append(this.nameForClass(UpdateInterceptor.class)).append(" updateInterceptor) {\nthis.outSupplier = outSupplier;\nthis.closeable = closeable;\n");
        if (((GMWMetaData)this.metaData()).useUpdateInterceptor()) {
            mainCode.append("this.updateInterceptor = updateInterceptor;");
        }
        mainCode.append("}\n");
    }

    @Override
    protected void generateMethod(Method method, StringBuilder params, List<String> paramList, SourceCodeFormatter mainCode) {
        String eventName;
        Class<?>[] parameterTypes;
        Class<?> returnType;
        String name = method.getName();
        String template = GenerateMethodWriter2.templateFor(name, returnType = method.getReturnType(), parameterTypes = method.getParameterTypes());
        if (template != null) {
            mainCode.append(template);
            return;
        }
        boolean terminating = returnType == Void.class || returnType == Void.TYPE || returnType.isPrimitive();
        String wdc = this.nameForClass(WriteDocumentContext.class);
        this.withLineNumber(mainCode).append("MarshallableOut out = this.outSupplier.get();\ntry (final ").append(wdc).append(" dc = (").append(wdc).append(") out.acquireWritingDocument(").append(((GMWMetaData)this.metaData()).metaData()).append(")) {\n");
        mainCode.append("dc.chainedElement(" + !terminating + ");\n");
        mainCode.append("if (out.recordHistory()) MessageHistory.writeHistory(dc);\n");
        int startJ = 0;
        if (parameterTypes.length > 0 && name.equals(((GMWMetaData)this.metaData()).genericEvent)) {
            eventName = parameterTypes[0].getName();
            startJ = 1;
        } else {
            eventName = '\"' + name + '\"';
        }
        this.writeEventNameOrId(method, mainCode, eventName);
        if (parameterTypes.length == 0) {
            mainCode.append(".text(\"\");\n");
        } else {
            this.writeArrayOfParameters(method, mainCode, startJ);
        }
        mainCode.append("}\n");
        this.methodReturn(mainCode, method, ((GMWMetaData)this.metaData()).interfaces());
    }

    @Override
    protected void generateEnd(SourceCodeFormatter mainCode) {
        super.generateEnd(mainCode);
        for (Map.Entry<Class<?>, String> e : this.methodWritersMap.entrySet()) {
            mainCode.append("private transient ThreadLocal<").append(this.nameForClass(e.getKey())).append("> ").append(e.getValue()).append("= ThreadLocal.withInitial(() -> this.outSupplier.get().methodWriter(").append(this.nameForClass(e.getKey())).append(".class));\n");
        }
    }

    private void writeEventNameOrId(Method method, SourceCodeFormatter body, String eventName) {
        Optional methodId;
        Optional<Object> optional = ((GMWMetaData)this.metaData()).useMethodIds() ? Arrays.stream(method.getAnnotations()).filter(MethodId.class::isInstance).findFirst() : (methodId = Optional.empty());
        if (methodId.isPresent()) {
            long value = ((MethodId)methodId.get()).value();
            this.withLineNumber(body).append("dc.wire().writeEventId(").append(eventName).append(", ").append(String.valueOf(value)).append(")");
        } else {
            this.withLineNumber(body).append("dc.wire().write(").append(eventName).append(")");
        }
    }

    private void writeArrayOfParameters(Method dm, SourceCodeFormatter body, int startJ) {
        boolean multipleParams;
        boolean bl = multipleParams = dm.getParameterTypes().length > startJ + 1;
        if (multipleParams) {
            body.append(".array(v -> {\n");
        }
        Parameter[] parameters = dm.getParameters();
        for (int j = startJ; j < parameters.length; ++j) {
            Parameter p = parameters[j];
            if (p.getType().isPrimitive() || CharSequence.class.isAssignableFrom(p.getType())) {
                body.append(multipleParams ? "v." : ".").append(GenerateMethodWriter2.asString(p.getType())).append("(").append(p.getName()).append(");\n");
                continue;
            }
            this.writeValue(dm, body, startJ, p);
        }
        if (multipleParams) {
            body.append("}, Object[].class);\n");
        }
    }

    private void writeValue(Method dm, SourceCodeFormatter body, int startJ, Parameter p) {
        String className = p.getType().getTypeName().replace('$', '.');
        body.append(dm.getParameterTypes().length > startJ + 1 ? "v." : ".").append("object(").append(className).append(".class, ").append(p.getName()).append(");\n");
    }

    private void methodReturn(SourceCodeFormatter result, Method method, Set<Class> interfaceClases) {
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            return;
        }
        if (interfaceClases.stream().anyMatch(i -> returnType == i || returnType.isAssignableFrom((Class<?>)i))) {
            this.withLineNumber(result).append("return this;\n");
        } else if (returnType.isInterface()) {
            this.methodWritersMap.computeIfAbsent(returnType, k -> "methodWriter" + k.getSimpleName() + "TL");
            this.withLineNumber(result).append("return methodWriter").append(returnType.getSimpleName()).append("TL.get();\n");
        } else if (!returnType.isPrimitive()) {
            this.withLineNumber(result).append("return null;\n");
        } else if (returnType == Boolean.TYPE) {
            this.withLineNumber(result).append("return false;\n");
        } else if (returnType == Byte.TYPE) {
            this.withLineNumber(result).append("return (byte)0;\n");
        } else {
            this.withLineNumber(result).append("return 0;\n");
        }
    }

    static {
        TEMPLATE_METHODS.put("close", Collections.singletonMap(Collections.singletonList(Void.TYPE), "public void close() {\n   if (this.closeable != null) {\n        this.closeable.close();\n   }\n}\n"));
        TEMPLATE_METHODS.put("recordHistory", Collections.singletonMap(Collections.singletonList(Boolean.TYPE), "public boolean recordHistory() {\n    return this.outSupplier.get().recordHistory();\n}\n"));
        List dcBoolean = Stream.of(DocumentContext.class, Boolean.TYPE).collect(Collectors.toList());
        TEMPLATE_METHODS.put("acquireWritingDocument", Collections.singletonMap(dcBoolean, "public " + DOCUMENT_CONTEXT + " acquireWritingDocument(boolean metaData){\n    return this.outSupplier.get().acquireWritingDocument(metaData);\n}\n"));
        LinkedHashMap<List<Class>, String> wd = new LinkedHashMap<List<Class>, String>();
        wd.put(Collections.singletonList(DocumentContext.class), "public " + DOCUMENT_CONTEXT + " writingDocument(){\n    return this.outSupplier.get().writingDocument();\n}\n");
        wd.put(dcBoolean, "public " + DOCUMENT_CONTEXT + " writingDocument(boolean metaData){\nreturn this.outSupplier.get().writingDocument(metaData);\n}\n");
        TEMPLATE_METHODS.put("writingDocument", wd);
    }

    public static class GMWMetaData
    extends AbstractClassGenerator.MetaData<GMWMetaData> {
        private boolean metaData;
        private boolean useMethodIds;
        private String genericEvent;

        public boolean metaData() {
            return this.metaData;
        }

        public GMWMetaData metaData(boolean metaData) {
            this.metaData = metaData;
            return this;
        }

        public boolean useMethodIds() {
            return this.useMethodIds;
        }

        public GMWMetaData useMethodIds(boolean useMethodIds) {
            this.useMethodIds = useMethodIds;
            return this;
        }

        public String genericEvent() {
            return this.genericEvent;
        }

        public GMWMetaData genericEvent(String genericEvent) {
            this.genericEvent = genericEvent;
            return this;
        }
    }
}

