/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.wire.LongConverter;

public abstract class AbstractTimestampLongConverter
implements LongConverter {
    public static final ZoneId UTC = ZoneId.of("UTC");
    public static final String TIMESTAMP_LONG_CONVERTERS_ZONE_ID_SYSTEM_PROPERTY = "timestampLongConverters.zoneId";
    private final ZoneId zoneId;
    private final DateTimeFormatter dtf;
    private final long amountPerSecond;
    private final long nanosPerAmount;

    public AbstractTimestampLongConverter(TimeUnit timeUnit) {
        this(System.getProperty(TIMESTAMP_LONG_CONVERTERS_ZONE_ID_SYSTEM_PROPERTY, UTC.toString()), timeUnit);
    }

    public AbstractTimestampLongConverter(String zoneId, TimeUnit timeUnit) {
        this.zoneId = ZoneId.of(zoneId);
        this.amountPerSecond = timeUnit.convert(1L, TimeUnit.SECONDS);
        this.nanosPerAmount = TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        this.dtf = this.createFormatter();
    }

    @Override
    public long parse(CharSequence text) {
        if (text == null || text.length() == 0) {
            return 0L;
        }
        try {
            TemporalAccessor parse;
            if (text.length() > 4 && text.charAt(4) == '/') {
                text = text.toString().replace('/', '-');
            }
            if ((parse = this.dtf.parse(text)).query(TemporalQueries.zoneId()) != null) {
                return this.parseFormattedDate(ZonedDateTime.from(parse).withZoneSameInstant(UTC));
            }
            return this.parseFormattedDate(LocalDateTime.from(parse).atZone(this.zoneId).withZoneSameInstant(UTC));
        }
        catch (DateTimeParseException dtpe) {
            try {
                return this.parseTimestamp(Long.parseLong(text.toString()), text);
            }
            catch (NumberFormatException e) {
                throw dtpe;
            }
        }
    }

    protected abstract long parseFormattedDate(ZonedDateTime var1);

    protected abstract long parseTimestamp(long var1, CharSequence var3);

    private DateTimeFormatter createFormatter() {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss");
        this.appendFraction(builder);
        builder.optionalStart().appendOffsetId().optionalEnd();
        return builder.toFormatter();
    }

    protected abstract void appendFraction(DateTimeFormatterBuilder var1);

    @Override
    public void append(StringBuilder text, long value) {
        if (value <= 0L) {
            text.append(value);
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(value / this.amountPerSecond, (int)(value % this.amountPerSecond * this.nanosPerAmount), ZoneOffset.UTC);
        if (this.zoneId.equals(UTC)) {
            this.dtf.formatTo(ldt, text);
        } else {
            this.dtf.formatTo(ZonedDateTime.of(ldt, UTC).withZoneSameInstant(this.zoneId), text);
        }
    }
}

