/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Arrays;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.IntConverter;

public class Base85IntConverter
implements IntConverter {
    public static final int MAX_LENGTH = IntConverter.maxParseLength(85);
    public static final Base85IntConverter INSTANCE = new Base85IntConverter();
    private static final String CHARS = "0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz\"#$%&'()*+,-./ ";
    private static final char[] DECODE = "0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz\"#$%&'()*+,-./ ".toCharArray();
    private static final byte[] ENCODE = new byte[128];
    private static final int BASE = 85;

    @Override
    public int maxParseLength() {
        return MAX_LENGTH;
    }

    @Override
    public int parse(CharSequence text) {
        this.lengthCheck(text);
        int v = 0;
        for (int i = 0; i < text.length(); ++i) {
            byte b = ENCODE[text.charAt(i)];
            if (b < 0) continue;
            v = v * 85 + b;
        }
        return v;
    }

    @Override
    public void append(StringBuilder text, int value) {
        int start = text.length();
        for (long value2 = (long)value & 0xFFFFFFFFL; value2 != 0L; value2 /= 85L) {
            int v = (int)(value2 % 85L);
            text.append(DECODE[v]);
        }
        StringUtils.reverse((StringBuilder)text, (int)start);
        if (text.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            text.setLength(start + this.maxParseLength());
        }
    }

    static {
        assert (DECODE.length == 85);
        Arrays.fill(ENCODE, (byte)-1);
        for (int i = 0; i < DECODE.length; ++i) {
            char c = DECODE[i];
            Base85IntConverter.ENCODE[c] = (byte)i;
        }
    }
}

