/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;

public class WireToOutputStream {
    private final Bytes<ByteBuffer> bytes = Bytes.elasticHeapByteBuffer((int)128);
    private final Wire wire;
    private final DataOutputStream dos;

    public WireToOutputStream(WireType wireType, OutputStream os) {
        this.wire = (Wire)wireType.apply(this.bytes);
        this.dos = new DataOutputStream(os);
    }

    public Wire getWire() {
        this.wire.clear();
        return this.wire;
    }

    public void flush() throws IOException {
        int length = Math.toIntExact(this.bytes.readRemaining());
        this.dos.writeInt(length);
        this.dos.write(((ByteBuffer)this.bytes.underlyingObject()).array(), 0, length);
    }
}

