/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.BitSet;
import net.openhft.chronicle.core.Jvm;

class BitSetUtil {
    private static Field wordsField;
    private static Field wordsInUse;
    private static Field sizeIsSticky;

    BitSetUtil() {
    }

    static long getWord(BitSet bs, int index) {
        try {
            long[] longs = (long[])wordsField.get(bs);
            return longs[index];
        }
        catch (IllegalAccessException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    static BitSet set(BitSet using, long[] words) {
        try {
            wordsField.set(using, words);
            wordsInUse.set(using, words.length);
            sizeIsSticky.set(using, false);
            return using;
        }
        catch (IllegalAccessException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    static {
        try {
            wordsField = BitSet.class.getDeclaredField("words");
            wordsInUse = BitSet.class.getDeclaredField("wordsInUse");
            sizeIsSticky = BitSet.class.getDeclaredField("sizeIsSticky");
            Jvm.setAccessible((AccessibleObject)wordsField);
            Jvm.setAccessible((AccessibleObject)wordsInUse);
            Jvm.setAccessible((AccessibleObject)sizeIsSticky);
        }
        catch (Exception e) {
            Jvm.rethrow((Throwable)e);
        }
    }
}

