/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.ref.TextBooleanReference;
import net.openhft.chronicle.bytes.ref.TextIntReference;
import net.openhft.chronicle.bytes.ref.TextLongArrayReference;
import net.openhft.chronicle.bytes.ref.TextLongReference;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.BooleanValue;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.BinaryWriteDocumentContext;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.Comment;
import net.openhft.chronicle.wire.CommentAnnotationNotifier;
import net.openhft.chronicle.wire.DefaultValueIn;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Quotes;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SerializationStrategies;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TextMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.TextReadDocumentContext;
import net.openhft.chronicle.wire.TextWriteDocumentContext;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlKeys;
import net.openhft.chronicle.wire.YamlToken;
import net.openhft.chronicle.wire.YamlTokeniser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlWire
extends AbstractWire
implements Wire {
    public static final BytesStore TYPE = BytesStore.from((CharSequence)"!type ");
    static final String SEQ_MAP = "!seqmap";
    static final String NULL = "!null \"\"";
    static final BitSet STARTS_QUOTE_CHARS = new BitSet();
    static final BitSet QUOTE_CHARS = new BitSet();
    static final BytesStore COMMA_SPACE = BytesStore.from((CharSequence)", ");
    static final BytesStore COMMA_NEW_LINE = BytesStore.from((CharSequence)",\n");
    static final BytesStore NEW_LINE = BytesStore.from((CharSequence)"\n");
    static final BytesStore EMPTY_AFTER_COMMENT = BytesStore.from((CharSequence)"");
    static final BytesStore EMPTY = BytesStore.from((CharSequence)"");
    static final BytesStore SPACE = BytesStore.from((CharSequence)" ");
    static final BytesStore END_FIELD = NEW_LINE;
    static final char[] HEXADECIMAL = "0123456789ABCDEF".toCharArray();
    private final TextValueOut valueOut = this.createValueOut();
    private final TextValueIn valueIn = this.createValueIn();
    private final StringBuilder sb = new StringBuilder();
    private final YamlTokeniser yt;
    private DefaultValueIn defaultValueIn;
    private WriteDocumentContext writeContext;
    private ReadDocumentContext readContext;

    public YamlWire(@NotNull Bytes bytes, boolean use8bit) {
        super(bytes, use8bit);
        this.yt = new YamlTokeniser((BytesIn)bytes);
        this.defaultValueIn = new DefaultValueIn(this);
    }

    public YamlWire(@NotNull Bytes bytes) {
        this(bytes, false);
    }

    @NotNull
    public static YamlWire fromFile(String name) throws IOException {
        return new YamlWire(BytesUtil.readFile((String)name), true);
    }

    @NotNull
    public static YamlWire from(@NotNull String text) {
        return new YamlWire(Bytes.from((String)text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String asText(@NotNull Wire wire) {
        assert (wire.startUse());
        try {
            long pos = wire.bytes().readPosition();
            @NotNull YamlWire tw = new YamlWire((Bytes)NativeBytes.nativeBytes());
            wire.copyTo(tw);
            wire.bytes().readPosition(pos);
            String string = tw.toString();
            return string;
        }
        finally {
            assert (wire.endUse());
        }
    }

    public static <ACS extends Appendable & CharSequence> void unescape(@NotNull ACS sb) {
        int end = 0;
        int length = ((CharSequence)sb).length();
        for (int i = 0; i < length; ++i) {
            int ch = ((CharSequence)sb).charAt(i);
            if (ch == 92 && i < length - 1) {
                char ch3 = ((CharSequence)sb).charAt(++i);
                switch (ch3) {
                    case '0': {
                        ch = 0;
                        break;
                    }
                    case 'a': {
                        ch = 7;
                        break;
                    }
                    case 'b': {
                        ch = 8;
                        break;
                    }
                    case 't': {
                        ch = 9;
                        break;
                    }
                    case 'n': {
                        ch = 10;
                        break;
                    }
                    case 'v': {
                        ch = 11;
                        break;
                    }
                    case 'f': {
                        ch = 12;
                        break;
                    }
                    case 'r': {
                        ch = 13;
                        break;
                    }
                    case 'e': {
                        ch = 27;
                        break;
                    }
                    case 'N': {
                        ch = 133;
                        break;
                    }
                    case '_': {
                        ch = 160;
                        break;
                    }
                    case 'x': {
                        ch = (char)(Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 16 + Character.getNumericValue(((CharSequence)sb).charAt(++i)));
                        break;
                    }
                    case 'u': {
                        ch = (char)(Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 4096 + Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 256 + Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 16 + Character.getNumericValue(((CharSequence)sb).charAt(++i)));
                        break;
                    }
                    default: {
                        ch = ch3;
                    }
                }
            }
            AppendableUtil.setCharAt(sb, (int)end++, (char)ch);
        }
        if (length != ((CharSequence)sb).length()) {
            throw new IllegalStateException("Length changed from " + length + " to " + ((CharSequence)sb).length() + " for " + sb);
        }
        AppendableUtil.setLength(sb, (int)end);
    }

    @Override
    public boolean hintReadInputOrder() {
        return true;
    }

    @Override
    @NotNull
    public <T> T methodWriter(@NotNull Class<T> tClass, Class ... additional) {
        VanillaMethodWriterBuilder<T> builder = new VanillaMethodWriterBuilder<T>(tClass, WireType.YAML, () -> this.newTextMethodWriterInvocationHandler(tClass));
        for (Class aClass : additional) {
            builder.addInterface(aClass);
        }
        builder.marshallableOut(this);
        return builder.build();
    }

    @NotNull
    TextMethodWriterInvocationHandler newTextMethodWriterInvocationHandler(Class ... interfaces) {
        for (Class anInterface : interfaces) {
            Comment c = anInterface.getAnnotation(Comment.class);
            if (c == null) continue;
            this.writeComment(c.value());
        }
        return new TextMethodWriterInvocationHandler(this);
    }

    @Override
    @NotNull
    public <T> MethodWriterBuilder<T> methodWriterBuilder(@NotNull Class<T> tClass) {
        VanillaMethodWriterBuilder<T> builder = new VanillaMethodWriterBuilder<T>(tClass, WireType.YAML, () -> this.newTextMethodWriterInvocationHandler(tClass));
        builder.marshallableOut(this);
        return builder;
    }

    @Override
    public void classLookup(ClassLookup classLookup) {
        this.classLookup = classLookup;
    }

    @Override
    public ClassLookup classLookup() {
        return this.classLookup;
    }

    @Override
    @NotNull
    public DocumentContext writingDocument(boolean metaData) {
        if (this.writeContext == null) {
            this.useBinaryDocuments();
        }
        this.writeContext.start(metaData);
        return this.writeContext;
    }

    @Override
    @NotNull
    public DocumentContext readingDocument() {
        this.initReadContext();
        return this.readContext;
    }

    protected void initReadContext() {
        if (this.readContext == null) {
            this.useBinaryDocuments();
        }
        this.readContext.start();
    }

    @NotNull
    public YamlWire useBinaryDocuments() {
        this.readContext = new BinaryReadDocumentContext(this, false);
        this.writeContext = new BinaryWriteDocumentContext(this);
        return this;
    }

    @NotNull
    public YamlWire useTextDocuments() {
        this.readContext = new TextReadDocumentContext(this);
        this.writeContext = new TextWriteDocumentContext(this);
        return this;
    }

    @Override
    @NotNull
    public DocumentContext readingDocument(long readLocation) {
        long readPosition = this.bytes().readPosition();
        long readLimit = this.bytes().readLimit();
        this.bytes().readPosition(readLocation);
        this.initReadContext();
        this.readContext.closeReadLimit(readLimit);
        this.readContext.closeReadPosition(readPosition);
        return this.readContext;
    }

    @NotNull
    protected TextValueOut createValueOut() {
        return new TextValueOut();
    }

    @NotNull
    protected TextValueIn createValueIn() {
        return new TextValueIn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.bytes.readRemaining() > 0x100000L) {
            long l = this.bytes.readLimit();
            try {
                this.bytes.readLimit(this.bytes.readPosition() + 0x100000L);
                String string = this.bytes.toString() + "..";
                return string;
            }
            finally {
                this.bytes.readLimit(l);
            }
        }
        return this.bytes.toString();
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        if (!(wire instanceof YamlWire)) {
            throw new UnsupportedOperationException("Not implemented yet. Can only copy TextWire format to the same format");
        }
        wire.bytes().write((BytesStore)this.bytes, this.bytes().readPosition(), this.bytes().readLimit());
    }

    @Override
    public long readEventNumber() {
        StringBuilder sb = this.acquireStringBuilder();
        this.readField(sb);
        try {
            return Integer.parseInt(sb.toString());
        }
        catch (NumberFormatException ignored) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.readField(this.acquireStringBuilder());
        switch (this.yt.current()) {
            case NONE: 
            case MAPPING_END: {
                return this.defaultValueIn;
            }
        }
        return this.valueIn;
    }

    @NotNull
    private StringBuilder acquireStringBuilder() {
        StringUtils.setCount((StringBuilder)this.sb, (int)0);
        return this.sb;
    }

    @NotNull
    protected StringBuilder readField(@NotNull StringBuilder sb) {
        this.startEventIfTop();
        sb.setLength(0);
        if (this.yt.current() == YamlToken.MAPPING_KEY) {
            this.yt.next();
            if (this.yt.current() != YamlToken.TEXT) {
                throw new IllegalStateException(this.yt.toString());
            }
        } else {
            return sb;
        }
        sb.append(this.yt.text());
        this.yt.next();
        YamlWire.unescape(sb);
        return sb;
    }

    @Override
    @Nullable
    public <K> K readEvent(@NotNull Class<K> expectedClass) {
        YamlToken next;
        this.startEventIfTop();
        if (this.yt.current() == YamlToken.MAPPING_KEY && (next = this.yt.next()) == YamlToken.TEXT) {
            this.sb.setLength(0);
            this.sb.append(this.yt.text());
            this.yt.next();
            YamlWire.unescape(this.sb);
            return this.toExpected(expectedClass, this.sb);
        }
        throw new UnsupportedOperationException(this.yt.toString());
    }

    @Override
    public boolean isNotEmptyAfterPadding() {
        this.consumePadding();
        switch (this.yt.current()) {
            case NONE: 
            case MAPPING_END: 
            case DOCUMENT_END: 
            case SEQUENCE_END: {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private <K> K toExpected(Class<K> expectedClass, StringBuilder sb) {
        return (K)ObjectUtils.convertTo(expectedClass, (Object)WireInternal.INTERNER.intern((CharSequence)sb));
    }

    @Override
    public void consumePadding() {
        block3: while (true) {
            switch (this.yt.current()) {
                case COMMENT: 
                case DIRECTIVE: 
                case DIRECTIVES_END: {
                    this.yt.next();
                    continue block3;
                }
            }
            break;
        }
    }

    @Override
    @NotNull
    public String readingPeekYaml() {
        return "todo";
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        return this.read(key.name().toString());
    }

    @Override
    @NotNull
    public ValueIn read(String keyName) {
        this.startEventIfTop();
        YamlKeys keys = this.yt.keys();
        int count = keys.count();
        if (count > 0) {
            long pos = this.yt.lastKeyPosition();
            long[] offsets = keys.offsets();
            int contextSize = this.yt.contextSize();
            for (int i = 0; i < count; ++i) {
                this.yt.revertToContext(contextSize);
                YamlToken next = this.yt.rereadAndNext(offsets[i]);
                assert (next == YamlToken.MAPPING_KEY);
                if (!this.checkForMatch(keyName)) continue;
                keys.removeIndex(i);
                return this.valueIn;
            }
            this.yt.revertToContext(contextSize);
            this.bytes.readPosition(pos);
            this.yt.next();
        }
        int minIndent = this.yt.topContext().indent;
        while (this.yt.current() == YamlToken.MAPPING_KEY) {
            long lastKeyPosition = this.yt.lastKeyPosition();
            if (this.checkForMatch(keyName)) {
                return this.valueIn;
            }
            keys.push(lastKeyPosition);
            this.valueIn.consumeAny(minIndent);
        }
        return this.defaultValueIn;
    }

    public String dumpContext() {
        OnHeapBytes b = Bytes.allocateElasticOnHeap((int)128);
        YamlWire yw = new YamlWire((Bytes)b);
        yw.valueOut.list(this.yt.contexts, YamlTokeniser.YTContext.class);
        return b.toString();
    }

    private boolean checkForMatch(@NotNull String keyName) {
        YamlToken next = this.yt.next();
        if (next != YamlToken.TEXT) {
            throw new IllegalStateException(next.toString());
        }
        this.sb.setLength(0);
        this.sb.append(this.yt.text());
        this.yt.next();
        YamlWire.unescape(this.sb);
        return this.sb.length() == 0 || StringUtils.isEqual((StringBuilder)this.sb, (CharSequence)keyName);
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.startEventIfTop();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        this.sb.setLength(0);
        if (this.yt.current() == YamlToken.COMMENT) {
            YamlToken next = this.yt.next();
            this.sb.append(this.yt.text());
        }
        return this;
    }

    @Override
    public void clear() {
        this.yt.reset();
        this.bytes.clear();
        this.valueIn.resetState();
        this.valueOut.resetState();
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    @NotNull
    public ValueOut write() {
        return this.valueOut.write();
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        return this.valueOut.write(key);
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull CharSequence name) {
        return this.valueOut.write(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueOut writeEvent(Class expectedType, Object eventKey) {
        if (eventKey instanceof WireKey) {
            return this.writeEventName((WireKey)eventKey);
        }
        if (eventKey instanceof CharSequence) {
            return this.writeEventName((CharSequence)eventKey);
        }
        boolean wasLeft = this.valueOut.swapLeaf(true);
        try {
            ValueOut valueOut = this.valueOut.write(expectedType, eventKey);
            return valueOut;
        }
        finally {
            this.valueOut.swapLeaf(wasLeft);
        }
    }

    @Override
    @NotNull
    public WireOut dropDefault(boolean dropDefault) {
        this.valueOut.dropDefault = dropDefault;
        return this;
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(@NotNull CharSequence s) {
        this.valueOut.writeComment(s);
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        for (int i = 0; i < paddingToAdd; ++i) {
            this.bytes.writeUnsignedByte((this.bytes.writePosition() & 0x3FL) == 0L ? 10 : 32);
        }
        return this;
    }

    void escape(@NotNull CharSequence s) {
        @NotNull Quotes quotes = this.needsQuotes(s);
        if (quotes == Quotes.NONE) {
            this.escape0(s, quotes);
            return;
        }
        this.bytes.writeUnsignedByte((int)quotes.q);
        this.escape0(s, quotes);
        this.bytes.writeUnsignedByte((int)quotes.q);
    }

    protected void escape0(@NotNull CharSequence s, @NotNull Quotes quotes) {
        block16: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\u0000': {
                    this.bytes.appendUtf8((CharSequence)"\\0");
                    continue block16;
                }
                case '\u0007': {
                    this.bytes.appendUtf8((CharSequence)"\\a");
                    continue block16;
                }
                case '\b': {
                    this.bytes.appendUtf8((CharSequence)"\\b");
                    continue block16;
                }
                case '\t': {
                    this.bytes.appendUtf8((CharSequence)"\\t");
                    continue block16;
                }
                case '\n': {
                    this.bytes.appendUtf8((CharSequence)"\\n");
                    continue block16;
                }
                case '\u000b': {
                    this.bytes.appendUtf8((CharSequence)"\\v");
                    continue block16;
                }
                case '\f': {
                    this.bytes.appendUtf8((CharSequence)"\\f");
                    continue block16;
                }
                case '\r': {
                    this.bytes.appendUtf8((CharSequence)"\\r");
                    continue block16;
                }
                case '\u001b': {
                    this.bytes.appendUtf8((CharSequence)"\\e");
                    continue block16;
                }
                case '\"': {
                    if (ch == quotes.q) {
                        ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte((int)ch);
                        continue block16;
                    }
                    this.bytes.writeUnsignedByte((int)ch);
                    continue block16;
                }
                case '\'': {
                    if (ch == quotes.q) {
                        ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte((int)ch);
                        continue block16;
                    }
                    this.bytes.writeUnsignedByte((int)ch);
                    continue block16;
                }
                case '\\': {
                    ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte((int)ch);
                    continue block16;
                }
                case '\u0085': {
                    this.bytes.appendUtf8((CharSequence)"\\N");
                    continue block16;
                }
                case '\u00a0': {
                    this.bytes.appendUtf8((CharSequence)"\\_");
                    continue block16;
                }
                default: {
                    if (ch > '\u00ff') {
                        this.appendU4(ch);
                        continue block16;
                    }
                    if (ch < ' ' || ch > '\u007f') {
                        this.appendX2(ch);
                        continue block16;
                    }
                    this.bytes.appendUtf8((int)ch);
                }
            }
        }
    }

    private void appendX2(char ch) {
        this.bytes.append('\\');
        this.bytes.append('x');
        this.bytes.append(HEXADECIMAL[ch >> 4 & 0xF]);
        this.bytes.append(HEXADECIMAL[ch & 0xF]);
    }

    private void appendU4(char ch) {
        this.bytes.append('\\');
        this.bytes.append('u');
        this.bytes.append(HEXADECIMAL[ch >> 12]);
        this.bytes.append(HEXADECIMAL[ch >> 8 & 0xF]);
        this.bytes.append(HEXADECIMAL[ch >> 4 & 0xF]);
        this.bytes.append(HEXADECIMAL[ch & 0xF]);
    }

    @NotNull
    protected Quotes needsQuotes(@NotNull CharSequence s) {
        @NotNull Quotes quotes = Quotes.NONE;
        if (s.length() == 0) {
            return Quotes.DOUBLE;
        }
        if (STARTS_QUOTE_CHARS.get(s.charAt(0)) || Character.isWhitespace(s.charAt(s.length() - 1))) {
            return Quotes.DOUBLE;
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (QUOTE_CHARS.get(ch) || ch < ' ' || ch > '\u007f') {
                return Quotes.DOUBLE;
            }
            if (ch != '\"') continue;
            quotes = Quotes.SINGLE;
        }
        return quotes;
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new TextLongReference();
    }

    @Override
    @NotNull
    public BooleanValue newBooleanReference() {
        return new TextBooleanReference();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new TextIntReference();
    }

    @Override
    @NotNull
    public LongArrayValues newLongArrayReference() {
        return new TextLongArrayReference();
    }

    public void append(@NotNull CharSequence cs) {
        if (this.use8bit) {
            this.bytes.append8bit(cs);
        } else {
            this.bytes.appendUtf8(cs);
        }
    }

    public void append(@NotNull CharSequence cs, int offset, int length) {
        if (this.use8bit) {
            this.bytes.append8bit(cs, offset, offset + length);
        } else {
            this.bytes.appendUtf8(cs, offset, length);
        }
    }

    private <T> void readCollection(Class<T> elementType, Collection<T> collection) {
        if (this.yt.current() == YamlToken.SEQUENCE_START) {
            while (this.yt.next() == YamlToken.SEQUENCE_ENTRY) {
                if (this.yt.next() == YamlToken.TEXT) {
                    collection.add(ObjectUtils.convertTo(elementType, (Object)this.yt.text()));
                    continue;
                }
                throw new UnsupportedOperationException(this.yt.toString());
            }
        } else {
            throw new UnsupportedOperationException(this.yt.toString());
        }
    }

    @NotNull
    private Map readMap(Class valueType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.yt.current() == YamlToken.MAPPING_START) {
            while (this.yt.next() == YamlToken.MAPPING_KEY) {
                if (this.yt.next() == YamlToken.TEXT) {
                    String key = this.yt.text();
                    if (this.yt.next() != YamlToken.TEXT) {
                        throw new UnsupportedOperationException(this.yt.toString());
                    }
                    Object o = ObjectUtils.convertTo((Class)valueType, (Object)this.yt.text());
                    map.put(key, o);
                    continue;
                }
                throw new UnsupportedOperationException(this.yt.toString());
            }
        } else {
            throw new UnsupportedOperationException(this.yt.toString());
        }
        return map;
    }

    private void writeObject(Object o, int indentation) {
        this.writeTwo('-', ' ');
        this.indentation(indentation - 2);
        this.valueOut.object(o);
    }

    private void indentation(int indentation) {
        while (indentation-- > 0) {
            this.bytes.writeUnsignedByte(32);
        }
    }

    @Override
    public void writeStartEvent() {
        this.valueOut.prependSeparator();
        this.writeTwo('?', ' ');
    }

    @Override
    public void writeEndEvent() {
        this.valueOut.endEvent();
    }

    void writeTwo(char ch1, char ch2) {
        this.bytes.writeUnsignedByte((int)ch1);
        this.bytes.writeUnsignedByte((int)ch2);
    }

    @Override
    public void startEvent() {
        this.consumePadding();
        if (this.yt.current() == YamlToken.MAPPING_START) {
            this.yt.next(Integer.MAX_VALUE);
            return;
        }
        throw new UnsupportedOperationException(this.yt.toString());
    }

    void startEventIfTop() {
        this.consumePadding();
        if (this.yt.contextSize() == 3 && this.yt.current() == YamlToken.MAPPING_START) {
            this.yt.next();
        }
    }

    @Override
    public boolean isEndEvent() {
        this.consumePadding();
        return this.yt.current() == YamlToken.MAPPING_END;
    }

    @Override
    public void endEvent() {
        int minIndent = this.yt.topContext().indent;
        switch (this.yt.current()) {
            case NONE: 
            case MAPPING_END: 
            case DOCUMENT_END: 
            case MAPPING_KEY: {
                break;
            }
            case SEQUENCE_END: {
                this.yt.next();
                break;
            }
            default: {
                this.valueIn.consumeAny(minIndent);
            }
        }
        if (this.yt.current() == YamlToken.NONE) {
            this.yt.next(Integer.MIN_VALUE);
        } else {
            while (this.yt.current() == YamlToken.MAPPING_KEY) {
                this.yt.next();
                this.valueIn.consumeAny(minIndent);
            }
        }
        if (this.yt.current() == YamlToken.MAPPING_END) {
            this.yt.next(Integer.MIN_VALUE);
            return;
        }
        throw new UnsupportedOperationException(this.yt.toString());
    }

    public void reset() {
        this.bytes.readPosition(0L);
        this.yt.reset();
    }

    static {
        AbstractReferenceCounted.unmonitor((ReferenceCounted)TYPE);
        for (char ch : "?%&@`0123456789+- ',#:{}[]|>!\\".toCharArray()) {
            STARTS_QUOTE_CHARS.set(ch);
        }
        for (char ch : "?,#:{}[]|>\\".toCharArray()) {
            QUOTE_CHARS.set(ch);
        }
        WireInternal.INTERNER.valueCount();
    }

    class TextValueIn
    implements ValueIn {
        TextValueIn() {
        }

        @Override
        public void resetState() {
            YamlWire.this.yt.reset();
        }

        @Override
        @Nullable
        public String text() {
            @Nullable StringBuilder cs = this.textTo0(YamlWire.this.acquireStringBuilder());
            return cs == null ? null : WireInternal.INTERNER.intern((CharSequence)cs);
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            sb.setLength(0);
            @Nullable StringBuilder cs = this.textTo0(sb);
            if (cs == null) {
                return null;
            }
            if (cs != sb) {
                sb.setLength(0);
                sb.append((CharSequence)cs);
            }
            return sb;
        }

        @Override
        @Nullable
        public Bytes textTo(@NotNull Bytes bytes) {
            bytes.clear();
            if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            bytes.clear();
            bytes.append((CharSequence)YamlWire.this.yt.text());
            YamlWire.this.yt.next();
            return bytes;
        }

        @Override
        @NotNull
        public BracketType getBracketType() {
            switch (YamlWire.this.yt.current()) {
                default: {
                    throw new UnsupportedOperationException(YamlWire.this.yt.toString());
                }
                case MAPPING_START: {
                    return BracketType.MAP;
                }
                case SEQUENCE_START: {
                    return BracketType.SEQ;
                }
                case MAPPING_KEY: 
                case SEQUENCE_ENTRY: 
                case STREAM_START: 
                case TEXT: 
            }
            return BracketType.NONE;
        }

        @Nullable
        Bytes textTo0(@NotNull Bytes a) {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            a.append((CharSequence)YamlWire.this.yt.text());
            return a;
        }

        @Nullable
        StringBuilder textTo0(@NotNull StringBuilder a) {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_ENTRY) {
                YamlWire.this.yt.next();
            }
            if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                a.append(YamlWire.this.yt.text());
                YamlWire.unescape(a);
                YamlWire.this.yt.next();
            } else if (YamlWire.this.yt.current() == YamlToken.TAG) {
                if (YamlWire.this.yt.isText("!null")) {
                    YamlWire.this.yt.next();
                    YamlWire.this.yt.next();
                    return null;
                }
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            return a;
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, BooleanConsumer consumer) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut toBytes) {
            toBytes.clear();
            return this.bytes(b -> toBytes.write((BytesStore)b));
        }

        @Override
        @Nullable
        public WireIn bytesSet(@NotNull PointerBytesStore toBytes) {
            return this.bytes(bytes -> {
                long capacity = bytes.readRemaining();
                VanillaBytes bytes2 = Bytes.allocateDirect((long)capacity);
                bytes2.write((BytesStore)bytes);
                toBytes.set(bytes2.addressForRead(bytes2.start()), capacity);
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadBytesMarshallable bytesConsumer) {
            YamlWire.this.consumePadding();
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            if (YamlWire.this.yt.current() == YamlToken.TAG) {
                YamlWire.this.bytes.readSkip(1L);
                YamlWire.this.yt.text(sb);
                YamlWire.this.yt.next();
                if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                    throw new UnsupportedOperationException(YamlWire.this.yt.toString());
                }
                @Nullable byte[] uncompressed = Compression.uncompress((CharSequence)sb, (Object)YamlWire.this.yt, t -> {
                    @NotNull StringBuilder sb2 = YamlWire.this.acquireStringBuilder();
                    t.text(sb2);
                    return Base64.getDecoder().decode(sb2.toString());
                });
                if (uncompressed != null) {
                    Bytes bytes = Bytes.wrapForRead((byte[])uncompressed);
                    bytesConsumer.readMarshallable((BytesIn)bytes);
                    bytes.releaseLast();
                    return YamlWire.this;
                } else {
                    if (!StringUtils.isEqual((StringBuilder)sb, (CharSequence)"!null")) throw new IORuntimeException("Unsupported type=" + sb);
                    bytesConsumer.readMarshallable(null);
                    YamlWire.this.yt.next();
                }
                return YamlWire.this;
            } else {
                this.textTo(sb);
                Bytes bytes = Bytes.wrapForRead((byte[])sb.toString().getBytes(StandardCharsets.ISO_8859_1));
                bytesConsumer.readMarshallable((BytesIn)bytes);
                bytes.releaseLast();
            }
            return YamlWire.this;
        }

        @Override
        @Nullable
        public byte[] bytes() {
            YamlWire.this.consumePadding();
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return YamlWire.this;
        }

        @Override
        public long readLength() {
            return this.readLengthMarshallable();
        }

        @Override
        @NotNull
        public WireIn skipValue() {
            this.consumeAny(((YamlWire)YamlWire.this).yt.topContext().indent);
            return YamlWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long readLengthMarshallable() {
            long start = YamlWire.this.bytes.readPosition();
            try {
                this.consumeAny(((YamlWire)YamlWire.this).yt.topContext().indent);
                long l = YamlWire.this.bytes.readPosition() - start;
                return l;
            }
            finally {
                YamlWire.this.bytes.readPosition(start);
            }
        }

        protected void consumeAny(int minIndent) {
            YamlWire.this.consumePadding();
            int indent2 = Math.max(((YamlWire)YamlWire.this).yt.topContext().indent, minIndent);
            switch (YamlWire.this.yt.current()) {
                case SEQUENCE_ENTRY: 
                case TAG: {
                    YamlWire.this.yt.next(minIndent);
                    this.consumeAny(minIndent);
                    break;
                }
                case MAPPING_START: {
                    this.consumeMap(indent2);
                    break;
                }
                case SEQUENCE_START: {
                    this.consumeSeq(indent2);
                    break;
                }
                case MAPPING_KEY: {
                    YamlWire.this.yt.next(minIndent);
                    this.consumeAny(minIndent);
                    if (YamlWire.this.yt.current() == YamlToken.MAPPING_KEY || YamlWire.this.yt.current() == YamlToken.MAPPING_END) break;
                    this.consumeAny(minIndent);
                    break;
                }
                case MAPPING_END: 
                case SEQUENCE_END: {
                    YamlWire.this.yt.next(minIndent);
                    break;
                }
                case TEXT: {
                    YamlWire.this.yt.next(minIndent);
                    break;
                }
                case DOCUMENT_END: 
                case STREAM_START: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(YamlWire.this.yt.toString());
                }
            }
        }

        private void consumeSeq(int minIndent) {
            assert (YamlWire.this.yt.current() == YamlToken.SEQUENCE_START);
            YamlWire.this.yt.next(minIndent);
            block4: while (true) {
                switch (YamlWire.this.yt.current()) {
                    case SEQUENCE_ENTRY: {
                        YamlWire.this.yt.next(minIndent);
                        this.consumeAny(minIndent);
                        continue block4;
                    }
                    case SEQUENCE_END: {
                        YamlWire.this.yt.next(minIndent);
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException(YamlWire.this.yt.toString());
        }

        private void consumeMap(int minIndent) {
            YamlWire.this.yt.next(minIndent);
            while (YamlWire.this.yt.current() == YamlToken.MAPPING_KEY) {
                YamlWire.this.yt.next(minIndent);
                this.consumeAny(minIndent);
                this.consumeAny(minIndent);
            }
            if (YamlWire.this.yt.current() == YamlToken.NONE) {
                YamlWire.this.yt.next(Integer.MIN_VALUE);
            }
            if (YamlWire.this.yt.current() == YamlToken.MAPPING_END) {
                YamlWire.this.yt.next(minIndent);
            }
        }

        @Override
        @NotNull
        public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> tFlag) {
            YamlWire.this.consumePadding();
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            if (this.textTo(sb) == null) {
                tFlag.accept(t, null);
                return YamlWire.this;
            }
            Boolean flag = sb.length() == 0 ? null : Boolean.valueOf(StringUtils.isEqual((StringBuilder)sb, (CharSequence)"true"));
            tFlag.accept(t, flag);
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
            YamlWire.this.consumePadding();
            tb.accept(t, (byte)this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            YamlWire.this.consumePadding();
            ti.accept(t, (short)this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            YamlWire.this.consumePadding();
            ti.accept(t, (short)this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            YamlWire.this.consumePadding();
            ti.accept(t, (int)this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            YamlWire.this.consumePadding();
            ti.accept(t, (int)this.getALong());
            return YamlWire.this;
        }

        long getALong() {
            if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                String text = YamlWire.this.yt.text();
                long l = text.startsWith("0x") || text.startsWith("0X") ? Long.parseLong(text.substring(2), 16) : Long.parseLong(text);
                YamlWire.this.yt.next();
                return l;
            }
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            YamlWire.this.consumePadding();
            tl.accept(t, this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            YamlWire.this.consumePadding();
            tl.accept(t, this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
            YamlWire.this.consumePadding();
            tf.accept(t, (float)this.getADouble());
            return YamlWire.this;
        }

        public double getADouble() {
            if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                double v = Double.parseDouble(YamlWire.this.yt.text());
                YamlWire.this.yt.next();
                return v;
            }
            throw new UnsupportedOperationException("yt:" + (Object)((Object)YamlWire.this.yt.current()));
        }

        @Override
        @NotNull
        public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
            YamlWire.this.consumePadding();
            td.accept(t, this.getADouble());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
            YamlWire.this.consumePadding();
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            this.textTo(sb);
            setLocalTime.accept(t, LocalTime.parse(WireInternal.INTERNER.intern((CharSequence)sb)));
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
            YamlWire.this.consumePadding();
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            this.textTo(sb);
            tZonedDateTime.accept(t, ZonedDateTime.parse(WireInternal.INTERNER.intern((CharSequence)sb)));
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
            YamlWire.this.consumePadding();
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            this.textTo(sb);
            tLocalDate.accept(t, LocalDate.parse(WireInternal.INTERNER.intern((CharSequence)sb)));
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
            YamlWire.this.consumePadding();
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            this.textTo(sb);
            tuuid.accept(t, UUID.fromString(WireInternal.INTERNER.intern((CharSequence)sb)));
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
            YamlWire.this.consumePadding();
            if (!(values instanceof TextLongArrayReference)) {
                values = new TextLongArrayReference();
                setter.accept(t, values);
            }
            @NotNull Byteable b = (Byteable)values;
            long length = TextLongArrayReference.peakLength((BytesStore)YamlWire.this.bytes, (long)YamlWire.this.bytes.readPosition());
            b.bytesStore((BytesStore)YamlWire.this.bytes, YamlWire.this.bytes.readPosition(), length);
            YamlWire.this.bytes.readSkip(length);
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(@Nullable LongValue value) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public WireIn int32(@NotNull IntValue value) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        public WireIn bool(@NotNull BooleanValue value) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
            if (!(value instanceof TextLongReference)) {
                value = new TextLongReference();
                setter.accept(t, value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public <T> boolean sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_START) {
                int minIndent = ((YamlWire)YamlWire.this).yt.secondTopContext().indent;
                YamlWire.this.yt.next(Integer.MAX_VALUE);
                tReader.accept(t, YamlWire.this.valueIn);
                if (YamlWire.this.yt.current() == YamlToken.NONE) {
                    YamlWire.this.yt.next(minIndent);
                }
                if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_END) {
                    YamlWire.this.yt.next(minIndent);
                }
            } else if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                tReader.accept(t, YamlWire.this.valueIn);
            } else {
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            return true;
        }

        @Override
        public <T> boolean sequence(List<T> list, @NotNull List<T> buffer, Supplier<T> bufferAdd, ValueIn.Reader reader0) {
            return this.sequence(list, buffer, bufferAdd);
        }

        @Override
        public <T> boolean sequence(@NotNull List<T> list, @NotNull List<T> buffer, @NotNull Supplier<T> bufferAdd) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public <T, K> WireIn sequence(@NotNull T t, K kls, @NotNull TriConsumer<T, K, ValueIn> tReader) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        public boolean hasNext() {
            YamlWire.this.consumePadding();
            switch (YamlWire.this.yt.current()) {
                case NONE: 
                case MAPPING_END: 
                case DOCUMENT_END: 
                case SEQUENCE_END: 
                case STREAM_END: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean hasNextSequenceItem() {
            switch (YamlWire.this.yt.current()) {
                case SEQUENCE_ENTRY: 
                case TEXT: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.TAG) {
                ts.accept(t, YamlWire.this.yt.text());
                YamlWire.this.yt.next();
            } else {
                ts.accept(t, "java.lang.Object");
            }
            return this;
        }

        @Override
        public Class typePrefix() {
            if (YamlWire.this.yt.current() != YamlToken.TAG) {
                return null;
            }
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            YamlWire.this.yt.text(sb);
            try {
                YamlWire.this.yt.next();
                return YamlWire.this.classLookup().forName((CharSequence)sb);
            }
            catch (ClassNotFoundException e) {
                Jvm.warn().on(this.getClass(), "Unable to find " + sb + " " + e);
                return null;
            }
        }

        @Override
        public Object typePrefixOrObject(Class tClass) {
            YamlWire.this.consumePadding();
            switch (YamlWire.this.yt.current()) {
                case TAG: {
                    Class type = this.typePrefix();
                    return type;
                }
            }
            return null;
        }

        @Override
        public boolean isTyped() {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @NotNull
        String stringForCode(int code) {
            return code < 0 ? "Unexpected end of input" : "'" + (char)code + "'";
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) throws IORuntimeException, BufferUnderflowException {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        public Type typeLiteral(BiFunction<CharSequence, ClassNotFoundException, Type> unresolvedHandler) {
            if (YamlWire.this.yt.current() == YamlToken.TAG && YamlWire.this.yt.text().equals("type") && YamlWire.this.yt.next() == YamlToken.TEXT) {
                Class aClass = ClassAliasPool.CLASS_ALIASES.forName((CharSequence)YamlWire.this.yt.text());
                YamlWire.this.yt.next();
                return aClass;
            }
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @Nullable
        public Object marshallable(@NotNull Object object, @NotNull SerializationStrategy strategy) throws BufferUnderflowException, IORuntimeException {
            if (this.isNull()) {
                this.consumeAny(((YamlWire)YamlWire.this).yt.topContext().indent);
                return null;
            }
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_ENTRY) {
                YamlWire.this.yt.next();
                YamlWire.this.consumePadding();
            }
            switch (YamlWire.this.yt.current()) {
                case TAG: {
                    this.typePrefix(null, (o, x) -> {});
                    break;
                }
                case SEQUENCE_START: {
                    Jvm.warn().on(this.getClass(), "Expected a {} but was blank for type " + object.getClass());
                    this.consumeAny(((YamlWire)YamlWire.this).yt.secondTopContext().indent);
                    return object;
                }
                case MAPPING_START: {
                    this.wireIn().startEvent();
                    object = strategy.readUsing(object, this);
                    try {
                        this.wireIn().endEvent();
                    }
                    catch (UnsupportedOperationException uoe) {
                        throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (Object)((Object)YamlWire.this.yt.current()) + "', bytes=" + Bytes.toString((Bytes)YamlWire.this.bytes, (long)1024L));
                    }
                    return object;
                }
            }
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Demarshallable demarshallable(@NotNull Class clazz) {
            Object object;
            YamlWire.this.consumePadding();
            switch (YamlWire.this.yt.current()) {
                case TAG: {
                    YamlWire.this.yt.next();
                }
                case MAPPING_START: {
                    break;
                }
                default: {
                    throw new IORuntimeException("Unsupported type " + (Object)((Object)YamlWire.this.yt.current()));
                }
            }
            long len = this.readLengthMarshallable();
            long limit = YamlWire.this.bytes.readLimit();
            long position = YamlWire.this.bytes.readPosition();
            long newLimit = position - 1L + len;
            try {
                YamlWire.this.bytes.readLimit(newLimit);
                YamlWire.this.bytes.readSkip(1L);
                YamlWire.this.consumePadding();
                object = Demarshallable.newInstance(clazz, YamlWire.this);
            }
            finally {
                YamlWire.this.bytes.readLimit(limit);
                YamlWire.this.bytes.readPosition(newLimit);
            }
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() != YamlToken.MAPPING_END) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (Object)((Object)YamlWire.this.yt.current()) + "', bytes=" + Bytes.toString((Bytes)YamlWire.this.bytes, (long)1024L));
            }
            YamlWire.this.yt.next();
            return object;
        }

        @Override
        @Nullable
        public <T> T typedMarshallable() {
            return (T)this.objectWithInferredType(null, SerializationStrategies.ANY_NESTED, null);
        }

        @Override
        @Nullable
        public <K, V> Map<K, V> map(@NotNull Class<K> kClass, @NotNull Class<V> vClass, @Nullable Map<K, V> usingMap) {
            YamlWire.this.consumePadding();
            if (usingMap == null) {
                usingMap = new LinkedHashMap();
            } else {
                usingMap.clear();
            }
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            switch (YamlWire.this.yt.current()) {
                case TAG: {
                    return this.typedMap(kClass, vClass, usingMap, sb);
                }
                case MAPPING_START: {
                    return this.marshallableAsMap(kClass, vClass, usingMap);
                }
                case SEQUENCE_START: {
                    return YamlWire.this.readAllAsMap(kClass, vClass, usingMap);
                }
            }
            throw new IORuntimeException("Unexpected code " + (Object)((Object)YamlWire.this.yt.current()));
        }

        @Nullable
        private <K, V> Map<K, V> typedMap(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap, @NotNull StringBuilder sb) {
            YamlWire.this.yt.text(sb);
            YamlWire.this.yt.next();
            if ("!null".contentEquals(sb)) {
                this.text();
                return null;
            }
            if (YamlWire.SEQ_MAP.contentEquals(sb)) {
                YamlWire.this.consumePadding();
                if (YamlWire.this.yt.current() != YamlToken.SEQUENCE_START) {
                    throw new IORuntimeException("Unsupported start of sequence : " + (Object)((Object)YamlWire.this.yt.current()));
                }
                do {
                    this.marshallable((WireIn r) -> {
                        @Nullable E k = r.read(() -> "key").object(kClazz);
                        @Nullable E v = r.read(() -> "value").object(vClass);
                        usingMap.put(k, v);
                    });
                } while (this.hasNextSequenceItem());
                return usingMap;
            }
            throw new IORuntimeException("Unsupported type :" + sb);
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            YamlWire.this.consumePadding();
            usingMap.clear();
            if (YamlWire.this.yt.current() != YamlToken.TAG) {
                YamlWire.this.yt.text(YamlWire.this.sb);
                YamlWire.this.yt.next();
                if (YamlWire.SEQ_MAP.contentEquals(YamlWire.this.sb)) {
                    while (this.hasNext()) {
                        this.sequence(this, (T o, ValueIn s) -> s.marshallable((WireIn r) -> {
                            try {
                                @Nullable ReadMarshallable k = (ReadMarshallable)r.read(() -> "key").typedMarshallable();
                                @Nullable ReadMarshallable v = (ReadMarshallable)r.read(() -> "value").typedMarshallable();
                                usingMap.put(k, v);
                            }
                            catch (Exception e) {
                                Jvm.warn().on(this.getClass(), (Throwable)e);
                            }
                        }));
                    }
                } else {
                    throw new IORuntimeException("Unsupported type " + YamlWire.this.sb);
                }
            }
        }

        @Override
        public boolean bool() {
            YamlWire.this.consumePadding();
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            if (this.textTo(sb) == null) {
                throw new NullPointerException("value is null");
            }
            if (ObjectUtils.isTrue((CharSequence)sb)) {
                return true;
            }
            if (ObjectUtils.isFalse((CharSequence)sb)) {
                return false;
            }
            Jvm.debug().on(this.getClass(), "Unable to parse '" + sb + "' as a boolean flag, assuming false");
            return false;
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public int uint16() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < 0L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/ZERO");
            }
            return (int)l;
        }

        @Override
        public long int64() {
            YamlWire.this.consumePadding();
            YamlWire.this.valueIn.skipType();
            if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                Jvm.warn().on(this.getClass(), "Unable to read " + YamlWire.this.valueIn.object() + " as a long.");
                return 0L;
            }
            return this.getALong();
        }

        @Override
        public double float64() {
            YamlWire.this.consumePadding();
            YamlWire.this.valueIn.skipType();
            if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                Jvm.warn().on(this.getClass(), "Unable to read " + YamlWire.this.valueIn.object() + " as a long.");
                return 0.0;
            }
            return this.getADouble();
        }

        void skipType() {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.TAG) {
                YamlWire.this.yt.next();
                YamlWire.this.consumePadding();
            }
        }

        @Override
        public float float32() {
            double d = this.float64();
            if ((double)((float)d) != d) {
                throw new IllegalStateException("value=" + d + " can not be represented as a float");
            }
            return (float)d;
        }

        @Override
        public boolean isNull() {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.TAG && YamlWire.this.yt.isText("!null")) {
                this.consumeAny(0);
                return true;
            }
            return false;
        }

        @Override
        public Object objectWithInferredType(Object using, @NotNull SerializationStrategy strategy, Class type) {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_ENTRY) {
                YamlWire.this.yt.next();
            }
            @Nullable Object o = this.objectWithInferredType0(using, strategy, type);
            YamlWire.this.consumePadding();
            return o;
        }

        @Nullable
        Object objectWithInferredType0(Object using, @NotNull SerializationStrategy strategy, Class type) {
            if (YamlWire.this.yt.current() == YamlToken.TAG) {
                Class aClass = this.typePrefix();
                if (type == null || type == Object.class || type.isInterface()) {
                    type = aClass;
                }
            }
            switch (YamlWire.this.yt.current()) {
                case MAPPING_START: {
                    if (type != null) {
                        if (type == SortedMap.class && !(using instanceof SortedMap)) {
                            using = new TreeMap();
                        }
                        if (type == Object.class || Map.class.isAssignableFrom(type) || using instanceof Map) {
                            return this.map(Object.class, Object.class, using);
                        }
                    }
                    return YamlWire.this.valueIn.object(using, type);
                }
                case SEQUENCE_START: {
                    return this.readSequence(type);
                }
                case TEXT: {
                    Object o = YamlWire.this.valueIn.readNumberOrText();
                    return ObjectUtils.convertTo((Class)type, (Object)o);
                }
            }
            throw new UnsupportedOperationException("Cannot determine what to do with " + (Object)((Object)YamlWire.this.yt.current()));
        }

        @Nullable
        protected Object readNumberOrText() {
            char bq = YamlWire.this.yt.blockQuote();
            @Nullable String s = this.text();
            if (s == null || bq != '\u0000' || s.length() < 1 || s.length() > 40 || "0123456789.+-".indexOf(s.charAt(0)) < 0) {
                return s;
            }
            String ss = s;
            if (s.indexOf(95) >= 0) {
                ss = s.replace("_", "");
            }
            try {
                return Long.decode(ss);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.parseDouble(ss);
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        if (s.length() == 7 && s.charAt(1) == ':') {
                            return LocalTime.parse('0' + s);
                        }
                        if (s.length() == 8 && s.charAt(2) == ':') {
                            return LocalTime.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    try {
                        if (s.length() == 10) {
                            return LocalDate.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    try {
                        if (s.length() >= 22) {
                            return ZonedDateTime.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    return s;
                }
            }
        }

        @NotNull
        private Object readSequence(@NotNull Class clazz) {
            @NotNull TreeSet<E> coll = clazz == SortedSet.class ? new TreeSet() : (clazz == Set.class ? new LinkedHashSet() : new ArrayList());
            this.readCollection(coll);
            if (clazz.isArray()) {
                Object o = Array.newInstance(clazz.getComponentType(), coll.size());
                if (clazz.getComponentType().isPrimitive()) {
                    Iterator iter = coll.iterator();
                    for (int i = 0; i < coll.size(); ++i) {
                        Array.set(o, i, iter.next());
                    }
                    return o;
                }
                return coll.toArray((Object[])o);
            }
            return coll;
        }

        private void readCollection(Collection list) {
            this.sequence(list, (T l, ValueIn v) -> {
                while (v.hasNextSequenceItem()) {
                    l.add(v.object());
                }
            });
        }

        public String toString() {
            return YamlWire.this.toString();
        }
    }

    class TextValueOut
    implements ValueOut,
    CommentAnnotationNotifier {
        protected boolean hasCommentAnnotation = false;
        protected int indentation = 0;
        @NotNull
        protected List<BytesStore> seps = new ArrayList<BytesStore>(4);
        @NotNull
        protected BytesStore sep = BytesStore.empty();
        protected boolean leaf = false;
        protected boolean dropDefault = false;
        @Nullable
        private String eventName;

        TextValueOut() {
        }

        @Override
        public void hasPrecedingComment(boolean hasCommentAnnotation) {
            this.hasCommentAnnotation = hasCommentAnnotation;
        }

        @Override
        public void resetState() {
            this.indentation = 0;
            this.seps.clear();
            this.sep = BytesStore.empty();
            this.leaf = false;
            this.dropDefault = false;
            this.eventName = null;
            YamlWire.this.yt.reset();
        }

        void prependSeparator() {
            YamlWire.this.append((CharSequence)this.sep);
            if (this.sep.endsWith('\n') || this.sep == EMPTY_AFTER_COMMENT) {
                this.indent();
            }
            this.sep = BytesStore.empty();
        }

        @Override
        @NotNull
        public boolean swapLeaf(boolean isLeaf) {
            if (isLeaf == this.leaf) {
                return this.leaf;
            }
            this.leaf = isLeaf;
            if (!isLeaf && this.sep.startsWith(',')) {
                this.elementSeparator();
            }
            return !this.leaf;
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return YamlWire.this;
        }

        private void indent() {
            for (int i = 0; i < this.indentation; ++i) {
                YamlWire.this.bytes.writeUnsignedShort(8224);
            }
        }

        public void elementSeparator() {
            if (this.indentation == 0) {
                if (this.leaf) {
                    this.sep = COMMA_SPACE;
                } else {
                    this.sep = BytesStore.empty();
                    YamlWire.this.bytes.writeUnsignedByte(10);
                }
            } else {
                this.sep = this.leaf ? COMMA_SPACE : COMMA_NEW_LINE;
            }
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            if (this.dropDefault) {
                if (flag == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.append(flag == null ? this.nullOut() : (flag != false ? "true" : "false"));
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public String nullOut() {
            return "!!null \"\"";
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            if (this.dropDefault) {
                if (s == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            if (s == null) {
                YamlWire.this.append(this.nullOut());
            } else {
                YamlWire.this.escape(s);
            }
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore fromBytes) {
            if (this.dropDefault) {
                if (fromBytes == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            if (this.isText(fromBytes)) {
                return this.text(fromBytes);
            }
            int length = Maths.toInt32((long)fromBytes.readRemaining());
            @NotNull byte[] byteArray = new byte[length];
            fromBytes.copyTo(byteArray);
            return this.bytes(byteArray);
        }

        @Override
        @NotNull
        public WireOut rawBytes(@NotNull byte[] value) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.bytes.write(value);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut rawText(CharSequence value) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.bytes.write(value);
            this.elementSeparator();
            return this.wireOut();
        }

        private boolean isText(@Nullable BytesStore fromBytes) {
            if (fromBytes == null) {
                return true;
            }
            for (long i = fromBytes.readPosition(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch < 127) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public ValueOut writeLength(long remaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut bytes(byte[] byteArray) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            return this.bytes("!binary", byteArray);
        }

        @Override
        @NotNull
        public WireOut bytes(@NotNull String type, byte[] byteArray) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            this.typePrefix(type);
            YamlWire.this.append(Base64.getEncoder().encodeToString(byteArray));
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@NotNull String type, @NotNull BytesStore bytesStore) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            this.typePrefix(type);
            YamlWire.this.append(Base64.getEncoder().encodeToString(bytesStore.toByteArray()));
            YamlWire.this.append((CharSequence)END_FIELD);
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            if (this.dropDefault) {
                if (i8 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.bytes.append((int)i8);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            if (this.dropDefault) {
                if (u8 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.bytes.append(u8);
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            if (this.dropDefault) {
                if (i16 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.bytes.append((int)i16);
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            if (this.dropDefault) {
                if (u16 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.bytes.append(u16);
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            if (this.dropDefault) {
                if (codepoint == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            sb.appendCodePoint(codepoint);
            this.text(sb);
            this.sep = BytesStore.empty();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            if (this.dropDefault) {
                if (i32 == 0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.bytes.append(i32);
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            if (this.dropDefault) {
                if (u32 == 0L) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.bytes.append(u32);
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            if (this.dropDefault) {
                if (i64 == 0L) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.bytes.append(i64);
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut int128forBinding(long i64x0, long i64x1, TwoLongValue longValue) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public WireOut int64_0x(long i64) {
            if (this.dropDefault) {
                if (i64 == 0L) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            ((Bytes)((Bytes)YamlWire.this.bytes.writeUnsignedByte(48)).writeUnsignedByte(120)).appendBase16(i64);
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            TextLongArrayReference.write((Bytes)YamlWire.this.bytes, (long)capacity);
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, @NotNull LongArrayValues values) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            long pos = YamlWire.this.bytes.writePosition();
            TextLongArrayReference.write((Bytes)YamlWire.this.bytes, (long)capacity);
            ((Byteable)values).bytesStore((BytesStore)YamlWire.this.bytes, pos, YamlWire.this.bytes.writePosition() - pos);
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            if (this.dropDefault) {
                if (f == 0.0f) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            double af = Math.abs(f);
            if (af >= 0.001 && af < 1000000.0) {
                YamlWire.this.bytes.append(f);
            } else {
                YamlWire.this.bytes.append((CharSequence)this.floatToString(f));
            }
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            if (this.dropDefault) {
                if (d == 0.0) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            double ad = Math.abs(d);
            if (ad >= 1.0E-7 && ad < 1.0E15) {
                if ((double)((int)(ad / 1000000.0)) * 1000000.0 == ad) {
                    ((Bytes)YamlWire.this.bytes.append((int)(d / 1000000.0))).append((CharSequence)"E6");
                } else if ((double)((int)(ad / 1000.0)) * 1000.0 == ad) {
                    ((Bytes)YamlWire.this.bytes.append((int)(d / 1000.0))).append((CharSequence)"E3");
                } else if (ad < 0.001) {
                    double d7 = (double)Math.round(d * 1.0E16) / 1.0E9;
                    double ad7 = Math.abs(d7);
                    if (ad7 < 10.0) {
                        ((Bytes)YamlWire.this.bytes.append(d7)).append((CharSequence)"E-7");
                    } else if (ad7 < 100.0) {
                        ((Bytes)YamlWire.this.bytes.append(d7 / 10.0)).append((CharSequence)"E-6");
                    } else if (ad7 < 1000.0) {
                        ((Bytes)YamlWire.this.bytes.append(d7 / 100.0)).append((CharSequence)"E-5");
                    } else if (ad7 < 10000.0) {
                        ((Bytes)YamlWire.this.bytes.append(d7 / 1000.0)).append((CharSequence)"E-4");
                    } else {
                        ((Bytes)YamlWire.this.bytes.append(d7 / 10000.0)).append((CharSequence)"E-3");
                    }
                } else {
                    YamlWire.this.bytes.append(d);
                }
            } else {
                YamlWire.this.bytes.append((CharSequence)this.doubleToString(d));
            }
            this.elementSeparator();
            return YamlWire.this;
        }

        protected String doubleToString(double d) {
            return Double.toString(d);
        }

        protected String floatToString(float f) {
            return Float.toString(f);
        }

        @Override
        @NotNull
        public WireOut time(LocalTime localTime) {
            return this.asText(localTime);
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@Nullable ZonedDateTime zonedDateTime) {
            String s;
            if (this.dropDefault) {
                if (zonedDateTime == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            return (s = zonedDateTime.toString()).endsWith("]") ? this.text(s) : this.asText(s);
        }

        @Override
        @NotNull
        public WireOut date(LocalDate localDate) {
            return this.asText(localDate);
        }

        @Override
        @NotNull
        public WireOut dateTime(LocalDateTime localDateTime) {
            return this.asText(localDateTime);
        }

        @NotNull
        private WireOut asText(@Nullable Object stringable) {
            if (this.dropDefault) {
                if (stringable == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            if (stringable == null) {
                this.nu11();
            } else {
                this.prependSeparator();
                YamlWire.this.append(stringable.toString());
                this.elementSeparator();
            }
            return YamlWire.this;
        }

        @Override
        @NotNull
        public ValueOut optionalTyped(Class aClass) {
            return this.typePrefix(aClass);
        }

        @Override
        @NotNull
        public ValueOut typePrefix(@NotNull CharSequence typeName) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.bytes.writeUnsignedByte(33);
            YamlWire.this.append(typeName);
            YamlWire.this.bytes.writeUnsignedByte(32);
            this.sep = BytesStore.empty();
            return this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> typeTranslator, Class type) {
            if (this.dropDefault) {
                if (type == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.append((CharSequence)TYPE);
            typeTranslator.accept(type, YamlWire.this.bytes);
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull CharSequence type) {
            if (this.dropDefault) {
                if (type == null) {
                    return this.wireOut();
                }
                this.writeSavedEventName();
            }
            this.prependSeparator();
            YamlWire.this.append((CharSequence)TYPE);
            YamlWire.this.escape(type);
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            return this.asText(uuid);
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextIntReference.write((Bytes)YamlWire.this.bytes, (int)value);
            this.elementSeparator();
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, IntValue intValue) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (!TextIntReference.class.isInstance(intValue)) {
                throw new IllegalArgumentException();
            }
            this.prependSeparator();
            long offset = YamlWire.this.bytes.writePosition();
            TextIntReference.write((Bytes)YamlWire.this.bytes, (int)value);
            long length = YamlWire.this.bytes.writePosition() - offset;
            ((Byteable)intValue).bytesStore((BytesStore)YamlWire.this.bytes, offset, length);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.prependSeparator();
            TextLongReference.write((Bytes)YamlWire.this.bytes, (long)value);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, LongValue longValue) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (!TextLongReference.class.isInstance(longValue)) {
                throw new IllegalArgumentException();
            }
            this.prependSeparator();
            long offset = YamlWire.this.bytes.writePosition();
            TextLongReference.write((Bytes)YamlWire.this.bytes, (long)value);
            long length = YamlWire.this.bytes.writePosition() - offset;
            ((Byteable)longValue).bytesStore((BytesStore)YamlWire.this.bytes, offset, length);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut boolForBinding(boolean value, @NotNull BooleanValue longValue) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (!TextBooleanReference.class.isInstance(longValue)) {
                throw new IllegalArgumentException();
            }
            this.prependSeparator();
            long offset = YamlWire.this.bytes.writePosition();
            TextBooleanReference.write((boolean)value, (BytesStore)YamlWire.this.bytes, (long)offset);
            long length = YamlWire.this.bytes.writePosition() - offset;
            ((Byteable)longValue).bytesStore((BytesStore)YamlWire.this.bytes, offset, length);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public <T> WireOut sequence(T t, @NotNull BiConsumer<T, ValueOut> writer) {
            this.startBlock('[');
            boolean leaf = this.leaf;
            if (!leaf) {
                this.newLine();
            } else {
                YamlWire.this.bytes.writeUnsignedByte(32);
            }
            long pos = YamlWire.this.bytes.writePosition();
            writer.accept(t, this);
            if (!leaf) {
                this.addNewLine(pos);
            }
            this.popState();
            if (!leaf) {
                this.indent();
            } else {
                this.addSpace(pos);
            }
            this.endBlock(this.leaf, ']');
            return this.wireOut();
        }

        public void startBlock(char c) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (!this.sep.isEmpty()) {
                YamlWire.this.append((CharSequence)this.sep);
                this.indent();
                this.sep = EMPTY;
            }
            this.pushState();
            YamlWire.this.bytes.writeUnsignedByte((int)c);
        }

        @Override
        @NotNull
        public <T, K> WireOut sequence(T t, K kls, @NotNull TriConsumer<T, K, ValueOut> writer) {
            boolean leaf = this.leaf;
            this.startBlock('[');
            if (leaf) {
                this.sep = SPACE;
            } else {
                this.newLine();
            }
            long pos = YamlWire.this.bytes.readPosition();
            writer.accept(t, kls, this);
            if (leaf) {
                this.addSpace(pos);
            } else {
                this.addNewLine(pos);
            }
            this.popState();
            if (!leaf) {
                this.indent();
            }
            this.endBlock(this.leaf, ']');
            return this.wireOut();
        }

        public void endBlock(boolean leaf, char c) {
            YamlWire.this.bytes.writeUnsignedByte((int)c);
            this.sep = leaf ? COMMA_SPACE : COMMA_NEW_LINE;
        }

        protected void addNewLine(long pos) {
            if (YamlWire.this.bytes.writePosition() > pos + 1L) {
                YamlWire.this.bytes.writeUnsignedByte(10);
            }
        }

        protected void addSpace(long pos) {
            if (YamlWire.this.bytes.writePosition() > pos + 1L) {
                YamlWire.this.bytes.writeUnsignedByte(32);
            }
        }

        protected void newLine() {
            this.sep = NEW_LINE;
        }

        protected void popState() {
            this.sep = this.seps.remove(this.seps.size() - 1);
            --this.indentation;
            this.leaf = false;
            this.dropDefault = false;
        }

        protected void pushState() {
            ++this.indentation;
            this.seps.add(this.sep);
            this.sep = EMPTY;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(object.getClass());
            boolean wasLeaf0 = this.leaf;
            if (this.indentation > 1 && wm.isLeaf()) {
                this.leaf = true;
            }
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (YamlWire.this.bytes.writePosition() == 0L) {
                object.writeMarshallable(YamlWire.this);
                if (YamlWire.this.bytes.writePosition() == 0L) {
                    YamlWire.this.bytes.append((CharSequence)"{}");
                }
                return YamlWire.this;
            }
            boolean wasLeaf = this.leaf;
            this.startBlock('{');
            if (wasLeaf) {
                this.afterOpen();
            } else {
                this.newLine();
            }
            object.writeMarshallable(YamlWire.this);
            BytesStore popSep = null;
            if (wasLeaf) {
                if (this.sep.endsWith(' ')) {
                    YamlWire.this.append(" ");
                }
                this.leaf = false;
                this.popState();
            } else if (this.seps.size() > 0) {
                popSep = this.seps.get(this.seps.size() - 1);
                this.popState();
                this.sep = NEW_LINE;
            }
            if (this.sep.startsWith(',')) {
                YamlWire.this.append((CharSequence)this.sep, 1, this.sep.length() - 1);
                if (!wasLeaf) {
                    this.indent();
                }
            } else {
                this.prependSeparator();
            }
            this.endBlock(this.leaf, '}');
            this.leaf = wasLeaf0;
            if (popSep != null) {
                this.sep = popSep;
            }
            if (this.indentation == 0) {
                this.afterClose();
            } else {
                this.elementSeparator();
            }
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull Serializable object) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            if (YamlWire.this.bytes.writePosition() == 0L) {
                this.writeSerializable(object);
                return YamlWire.this;
            }
            boolean wasLeaf = this.leaf;
            if (!wasLeaf) {
                this.pushState();
            }
            this.prependSeparator();
            YamlWire.this.bytes.writeUnsignedByte(object instanceof Externalizable ? 91 : 123);
            if (wasLeaf) {
                this.afterOpen();
            } else {
                this.newLine();
            }
            this.writeSerializable(object);
            @Nullable BytesStore popSep = null;
            if (wasLeaf) {
                this.leaf = false;
            } else if (this.seps.size() > 0) {
                popSep = this.seps.get(this.seps.size() - 1);
                this.popState();
                this.sep = NEW_LINE;
            }
            if (this.sep.startsWith(',')) {
                YamlWire.this.append((CharSequence)this.sep, 1, this.sep.length() - 1);
                if (!wasLeaf) {
                    this.indent();
                }
            } else {
                this.prependSeparator();
            }
            YamlWire.this.bytes.writeUnsignedByte(object instanceof Externalizable ? 93 : 125);
            if (popSep != null) {
                this.sep = popSep;
            }
            if (this.indentation == 0) {
                this.afterClose();
            } else {
                this.elementSeparator();
            }
            return YamlWire.this;
        }

        private void writeSerializable(@NotNull Serializable object) {
            try {
                if (object instanceof Externalizable) {
                    ((Externalizable)object).writeExternal(YamlWire.this.objectOutput());
                } else {
                    Wires.writeMarshallable(object, YamlWire.this);
                }
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        protected void afterClose() {
            this.newLine();
            YamlWire.this.append((CharSequence)this.sep);
            this.sep = EMPTY;
        }

        protected void afterOpen() {
            this.sep = SPACE;
        }

        @Override
        @NotNull
        public WireOut map(@NotNull Map map) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.marshallable(map, Object.class, Object.class, false);
            return YamlWire.this;
        }

        protected void endField() {
            this.sep = END_FIELD;
        }

        @Override
        @NotNull
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            if (this.dropDefault) {
                this.writeSavedEventName();
            }
            this.typePrefix(YamlWire.SEQ_MAP);
            map.forEach((k, v) -> this.sequence((ValueOut w) -> w.marshallable((WireOut m) -> m.write(() -> "key").typedMarshallable((WriteMarshallable)k).write(() -> "value").typedMarshallable((WriteMarshallable)v))));
            return this.wireOut();
        }

        protected void fieldValueSeperator() {
            YamlWire.this.writeTwo(':', ' ');
        }

        @NotNull
        public ValueOut write() {
            if (this.dropDefault) {
                this.eventName = "";
            } else {
                YamlWire.this.append((CharSequence)this.sep);
                YamlWire.this.writeTwo('\"', '\"');
                this.endEvent();
            }
            return this;
        }

        @NotNull
        public ValueOut write(@NotNull WireKey key) {
            if (this.dropDefault) {
                this.eventName = key.name().toString();
            } else {
                this.write(key.name());
            }
            return this;
        }

        @NotNull
        public ValueOut write(@NotNull CharSequence name) {
            if (this.dropDefault) {
                this.eventName = name.toString();
            } else {
                this.prependSeparator();
                YamlWire.this.escape(name);
                this.fieldValueSeperator();
            }
            return this;
        }

        @NotNull
        public ValueOut write(Class expectedType, @NotNull Object objectKey) {
            if (this.dropDefault) {
                if (expectedType != String.class) {
                    throw new UnsupportedOperationException(YamlWire.this.yt.toString());
                }
                this.eventName = objectKey.toString();
            } else {
                this.prependSeparator();
                YamlWire.this.writeStartEvent();
                this.object(expectedType, objectKey);
                this.endEvent();
            }
            return this;
        }

        private void writeSavedEventName() {
            if (this.eventName == null) {
                return;
            }
            this.prependSeparator();
            YamlWire.this.escape(this.eventName);
            this.fieldValueSeperator();
            this.eventName = null;
        }

        public void endEvent() {
            if (YamlWire.this.bytes.readByte(YamlWire.this.bytes.writePosition() - 1L) <= 32) {
                YamlWire.this.bytes.writeSkip(-1L);
            }
            this.fieldValueSeperator();
            this.sep = BytesStore.empty();
        }

        public void writeComment(@NotNull CharSequence s) {
            if (this.hasCommentAnnotation) {
                if (!this.sep.endsWith('\n')) {
                    return;
                }
                this.sep = COMMA_SPACE;
            } else {
                this.prependSeparator();
            }
            YamlWire.this.append((CharSequence)this.sep);
            if (this.hasCommentAnnotation) {
                YamlWire.this.writeTwo('\t', '\t');
            }
            YamlWire.this.writeTwo('#', ' ');
            YamlWire.this.append(s);
            YamlWire.this.bytes.writeUnsignedByte(10);
            this.sep = EMPTY_AFTER_COMMENT;
        }
    }
}

