/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.MethodWriterInterceptor;
import net.openhft.chronicle.bytes.MethodWriterInterceptorReturns;
import net.openhft.chronicle.bytes.MethodWriterInvocationHandler;
import net.openhft.chronicle.bytes.MethodWriterListener;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.GeneratedProxyClass;
import net.openhft.chronicle.wire.MethodWriterInvocationHandlerSupplier;
import org.jetbrains.annotations.NotNull;

public class VanillaMethodWriterBuilder<T>
implements Supplier<T>,
MethodWriterBuilder<T> {
    private static final boolean DISABLE_PROXY_GEN = Boolean.getBoolean("disableProxyCodegen");
    private final Set<Class> interfaces = new LinkedHashSet<Class>();
    private static final Map<Set<Class>, Class> setOfClassesToClassName = new ConcurrentHashMap<Set<Class>, Class>();
    private final String packageName;
    private final String className;
    private ClassLoader classLoader;
    @NotNull
    private final MethodWriterInvocationHandlerSupplier handlerSupplier;
    private final String proxyClassName;
    private Class<?> proxyClass;

    public VanillaMethodWriterBuilder(@NotNull Class<T> tClass, @NotNull Supplier<MethodWriterInvocationHandler> handlerSupplier) {
        this.packageName = tClass.getPackage().getName();
        this.className = tClass.getSimpleName();
        this.proxyClassName = this.className + "MethodWriter";
        this.addInterface(tClass);
        this.classLoader = tClass.getClassLoader();
        this.handlerSupplier = new MethodWriterInvocationHandlerSupplier(handlerSupplier);
        try {
            this.proxyClass = Class.forName(this.packageName + "." + this.proxyClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @NotNull
    public MethodWriterBuilder<T> classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> addInterface(Class additionalClass) {
        if (this.interfaces.contains(additionalClass)) {
            return this;
        }
        this.interfaces.add(additionalClass);
        for (Method method : additionalClass.getMethods()) {
            Class<?> returnType = method.getReturnType();
            if (!returnType.isInterface() || Jvm.dontChain(returnType)) continue;
            this.addInterface(returnType);
        }
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> recordHistory(boolean recordHistory) {
        this.handlerSupplier.recordHistory(recordHistory);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> methodWriterListener(MethodWriterListener methodWriterListener) {
        this.handlerSupplier.methodWriterListener(methodWriterListener);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> methodWriterInterceptor(MethodWriterInterceptor methodWriterInterceptor) {
        this.handlerSupplier.methodWriterInterceptor(methodWriterInterceptor);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> methodWriterInterceptorReturns(MethodWriterInterceptorReturns methodWriterInterceptor) {
        this.handlerSupplier.methodWriterInterceptorReturns(methodWriterInterceptor);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> onClose(Closeable closeable) {
        this.handlerSupplier.onClose(closeable);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> disableThreadSafe(boolean theadSafe) {
        this.handlerSupplier.disableThreadSafe(theadSafe);
        return this;
    }

    @NotNull
    public T build() {
        return this.get();
    }

    private Class generatedProxyClass(Set<Class> interfaces) {
        return GeneratedProxyClass.from(this.packageName, interfaces, this.proxyClassName, this.classLoader);
    }

    @Override
    @NotNull
    public T get() {
        block8: {
            block7: {
                if (this.proxyClass != null) {
                    try {
                        Constructor<?> constructor = this.proxyClass.getConstructor(MethodWriterInvocationHandlerSupplier.class);
                        return (T)constructor.newInstance(this.handlerSupplier);
                    }
                    catch (Throwable e) {
                        if (!Jvm.isDebug()) break block7;
                        Jvm.debug().on(this.getClass(), e);
                    }
                }
            }
            if (!DISABLE_PROXY_GEN) {
                try {
                    LinkedHashSet<Class> setOfInterfaces = new LinkedHashSet<Class>(this.interfaces);
                    setOfInterfaces.add(Closeable.class);
                    Class o = setOfClassesToClassName.computeIfAbsent(setOfInterfaces, this::generatedProxyClass);
                    if (o != null) {
                        return o.getConstructor(MethodWriterInvocationHandlerSupplier.class).newInstance(this.handlerSupplier);
                    }
                }
                catch (Throwable e) {
                    if (!Jvm.isDebug()) break block8;
                    Jvm.debug().on(this.getClass(), e);
                }
            }
        }
        @NotNull Class[] interfacesArr = this.interfaces.toArray(new Class[this.interfaces.size()]);
        return (T)Proxy.newProxyInstance(this.classLoader, interfacesArr, (InvocationHandler)new CallSupplierInvocationHandler());
    }

    public MethodWriterBuilder<T> genericEvent(String genericEvent) {
        this.handlerSupplier.genericEvent(genericEvent);
        return this;
    }

    public MethodWriterBuilder<T> useMethodIds(boolean useMethodIds) {
        this.handlerSupplier.useMethodIds(useMethodIds);
        return this;
    }

    public Class<?> proxyClass() {
        return this.proxyClass;
    }

    public MethodWriterBuilder<T> proxyClass(Class<?> proxyClass) {
        if (proxyClass.isInterface()) {
            throw new IllegalArgumentException("expecting a class rather than an interface, proxyClass=" + proxyClass);
        }
        this.proxyClass = proxyClass;
        return this;
    }

    class CallSupplierInvocationHandler
    implements InvocationHandler {
        CallSupplierInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return VanillaMethodWriterBuilder.this.handlerSupplier.get().invoke(proxy, method, args);
        }
    }
}

