/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAnyWire
extends AbstractWire
implements Wire {
    @NotNull
    protected final WireAcquisition wireAcquisition;

    public AbstractAnyWire(@NotNull Bytes bytes, @NotNull WireAcquisition wa) {
        super(bytes, false);
        this.wireAcquisition = wa;
    }

    @Nullable
    public Wire underlyingWire() {
        return this.wireAcquisition.acquireWire();
    }

    @NotNull
    public Supplier<WireType> underlyingType() {
        return this.wireAcquisition.underlyingType();
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        this.wireAcquisition.acquireWire().copyTo(wire);
    }

    @Override
    @NotNull
    public ValueIn read() {
        return this.wireAcquisition.acquireWire().read();
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        return this.wireAcquisition.acquireWire().read(key);
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        return this.wireAcquisition.acquireWire().read(name);
    }

    @Override
    @Nullable
    public <K> K readEvent(Class<K> expectedClass) {
        return this.wireAcquisition.acquireWire().readEvent(expectedClass);
    }

    @Override
    public void writeStartEvent() {
        this.wireAcquisition.acquireWire().writeStartEvent();
    }

    @Override
    public void writeEndEvent() {
        this.wireAcquisition.acquireWire().writeEndEvent();
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.wireAcquisition.acquireWire().getValueIn();
    }

    @Override
    @NotNull
    public WireIn readComment(@NotNull StringBuilder sb) {
        return this.wireAcquisition.acquireWire().readComment(sb);
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return this.wireAcquisition.acquireWire().newIntReference();
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return this.wireAcquisition.acquireWire().newLongReference();
    }

    @Override
    @NotNull
    public LongArrayValues newLongArrayReference() {
        return this.wireAcquisition.acquireWire().newLongArrayReference();
    }

    void checkWire() {
        this.wireAcquisition.acquireWire();
    }

    @Override
    @NotNull
    public DocumentContext readingDocument() {
        return this.wireAcquisition.acquireWire().readingDocument();
    }

    @Override
    public DocumentContext readingDocument(long readLocation) {
        return this.wireAcquisition.acquireWire().readingDocument(readLocation);
    }

    @Override
    public void consumePadding() {
        this.wireAcquisition.acquireWire().consumePadding();
    }

    @Override
    @NotNull
    public ValueOut write() {
        return this.wireAcquisition.acquireWire().write();
    }

    @Override
    @NotNull
    public ValueOut write(WireKey key) {
        return this.wireAcquisition.acquireWire().write(key);
    }

    @Override
    public ValueOut write(CharSequence key) {
        return this.wireAcquisition.acquireWire().write(key);
    }

    @Override
    public ValueOut writeEvent(Class expectedType, Object eventKey) {
        return this.wireAcquisition.acquireWire().writeEvent(expectedType, eventKey);
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.wireAcquisition.acquireWire().getValueOut();
    }

    @Override
    @NotNull
    public WireOut writeComment(CharSequence s) {
        return this.wireAcquisition.acquireWire().writeComment(s);
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        return this.wireAcquisition.acquireWire().addPadding(paddingToAdd);
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) {
        return this.wireAcquisition.acquireWire().writingDocument(metaData);
    }

    @Override
    public String readingPeekYaml() {
        return this.wireAcquisition.acquireWire().readingPeekYaml();
    }

    static interface WireAcquisition {
        @NotNull
        public Supplier<WireType> underlyingType();

        @Nullable
        public Wire acquireWire();

        public void classLookup(ClassLookup var1);

        @Nullable
        public ClassLookup classLookup();
    }
}

