/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import net.openhft.chronicle.wire.LongConverter;

public class MicroTimestampLongConverter
implements LongConverter {
    final DateTimeFormatter dtf = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).toFormatter();

    @Override
    public long parse(CharSequence text) {
        TemporalAccessor parse = this.dtf.parse(text);
        long time = parse.getLong(ChronoField.EPOCH_DAY) * 86400000000L;
        if (parse.isSupported(ChronoField.MICRO_OF_DAY)) {
            time += parse.getLong(ChronoField.MICRO_OF_DAY);
        } else if (parse.isSupported(ChronoField.MILLI_OF_DAY)) {
            time += parse.getLong(ChronoField.MILLI_OF_DAY) * 1000L;
        } else if (parse.isSupported(ChronoField.SECOND_OF_DAY)) {
            time += parse.getLong(ChronoField.SECOND_OF_DAY) * 1000000L;
        }
        return time;
    }

    @Override
    public void append(StringBuilder text, long value) {
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(value / 1000000L, (int)(value % 1000000L * 1000L), ZoneOffset.UTC);
        this.dtf.formatTo(ldt, text);
    }
}

