/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.wire.LongConverter;

public class WordsLongConverter
implements LongConverter {
    static final Pattern NON_LETTER = Pattern.compile("\\W");
    static final String[] WORDS;
    static final Map<String, Integer> WORD_ID;
    private final String sep;

    public WordsLongConverter() {
        this('.');
    }

    public WordsLongConverter(char sep) {
        this.sep = Character.toString(sep);
    }

    @Override
    public long parse(CharSequence text) {
        String[] split = NON_LETTER.split(text.toString().trim(), 0);
        long value = 0L;
        int shift = 0;
        for (String s : split) {
            Integer id = WORD_ID.get(s);
            if (id == null) {
                throw new IllegalArgumentException("Unknown word'" + s + "'");
            }
            value += id.longValue() << shift;
            shift += 11;
        }
        return value;
    }

    @Override
    public void append(StringBuilder text, long value) {
        String sep = "";
        do {
            text.append(sep);
            text.append(WORDS[(int)(value & 0x7FFL)]);
            sep = this.sep;
        } while ((value >>>= 11) > 0L);
    }

    static {
        WORD_ID = new HashMap<String, Integer>();
        try {
            WORDS = new String(IOTools.readFile((String)"2k-oxford-words.txt"), StandardCharsets.ISO_8859_1).split("\\s+");
            for (int i = 0; i < WORDS.length; ++i) {
                String word = WORDS[i];
                WORD_ID.put(word, i);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

