/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.compiler.CompilerUtils;

public enum GeneratedProxyClass {

    private static final String PACKAGE = "net.openhft.chronicle.wire.proxy";

    public static Class from(Set<Class> interfaces, String className) {
        int maxArgs = 0;
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        StringBuilder sb = new StringBuilder("package net.openhft.chronicle.wire.proxy;\n\nimport net.openhft.chronicle.core.Jvm;\nimport java.lang.reflect.InvocationHandler;\nimport java.lang.reflect.Method;\nimport java.util.ArrayList;\nimport java.util.List;\n");
        sb.append("public class " + className + " implements ");
        Iterator<Class> iterator = interfaces.iterator();
        StringBuilder methodArray = new StringBuilder();
        int count = 0;
        while (iterator.hasNext()) {
            Class interfaceClazz = iterator.next();
            String interfaceName = interfaceClazz.getName().replace("$", ".");
            sb.append(interfaceName);
            if (!interfaceClazz.isInterface()) {
                throw new IllegalArgumentException("expecting and interface instead of class=" + interfaceClazz.getName());
            }
            int j = -1;
            for (Method dm : interfaceClazz.getMethods()) {
                ++j;
                if (!methods.add(dm)) continue;
                maxArgs = Math.max(maxArgs, dm.getParameterCount());
                methodArray.append("    methods[" + count++ + "]=" + interfaceClazz.getName().replace("$", ".") + ".class.getMethods()[" + j + "];\n");
            }
            if (!iterator.hasNext()) break;
            sb.append(",\n              ");
        }
        sb.append(" {\n\n");
        GeneratedProxyClass.addFieldsAndConstructor(maxArgs, methods, sb, className, methodArray);
        GeneratedProxyClass.createProxyMethods(methods, sb);
        sb.append("}\n");
        System.out.println(sb.toString());
        try {
            return CompilerUtils.CACHED_COMPILER.loadFromJava("net.openhft.chronicle.wire.proxy." + className, sb.toString());
        }
        catch (ClassNotFoundException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    private static void addFieldsAndConstructor(int maxArgs, LinkedHashSet<Method> declaredMethods, StringBuilder sb, String className, StringBuilder methodArray) {
        sb.append("  private final Object proxy;\n  private final InvocationHandler handler;\n  private Method[] methods = new  Method[" + declaredMethods.size() + "];\n");
        sb.append("  private List<Object[]> args = new ArrayList<Object[]>(" + (maxArgs + 1) + ");\n\n");
        sb.append("  public " + className + "(Object proxy, InvocationHandler handler) {\n    this.proxy = proxy;\n    this.handler = handler;\n");
        for (int j = 0; j <= maxArgs; ++j) {
            sb.append("    args.add(new Object[" + j + "]);\n");
        }
        sb.append((CharSequence)methodArray);
        sb.append("  }\n\n");
    }

    private static void createProxyMethods(LinkedHashSet<Method> declaredMethods, StringBuilder sb) {
        int methodIndex = -1;
        for (Method dm : declaredMethods) {
            Class<?> returnType = dm.getReturnType();
            sb.append(GeneratedProxyClass.createMethodSignature(dm, returnType));
            sb.append("    Method method = this.methods[" + ++methodIndex + "];\n");
            sb.append("    Object[] a = this.args.get(" + dm.getParameterCount() + ");\n");
            GeneratedProxyClass.assignParametersToArgs(sb, dm);
            GeneratedProxyClass.callInvoke(sb, returnType);
        }
    }

    private static void callInvoke(StringBuilder sb, Class<?> returnType) {
        sb.append("    try {\n      ");
        if (returnType != Void.TYPE) {
            sb.append("return (" + returnType.getName() + ")");
        }
        sb.append(" handler.invoke(proxy,method,a);\n    } catch (Throwable throwable) {\n       throw Jvm.rethrow(throwable);\n    }\n  }\n");
    }

    private static void assignParametersToArgs(StringBuilder sb, Method dm) {
        int len = dm.getParameters().length;
        for (int j = 0; j < len; ++j) {
            String paramName = dm.getParameters()[j].getName();
            sb.append("    a[" + j + "] = " + paramName + ";\n");
        }
    }

    private static CharSequence createMethodSignature(Method dm, Class<?> returnType) {
        int len = dm.getParameters().length;
        StringBuilder result = new StringBuilder();
        result.append("  public ").append(returnType.getName() + " ").append(dm.getName()).append("(");
        for (int j = 0; j < len; ++j) {
            Parameter p = dm.getParameters()[j];
            result.append(p.getType().getTypeName().replace("$", ".") + " " + p.getName());
            if (j == len - 1) break;
            result.append(",");
        }
        result.append(") {\n");
        return result;
    }

    public static String className(Class inter) {
        return inter.getName().replace(inter.getPackage().getName() + ".", "");
    }

    public static String className(Collection<Class> inter) {
        StringBuilder s = new StringBuilder();
        for (Class aClass : inter) {
            s.append(GeneratedProxyClass.className(aClass) + "$");
        }
        return s.toString();
    }

    public static interface MsgListener
    extends Closeable {
        public void onMessage(Object var1);
    }
}

