/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.openhft.chronicle.wire.AbstractMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public class BinaryMethodWriterInvocationHandler
extends AbstractMethodWriterInvocationHandler {
    @NotNull
    private final Supplier<MarshallableOut> marshallableOutSupplier;

    BinaryMethodWriterInvocationHandler(@NotNull MarshallableOut marshallableOut) {
        this(() -> marshallableOut);
    }

    public BinaryMethodWriterInvocationHandler(Supplier<MarshallableOut> marshallableOutSupplier) {
        this.marshallableOutSupplier = marshallableOutSupplier;
        this.recordHistory = marshallableOutSupplier.get().recordHistory();
    }

    @Override
    protected void handleInvoke(Method method, Object[] args) {
        MarshallableOut marshallableOut = this.marshallableOutSupplier.get();
        try (DocumentContext context = marshallableOut.writingDocument();){
            Wire wire = context.wire();
            this.handleInvoke(method, args, wire);
            wire.padToCacheAlign();
        }
    }
}

