/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Externalizable;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.threads.ThreadLocalHelper;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.wire.AbstractFieldInfo;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.FieldInfo;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ScalarStrategy;
import net.openhft.chronicle.wire.SerializationStrategies;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaFieldInfo;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireDumper;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Wires
extends Enum<Wires> {
    public static final int LENGTH_MASK = 0x3FFFFFFF;
    public static final int NOT_COMPLETE = Integer.MIN_VALUE;
    @Deprecated
    public static final int NOT_READY = Integer.MIN_VALUE;
    public static final int META_DATA = 0x40000000;
    public static final int UNKNOWN_LENGTH = 0;
    public static final int MAX_LENGTH = 0x3FFFFFFF;
    public static final int NOT_COMPLETE_UNKNOWN_LENGTH = Integer.MIN_VALUE;
    public static final int END_OF_DATA = -1073741824;
    public static final int NOT_INITIALIZED = 0;
    public static final Bytes<?> NO_BYTES;
    public static final WireIn EMPTY;
    public static final int SPB_HEADER_SIZE = 4;
    public static final List<Function<Class, SerializationStrategy>> CLASS_STRATEGY_FUNCTIONS;
    public static final ClassLocal<SerializationStrategy> CLASS_STRATEGY;
    static final ClassLocal<FieldInfoPair> FIELD_INFOS;
    static final StringBuilderPool SBP;
    static final ClassLocal<Function<String, Marshallable>> MARSHALLABLE_FUNCTION;
    private static final /* synthetic */ Wires[] $VALUES;

    public static Wires[] values() {
        return (Wires[])$VALUES.clone();
    }

    public static Wires valueOf(String name) {
        return Enum.valueOf(Wires.class, name);
    }

    @Nullable
    public static <T> T read(@NotNull Class<T> tClass, ValueIn in) {
        SerializationStrategy strategy = (SerializationStrategy)CLASS_STRATEGY.get(tClass);
        return strategy.read(in, tClass);
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes) {
        return WireDumper.of(bytes).asString();
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes, long position) {
        long limit = bytes.readLimit();
        if (position > limit) {
            return "";
        }
        return WireDumper.of(bytes).asString(position, limit - position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fromSizePrefixedBlobs(@NotNull DocumentContext dc) {
        long start;
        Wire wire = dc.wire();
        Bytes<?> bytes = wire.bytes();
        if (wire instanceof TextWire) {
            return bytes.toString();
        }
        if ("BufferedTailer".equals(dc.getClass().getSimpleName())) {
            long length = wire.bytes().readLimit();
            int metaDataBit = dc.isMetaData() ? 0x40000000 : 0;
            int header = metaDataBit | Wires.toIntU30(length, "Document length %,d out of 30-bit int range.");
            NativeBytes tempBytes = Bytes.allocateElasticDirect();
            try {
                tempBytes.writeOrderedInt(header);
                tempBytes.write(((BinaryReadDocumentContext)dc).wire.bytes, 0L, ((BinaryReadDocumentContext)dc).wire.bytes.readLimit());
                WireType wireType = WireType.valueOf(wire);
                assert (wireType != null);
                Wire tempWire = (Wire)wireType.apply(tempBytes);
                String string = WireDumper.of(tempWire).asString(0L, length + 4L);
                return string;
            }
            finally {
                tempBytes.release();
            }
        }
        long headerPosition = dc instanceof BinaryReadDocumentContext ? ((start = ((BinaryReadDocumentContext)dc).lastStart) != -1L ? start : bytes.readPosition() - 4L) : bytes.readPosition() - 4L;
        long length = Wires.lengthOf(bytes.readInt(headerPosition));
        return WireDumper.of(wire).asString(headerPosition, length + 4L);
    }

    public static String fromSizePrefixedBlobs(@NotNull WireIn wireIn) {
        return WireDumper.of(wireIn).asString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CharSequence asText(@NotNull WireIn wireIn) {
        long pos = wireIn.bytes().readPosition();
        try {
            Bytes bytes = Wires.acquireBytes();
            wireIn.copyTo(new TextWire(bytes).addTimeStamps(true));
            Bytes bytes2 = bytes;
            return bytes2;
        }
        finally {
            wireIn.bytes().readPosition(pos);
        }
    }

    public static StringBuilder acquireStringBuilder() {
        return SBP.acquireStringBuilder();
    }

    public static int lengthOf(int len) {
        int len0 = len & 0x3FFFFFFF;
        return len0;
    }

    public static boolean isReady(int header) {
        return (header & Integer.MIN_VALUE) == 0 && header != 0;
    }

    public static boolean isNotComplete(int header) {
        return (header & Integer.MIN_VALUE) != 0 || header == 0;
    }

    public static boolean isReadyData(int header) {
        return (header & 0xC0000000) == 0 && header != 0;
    }

    @Deprecated
    public static boolean isData(long len) {
        return Wires.isData((int)len);
    }

    public static boolean isData(int len) {
        return (len & 0x40000000) == 0;
    }

    public static boolean isReadyMetaData(int len) {
        return (len & 0xC0000000) == 0x40000000;
    }

    public static boolean isKnownLength(int len) {
        return (len & Integer.MAX_VALUE) != 0;
    }

    public static boolean isNotInitialized(int len) {
        return len == 0;
    }

    public static int toIntU30(long l, @NotNull String error) {
        if (l < 0L || l > 0x3FFFFFFFL) {
            throw new IllegalStateException(String.format(error, l));
        }
        return (int)l;
    }

    public static boolean acquireLock(@NotNull BytesStore store, long position) {
        return store.compareAndSwapInt(position, 0, Integer.MIN_VALUE);
    }

    public static boolean exceedsMaxLength(long length) {
        return length > 0x3FFFFFFFL;
    }

    @ForceInline
    public static <T extends WriteMarshallable> long writeData(@NotNull WireOut wireOut, @NotNull T writer) {
        return WireInternal.writeData(wireOut, false, false, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    public static long readWire(@NotNull WireIn wireIn, long size, @NotNull ReadMarshallable readMarshallable) {
        Bytes<?> bytes = wireIn.bytes();
        long limit0 = bytes.readLimit();
        long limit = bytes.readPosition() + size;
        try {
            bytes.readLimit(limit);
            readMarshallable.readMarshallable(wireIn);
        }
        finally {
            bytes.readLimit(limit0);
            bytes.readPosition(limit);
        }
        return bytes.readPosition();
    }

    @Nullable
    public static Bytes acquireBytes() {
        Bytes bytes = (Bytes)ThreadLocalHelper.getTL(WireInternal.BYTES_TL, Bytes::allocateElasticDirect);
        bytes.clear();
        return bytes;
    }

    @Nullable
    static Bytes acquireBytesForToString() {
        Bytes bytes = (Bytes)ThreadLocalHelper.getTL(WireInternal.BYTES_F2S_TL, Bytes::allocateElasticDirect);
        bytes.clear();
        return bytes;
    }

    @Nullable
    public static Wire acquireBinaryWire() {
        Wire wire = (Wire)ThreadLocalHelper.getTL(WireInternal.BINARY_WIRE_TL, () -> new BinaryWire(Wires.acquireBytes()));
        wire.clear();
        return wire;
    }

    @Nullable
    public static Bytes acquireAnotherBytes() {
        Bytes bytes = (Bytes)ThreadLocalHelper.getTL(WireInternal.BYTES_TL, Bytes::allocateElasticDirect);
        bytes.clear();
        return bytes;
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes<?> bytes, long position, long length) {
        return WireDumper.of(bytes).asString(position, length);
    }

    public static void readMarshallable(@NotNull Object marshallable, @NotNull WireIn wire, boolean overwrite) {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass());
        wm.readMarshallable(marshallable, wire, wm.defaultValue(), overwrite);
    }

    public static void writeMarshallable(@NotNull Object marshallable, @NotNull WireOut wire) {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass());
        wm.writeMarshallable(marshallable, wire);
    }

    public static void writeMarshallable(@NotNull Object marshallable, @NotNull WireOut wire, boolean writeDefault) {
        WireMarshaller marshaller = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass());
        if (writeDefault) {
            marshaller.writeMarshallable(marshallable, wire);
        } else {
            marshaller.writeMarshallable(marshallable, wire, marshaller.defaultValue(), false);
        }
    }

    public static void writeMarshallable(@NotNull Object marshallable, @NotNull WireOut wire, @NotNull Object previous, boolean copy) {
        assert (marshallable.getClass() == previous.getClass());
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass());
        wm.writeMarshallable(marshallable, wire, previous, copy);
    }

    public static void writeKey(@NotNull Object marshallable, Bytes bytes) {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass());
        wm.writeKey(marshallable, bytes);
    }

    @NotNull
    public static <T extends Marshallable> T deepCopy(@NotNull T marshallable) {
        Wire wire = Wires.acquireBinaryWire();
        marshallable.writeMarshallable(wire);
        Marshallable t = (Marshallable)ObjectUtils.newInstance(marshallable.getClass());
        t.readMarshallable(wire);
        return (T)t;
    }

    @NotNull
    public static <T> T copyTo(Object source, @NotNull T target) {
        Wire wire = Wires.acquireBinaryWire();
        wire.getValueOut().object(source);
        wire.getValueIn().typePrefix();
        wire.getValueIn().object(target, target.getClass());
        return target;
    }

    @NotNull
    public static <T> T project(Class<T> tClass, Object source) {
        Object target = ObjectUtils.newInstance(tClass);
        Wires.copyTo(source, target);
        return (T)target;
    }

    public static boolean isEquals(@NotNull Object o1, @NotNull Object o2) {
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        return ((WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(o1.getClass())).isEqual(o1, o2);
    }

    @NotNull
    public static List<FieldInfo> fieldInfos(@NotNull Class aClass) {
        return ((FieldInfoPair)Wires.FIELD_INFOS.get((Class)aClass)).list;
    }

    public static FieldInfo fieldInfo(@NotNull Class aClass, String name) {
        return ((FieldInfoPair)Wires.FIELD_INFOS.get((Class)aClass)).map.get(name);
    }

    public static boolean isEndOfFile(int num) {
        return num == -1073741824;
    }

    @Nullable
    public static <T> T getField(@NotNull Object o, String name, Class<T> tClass) throws NoSuchFieldException {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(o.getClass());
        Object value = wm.getField(o, name);
        return (T)ObjectUtils.convertTo(tClass, (Object)value);
    }

    public static void setField(@NotNull Object o, String name, Object value) throws NoSuchFieldException {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(o.getClass());
        wm.setField(o, name, value);
    }

    public static void reset(@NotNull Object o) {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(o.getClass());
        wm.reset(o);
    }

    @Nullable
    public static <E> E objectSequence(ValueIn in, @Nullable E using, @Nullable Class clazz, SerializationStrategy<E> strategy) {
        if (clazz == Object.class) {
            strategy = SerializationStrategies.LIST;
        }
        if (using == null) {
            using = strategy.newInstance(clazz);
        }
        return (E)(in.sequence(using, strategy::readUsing) ? ReadResolvable.readResolve(using) : null);
    }

    @Nullable
    public static <E> E objectMap(ValueIn in, @Nullable E using, @Nullable Class clazz, SerializationStrategy<E> strategy) {
        if (clazz == Object.class) {
            strategy = SerializationStrategies.MAP;
        }
        if (using == null) {
            using = strategy.newInstance(clazz);
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return (E)WireInternal.throwable(in, false, (Throwable)using);
        }
        if (using == null) {
            throw new IllegalStateException("failed to create instance of clazz=" + clazz + " is it aliased?");
        }
        Object ret = in.marshallable(using, strategy);
        return (E)ReadResolvable.readResolve((Object)ret);
    }

    @NotNull
    public static <E> E objectDate(ValueIn in, @Nullable E using) {
        in.wireIn().read();
        long time = in.int64();
        if (using instanceof Date) {
            ((Date)using).setTime(time);
            return using;
        }
        return (E)new Date(time);
    }

    @Nullable
    public static <E> E object0(ValueIn in, @Nullable E using, @Nullable Class clazz) {
        SerializationStrategy strategy;
        BracketType brackets;
        Object o = in.typePrefixOrObject(clazz);
        if (o != null && !(o instanceof Class)) {
            return (E)in.marshallable(o, SerializationStrategies.MARSHALLABLE);
        }
        Class clazz2 = (Class)o;
        if (clazz2 == Void.TYPE) {
            in.text();
            return null;
        }
        if (clazz2 != null && (clazz == null || clazz.isAssignableFrom(clazz2) || ReadResolvable.class.isAssignableFrom(clazz2) || !ObjectUtils.isConcreteClass(clazz)) && !(clazz = clazz2).isInstance(using)) {
            using = null;
        }
        if (clazz == null) {
            clazz = Object.class;
        }
        if ((brackets = (strategy = (SerializationStrategy)CLASS_STRATEGY.get(clazz)).bracketType()) == BracketType.UNKNOWN) {
            brackets = in.getBracketType();
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return Wires.objectDate(in, using);
        }
        switch (brackets) {
            case MAP: {
                return Wires.objectMap(in, using, clazz, strategy);
            }
            case SEQ: {
                return Wires.objectSequence(in, using, clazz, strategy);
            }
            case NONE: {
                E e = strategy.readUsing(using, in);
                return (E)ObjectUtils.convertTo(clazz, e);
            }
        }
        throw new AssertionError();
    }

    public static String typeNameFor(@NotNull Object value) {
        return value instanceof Marshallable ? ((Marshallable)value).getClassName() : ClassAliasPool.CLASS_ALIASES.nameFor(value.getClass());
    }

    static Marshallable newInstance(Constructor constructor, String typeName) {
        try {
            return (Marshallable)constructor.newInstance(new TupleInvocationHandler(typeName));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T tupleFor(Class<T> tClass, String typeName) {
        if (tClass == null || tClass == Object.class) {
            tClass = Marshallable.class;
        }
        return (T)((Function)MARSHALLABLE_FUNCTION.get(tClass)).apply(typeName);
    }

    public static boolean dtoInterface(Class clazz) {
        return clazz != null && clazz.isInterface() && !clazz.getPackage().getName().startsWith("java");
    }

    static {
        $VALUES = new Wires[0];
        NO_BYTES = new VanillaBytes(BytesStore.empty());
        EMPTY = new BinaryWire(NO_BYTES);
        CLASS_STRATEGY_FUNCTIONS = new CopyOnWriteArrayList<Function<Class, SerializationStrategy>>();
        CLASS_STRATEGY = ClassLocal.withInitial(c -> {
            for (Function<Class, SerializationStrategy> func : CLASS_STRATEGY_FUNCTIONS) {
                SerializationStrategy strategy = func.apply((Class)c);
                if (strategy == null) continue;
                return strategy;
            }
            return SerializationStrategies.ANY_OBJECT;
        });
        FIELD_INFOS = ClassLocal.withInitial(VanillaFieldInfo::lookupClass);
        SBP = new StringBuilderPool();
        CLASS_STRATEGY_FUNCTIONS.add(SerializeEnum.INSTANCE);
        CLASS_STRATEGY_FUNCTIONS.add(SerializeJavaLang.INSTANCE);
        CLASS_STRATEGY_FUNCTIONS.add(SerializeMarshallables.INSTANCE);
        CLASS_STRATEGY_FUNCTIONS.add(SerializeBytes.INSTANCE);
        WireInternal.addAliases();
        MARSHALLABLE_FUNCTION = ClassLocal.withInitial(tClass -> {
            Class[] interfaces = new Class[]{Marshallable.class, tClass};
            if (tClass == Marshallable.class) {
                interfaces = new Class[]{Marshallable.class};
            }
            Class<?> proxyClass = Proxy.getProxyClass(tClass.getClassLoader(), interfaces);
            try {
                Constructor<?> constructor = proxyClass.getConstructor(InvocationHandler.class);
                return typeName -> Wires.newInstance(constructor, typeName);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    static class TupleFieldInfo
    extends AbstractFieldInfo {
        public TupleFieldInfo(String name, Class type) {
            super(type, SerializeMarshallables.INSTANCE.apply(type).bracketType(), name);
        }

        private Map<String, Object> getMap(Object o) {
            TupleInvocationHandler invocationHandler = (TupleInvocationHandler)Proxy.getInvocationHandler(o);
            return invocationHandler.fields;
        }

        @Override
        @Nullable
        public Object get(Object object) {
            return this.getMap(object).get(this.name);
        }

        @Override
        public long getLong(Object object) {
            return (Long)ObjectUtils.convertTo(Long.class, (Object)this.get(object));
        }

        @Override
        public int getInt(Object object) {
            return (Integer)ObjectUtils.convertTo(Integer.class, (Object)this.get(object));
        }

        @Override
        public char getChar(Object object) {
            return ((Character)ObjectUtils.convertTo(Character.class, (Object)this.get(object))).charValue();
        }

        @Override
        public double getDouble(Object object) {
            return (Double)ObjectUtils.convertTo(Double.class, (Object)this.get(object));
        }

        @Override
        public void set(Object object, Object value) throws IllegalArgumentException {
            this.getMap(object).put(this.name, value);
        }

        @Override
        public void set(Object object, char value) throws IllegalArgumentException {
            this.set((Object)this.name, Character.valueOf(value));
        }

        @Override
        public void set(Object object, int value) throws IllegalArgumentException {
            this.set((Object)this.name, (Object)value);
        }

        @Override
        public void set(Object object, long value) throws IllegalArgumentException {
            this.set((Object)this.name, (Object)value);
        }

        @Override
        public void set(Object object, double value) throws IllegalArgumentException {
            this.set((Object)this.name, (Object)value);
        }

        @Override
        public Class genericType(int index) {
            return Object.class;
        }
    }

    static class TupleInvocationHandler
    implements InvocationHandler {
        final String typeName;
        final Map<String, Object> fields = new LinkedHashMap<String, Object>();

        private TupleInvocationHandler(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            switch (method.getName()) {
                case "hashCode": {
                    if (args != null && args.length != 0) break;
                    return Maths.agitate((long)((long)this.typeName.hashCode() * 1019L + (long)this.fields.hashCode() * 10191L));
                }
                case "equals": {
                    if (args == null || args.length != 1) break;
                    return this.equals0(proxy, args[0]);
                }
                case "deepCopy": {
                    if (args != null && args.length != 0) break;
                    TupleInvocationHandler h2 = new TupleInvocationHandler(this.typeName);
                    h2.fields.putAll(this.fields);
                    return proxy.getClass().getDeclaredConstructor(InvocationHandler.class).newInstance(h2);
                }
                case "toString": {
                    if (args != null && args.length != 0) break;
                    return WireType.TEXT.asString(proxy);
                }
                case "readMarshallable": {
                    if (args.length != 1) break;
                    WireIn in = (WireIn)args[0];
                    while (in.hasMore()) {
                        this.fields.put(in.readEvent(String.class), in.getValueIn().object());
                    }
                    return null;
                }
                case "writeMarshallable": {
                    if (args.length != 1) break;
                    WireOut out = (WireOut)args[0];
                    for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        if (value == null) continue;
                        out.write(key).object(value);
                    }
                    return null;
                }
                case "getField": {
                    if (args.length != 2) break;
                    Object value = this.fields.get(args[0]);
                    return ObjectUtils.convertTo((Class)((Class)args[1]), (Object)value);
                }
                case "setField": {
                    if (args.length != 2) break;
                    this.fields.put(args[0].toString(), args[1]);
                    return null;
                }
                case "getClassName": {
                    if (args != null && args.length != 0) break;
                    return this.typeName;
                }
                case "$fieldInfos": {
                    if (args != null && args.length != 0) break;
                    ArrayList<TupleFieldInfo> fieldInfos = new ArrayList<TupleFieldInfo>();
                    for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                        Class<?> valueClass = entry.getValue().getClass();
                        fieldInfos.add(new TupleFieldInfo(entry.getKey(), valueClass));
                    }
                    return fieldInfos;
                }
            }
            if (args == null || args.length == 0) {
                Class<?> returnType = method.getReturnType();
                return ObjectUtils.convertTo(returnType, (Object)this.fields.get(method.getName()));
            }
            if (args.length == 1) {
                this.fields.put(method.getName(), args[0]);
                return proxy;
            }
            throw new UnsupportedOperationException(method.toString());
        }

        @NotNull
        private Object equals0(Object proxy, Object o) {
            if (proxy == o) {
                return true;
            }
            if (!(o instanceof Marshallable)) {
                return false;
            }
            Marshallable m = (Marshallable)o;
            if (!m.getClassName().equals(this.typeName)) {
                return false;
            }
            if (!Proxy.isProxyClass(m.getClass())) {
                return false;
            }
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(m);
            if (!(invocationHandler instanceof TupleInvocationHandler)) {
                return false;
            }
            TupleInvocationHandler tih = (TupleInvocationHandler)invocationHandler;
            return this.fields.equals(tih.fields);
        }
    }

    static class FieldInfoPair {
        static final FieldInfoPair EMPTY = new FieldInfoPair(Collections.emptyList(), Collections.emptyMap());
        @NotNull
        final List<FieldInfo> list;
        @NotNull
        final Map<String, FieldInfo> map;

        public FieldInfoPair(@NotNull List<FieldInfo> list, @NotNull Map<String, FieldInfo> map) {
            this.list = list;
            this.map = map;
        }
    }

    static enum SerializeMarshallables implements Function<Class, SerializationStrategy>
    {
        INSTANCE;


        @Nullable
        static SerializationStrategy getSerializationStrategy(@NotNull Class aClass) {
            if (Demarshallable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.DEMARSHALLABLE;
            }
            if (ReadMarshallable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.MARSHALLABLE;
            }
            return null;
        }

        @Override
        public SerializationStrategy apply(@NotNull Class aClass) {
            SerializationStrategy x = SerializeMarshallables.getSerializationStrategy(aClass);
            if (x != null) {
                return x;
            }
            if (Map.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.MAP;
            }
            if (Set.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.SET;
            }
            if (List.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.LIST;
            }
            if (Externalizable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.EXTERNALIZABLE;
            }
            if (Serializable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.ANY_NESTED;
            }
            return SerializationStrategies.ANY_SCALAR;
        }
    }

    static enum SerializeJavaLang implements Function<Class, SerializationStrategy>
    {
        INSTANCE;


        @Override
        public SerializationStrategy apply(@NotNull Class aClass) {
            switch (aClass.getName()) {
                case "[B": {
                    return ScalarStrategy.of(byte[].class, (o, in) -> in.bytes());
                }
                case "java.lang.StringBuilder": {
                    return ScalarStrategy.of(StringBuilder.class, (o, in) -> {
                        StringBuilder builder = o == null ? Wires.acquireStringBuilder() : o;
                        in.textTo(builder);
                        return o;
                    });
                }
                case "java.lang.String": {
                    return ScalarStrategy.of(String.class, (o, in) -> in.text());
                }
                case "java.lang.Object": {
                    return SerializationStrategies.ANY_OBJECT;
                }
                case "java.lang.Class": {
                    return ScalarStrategy.of(Class.class, (o, in) -> {
                        try {
                            return ClassAliasPool.CLASS_ALIASES.forName((CharSequence)in.text());
                        }
                        catch (ClassNotFoundException e) {
                            throw new IORuntimeException((Throwable)e);
                        }
                    });
                }
                case "java.lang.Boolean": {
                    return ScalarStrategy.of(Boolean.class, (o, in) -> in.bool());
                }
                case "java.lang.Byte": {
                    return ScalarStrategy.of(Byte.class, (o, in) -> in.int8());
                }
                case "java.lang.Short": {
                    return ScalarStrategy.of(Short.class, (o, in) -> in.int16());
                }
                case "java.lang.Character": {
                    return ScalarStrategy.of(Character.class, (o, in) -> {
                        String text = in.text();
                        if (text == null || text.length() == 0) {
                            return null;
                        }
                        return Character.valueOf(text.charAt(0));
                    });
                }
                case "java.lang.Integer": {
                    return ScalarStrategy.of(Integer.class, (o, in) -> in.int32());
                }
                case "java.lang.Float": {
                    return ScalarStrategy.of(Float.class, (o, in) -> Float.valueOf(in.float32()));
                }
                case "java.lang.Long": {
                    return ScalarStrategy.of(Long.class, (o, in) -> in.int64());
                }
                case "java.lang.Double": {
                    return ScalarStrategy.of(Double.class, (o, in) -> in.float64());
                }
                case "java.time.LocalTime": {
                    return ScalarStrategy.of(LocalTime.class, (o, in) -> in.time());
                }
                case "java.time.LocalDate": {
                    return ScalarStrategy.of(LocalDate.class, (o, in) -> in.date());
                }
                case "java.time.LocalDateTime": {
                    return ScalarStrategy.of(LocalDateTime.class, (o, in) -> in.dateTime());
                }
                case "java.time.ZonedDateTime": {
                    return ScalarStrategy.of(ZonedDateTime.class, (o, in) -> in.zonedDateTime());
                }
                case "java.io.File": {
                    return ScalarStrategy.text(File.class, File::new);
                }
                case "java.util.UUID": {
                    return ScalarStrategy.of(UUID.class, (o, in) -> in.uuid());
                }
                case "java.math.BigInteger": {
                    return ScalarStrategy.text(BigInteger.class, BigInteger::new);
                }
                case "java.math.BigDecimal": {
                    return ScalarStrategy.text(BigDecimal.class, BigDecimal::new);
                }
            }
            if (aClass.isPrimitive()) {
                return SerializationStrategies.ANY_SCALAR;
            }
            if (aClass.isArray()) {
                Class<?> componentType = aClass.getComponentType();
                if (componentType.isPrimitive()) {
                    return SerializationStrategies.PRIM_ARRAY;
                }
                return SerializationStrategies.ARRAY;
            }
            if (Enum.class.isAssignableFrom(aClass)) {
                SerializationStrategy ss = SerializeMarshallables.getSerializationStrategy(aClass);
                return ss == null ? SerializationStrategies.ENUM : ss;
            }
            return null;
        }
    }

    static enum SerializeEnum implements Function<Class, SerializationStrategy>
    {
        INSTANCE;


        @Nullable
        static SerializationStrategy getSerializationStrategy(@NotNull Class aClass) {
            if (Enum.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.ENUM;
            }
            return null;
        }

        @Override
        @Nullable
        public SerializationStrategy apply(@NotNull Class aClass) {
            return SerializeEnum.getSerializationStrategy(aClass);
        }
    }

    static enum SerializeBytes implements Function<Class, SerializationStrategy>
    {
        INSTANCE;


        @Override
        public SerializationStrategy apply(@NotNull Class aClass) {
            switch (aClass.getName()) {
                case "net.openhft.chronicle.bytes.BytesStore": {
                    return ScalarStrategy.of(BytesStore.class, (o, in) -> in.bytesStore());
                }
            }
            return null;
        }
    }
}

