/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.SourceContext;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class VanillaMessageHistory
extends AbstractMarshallable
implements MessageHistory {
    public static final int MESSAGE_HISTORY_LENGTH = 20;
    private static final ThreadLocal<MessageHistory> THREAD_LOCAL = ThreadLocal.withInitial(() -> {
        VanillaMessageHistory veh = new VanillaMessageHistory();
        veh.addSourceDetails(true);
        return veh;
    });
    private int sources;
    @NotNull
    private int[] sourceIdArray = new int[20];
    @NotNull
    private long[] sourceIndexArray = new long[20];
    private int timings;
    @NotNull
    private long[] timingsArray = new long[40];
    private boolean addSourceDetails = false;

    static MessageHistory getThreadLocal() {
        return THREAD_LOCAL.get();
    }

    static void setThreadLocal(MessageHistory md) {
        THREAD_LOCAL.set(md);
    }

    public void addSourceDetails(boolean addSourceDetails) {
        this.addSourceDetails = addSourceDetails;
    }

    @Override
    public void reset() {
        this.timings = 0;
        this.sources = 0;
    }

    @Override
    public int timings() {
        return this.timings;
    }

    @Override
    public long timing(int n) {
        return this.timingsArray[n];
    }

    @Override
    public int sources() {
        return this.sources;
    }

    @Override
    public int sourceId(int n) {
        return this.sourceIdArray[n] & 0xFF;
    }

    @Override
    public long sourceIndex(int n) {
        return this.sourceIndexArray[n];
    }

    @Override
    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        this.sources = 0;
        wire.read(() -> "sources").sequence(this, (t, in) -> {
            while (in.hasNextSequenceItem()) {
                t.addSource(in.int32(), in.int64());
            }
        });
        this.timings = 0;
        wire.read(() -> "timings").sequence(this, (t, in) -> {
            while (in.hasNextSequenceItem()) {
                t.addTiming(in.int64());
            }
        });
        if (this.addSourceDetails) {
            Object o = wire.parent();
            if (o instanceof SourceContext) {
                SourceContext dc = (SourceContext)o;
                this.addSource(dc.sourceId(), dc.index());
            }
            this.addTiming(System.nanoTime());
        }
    }

    private void addSource(int id, long index) {
        this.sourceIdArray[this.sources] = (byte)id;
        this.sourceIndexArray[this.sources++] = index;
    }

    public void addTiming(long l) {
        this.timingsArray[this.timings++] = l;
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write("sources").sequence(this, (t, out) -> {
            for (int i = 0; i < t.sources; ++i) {
                out.uint32(t.sourceIdArray[i]);
                out.int64_0x(t.sourceIndexArray[i]);
            }
        });
        wire.write("timings").sequence(this, (t, out) -> {
            for (int i = 0; i < t.timings; ++i) {
                out.int64(t.timingsArray[i]);
            }
            out.int64(System.nanoTime());
        });
    }
}

