/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.wire.MethodReader;
import net.openhft.chronicle.wire.TextWire;

public class TextMethodTester<T> {
    private final String input;
    private final Class<T> outputClass;
    private final String output;
    private final Function<T, Object> componentFunction;
    private String setup;
    private Function<String, String> afterRun;
    private String expected;
    private String actual;

    public TextMethodTester(String input, Function<T, Object> componentFunction, Class<T> outputClass, String output) {
        this.input = input;
        this.outputClass = outputClass;
        this.output = output;
        this.componentFunction = componentFunction;
    }

    public String setup() {
        return this.setup;
    }

    public TextMethodTester setup(String setup) {
        this.setup = setup;
        return this;
    }

    public Function<String, String> afterRun() {
        return this.afterRun;
    }

    public TextMethodTester afterRun(Function<String, String> afterRun) {
        this.afterRun = afterRun;
        return this;
    }

    public TextMethodTester run() throws IOException {
        TextWire wire2 = new TextWire((Bytes)Bytes.allocateElasticDirect()).useTextDocuments();
        T writer = wire2.methodWriter(this.outputClass, new Class[0]);
        Object component = this.componentFunction.apply(writer);
        if (this.setup != null) {
            TextWire wire0 = new TextWire(BytesUtil.readFile((String)this.setup)).useTextDocuments();
            MethodReader reader0 = wire0.methodReader(component);
            while (reader0.readOne()) {
                wire2.bytes().clear();
            }
            wire2.bytes().clear();
        }
        TextWire wire = new TextWire(BytesUtil.readFile((String)this.input)).useTextDocuments();
        this.expected = BytesUtil.readFile((String)this.output).toString().trim().replace("\r", "");
        MethodReader reader = wire.methodReader(component);
        while (reader.readOne()) {
            wire2.bytes().append((CharSequence)"---\n");
        }
        this.actual = ((Object)wire2).toString().trim();
        if (this.afterRun != null) {
            this.expected = this.afterRun.apply(this.expected);
            this.actual = this.afterRun.apply(this.actual);
        }
        return this;
    }

    public String expected() {
        return this.expected;
    }

    public String actual() {
        return this.actual;
    }
}

