/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.wire.AbstractAnyWire;
import net.openhft.chronicle.wire.BinaryWireCode;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadAnyWire
extends AbstractAnyWire
implements Wire {
    public ReadAnyWire(Bytes bytes) {
        super(bytes, new ReadAnyWireAcquisition(bytes));
    }

    @Override
    public void classLookup(ClassLookup classLookup) {
        this.wireAcquisition.classLookup(classLookup);
    }

    @Override
    public ClassLookup classLookup() {
        return this.wireAcquisition.classLookup();
    }

    @Override
    public void clear() {
        this.checkWire();
        this.bytes.clear();
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        this.checkWire();
        return this.bytes;
    }

    static class ReadAnyWireAcquisition
    implements AbstractAnyWire.WireAcquisition {
        private final Bytes bytes;
        WireType wireType;
        @Nullable
        Wire wire = null;
        private ClassLookup classLookup = ClassAliasPool.CLASS_ALIASES;

        public ReadAnyWireAcquisition(Bytes bytes) {
            this.bytes = bytes;
        }

        @Override
        public void classLookup(ClassLookup classLookup) {
            this.classLookup = classLookup;
            if (this.wire != null) {
                this.wire.classLookup(classLookup);
            }
        }

        @Override
        public ClassLookup classLookup() {
            return this.classLookup;
        }

        @Override
        @NotNull
        public Supplier<WireType> underlyingType() {
            return () -> this.wireType;
        }

        @Override
        @Nullable
        public Wire acquireWire() {
            if (this.wire != null) {
                return this.wire;
            }
            if (this.bytes.readRemaining() >= 8L) {
                int firstBytes = this.bytes.readInt(this.bytes.readPosition()) | this.bytes.readInt(this.bytes.readPosition() + 4L);
                firstBytes |= firstBytes >> 16;
                if (((firstBytes |= firstBytes >> 8) & 0x80) == 0) {
                    System.out.println("TEXT_WIRE");
                    this.wireType = WireType.TEXT;
                } else if (BinaryWireCode.isFieldCode(this.bytes.readByte(this.bytes.readPosition()))) {
                    System.out.println("FIELDLESS_BINARY");
                    this.wireType = WireType.FIELDLESS_BINARY;
                } else {
                    System.out.println("BINARY");
                    this.wireType = WireType.BINARY;
                }
                Wire wire = (Wire)this.wireType.apply(this.bytes);
                wire.classLookup(this.classLookup);
                this.wire = wire;
                return this.wire;
            }
            return null;
        }

        public Bytes bytes() {
            return this.bytes;
        }
    }
}

