/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireSerializedLambda;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.WriteValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValueOut {
    public static final int SMALL_MESSAGE = 64;

    @NotNull
    public WireOut bool(Boolean var1);

    @NotNull
    public WireOut text(@Nullable CharSequence var1);

    @NotNull
    default public WireOut text(@Nullable String s) {
        return this.text((CharSequence)s);
    }

    default public WireOut nu11() {
        return this.text((CharSequence)null);
    }

    @NotNull
    default public WireOut text(@Nullable BytesStore s) {
        return this.text((CharSequence)s);
    }

    @NotNull
    default public WireOut int8(long x) {
        return this.int8(Maths.toInt8((long)x));
    }

    @NotNull
    public WireOut int8(byte var1);

    @NotNull
    public WireOut bytes(@Nullable BytesStore var1);

    default public WireOut bytesLiteral(@Nullable BytesStore fromBytes) {
        return this.bytes(fromBytes);
    }

    @NotNull
    public WireOut bytes(String var1, @Nullable BytesStore var2);

    @NotNull
    public WireOut rawBytes(byte[] var1);

    @NotNull
    public ValueOut writeLength(long var1);

    @NotNull
    public WireOut bytes(byte[] var1);

    @NotNull
    public WireOut bytes(String var1, byte[] var2);

    @NotNull
    default public WireOut uint8(int x) {
        return this.uint8checked(Maths.toUInt8((long)x));
    }

    @NotNull
    public WireOut uint8checked(int var1);

    @NotNull
    default public WireOut int16(long x) {
        return this.int16(Maths.toInt16((long)x));
    }

    @NotNull
    public WireOut int16(short var1);

    @NotNull
    default public WireOut uint16(long x) {
        return this.uint16checked((int)x);
    }

    @NotNull
    public WireOut uint16checked(int var1);

    @NotNull
    public WireOut utf8(int var1);

    @NotNull
    default public WireOut int32(long x) {
        return this.int32(Maths.toInt32((long)x));
    }

    @NotNull
    public WireOut int32(int var1);

    @NotNull
    default public WireOut int32(int i32, int previous) {
        return this.int32(i32);
    }

    @NotNull
    default public WireOut uint32(long x) {
        return this.uint32checked(x);
    }

    @NotNull
    public WireOut uint32checked(long var1);

    @NotNull
    public WireOut int64(long var1);

    @NotNull
    default public WireOut int64(long i64, long previous) {
        return this.int64(i64);
    }

    @NotNull
    public WireOut int64_0x(long var1);

    @NotNull
    public WireOut int64array(long var1);

    @NotNull
    public WireOut int64array(long var1, LongArrayValues var3);

    @NotNull
    public WireOut float32(float var1);

    @NotNull
    public WireOut float64(double var1);

    @NotNull
    default public WireOut float32(float f, float previous) {
        return this.float32(f);
    }

    @NotNull
    default public WireOut float64(double d, double previous) {
        return this.float64(d);
    }

    @NotNull
    public WireOut time(LocalTime var1);

    @NotNull
    public WireOut zonedDateTime(ZonedDateTime var1);

    @NotNull
    public WireOut date(LocalDate var1);

    @NotNull
    public WireOut dateTime(LocalDateTime var1);

    @NotNull
    public ValueOut typePrefix(CharSequence var1);

    @NotNull
    default public ValueOut typePrefix(Class type) {
        return this.typePrefix(ClassAliasPool.CLASS_ALIASES.nameFor(type));
    }

    @NotNull
    default public WireOut typeLiteral(@Nullable Class type) {
        return type == null ? this.nu11() : this.typeLiteral((t, b) -> b.appendUtf8((CharSequence)ClassAliasPool.CLASS_ALIASES.nameFor(t)), type);
    }

    @NotNull
    public WireOut typeLiteral(@NotNull CharSequence var1);

    @NotNull
    public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> var1, @NotNull Class var2);

    @NotNull
    public WireOut uuid(UUID var1);

    @NotNull
    public WireOut int32forBinding(int var1);

    @NotNull
    public WireOut int32forBinding(int var1, @NotNull IntValue var2);

    @NotNull
    public WireOut int64forBinding(long var1);

    @NotNull
    public WireOut int64forBinding(long var1, @NotNull LongValue var3);

    @NotNull
    default public WireOut sequence(WriteValue writer) {
        return this.sequence(writer, WriteValue::writeValue);
    }

    @NotNull
    default public <T> WireOut sequence(Iterable<T> t) {
        if (t instanceof SortedSet) {
            this.typePrefix(SortedSet.class);
        } else if (t instanceof Set) {
            this.typePrefix(Set.class);
        }
        return this.sequence(t, (it, out) -> {
            for (Object o : it) {
                out.object(o);
            }
        });
    }

    @NotNull
    public <T> WireOut sequence(T var1, BiConsumer<T, ValueOut> var2);

    @NotNull
    public <T, K> WireOut sequence(T var1, K var2, TriConsumer<T, K, ValueOut> var3);

    @NotNull
    default public WireOut array(@NotNull WriteValue writer, @NotNull Class arrayType) {
        if (arrayType == String[].class) {
            this.typePrefix("String[] ");
        } else if (arrayType != Object[].class) {
            this.typePrefix(ClassAliasPool.CLASS_ALIASES.nameFor(arrayType.getComponentType()) + "[]");
        }
        return this.sequence(writer);
    }

    @NotNull
    public WireOut marshallable(WriteMarshallable var1);

    @NotNull
    public WireOut marshallable(Serializable var1);

    @Deprecated
    @NotNull
    public WireOut map(Map var1);

    @Deprecated
    @NotNull
    public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> var1);

    @NotNull
    public ValueOut leaf();

    @NotNull
    default public ValueOut leaf(boolean leaf) {
        return leaf ? this.leaf() : this;
    }

    @NotNull
    default public WireOut typedMarshallable(@Nullable WriteMarshallable object) {
        if (object == null) {
            return this.nu11();
        }
        this.typePrefix(object.getClass());
        return this.marshallable(object);
    }

    @NotNull
    default public WireOut typedMarshallable(@Nullable Serializable object) {
        if (object == null) {
            return this.nu11();
        }
        this.typePrefix(object.getClass());
        if (object instanceof WriteMarshallable) {
            return this.marshallable((WriteMarshallable)((Object)object));
        }
        return this.marshallable(object);
    }

    @NotNull
    default public WireOut typedMarshallable(CharSequence typeName, WriteMarshallable object) {
        this.typePrefix(typeName);
        return this.marshallable(object);
    }

    @NotNull
    default public <E extends Enum<E>> WireOut asEnum(@Nullable E e) {
        return this.text(e == null ? null : e.name());
    }

    @NotNull
    default public <V> WireOut set(Set<V> coll) {
        return this.set(coll, null);
    }

    @NotNull
    default public <V> WireOut set(Set<V> coll, Class<V> assumedClass) {
        return this.collection(coll, assumedClass);
    }

    @NotNull
    default public <V> WireOut list(List<V> coll) {
        return this.list(coll, null);
    }

    @NotNull
    default public <V> WireOut list(List<V> coll, Class<V> assumedClass) {
        this.sequence(coll, assumedClass, (s, kls, out) -> {
            int size = s.size();
            for (int i = 0; i < size; ++i) {
                out.leaf();
                this.marshallable((WriteMarshallable)s.get(i));
            }
        });
        return this.wireOut();
    }

    @NotNull
    default public <V> WireOut collection(Collection<V> coll, Class<V> assumedClass) {
        this.sequence(coll, assumedClass, (s, kls, out) -> {
            for (Object v : s) {
                this.object((Class)kls, (Object)v);
            }
        });
        return this.wireOut();
    }

    @NotNull
    default public <V> WireOut object(Class<V> expectedType, V v) {
        if (v instanceof WriteMarshallable) {
            if (v.getClass() == expectedType) {
                this.marshallable((WriteMarshallable)v);
            } else {
                this.typedMarshallable((WriteMarshallable)v);
            }
        } else if (v != null && v.getClass() == expectedType) {
            this.untypedObject(v);
        } else {
            this.object(v);
        }
        return this.wireOut();
    }

    @NotNull
    default public <K, V> WireOut marshallable(Map<K, V> map) {
        return this.marshallable(map, null, null, true);
    }

    @NotNull
    default public <K, V> WireOut marshallable(@Nullable Map<K, V> map, Class<K> kClass, Class<V> vClass, boolean leaf) {
        if (map == null) {
            this.nu11();
            return this.wireOut();
        }
        this.marshallable((WireOut m) -> {
            for (Map.Entry entry : map.entrySet()) {
                m.writeEvent(kClass, entry.getKey()).leaf(leaf).object(vClass, entry.getValue());
            }
        });
        return this.wireOut();
    }

    @NotNull
    default public WireOut object(@Nullable Object value) {
        if (value == null) {
            return this.nu11();
        }
        switch (value.getClass().getName()) {
            case "[B": {
                return this.typePrefix(byte[].class).bytes((byte[])value);
            }
            case "[S": 
            case "[C": 
            case "[I": 
            case "[J": 
            case "[F": 
            case "[D": 
            case "[Z": {
                return this.typePrefix(value.getClass()).leaf(true).sequence(value, (v, out) -> {
                    int len = Array.getLength(v);
                    for (int i = 0; i < len; ++i) {
                        out.untypedObject(Array.get(v, i));
                    }
                });
            }
            case "java.lang.String": {
                return this.text((String)value);
            }
            case "java.lang.Byte": {
                return this.fixedInt8((Byte)value);
            }
            case "java.lang.Boolean": {
                return this.bool((Boolean)value);
            }
            case "java.lang.Character": {
                return this.text(value.toString());
            }
            case "java.lang.Class": {
                return this.typeLiteral((Class)value);
            }
            case "java.lang.Short": {
                return this.fixedInt16((Short)value);
            }
            case "java.lang.Integer": {
                return this.fixedInt32((Integer)value);
            }
            case "java.lang.Long": {
                return this.fixedInt64((Long)value);
            }
            case "java.lang.Double": {
                return this.fixedFloat64((Double)value);
            }
            case "java.lang.Float": {
                return this.fixedFloat32(((Float)value).floatValue());
            }
            case "[java.lang.String;": {
                return this.array(v -> Stream.of((String[])value).forEach(v::text), String[].class);
            }
            case "[java.lang.Object;": {
                return this.array(v -> Stream.of((Object[])value).forEach(v::object), Object[].class);
            }
            case "java.time.LocalTime": {
                return this.optionalTyped(LocalTime.class).time((LocalTime)value);
            }
            case "java.time.LocalDate": {
                return this.optionalTyped(LocalDate.class).date((LocalDate)value);
            }
            case "java.time.LocalDateTime": {
                return this.optionalTyped(LocalDateTime.class).dateTime((LocalDateTime)value);
            }
            case "java.time.ZonedDateTime": {
                return this.optionalTyped(ZonedDateTime.class).zonedDateTime((ZonedDateTime)value);
            }
            case "java.util.Date": {
                long time = ((Date)value).getTime();
                return this.typePrefix(value.getClass()).fixedInt64(time);
            }
            case "java.util.UUID": {
                return this.optionalTyped(UUID.class).uuid((UUID)value);
            }
            case "java.math.BigInteger": 
            case "java.math.BigDecimal": 
            case "java.io.File": {
                return this.optionalTyped(value.getClass()).text(value.toString());
            }
        }
        if (value instanceof WriteMarshallable) {
            if (value instanceof Enum) {
                Jvm.warn().on(this.getClass(), "Treating " + value.getClass() + " as enum not WriteMarshallable");
                return this.typedScalar(value);
            }
            return this.typedMarshallable((WriteMarshallable)value);
        }
        if (value instanceof BytesStore) {
            return this.bytes((BytesStore)value);
        }
        if (value instanceof CharSequence) {
            return this.text((CharSequence)value);
        }
        if (value instanceof Map) {
            if (value instanceof SortedMap) {
                this.typePrefix(SortedMap.class);
            }
            return this.map((Map)value);
        }
        if (value instanceof Throwable) {
            return this.throwable((Throwable)value);
        }
        if (value instanceof Enum) {
            return this.typedScalar(value);
        }
        if (value instanceof Collection) {
            if (value instanceof SortedSet) {
                this.typePrefix(SortedSet.class);
            } else if (value instanceof Set) {
                this.typePrefix(Set.class);
            }
            return this.sequence((ValueOut v) -> ((Collection)value).stream().forEach(v::object));
        }
        if (WireSerializedLambda.isSerializableLambda(value.getClass())) {
            WireSerializedLambda.write(value, this);
            return this.wireOut();
        }
        if (Object[].class.isAssignableFrom(value.getClass())) {
            Class<?> type = value.getClass().getComponentType();
            return this.array(v -> Stream.of((Object[])value).forEach(val -> v.object(type, val)), value.getClass());
        }
        if (value instanceof Serializable) {
            return this.typedMarshallable((Serializable)value);
        }
        if (value instanceof ByteBuffer) {
            return this.object(BytesStore.wrap((ByteBuffer)((ByteBuffer)value)));
        }
        throw new IllegalStateException("type=" + value.getClass() + " is unsupported, it must either be of type Marshallable, String or " + "AutoBoxed primitive Object");
    }

    @NotNull
    default public ValueOut optionalTyped(Class aClass) {
        return this;
    }

    @NotNull
    default public WireOut fixedFloat32(float value) {
        return this.typePrefix(Float.TYPE).float32(Float.valueOf(value).floatValue());
    }

    @NotNull
    default public WireOut fixedInt8(byte value) {
        return this.typePrefix(Byte.TYPE).int8(value);
    }

    @NotNull
    default public WireOut fixedInt16(short value) {
        return this.typePrefix(Short.TYPE).int16(value);
    }

    @NotNull
    default public WireOut fixedInt32(int value) {
        return this.typePrefix(Integer.TYPE).int32(value);
    }

    @NotNull
    default public WireOut fixedFloat64(double value) {
        return this.float64(value);
    }

    @NotNull
    default public WireOut fixedInt64(long value) {
        return this.int64(value);
    }

    @NotNull
    default public WireOut untypedObject(@Nullable Object value) {
        if (value == null) {
            return this.nu11();
        }
        switch (value.getClass().getName()) {
            case "[B": {
                return this.bytes((byte[])value);
            }
            case "java.lang.Byte": {
                return this.int8((Byte)value);
            }
            case "java.lang.Short": {
                return this.int16((Short)value);
            }
            case "java.lang.Integer": {
                return this.int32((Integer)value);
            }
            case "java.lang.Long": {
                return this.int64((Long)value);
            }
            case "java.lang.Double": {
                return this.float64((Double)value);
            }
            case "java.lang.Float": {
                return this.float32(((Float)value).floatValue());
            }
            case "java.time.LocalTime": {
                return this.time((LocalTime)value);
            }
            case "java.time.LocalDate": {
                return this.date((LocalDate)value);
            }
            case "java.time.LocalDateTime": {
                return this.dateTime((LocalDateTime)value);
            }
            case "java.time.ZonedDateTime": {
                return this.zonedDateTime((ZonedDateTime)value);
            }
            case "java.util.UUID": {
                return this.uuid((UUID)value);
            }
            case "java.math.BigInteger": 
            case "java.math.BigDecimal": 
            case "java.io.File": {
                return this.text(value.toString());
            }
        }
        if (value instanceof Marshallable) {
            return this.marshallable((Marshallable)value);
        }
        if (value instanceof Enum) {
            return this.text(((Enum)value).name());
        }
        if (Object[].class.isAssignableFrom(value.getClass())) {
            Class<?> type = value.getClass().getComponentType();
            return this.array(v -> Stream.of((Object[])value).forEach(val -> v.object(type, val)), Object[].class);
        }
        return this.object(value);
    }

    @NotNull
    default public WireOut typedScalar(@NotNull Object value) {
        this.typePrefix(ClassAliasPool.CLASS_ALIASES.nameFor(value.getClass()));
        if (!(value instanceof CharSequence)) {
            value = value.toString();
        }
        this.text((CharSequence)value);
        return this.wireOut();
    }

    @NotNull
    default public WireOut throwable(@NotNull Throwable t) {
        this.typedMarshallable(t.getClass().getName(), w -> w.write(() -> "message").text(t.getMessage()).write(() -> "stackTrace").sequence((ValueOut w3) -> {
            StackTraceElement[] stes = t.getStackTrace();
            int last = Jvm.trimLast((int)0, (StackTraceElement[])stes);
            for (int i = 0; i < last; ++i) {
                StackTraceElement ste = stes[i];
                w3.leaf().marshallable((WireOut w4) -> w4.write(() -> "class").text(ste.getClassName()).write(() -> "method").text(ste.getMethodName()).write(() -> "file").text(ste.getFileName()).write(() -> "line").int32(ste.getLineNumber()));
            }
        }));
        return this.wireOut();
    }

    @NotNull
    public WireOut wireOut();

    default public WireOut compress(@NotNull String compression, @Nullable Bytes uncompressedBytes) {
        if (uncompressedBytes == null) {
            return this.nu11();
        }
        if (uncompressedBytes.readRemaining() < 64L) {
            return this.bytes((BytesStore)uncompressedBytes);
        }
        Bytes tmpBytes = Wires.acquireBytes();
        Compression.compress((CharSequence)compression, (Bytes)uncompressedBytes, (Bytes)tmpBytes);
        this.bytes(compression, (BytesStore)tmpBytes);
        return this.wireOut();
    }

    default public int compressedSize() {
        return Integer.MAX_VALUE;
    }

    @Deprecated
    @NotNull
    default public WireOut compress(String compression, @Nullable String str) {
        if (str == null || str.length() < 64) {
            return this.text(str);
        }
        WireInternal.compress(this, compression, str);
        return this.wireOut();
    }

    default public void resetBetweenDocuments() {
        this.resetState();
    }

    public void resetState();
}

