/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireParselet;
import net.openhft.chronicle.wire.WireParser;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodReader
implements Closeable {
    static final Object[] NO_ARGS = new Object[0];
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodReader.class);
    private final MarshallableIn in;
    @NotNull
    private final WireParser<Void> wireParser;
    private boolean closeIn = false;
    private boolean closed;

    public MethodReader(MarshallableIn in, Object ... objects) {
        this.in = in;
        WireParselet defaultParselet = (s, v, $) -> LOGGER.warn("Unknown message " + s + ' ' + v.text());
        if (objects[0] instanceof WireParselet) {
            defaultParselet = (WireParselet)objects[0];
        }
        this.wireParser = WireParser.wireParser(defaultParselet);
        HashSet<String> methodsHandled = new HashSet<String>();
        for (Object o : objects) {
            block7: for (Method m : o.getClass().getMethods()) {
                if (Modifier.isStatic(m.getModifiers())) continue;
                try {
                    Object.class.getMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    if (!methodsHandled.add(m.getName())) continue;
                    Class[] parameterTypes = m.getParameterTypes();
                    switch (parameterTypes.length) {
                        case 0: {
                            this.addParseletForMethod(o, m);
                            continue block7;
                        }
                        case 1: {
                            this.addParseletForMethod(o, m, parameterTypes[0]);
                            continue block7;
                        }
                        default: {
                            this.addParseletForMethod(o, m, parameterTypes);
                        }
                    }
                }
            }
        }
        if (this.wireParser.lookup("history") == null) {
            this.wireParser.register(() -> "history", (s, v, $) -> v.marshallable(MessageHistory.get()));
        }
    }

    static void logMessage(@NotNull CharSequence s, @NotNull ValueIn v) {
        String rest;
        String name = s.toString();
        if (v.wireIn() instanceof BinaryWire) {
            Bytes bytes = Bytes.elasticByteBuffer((int)((int)(v.wireIn().bytes().readRemaining() * 3L / 2L + 64L)));
            long pos = v.wireIn().bytes().readPosition();
            v.wireIn().copyTo(new TextWire(bytes));
            v.wireIn().bytes().readPosition(pos);
            rest = bytes.toString();
        } else {
            rest = v.toString();
        }
        LOGGER.debug("read " + name + " - " + rest);
    }

    @NotNull
    public MethodReader closeIn(boolean closeIn) {
        this.closeIn = closeIn;
        return this;
    }

    public void addParseletForMethod(Object o, @NotNull Method m, Class<?> parameterType) {
        Class<?> msgClass = parameterType;
        m.setAccessible(true);
        if (msgClass.isInterface() || !ReadMarshallable.class.isAssignableFrom(msgClass)) {
            Object[] argArr = new Object[]{null};
            this.wireParser.register(m::getName, (s, v, $) -> {
                try {
                    if (Jvm.isDebug()) {
                        MethodReader.logMessage(s, v);
                    }
                    objectArray[0] = v.object(msgClass);
                    m.invoke(o, argArr);
                }
                catch (Exception i) {
                    LOGGER.warn("Failure to dispatch message: " + m.getName() + " " + argArr[0], (Throwable)i);
                }
            });
        } else {
            ReadMarshallable arg;
            try {
                arg = (ReadMarshallable)msgClass.newInstance();
            }
            catch (Exception e) {
                try {
                    arg = (ReadMarshallable)OS.memory().allocateInstance(msgClass);
                }
                catch (InstantiationException e1) {
                    throw Jvm.rethrow((Throwable)e1);
                }
            }
            ReadMarshallable[] argArr = new ReadMarshallable[]{arg};
            this.wireParser.register(m::getName, (s, v, $) -> {
                try {
                    if (Jvm.isDebug()) {
                        MethodReader.logMessage(s, v);
                    }
                    v.marshallable(argArr[0]);
                    m.invoke(o, (Object[])argArr);
                }
                catch (Exception i) {
                    LOGGER.warn("Failure to dispatch message: " + m.getName() + " " + argArr[0], (Throwable)i);
                }
            });
        }
    }

    public void addParseletForMethod(Object o, @NotNull Method m) {
        m.setAccessible(true);
        this.wireParser.register(m::getName, (s, v, $) -> {
            try {
                if (Jvm.isDebug()) {
                    MethodReader.logMessage(s, v);
                }
                v.skipValue();
                m.invoke(o, NO_ARGS);
            }
            catch (Exception i) {
                LOGGER.warn("Failure to dispatch message: " + m.getName() + "()");
            }
        });
    }

    public void addParseletForMethod(Object o, @NotNull Method m, @NotNull Class[] parameterTypes) {
        m.setAccessible(true);
        Object[] args = new Object[parameterTypes.length];
        BiConsumer<Object[], ValueIn> sequenceReader = (a, v) -> {
            int i = 0;
            for (Class clazz : parameterTypes) {
                a[i++] = v.object(clazz);
            }
        };
        this.wireParser.register(m::getName, (s, v, $) -> {
            try {
                if (Jvm.isDebug()) {
                    MethodReader.logMessage(s, v);
                }
                v.sequence(args, sequenceReader);
                m.invoke(o, args);
            }
            catch (Exception i) {
                LOGGER.warn("Failure to dispatch message: " + m.getName() + " " + Arrays.toString(args), (Throwable)i);
            }
        });
    }

    public boolean readOne() {
        MessageHistory.get().reset();
        try (DocumentContext context = this.in.readingDocument();){
            if (!context.isData()) {
                boolean bl = false;
                return bl;
            }
            this.wireParser.accept(context.wire(), null);
        }
        return true;
    }

    public void close() {
        if (this.closeIn) {
            Closeable.closeQuietly((Object)this.in);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

