/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Serializable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SerializationStrategies;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValueIn {
    public static final Consumer<ValueIn> DISCARD = v -> {};

    @NotNull
    default public <T> WireIn text(T t, @NotNull BiConsumer<T, String> ts) {
        String text = this.text();
        ts.accept(t, text);
        return this.wireIn();
    }

    @NotNull
    default public WireIn text(@NotNull StringBuilder sb) {
        if (this.textTo(sb) == null) {
            sb.setLength(0);
        }
        return this.wireIn();
    }

    @NotNull
    default public WireIn text(@NotNull Bytes sdo) {
        sdo.clear();
        this.textTo(sdo);
        return this.wireIn();
    }

    @Nullable
    public String text();

    @Nullable
    public StringBuilder textTo(@NotNull StringBuilder var1);

    @Nullable
    public Bytes textTo(@NotNull Bytes var1);

    @Deprecated
    @NotNull
    default public WireIn bytes(@NotNull Bytes toBytes) {
        return this.bytes((BytesOut)toBytes);
    }

    @NotNull
    public WireIn bytes(@NotNull BytesOut var1);

    @NotNull
    default public WireIn bytesLiteral(@NotNull BytesOut toBytes) {
        return this.bytes(toBytes);
    }

    @Nullable
    default public BytesStore bytesLiteral() {
        return this.bytesStore();
    }

    @Nullable
    public WireIn bytesSet(@NotNull PointerBytesStore var1);

    @NotNull
    public WireIn bytesMatch(@NotNull BytesStore var1, BooleanConsumer var2);

    @NotNull
    public WireIn bytes(@NotNull ReadBytesMarshallable var1);

    @Nullable
    public byte[] bytes();

    @Nullable
    default public BytesStore bytesStore() {
        byte[] bytes = this.bytes();
        return bytes == null ? null : BytesStore.wrap((byte[])bytes);
    }

    default public void byteBuffer(@NotNull ByteBuffer bb) {
        bb.put(this.bytes());
    }

    @NotNull
    public WireIn wireIn();

    public long readLength();

    public WireIn skipValue();

    @NotNull
    public <T> WireIn bool(T var1, @NotNull ObjBooleanConsumer<T> var2);

    @NotNull
    public <T> WireIn int8(@NotNull T var1, @NotNull ObjByteConsumer<T> var2);

    @NotNull
    public <T> WireIn uint8(@NotNull T var1, @NotNull ObjShortConsumer<T> var2);

    @NotNull
    public <T> WireIn int16(@NotNull T var1, @NotNull ObjShortConsumer<T> var2);

    @NotNull
    public <T> WireIn uint16(@NotNull T var1, @NotNull ObjIntConsumer<T> var2);

    @NotNull
    public <T> WireIn int32(@NotNull T var1, @NotNull ObjIntConsumer<T> var2);

    @NotNull
    public <T> WireIn uint32(@NotNull T var1, @NotNull ObjLongConsumer<T> var2);

    @NotNull
    public <T> WireIn int64(@NotNull T var1, @NotNull ObjLongConsumer<T> var2);

    @NotNull
    public <T> WireIn float32(@NotNull T var1, @NotNull ObjFloatConsumer<T> var2);

    @NotNull
    public <T> WireIn float64(@NotNull T var1, @NotNull ObjDoubleConsumer<T> var2);

    @NotNull
    public <T> WireIn time(@NotNull T var1, @NotNull BiConsumer<T, LocalTime> var2);

    @NotNull
    public <T> WireIn zonedDateTime(@NotNull T var1, @NotNull BiConsumer<T, ZonedDateTime> var2);

    @NotNull
    public <T> WireIn date(@NotNull T var1, @NotNull BiConsumer<T, LocalDate> var2);

    default public LocalDate date() {
        return LocalDate.parse(this.text());
    }

    default public LocalTime time() {
        return LocalTime.parse(this.text());
    }

    default public LocalDateTime dateTime() {
        return LocalDateTime.parse(this.text());
    }

    default public ZonedDateTime zonedDateTime() {
        return ZonedDateTime.parse(this.text());
    }

    public boolean hasNext();

    public boolean hasNextSequenceItem();

    @NotNull
    public <T> WireIn uuid(@NotNull T var1, @NotNull BiConsumer<T, UUID> var2);

    @NotNull
    public <T> WireIn int64array(@Nullable LongArrayValues var1, T var2, @NotNull BiConsumer<T, LongArrayValues> var3);

    @NotNull
    public WireIn int64(@NotNull LongValue var1);

    @NotNull
    public WireIn int32(@NotNull IntValue var1);

    @NotNull
    default public LongValue int64ForBinding(@Nullable LongValue value) {
        LongValue ret = this.wireIn().newLongReference();
        this.int64(ret);
        return ret;
    }

    @NotNull
    default public IntValue int32ForBinding(@Nullable LongValue value) {
        IntValue ret = this.wireIn().newIntReference();
        this.int32(ret);
        return ret;
    }

    @NotNull
    public <T> WireIn int64(@Nullable LongValue var1, T var2, @NotNull BiConsumer<T, LongValue> var3);

    @NotNull
    public <T> WireIn int32(@Nullable IntValue var1, T var2, @NotNull BiConsumer<T, IntValue> var3);

    @NotNull
    public <T> boolean sequence(@NotNull T var1, @NotNull BiConsumer<T, ValueIn> var2);

    default public <T> boolean sequence(@NotNull T t, @NotNull SerializationStrategy<T> tReader) {
        return this.sequence(t, tReader::readUsing);
    }

    @NotNull
    public <T, K> WireIn sequence(@NotNull T var1, K var2, @NotNull TriConsumer<T, K, ValueIn> var3);

    default public <T> Set<T> set(Class<T> t) {
        return this.collection(LinkedHashSet::new, t);
    }

    default public <T> List<T> list(Class<T> t) {
        return this.collection(ArrayList::new, t);
    }

    default public <T, C extends Collection<T>> C collection(@NotNull Supplier<C> supplier, Class<T> t) {
        Collection list = (Collection)supplier.get();
        this.sequence(list, t, (s, kls, v) -> {
            while (v.hasNextSequenceItem()) {
                s.add(v.object((Class)kls));
            }
        });
        return (C)list;
    }

    @NotNull
    default public <O, T extends ReadMarshallable> WireIn set(@NotNull O o, Function<O, T> tSupplier) {
        return this.collection(o, tSupplier);
    }

    @NotNull
    default public <O, T extends ReadMarshallable> WireIn list(@NotNull O o, Function<O, T> tSupplier) {
        return this.collection(o, tSupplier);
    }

    @NotNull
    default public <O, T extends ReadMarshallable, C extends Collection<T>> WireIn collection(@NotNull O o, Function<O, T> tSupplier) {
        this.sequence(o, tSupplier, (o2, ts, v) -> {
            while (v.hasNextSequenceItem()) {
                ReadMarshallable t = (ReadMarshallable)ts.apply(o2);
                v.marshallable(t);
            }
        });
        return this.wireIn();
    }

    @Nullable
    default public <K, V> Map<K, V> marshallableAsMap(Class<K> kClass, @NotNull Class<V> vClass) {
        return this.marshallableAsMap(kClass, vClass, new LinkedHashMap());
    }

    @Nullable
    default public <K, V> Map<K, V> marshallableAsMap(Class<K> kClass, @NotNull Class<V> vClass, @NotNull Map<K, V> map) {
        return this.marshallable((WireIn m) -> m.readAllAsMap(kClass, vClass, map)) ? map : null;
    }

    public <T> T applyToMarshallable(Function<WireIn, T> var1);

    @Nullable
    public <T> T typedMarshallable() throws IORuntimeException;

    @Nullable
    default public <T> T typedMarshallable(@NotNull Function<Class, ReadMarshallable> marshallableFunction) throws IORuntimeException {
        Class aClass = this.typePrefix();
        if (ReadMarshallable.class.isAssignableFrom(aClass)) {
            ReadMarshallable marshallable = marshallableFunction.apply(aClass);
            this.marshallable(marshallable);
            return (T)marshallable;
        }
        return this.object(null, aClass);
    }

    @NotNull
    public <T> ValueIn typePrefix(T var1, @NotNull BiConsumer<T, CharSequence> var2);

    @NotNull
    public <T> WireIn typeLiteralAsText(T var1, @NotNull BiConsumer<T, CharSequence> var2) throws IORuntimeException, BufferUnderflowException;

    @NotNull
    default public <T> WireIn typeLiteral(T t, @NotNull BiConsumer<T, Class> classConsumer) throws IORuntimeException {
        return this.typeLiteralAsText(t, (o, x) -> {
            try {
                classConsumer.accept(o, ClassAliasPool.CLASS_ALIASES.forName(x));
            }
            catch (ClassNotFoundException e) {
                throw new IORuntimeException((Throwable)e);
            }
        });
    }

    @NotNull
    default public <T> WireIn typeLiteral(T t, @NotNull BiConsumer<T, Class> classConsumer, Class defaultClass) {
        return this.typeLiteralAsText(t, (o, x) -> {
            Class u = defaultClass;
            try {
                u = ClassAliasPool.CLASS_ALIASES.forName(x);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            classConsumer.accept(o, u);
        });
    }

    @Nullable
    public Object marshallable(Object var1, SerializationStrategy var2) throws BufferUnderflowException, IORuntimeException;

    default public boolean marshallable(@NotNull Serializable object) throws BufferUnderflowException, IORuntimeException {
        return this.marshallable(object, SerializationStrategies.SERIALIZABLE) != null;
    }

    default public boolean marshallable(@NotNull ReadMarshallable object) throws BufferUnderflowException, IORuntimeException {
        return this.marshallable(object, SerializationStrategies.MARSHALLABLE) != null;
    }

    @Deprecated
    default public void map(@NotNull Map<String, String> usingMap) {
        this.map(String.class, String.class, usingMap);
    }

    @Deprecated
    public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> var1);

    @Deprecated
    @Nullable
    public <K, V> Map<K, V> map(@NotNull Class<K> var1, @NotNull Class<V> var2, Map<K, V> var3);

    public boolean bool();

    public byte int8();

    public short int16();

    public int uint16();

    public int int32();

    default public int int32(int previous) {
        return this.int32();
    }

    public long int64();

    default public long int64(long previous) {
        return this.int64();
    }

    public float float32();

    default public float float32(float previous) {
        return this.float32();
    }

    public double float64();

    default public double float64(double previous) {
        return this.float64();
    }

    public <T> Class<T> typeLiteral() throws IORuntimeException, BufferUnderflowException;

    default public Throwable throwable(boolean appendCurrentStack) {
        return WireInternal.throwable(this, appendCurrentStack);
    }

    @Nullable
    default public <E extends Enum<E>> E asEnum(Class<E> eClass) {
        StringBuilder sb = WireInternal.acquireStringBuilder();
        this.text(sb);
        return sb.length() == 0 ? null : (E)WireInternal.internEnum(eClass, sb);
    }

    @NotNull
    default public <E extends Enum<E>> WireIn asEnum(Class<E> eClass, @NotNull Consumer<E> eConsumer) {
        eConsumer.accept(this.asEnum(eClass));
        return this.wireIn();
    }

    @NotNull
    default public <E extends Enum<E>, T> WireIn asEnum(Class<E> eClass, T t, @NotNull BiConsumer<T, E> teConsumer) {
        teConsumer.accept(t, this.asEnum(eClass));
        return this.wireIn();
    }

    @Nullable
    default public <E> E object(@NotNull Class<E> clazz) {
        return this.object(null, clazz);
    }

    @Nullable
    default public Object object() {
        Object o = this.objectWithInferredType(null, SerializationStrategies.ANY_OBJECT, null);
        return o;
    }

    @Nullable
    default public <E> E object(@Nullable E using, @Nullable Class clazz) {
        SerializationStrategy strategy;
        BracketType brackets;
        Class clazz2 = this.typePrefix();
        if (clazz2 == Void.TYPE) {
            this.text();
            return null;
        }
        if (clazz2 != null && (clazz == null || clazz.isAssignableFrom(clazz2) || ReadResolvable.class.isAssignableFrom(clazz2) || !ObjectUtils.isConcreteClass(clazz)) && !(clazz = clazz2).isInstance(using)) {
            using = null;
        }
        if (clazz == null) {
            clazz = Object.class;
        }
        if ((brackets = (strategy = (SerializationStrategy)Wires.CLASS_STRATEGY.get(clazz)).bracketType()) == BracketType.UNKNOWN) {
            brackets = this.getBracketType();
        }
        if (clazz != null && Date.class.isAssignableFrom(clazz)) {
            this.wireIn().read();
            long time = this.int64();
            if (using instanceof Date) {
                ((Date)using).setTime(time);
                return using;
            }
            return (E)new Date(time);
        }
        switch (brackets) {
            case MAP: {
                if (clazz == Object.class) {
                    strategy = SerializationStrategies.MAP;
                }
                if (using == null) {
                    using = strategy.newInstance(clazz);
                }
                if (using == null) {
                    Jvm.warn().on(ValueIn.class, "failed to create instance of clazz=" + clazz);
                }
                Object ret = this.marshallable(using, strategy);
                return (E)ReadResolvable.readResolve((Object)ret);
            }
            case SEQ: {
                if (clazz == Object.class) {
                    strategy = SerializationStrategies.LIST;
                }
                if (using == null) {
                    using = strategy.newInstance(clazz);
                }
                return (E)(this.sequence(using, strategy::readUsing) ? ReadResolvable.readResolve(using) : null);
            }
            case NONE: {
                E e = strategy.readUsing(using, this);
                return (E)ObjectUtils.convertTo(clazz, e);
            }
        }
        throw new AssertionError();
    }

    public BracketType getBracketType();

    public boolean isNull();

    @Nullable
    default public <T, E> WireIn object(@NotNull Class<E> clazz, T t, @NotNull BiConsumer<T, E> e) {
        e.accept(t, this.object(clazz));
        return this.wireIn();
    }

    public boolean isTyped();

    @Nullable
    public Class typePrefix();

    public void resetState();

    @Nullable
    public Object objectWithInferredType(Object var1, SerializationStrategy var2, Class var3);

    default public UUID uuid() {
        return UUID.fromString(this.text());
    }
}

