/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Externalizable;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.threads.ThreadLocalHelper;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.FieldInfo;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ScalarStrategy;
import net.openhft.chronicle.wire.SerializationStrategies;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaFieldInfo;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireDumper;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Wires
extends Enum<Wires> {
    public static final int LENGTH_MASK = 0x3FFFFFFF;
    public static final int NOT_COMPLETE = Integer.MIN_VALUE;
    @Deprecated
    public static final int NOT_READY = Integer.MIN_VALUE;
    public static final int META_DATA = 0x40000000;
    public static final int UNKNOWN_LENGTH = 0;
    public static final int MAX_LENGTH = 0x3FFFFFFF;
    public static final int NOT_COMPLETE_UNKNOWN_LENGTH = Integer.MIN_VALUE;
    public static final int END_OF_DATA = -1073741824;
    public static final int NOT_INITIALIZED = 0;
    public static final Bytes<?> NO_BYTES;
    public static final WireIn EMPTY;
    public static final int SPB_HEADER_SIZE = 4;
    public static final List<Function<Class, SerializationStrategy>> CLASS_STRATEGY_FUNCTIONS;
    public static final ClassLocal<SerializationStrategy> CLASS_STRATEGY;
    static final ClassLocal<FieldInfoPair> FIELD_INFOS;
    static final StringBuilderPool SBP;
    private static final /* synthetic */ Wires[] $VALUES;

    public static Wires[] values() {
        return (Wires[])$VALUES.clone();
    }

    public static Wires valueOf(String name) {
        return Enum.valueOf(Wires.class, name);
    }

    public static <T> T read(Class<T> tClass, ValueIn in) {
        SerializationStrategy strategy = (SerializationStrategy)CLASS_STRATEGY.get(tClass);
        return strategy.read(in, tClass);
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes) {
        return WireDumper.of(bytes).asString();
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes, long position) {
        long limit = bytes.readLimit();
        if (position > limit) {
            return "";
        }
        return WireDumper.of(bytes).asString(position, limit - position);
    }

    public static String fromSizePrefixedBlobs(@NotNull DocumentContext dc) {
        Wire wire = dc.wire();
        Bytes<?> bytes = wire.bytes();
        if (wire instanceof TextWire) {
            return bytes.toString();
        }
        long headerPosition = bytes.readPosition() - 4L;
        int length = Wires.lengthOf(bytes.readInt(headerPosition));
        return WireDumper.of(wire).asString(headerPosition, length + 4);
    }

    public static String fromSizePrefixedBlobs(@NotNull WireIn wireIn) {
        return WireDumper.of(wireIn).asString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence asText(@NotNull WireIn wireIn) {
        long pos = wireIn.bytes().readPosition();
        try {
            Bytes bytes = Wires.acquireBytes();
            wireIn.copyTo(new TextWire(bytes));
            Bytes bytes2 = bytes;
            return bytes2;
        }
        finally {
            wireIn.bytes().readPosition(pos);
        }
    }

    public static StringBuilder acquireStringBuilder() {
        return SBP.acquireStringBuilder();
    }

    public static int lengthOf(int len) {
        int len0 = len & 0x3FFFFFFF;
        return len0;
    }

    public static boolean isReady(int header) {
        return (header & Integer.MIN_VALUE) == 0 && header != 0;
    }

    public static boolean isNotComplete(int header) {
        return (header & Integer.MIN_VALUE) != 0 || header == 0;
    }

    public static boolean isReadyData(int header) {
        return (header & 0xC0000000) == 0 && header != 0;
    }

    @Deprecated
    public static boolean isData(long len) {
        return Wires.isData((int)len);
    }

    public static boolean isData(int len) {
        return (len & 0x40000000) == 0;
    }

    public static boolean isReadyMetaData(int len) {
        return (len & 0xC0000000) == 0x40000000;
    }

    public static boolean isKnownLength(int len) {
        return (len & Integer.MAX_VALUE) != 0;
    }

    public static boolean isNotInitialized(int len) {
        return len == 0;
    }

    public static int toIntU30(long l, @NotNull String error) {
        if (l < 0L || l > 0x3FFFFFFFL) {
            throw new IllegalStateException(String.format(error, l));
        }
        return (int)l;
    }

    public static boolean acquireLock(BytesStore store, long position) {
        return store.compareAndSwapInt(position, 0, Integer.MIN_VALUE);
    }

    public static boolean exceedsMaxLength(long length) {
        return length > 0x3FFFFFFFL;
    }

    @ForceInline
    public static <T extends WriteMarshallable> long writeData(@NotNull WireOut wireOut, @NotNull T writer) {
        return WireInternal.writeData(wireOut, false, false, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    public static long readWire(@NotNull WireIn wireIn, long size, @NotNull ReadMarshallable readMarshallable) {
        Bytes<?> bytes = wireIn.bytes();
        long limit0 = bytes.readLimit();
        long limit = bytes.readPosition() + size;
        try {
            bytes.readLimit(limit);
            readMarshallable.readMarshallable(wireIn);
        }
        finally {
            bytes.readLimit(limit0);
            bytes.readPosition(limit);
        }
        return bytes.readPosition();
    }

    public static Bytes acquireBytes() {
        Bytes bytes = (Bytes)ThreadLocalHelper.getTL(WireInternal.BYTES_TL, Bytes::allocateElasticDirect);
        bytes.clear();
        return bytes;
    }

    public static Wire acquireBinaryWire() {
        Wire wire = (Wire)ThreadLocalHelper.getTL(WireInternal.BINARY_WIRE_TL, () -> new BinaryWire(Wires.acquireBytes()));
        wire.clear();
        return wire;
    }

    public static Bytes acquireAnotherBytes() {
        Bytes bytes = (Bytes)ThreadLocalHelper.getTL(WireInternal.BYTES_TL, Bytes::allocateElasticDirect);
        bytes.clear();
        return bytes;
    }

    public static String fromSizePrefixedBlobs(Bytes<?> bytes, long position, long length) {
        return (null == null ? WireDumper.of(bytes) : WireDumper.of((WireIn)null)).asString(position, length);
    }

    public static void readMarshallable(Object marshallable, WireIn wire, boolean overwrite) {
        ((WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass())).readMarshallable(marshallable, wire, overwrite);
    }

    public static void writeMarshallable(Object marshallable, WireOut wire) {
        ((WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass())).writeMarshallable(marshallable, wire);
    }

    public static void writeMarshallable(Object marshallable, WireOut wire, Object previous, boolean copy) {
        assert (marshallable.getClass() == previous.getClass());
        ((WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass())).writeMarshallable(marshallable, wire, previous, copy);
    }

    public static void writeKey(Object marshallable, Bytes bytes) {
        ((WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass())).writeKey(marshallable, bytes);
    }

    public static <T extends Marshallable> T deepCopy(T marshallable) {
        Wire wire = Wires.acquireBinaryWire();
        marshallable.writeMarshallable(wire);
        Marshallable t = (Marshallable)ObjectUtils.newInstance(marshallable.getClass());
        t.readMarshallable(wire);
        return (T)t;
    }

    public static <T> T copyTo(Object source, T target) {
        Wire wire = Wires.acquireBinaryWire();
        wire.getValueOut().object(source);
        wire.getValueIn().object(target, target.getClass());
        return target;
    }

    public static <T> T project(Class<T> tClass, Object source) {
        Object target = ObjectUtils.newInstance(tClass);
        Wires.copyTo(source, target);
        return (T)target;
    }

    public static boolean isEquals(Object o1, Object o2) {
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        return ((WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(o1.getClass())).isEqual(o1, o2);
    }

    public static List<FieldInfo> fieldInfos(Class aClass) {
        return ((FieldInfoPair)Wires.FIELD_INFOS.get((Class)aClass)).list;
    }

    public static FieldInfo fieldInfo(Class aClass, String name) {
        return ((FieldInfoPair)Wires.FIELD_INFOS.get((Class)aClass)).map.get(name);
    }

    public static boolean isEndOfFile(int num) {
        return num == -1073741824;
    }

    static {
        $VALUES = new Wires[0];
        NO_BYTES = new VanillaBytes(BytesStore.empty());
        EMPTY = new BinaryWire(NO_BYTES);
        CLASS_STRATEGY_FUNCTIONS = new CopyOnWriteArrayList<Function<Class, SerializationStrategy>>();
        CLASS_STRATEGY = ClassLocal.withInitial(c -> {
            for (Function<Class, SerializationStrategy> func : CLASS_STRATEGY_FUNCTIONS) {
                SerializationStrategy strategy = func.apply((Class)c);
                if (strategy == null) continue;
                return strategy;
            }
            return SerializationStrategies.ANY_OBJECT;
        });
        FIELD_INFOS = ClassLocal.withInitial(VanillaFieldInfo::lookupClass);
        SBP = new StringBuilderPool();
        CLASS_STRATEGY_FUNCTIONS.add(SerializeJavaLang.INSTANCE);
        CLASS_STRATEGY_FUNCTIONS.add(SerializeMarshallables.INSTANCE);
        CLASS_STRATEGY_FUNCTIONS.add(SerializeBytes.INSTANCE);
        ClassAliasPool.CLASS_ALIASES.addAlias(VanillaFieldInfo.class, "FieldInfo");
    }

    static class FieldInfoPair {
        static final FieldInfoPair EMPTY = new FieldInfoPair(Collections.emptyList(), Collections.emptyMap());
        final List<FieldInfo> list;
        final Map<String, FieldInfo> map;

        public FieldInfoPair(List<FieldInfo> list, Map<String, FieldInfo> map) {
            this.list = list;
            this.map = map;
        }
    }

    static enum SerializeMarshallables implements Function<Class, SerializationStrategy>
    {
        INSTANCE;


        @Nullable
        static SerializationStrategy getSerializationStrategy(Class aClass) {
            if (Demarshallable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.DEMARSHALLABLE;
            }
            if (ReadMarshallable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.MARSHALLABLE;
            }
            return null;
        }

        @Override
        public SerializationStrategy apply(Class aClass) {
            SerializationStrategy x = SerializeMarshallables.getSerializationStrategy(aClass);
            if (x != null) {
                return x;
            }
            if (Map.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.MAP;
            }
            if (Set.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.SET;
            }
            if (List.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.LIST;
            }
            if (Externalizable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.EXTERNALIZABLE;
            }
            if (Serializable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.ANY_NESTED;
            }
            return null;
        }
    }

    static enum SerializeJavaLang implements Function<Class, SerializationStrategy>
    {
        INSTANCE;


        @Override
        public SerializationStrategy apply(Class aClass) {
            switch (aClass.getName()) {
                case "[B": {
                    return ScalarStrategy.of(byte[].class, (o, in) -> in.bytes());
                }
                case "java.lang.StringBuilder": {
                    return ScalarStrategy.of(StringBuilder.class, (o, in) -> {
                        StringBuilder builder = o == null ? Wires.acquireStringBuilder() : o;
                        in.textTo(builder);
                        return o;
                    });
                }
                case "java.lang.String": {
                    return ScalarStrategy.of(String.class, (o, in) -> in.text());
                }
                case "java.lang.Object": {
                    return SerializationStrategies.ANY_OBJECT;
                }
                case "java.lang.Class": {
                    return ScalarStrategy.of(Class.class, (o, in) -> {
                        try {
                            return ClassAliasPool.CLASS_ALIASES.forName((CharSequence)in.text());
                        }
                        catch (ClassNotFoundException e) {
                            throw new IORuntimeException((Throwable)e);
                        }
                    });
                }
                case "java.lang.Boolean": {
                    return ScalarStrategy.of(Boolean.class, (o, in) -> in.bool());
                }
                case "java.lang.Byte": {
                    return ScalarStrategy.of(Byte.class, (o, in) -> in.int8());
                }
                case "java.lang.Short": {
                    return ScalarStrategy.of(Short.class, (o, in) -> in.int16());
                }
                case "java.lang.Character": {
                    return ScalarStrategy.of(Character.class, (o, in) -> {
                        String text = in.text();
                        if (text == null || text.length() == 0) {
                            return null;
                        }
                        return Character.valueOf(text.charAt(0));
                    });
                }
                case "java.lang.Integer": {
                    return ScalarStrategy.of(Integer.class, (o, in) -> in.int32());
                }
                case "java.lang.Float": {
                    return ScalarStrategy.of(Float.class, (o, in) -> Float.valueOf(in.float32()));
                }
                case "java.lang.Long": {
                    return ScalarStrategy.of(Long.class, (o, in) -> in.int64());
                }
                case "java.lang.Double": {
                    return ScalarStrategy.of(Double.class, (o, in) -> in.float64());
                }
                case "java.time.LocalTime": {
                    return ScalarStrategy.of(LocalTime.class, (o, in) -> in.time());
                }
                case "java.time.LocalDate": {
                    return ScalarStrategy.of(LocalDate.class, (o, in) -> in.date());
                }
                case "java.time.LocalDateTime": {
                    return ScalarStrategy.of(LocalDateTime.class, (o, in) -> in.dateTime());
                }
                case "java.time.ZonedDateTime": {
                    return ScalarStrategy.of(ZonedDateTime.class, (o, in) -> in.zonedDateTime());
                }
                case "java.io.File": {
                    return ScalarStrategy.text(File.class, File::new);
                }
                case "java.util.UUID": {
                    return ScalarStrategy.of(UUID.class, (o, in) -> in.uuid());
                }
                case "java.math.BigInteger": {
                    return ScalarStrategy.text(BigInteger.class, BigInteger::new);
                }
                case "java.math.BigDecimal": {
                    return ScalarStrategy.text(BigDecimal.class, BigDecimal::new);
                }
            }
            if (aClass.isPrimitive()) {
                return SerializationStrategies.ANY_SCALAR;
            }
            if (aClass.isArray()) {
                Class<?> componentType = aClass.getComponentType();
                if (componentType.isPrimitive()) {
                    return SerializationStrategies.PRIM_ARRAY;
                }
                return SerializationStrategies.ARRAY;
            }
            if (Enum.class.isAssignableFrom(aClass)) {
                SerializationStrategy ss = SerializeMarshallables.getSerializationStrategy(aClass);
                return ss == null ? SerializationStrategies.ENUM : ss;
            }
            return null;
        }
    }

    static enum SerializeBytes implements Function<Class, SerializationStrategy>
    {
        INSTANCE;


        @Override
        public SerializationStrategy apply(Class aClass) {
            switch (aClass.getName()) {
                case "net.openhft.chronicle.bytes.BytesStore": {
                    return ScalarStrategy.of(BytesStore.class, (o, in) -> in.bytesStore());
                }
            }
            return null;
        }
    }
}

